/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.scripts.forms;

import jakarta.servlet.http.HttpSession;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.web.config.forms.ConstraintHandlerDefinition;
import org.alfresco.web.config.forms.ConstraintHandlersConfigElement;
import org.alfresco.web.config.forms.Control;
import org.alfresco.web.config.forms.ControlParam;
import org.alfresco.web.config.forms.DefaultControlsConfigElement;
import org.alfresco.web.config.forms.FormConfigElement;
import org.alfresco.web.config.forms.FormField;
import org.alfresco.web.config.forms.FormSet;
import org.alfresco.web.config.forms.FormsConfigElement;
import org.alfresco.web.config.forms.Mode;
import org.alfresco.web.scripts.forms.OptionsComparator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.springframework.extensions.config.Config;
import org.springframework.extensions.config.ConfigService;
import org.springframework.extensions.surf.FrameworkUtil;
import org.springframework.extensions.surf.RequestContext;
import org.springframework.extensions.surf.ServletUtil;
import org.springframework.extensions.surf.support.ThreadLocalRequestContext;
import org.springframework.extensions.surf.util.I18NUtil;
import org.springframework.extensions.surf.util.StringBuilderWriter;
import org.springframework.extensions.webscripts.AbstractMessageHelper;
import org.springframework.extensions.webscripts.Cache;
import org.springframework.extensions.webscripts.DeclarativeWebScript;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.TemplateConfigModel;
import org.springframework.extensions.webscripts.WebScript;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;
import org.springframework.extensions.webscripts.connector.Connector;
import org.springframework.extensions.webscripts.connector.ConnectorContext;
import org.springframework.extensions.webscripts.connector.ConnectorService;
import org.springframework.extensions.webscripts.connector.HttpMethod;
import org.springframework.extensions.webscripts.connector.Response;
import org.springframework.extensions.webscripts.json.JSONWriter;
import org.springframework.util.StringUtils;

public class FormUIGet
extends DeclarativeWebScript {
    private static Log logger = LogFactory.getLog(FormUIGet.class);
    protected static final String PROPERTY = "property";
    protected static final String ASSOCIATION = "association";
    protected static final String PROP_PREFIX = "prop:";
    protected static final String FIELD = "field";
    protected static final String SET = "set";
    protected static final String ASSOC_PREFIX = "assoc:";
    protected static final String OLD_DATA_TYPE_PREFIX = "d:";
    protected static final String ENDPOINT_ID = "alfresco";
    protected static final String ALFRESCO_PROXY = "/proxy/alfresco";
    protected static final String CM_NAME_PROP = "prop_cm_name";
    protected static final String MSG_DEFAULT_SET_LABEL = "form.default.set.label";
    protected static final String MSG_DEFAULT_FORM_ERROR = "form.error";
    protected static final String INDENT = "   ";
    protected static final String DELIMITER = "#alf#";
    protected static final String SUBMIT_TYPE_MULTIPART = "multipart";
    protected static final String SUBMIT_TYPE_JSON = "json";
    protected static final String SUBMIT_TYPE_URL = "urlencoded";
    protected static final String ENCTYPE_MULTIPART = "multipart/form-data";
    protected static final String ENCTYPE_JSON = "application/json";
    protected static final String ENCTYPE_URL = "application/x-www-form-urlencoded";
    protected static final String DEFAULT_MODE = "edit";
    protected static final String DEFAULT_SUBMIT_TYPE = "multipart";
    protected static final String DEFAULT_METHOD = "post";
    protected static final String DEFAULT_FIELD_TYPE = "text";
    protected static final String DEFAULT_CONSTRAINT_EVENT = "blur";
    protected static final String CONFIG_FORMS = "forms";
    protected static final String PARAM_ITEM_KIND = "itemKind";
    protected static final String PARAM_ITEM_ID = "itemId";
    protected static final String PARAM_FORM_ID = "formId";
    protected static final String PARAM_SUBMIT_TYPE = "submitType";
    protected static final String PARAM_SUBMISSION_URL = "submissionUrl";
    protected static final String PARAM_JS = "js";
    protected static final String PARAM_ERROR_KEY = "err";
    protected static final String CONSTRAINT_MANDATORY = "MANDATORY";
    protected static final String CONSTRAINT_LIST = "LIST";
    protected static final String CONSTRAINT_LENGTH = "LENGTH";
    protected static final String CONSTRAINT_NUMBER = "NUMBER";
    protected static final String CONSTRAINT_MINMAX = "MINMAX";
    protected static final String CONSTRAINT_REGEX = "REGEX";
    protected static final String CONSTRAINT_NODE_HANDLER = "Alfresco.forms.validation.nodeName";
    protected static final String CONSTRAINT_FILE_NAME_HANDLER = "Alfresco.forms.validation.fileName";
    protected static final String CONSTRAINT_MSG_LENGTH = "form.field.constraint.length";
    protected static final String CONSTRAINT_MSG_MINMAX = "form.field.constraint.minmax";
    protected static final String CONSTRAINT_MSG_NUMBER = "form.field.constraint.number";
    protected static final String CONTROL_SELECT_MANY = "/org/alfresco/components/form/controls/selectmany.ftl";
    protected static final String CONTROL_SELECT_ONE = "/org/alfresco/components/form/controls/selectone.ftl";
    protected static final String CONTROL_PARAM_OPTIONS = "options";
    protected static final String CONTROL_PARAM_OPTION_SEPARATOR = "optionSeparator";
    protected static final String MODEL_DATA = "data";
    protected static final String MODEL_DEFINITION = "definition";
    protected static final String MODEL_FIELDS = "fields";
    protected static final String MODEL_FORM_DATA = "formData";
    protected static final String MODEL_FORCE = "force";
    protected static final String MODEL_MESSAGE = "message";
    protected static final String MODEL_PROTECTED_FIELD = "protectedField";
    protected static final String MODEL_REPEATING = "repeating";
    protected static final String MODEL_DEFAULT_VALUE = "defaultValue";
    protected static final String MODEL_FORM = "form";
    protected static final String MODEL_ERROR = "error";
    protected static final String MODEL_NAME = "name";
    protected static final String MODEL_MODE = "mode";
    protected static final String MODEL_METHOD = "method";
    protected static final String MODEL_ENCTYPE = "enctype";
    protected static final String MODEL_SUBMISSION_URL = "submissionUrl";
    protected static final String MODEL_SHOW_CANCEL_BUTTON = "showCancelButton";
    protected static final String MODEL_SHOW_RESET_BUTTON = "showResetButton";
    protected static final String MODEL_SHOW_SUBMIT_BUTTON = "showSubmitButton";
    protected static final String MODEL_SHOW_CAPTION = "showCaption";
    protected static final String MODEL_DESTINATION = "destination";
    protected static final String MODEL_REDIRECT = "redirect";
    protected static final String MODEL_ARGUMENTS = "arguments";
    protected static final String MODEL_STRUCTURE = "structure";
    protected static final String MODEL_CONSTRAINTS = "constraints";
    protected static final String MODEL_VIEW_TEMPLATE = "viewTemplate";
    protected static final String MODEL_EDIT_TEMPLATE = "editTemplate";
    protected static final String MODEL_CREATE_TEMPLATE = "createTemplate";
    protected static final String MODEL_TYPE = "type";
    protected static final String MODEL_LABEL = "label";
    protected static final String MODEL_DESCRIPTION = "description";
    protected static final String MODEL_MANDATORY = "mandatory";
    protected static final String MODEL_DATA_TYPE = "dataType";
    protected static final String MODEL_DATA_TYPE_PARAMETERS = "dataTypeParameters";
    protected static final String MODEL_DATA_KEY_NAME = "dataKeyName";
    protected static final String MODEL_ENDPOINT_TYPE = "endpointType";
    protected static final String MODEL_ENDPOINT_MANDATORY = "endpointMandatory";
    protected static final String MODEL_ENDPOINT_MANY = "endpointMany";
    protected static final String MODEL_ENDPOINT_DIRECTION = "endpointDirection";
    protected static final String MODEL_JAVASCRIPT = "javascript";
    protected static final String MODEL_CAPABILITIES = "capabilities";
    protected static final String MODEL_PARAMETERS = "parameters";
    protected static final String MODEL_MAX_LENGTH = "maxLength";
    protected static final String MODEL_GROUP = "group";
    protected static final String MODEL_INDEX_TOKENISATION_MODE = "indexTokenisationMode";
    private static final String TYPE_INT = "int";
    private static final String TYPE_LONG = "long";
    private static final String TYPE_DOUBLE = "double";
    private static final String TYPE_FLOAT = "float";
    protected ConfigService configService;
    private MessageHelper messageHelper = null;

    public void setConfigService(ConfigService configService) {
        this.configService = configService;
    }

    protected Map<String, Object> executeImpl(WebScriptRequest req, Status status, Cache cache) {
        Map<String, Object> model = null;
        String itemKind = this.getParameter(req, PARAM_ITEM_KIND);
        String itemId = this.getParameter(req, PARAM_ITEM_ID);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("itemKind = " + itemKind));
            logger.debug((Object)("itemId = " + itemId));
        }
        if (itemKind != null && itemId != null && itemKind.length() > 0 && itemId.length() > 0) {
            model = this.generateModel(itemKind, itemId, req, status, cache);
        } else {
            model = new HashMap<String, Object>(1);
            model.put(MODEL_FORM, null);
        }
        return model;
    }

    protected Map<String, Object> generateModel(String itemKind, String itemId, WebScriptRequest request, Status status, Cache cache) {
        FormConfigElement formConfig;
        List<String> visibleFields;
        Response formSvcResponse;
        Map<String, Object> model = null;
        String modeParam = this.getParameter(request, MODEL_MODE, DEFAULT_MODE);
        String formId = this.getParameter(request, PARAM_FORM_ID);
        Mode mode = Mode.modeFromString(modeParam);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Showing " + String.valueOf((Object)mode) + " form (id=" + formId + ") for item: [" + itemKind + "]" + itemId));
        }
        if ((formSvcResponse = this.retrieveFormDefinition(itemKind, itemId, visibleFields = this.getVisibleFields(mode, formConfig = this.getFormConfig(itemId, formId)), formConfig)).getStatus().getCode() == 200) {
            model = this.generateFormModel(request, mode, formSvcResponse, formConfig);
        } else if (formSvcResponse.getStatus().getCode() == 401) {
            status.setCode(401);
            status.setRedirect(true);
        } else {
            String errorKey = this.getParameter(request, PARAM_ERROR_KEY);
            model = this.generateErrorModel(formSvcResponse, errorKey);
        }
        return model;
    }

    protected String getParameter(WebScriptRequest req, String name) {
        return this.getParameter(req, name, null);
    }

    protected String getParameter(WebScriptRequest req, String name, String defaultValue) {
        String value = req.getParameter(name);
        if ((value == null || value.length() == 0) && defaultValue != null) {
            value = defaultValue;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Returning \"" + value + "\" from getParameter for \"" + name + "\""));
        }
        return value;
    }

    protected FormConfigElement getFormConfig(String itemId, String formId) {
        FormConfigElement formConfig = null;
        FormsConfigElement formsConfig = null;
        RequestContext requestContext = ThreadLocalRequestContext.getRequestContext();
        TemplateConfigModel extendedTemplateConfigModel = requestContext.getExtendedTemplateConfigModel(null);
        if (extendedTemplateConfigModel != null) {
            Map configs = (Map)extendedTemplateConfigModel.getScoped().get(itemId);
            formsConfig = (FormsConfigElement)((Object)configs.get(CONFIG_FORMS));
        }
        if (formsConfig == null) {
            Config configResult = this.configService.getConfig((Object)itemId);
            formsConfig = (FormsConfigElement)configResult.getConfigElement(CONFIG_FORMS);
        }
        if (formsConfig != null) {
            if (formsConfig != null) {
                if (formId != null && formId.length() > 0) {
                    formConfig = formsConfig.getForm(formId);
                }
                if (formConfig == null) {
                    formConfig = formsConfig.getDefaultForm();
                }
            }
        } else if (logger.isWarnEnabled()) {
            logger.warn((Object)"Could not lookup form configuration as configService has not been set");
        }
        return formConfig;
    }

    protected List<String> getVisibleFields(Mode mode, FormConfigElement formConfig) {
        List<String> visibleFields = null;
        if (formConfig != null) {
            switch (mode) {
                case VIEW: {
                    visibleFields = formConfig.getVisibleViewFieldNamesAsList();
                    break;
                }
                case EDIT: {
                    visibleFields = formConfig.getVisibleEditFieldNamesAsList();
                    break;
                }
                case CREATE: {
                    visibleFields = formConfig.getVisibleCreateFieldNamesAsList();
                }
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Fields configured to be visible for " + String.valueOf((Object)mode) + " mode = " + String.valueOf(visibleFields)));
        }
        return visibleFields;
    }

    protected List<String> getVisibleFieldsInSet(ModelContext context, FormSet setConfig) {
        List<String> visibleFields = null;
        Mode mode = context.getMode();
        if (setConfig != null) {
            switch (mode) {
                case VIEW: {
                    visibleFields = context.getFormConfig().getVisibleViewFieldNamesForSetAsList(setConfig.getSetId());
                    break;
                }
                case EDIT: {
                    visibleFields = context.getFormConfig().getVisibleEditFieldNamesForSetAsList(setConfig.getSetId());
                    break;
                }
                case CREATE: {
                    visibleFields = context.getFormConfig().getVisibleCreateFieldNamesForSetAsList(setConfig.getSetId());
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Fields configured to be visible for set \"" + setConfig.getSetId() + "\" = " + String.valueOf(visibleFields)));
            }
        }
        return visibleFields;
    }

    protected Response retrieveFormDefinition(String itemKind, String itemId, List<String> visibleFields, FormConfigElement formConfig) {
        Response response;
        block3: {
            response = null;
            try {
                ConnectorService connService = FrameworkUtil.getConnectorService();
                RequestContext requestContext = ThreadLocalRequestContext.getRequestContext();
                String currentUserId = requestContext.getUserId();
                HttpSession currentSession = ServletUtil.getSession((boolean)true);
                Connector connector = connService.getConnector(ENDPOINT_ID, currentUserId, currentSession);
                ConnectorContext context = new ConnectorContext(HttpMethod.POST, null, FormUIGet.buildDefaultHeaders());
                context.setContentType(ENCTYPE_JSON);
                response = connector.call("/api/formdefinitions", context, (InputStream)this.generateFormDefPostBody(itemKind, itemId, visibleFields, formConfig));
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Response status: " + response.getStatus().getCode()));
                }
            }
            catch (Exception e) {
                if (!logger.isErrorEnabled()) break block3;
                logger.error((Object)"Failed to get form definition: ", (Throwable)e);
            }
        }
        return response;
    }

    private static Map<String, String> buildDefaultHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>(1, 1.0f);
        headers.put("Accept-Language", I18NUtil.getLocale().toString().replace('_', '-'));
        return headers;
    }

    protected String retrieveMessage(String messageKey, Object ... args) {
        if (this.messageHelper == null) {
            this.messageHelper = new MessageHelper((WebScript)this);
        }
        return this.messageHelper.get(messageKey, args);
    }

    protected ByteArrayInputStream generateFormDefPostBody(String itemKind, String itemId, List<String> visibleFields, FormConfigElement formConfig) throws IOException {
        StringBuilderWriter buf = new StringBuilderWriter(512);
        JSONWriter writer = new JSONWriter((Writer)buf);
        writer.startObject();
        writer.writeValue(PARAM_ITEM_KIND, itemKind);
        writer.writeValue(PARAM_ITEM_ID, itemId.replace(":/", ""));
        ArrayList<String> forcedFields = null;
        if (visibleFields != null && visibleFields.size() > 0) {
            writer.startValue(MODEL_FIELDS);
            writer.startArray();
            forcedFields = new ArrayList<String>(visibleFields.size());
            for (String fieldId : visibleFields) {
                writer.writeValue(fieldId);
                if (!formConfig.isFieldForced(fieldId)) continue;
                forcedFields.add(fieldId);
            }
            writer.endArray();
        }
        if (forcedFields != null && forcedFields.size() > 0) {
            writer.startValue(MODEL_FORCE);
            writer.startArray();
            for (String fieldId : forcedFields) {
                writer.writeValue(fieldId);
            }
            writer.endArray();
        }
        writer.endObject();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Generated JSON POST body: " + buf.toString()));
        }
        return new ByteArrayInputStream(buf.toString().getBytes());
    }

    protected Map<String, Object> generateFormModel(WebScriptRequest request, Mode mode, Response formSvcResponse, FormConfigElement formConfig) {
        try {
            String jsonResponse = formSvcResponse.getResponse();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("form definition JSON = \n" + jsonResponse));
            }
            JSONObject formDefinition = new JSONObject(new JSONTokener(jsonResponse));
            HashMap<String, Object> model = new HashMap<String, Object>(1);
            model.put(MODEL_FORM, this.generateFormUIModel(new ModelContext(request, mode, formDefinition, formConfig)));
            return model;
        }
        catch (JSONException je) {
            if (logger.isErrorEnabled()) {
                logger.error((Object)je);
            }
            return null;
        }
    }

    protected Map<String, Object> generateFormUIModel(ModelContext context) {
        String redirect;
        HashMap<String, Object> formUIModel = new HashMap<String, Object>(8);
        context.setFormUIModel(formUIModel);
        formUIModel.put(MODEL_MODE, context.getMode().toString());
        formUIModel.put(MODEL_METHOD, this.getParameter(context.getRequest(), MODEL_METHOD, DEFAULT_METHOD));
        formUIModel.put(MODEL_ENCTYPE, this.discoverEncodingFormat(context));
        formUIModel.put("submissionUrl", this.discoverSubmissionUrl(context));
        formUIModel.put(MODEL_ARGUMENTS, this.discoverArguments(context));
        formUIModel.put(MODEL_DATA, this.discoverData(context));
        formUIModel.put(MODEL_SHOW_CANCEL_BUTTON, this.discoverBooleanParam(context, MODEL_SHOW_CANCEL_BUTTON));
        formUIModel.put(MODEL_SHOW_RESET_BUTTON, this.discoverBooleanParam(context, MODEL_SHOW_RESET_BUTTON));
        formUIModel.put(MODEL_SHOW_SUBMIT_BUTTON, this.discoverBooleanParam(context, MODEL_SHOW_SUBMIT_BUTTON, true));
        String destination = this.getParameter(context.getRequest(), MODEL_DESTINATION);
        if (destination != null && destination.length() > 0) {
            formUIModel.put(MODEL_DESTINATION, destination);
        }
        if ((redirect = this.getParameter(context.getRequest(), MODEL_REDIRECT)) != null && redirect.length() > 0) {
            formUIModel.put(MODEL_REDIRECT, redirect);
        }
        this.processCapabilities(context, formUIModel);
        this.processTemplates(context, formUIModel);
        this.processFields(context, formUIModel);
        formUIModel.put(MODEL_SHOW_CAPTION, this.discoverBooleanParam(context, MODEL_SHOW_CAPTION, this.getDefaultShowCaption(context)));
        this.dumpFormUIModel(formUIModel);
        return formUIModel;
    }

    private boolean getDefaultShowCaption(ModelContext context) {
        if (context.getMode() == Mode.VIEW) {
            return false;
        }
        for (Constraint constraint : context.getConstraints()) {
            if (!CONSTRAINT_MANDATORY.equals(constraint.getId())) continue;
            return true;
        }
        return false;
    }

    protected String discoverEncodingFormat(ModelContext context) {
        String submitType = this.getParameter(context.getRequest(), PARAM_SUBMIT_TYPE, "multipart");
        String enctype = null;
        enctype = "multipart".equals(submitType) ? ENCTYPE_MULTIPART : (SUBMIT_TYPE_JSON.equals(submitType) ? ENCTYPE_JSON : (SUBMIT_TYPE_URL.equals(submitType) ? ENCTYPE_URL : ENCTYPE_MULTIPART));
        return enctype;
    }

    protected String discoverSubmissionUrl(ModelContext context) {
        Object submissionUrl = null;
        if (context.getFormConfig() != null && context.getFormConfig().getSubmissionURL() != null) {
            submissionUrl = context.getFormConfig().getSubmissionURL();
        } else {
            String defaultSubmissionUrl = null;
            try {
                JSONObject data = context.getFormDefinition().getJSONObject(MODEL_DATA);
                defaultSubmissionUrl = data.getString("submissionUrl");
            }
            catch (JSONException je) {
                throw new WebScriptException("Failed to find default submission URL", (Throwable)je);
            }
            submissionUrl = this.getParameter(context.getRequest(), "submissionUrl", defaultSubmissionUrl);
        }
        submissionUrl = this.getProxyPath(context) + (String)submissionUrl;
        return submissionUrl;
    }

    protected String getProxyPath(ModelContext context) {
        return context.getRequest().getContextPath() + ALFRESCO_PROXY;
    }

    protected Map<String, String> discoverArguments(ModelContext context) {
        HashMap<String, String> arguments = new HashMap<String, String>(3);
        arguments.put(PARAM_ITEM_KIND, this.getParameter(context.getRequest(), PARAM_ITEM_KIND));
        arguments.put(PARAM_ITEM_ID, this.getParameter(context.getRequest(), PARAM_ITEM_ID));
        arguments.put(PARAM_FORM_ID, this.getParameter(context.getRequest(), PARAM_FORM_ID));
        return arguments;
    }

    protected Map<String, Object> discoverData(ModelContext context) {
        Map<String, Object> dataModel = null;
        try {
            JSONObject data = context.getFormDefinition().getJSONObject(MODEL_DATA);
            JSONObject formData = data.getJSONObject(MODEL_FORM_DATA);
            JSONArray names = formData.names();
            if (names != null) {
                dataModel = new HashMap<String, Object>(names.length());
                for (int x = 0; x < names.length(); ++x) {
                    String key = names.getString(x);
                    dataModel.put(key, formData.get(key));
                }
            } else {
                dataModel = Collections.emptyMap();
            }
        }
        catch (JSONException je) {
            throw new WebScriptException("Failed to find form data", (Throwable)je);
        }
        return dataModel;
    }

    protected boolean discoverBooleanParam(ModelContext context, String name) {
        return this.discoverBooleanParam(context, name, false);
    }

    protected boolean discoverBooleanParam(ModelContext context, String name, boolean defaultValue) {
        String value = this.getParameter(context.getRequest(), name, Boolean.toString(defaultValue));
        return "true".equals(value);
    }

    protected JSONObject discoverFieldDefinition(ModelContext context, String fieldName) {
        JSONObject fieldDefinition = null;
        JSONObject propertyDefinition = context.getPropertyDefinitions().get(fieldName);
        JSONObject associationDefinition = context.getAssociationDefinitions().get(fieldName);
        if (propertyDefinition == null && associationDefinition == null) {
            if (fieldName.indexOf(PROP_PREFIX) != -1) {
                propertyDefinition = context.getPropertyDefinitions().get(fieldName.substring(PROP_PREFIX.length()));
            } else if (fieldName.indexOf(ASSOC_PREFIX) != -1) {
                associationDefinition = context.getAssociationDefinitions().get(fieldName.substring(ASSOC_PREFIX.length()));
            }
        }
        if (propertyDefinition != null) {
            fieldDefinition = propertyDefinition;
        } else if (associationDefinition != null) {
            fieldDefinition = associationDefinition;
        }
        return fieldDefinition;
    }

    protected String discoverSetLabel(FormSet setConfig) {
        String label = null;
        label = setConfig.getLabelId() != null ? this.retrieveMessage(setConfig.getLabelId(), new Object[0]) : (setConfig.getLabel() != null ? setConfig.getLabel() : ("".equals(setConfig.getSetId()) ? this.retrieveMessage(MSG_DEFAULT_SET_LABEL, new Object[0]) : setConfig.getSetId()));
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Returning label for set: " + label));
        }
        return label;
    }

    protected Map<String, List<String>> discoverSetMembership(ModelContext context) {
        HashMap<String, List<String>> setMemberships;
        block8: {
            setMemberships = new HashMap<String, List<String>>(4);
            try {
                JSONObject data = context.getFormDefinition().getJSONObject(MODEL_DATA);
                JSONObject definition = data.getJSONObject(MODEL_DEFINITION);
                JSONArray fieldsFromServer = definition.getJSONArray(MODEL_FIELDS);
                for (int x = 0; x < fieldsFromServer.length(); ++x) {
                    JSONObject fieldDefinition = fieldsFromServer.getJSONObject(x);
                    String fieldName = fieldDefinition.getString(MODEL_NAME);
                    if (!context.getFormConfig().isFieldHidden(fieldName, context.getMode())) {
                        ArrayList<String> fieldsForSet;
                        FormField fieldConfig;
                        String set = "";
                        if (fieldDefinition.has(MODEL_GROUP)) {
                            set = fieldDefinition.getString(MODEL_GROUP);
                        }
                        if ((fieldConfig = context.getFormConfig().getFields().get(fieldName)) != null && !fieldConfig.getSet().equals("")) {
                            set = fieldConfig.getSet();
                        }
                        if ((fieldsForSet = (ArrayList<String>)setMemberships.get(set)) == null) {
                            fieldsForSet = new ArrayList<String>(4);
                            fieldsForSet.add(fieldName);
                            setMemberships.put(set, fieldsForSet);
                            continue;
                        }
                        fieldsForSet.add(fieldName);
                        continue;
                    }
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug((Object)("Ignoring \"" + fieldName + "\" as it is configured to be hidden"));
                }
            }
            catch (JSONException je) {
                if (!logger.isErrorEnabled()) break block8;
                logger.error((Object)"Failed to discover set membership", (Throwable)je);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Set membership = " + String.valueOf(setMemberships)));
        }
        return setMemberships;
    }

    protected void processCapabilities(ModelContext context, Map<String, Object> formUIModel) {
        String jsEnabled = this.getParameter(context.getRequest(), PARAM_JS);
        if (jsEnabled != null && ("off".equalsIgnoreCase(jsEnabled) || "false".equalsIgnoreCase(jsEnabled) || "disabled".equalsIgnoreCase(jsEnabled))) {
            HashMap<String, Boolean> capabilities = new HashMap<String, Boolean>(1);
            capabilities.put(MODEL_JAVASCRIPT, false);
            formUIModel.put(MODEL_CAPABILITIES, capabilities);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("JavaScript disabled flag detected, added form capabilties: " + String.valueOf(capabilities)));
            }
        }
    }

    protected void processTemplates(ModelContext context, Map<String, Object> formUIModel) {
        FormConfigElement formConfig = context.getFormConfig();
        if (formConfig != null && formConfig.getViewTemplate() != null) {
            formUIModel.put(MODEL_VIEW_TEMPLATE, formConfig.getViewTemplate());
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Set viewTemplate to \"" + formConfig.getViewTemplate() + "\""));
            }
        }
        if (formConfig != null && formConfig.getEditTemplate() != null) {
            formUIModel.put(MODEL_EDIT_TEMPLATE, formConfig.getEditTemplate());
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Set editTemplate to \"" + formConfig.getEditTemplate() + "\""));
            }
        }
        if (formConfig != null && formConfig.getCreateTemplate() != null) {
            formUIModel.put(MODEL_CREATE_TEMPLATE, formConfig.getCreateTemplate());
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Set createTemplate to \"" + formConfig.getCreateTemplate() + "\""));
            }
        }
    }

    protected void processFields(ModelContext context, Map<String, Object> formUIModel) {
        List<String> visibleFields = this.getVisibleFields(context.getMode(), context.getFormConfig());
        if (context.getFormConfig() != null && visibleFields != null && visibleFields.size() > 0) {
            this.processVisibleFields(context);
        } else {
            this.processServerFields(context);
        }
        formUIModel.put(MODEL_FIELDS, context.getFields());
        formUIModel.put(MODEL_STRUCTURE, context.getStructure());
        formUIModel.put(MODEL_CONSTRAINTS, context.getConstraints());
    }

    protected void processVisibleFields(ModelContext context) {
        for (FormSet setConfig : context.getFormConfig().getRootSetsAsList()) {
            Set set = this.generateSetModelUsingVisibleFields(context, setConfig);
            if (set == null) continue;
            context.getStructure().add(set);
        }
    }

    protected void processServerFields(ModelContext context) {
        if (context.getFormConfig() != null) {
            Map<String, List<String>> setMembership = this.discoverSetMembership(context);
            for (FormSet setConfig : context.getFormConfig().getRootSetsAsList()) {
                Set set = this.generateSetModelUsingServerFields(context, setConfig, setMembership);
                if (set == null) continue;
                context.getStructure().add(set);
            }
        } else {
            Set set = this.generateDefaultSetModelUsingServerFields(context);
            context.getStructure().add(set);
        }
    }

    protected Set generateSetModelUsingVisibleFields(ModelContext context, FormSet setConfig) {
        Set set = null;
        List<String> fieldsInSet = this.getVisibleFieldsInSet(context, setConfig);
        if (fieldsInSet != null && fieldsInSet.size() > 0 || setConfig.getChildrenAsList().size() > 0) {
            set = this.generateSetModel(context, setConfig, fieldsInSet);
            for (FormSet childSetConfig : setConfig.getChildrenAsList()) {
                Set childSet = this.generateSetModelUsingVisibleFields(context, childSetConfig);
                set.addChild(childSet);
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)("Ignoring set \"" + setConfig.getSetId() + "\" as it does not have any fields or child sets"));
        }
        return set;
    }

    protected Set generateSetModelUsingServerFields(ModelContext context, FormSet setConfig, Map<String, List<String>> setMembership) {
        Set set = null;
        List<String> fieldsInSet = setMembership.get(setConfig.getSetId());
        if (fieldsInSet != null && fieldsInSet.size() > 0 || setConfig.getChildrenAsList().size() > 0) {
            set = this.generateSetModel(context, setConfig, fieldsInSet);
            for (FormSet childSetConfig : setConfig.getChildrenAsList()) {
                Set childSet = this.generateSetModelUsingServerFields(context, childSetConfig, setMembership);
                set.addChild(childSet);
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)("Ignoring set \"" + setConfig.getSetId() + "\" as it does not have any fields or child sets"));
        }
        return set;
    }

    protected Set generateSetModel(ModelContext context, FormSet setConfig, List<String> fields) {
        Set set = new Set(setConfig);
        for (String fieldName : fields) {
            FormField fieldConfig;
            Field field = this.generateFieldModel(context, fieldName, fieldConfig = context.getFormConfig().getFields().get(fieldName));
            if (field == null) continue;
            set.addChild(new FieldPointer(field.getId()));
            context.getFields().put(field.getId(), field);
        }
        return set;
    }

    protected Set generateDefaultSetModelUsingServerFields(ModelContext context) {
        Set set;
        block4: {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"No configuration was found therefore showing all fields in the default set...");
            }
            set = new Set("", this.retrieveMessage(MSG_DEFAULT_SET_LABEL, new Object[0]));
            try {
                JSONObject data = context.getFormDefinition().getJSONObject(MODEL_DATA);
                JSONObject definition = data.getJSONObject(MODEL_DEFINITION);
                JSONArray fieldsFromServer = definition.getJSONArray(MODEL_FIELDS);
                for (int x = 0; x < fieldsFromServer.length(); ++x) {
                    String fieldName = fieldsFromServer.getJSONObject(x).getString(MODEL_NAME);
                    Field field = this.generateFieldModel(context, fieldName, null);
                    if (field == null) continue;
                    set.addChild(new FieldPointer(field.getId()));
                    context.getFields().put(field.getId(), field);
                }
            }
            catch (JSONException je) {
                if (!logger.isErrorEnabled()) break block4;
                logger.error((Object)"Failed to generate default set from server fields", (Throwable)je);
            }
        }
        return set;
    }

    protected Field generateFieldModel(ModelContext context, String fieldName, FormField fieldConfig) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Generating model for field \"" + fieldName + "\""));
        }
        Field field = null;
        try {
            if (this.isFieldAmbiguous(context, fieldName)) {
                field = this.generateTransientFieldModel(fieldName, "/org/alfresco/components/form/controls/ambiguous.ftl");
            } else {
                JSONObject fieldDefinition = this.discoverFieldDefinition(context, fieldName);
                if (fieldDefinition != null) {
                    field = new Field();
                    this.processFieldIdentification(context, field, fieldDefinition, fieldConfig);
                    this.processFieldState(context, field, fieldDefinition, fieldConfig);
                    this.processFieldText(context, field, fieldDefinition, fieldConfig);
                    this.processFieldData(context, field, fieldDefinition, fieldConfig);
                    this.processFieldControl(context, field, fieldDefinition, fieldConfig);
                    this.processFieldConstraints(context, field, fieldDefinition, fieldConfig);
                    this.processFieldContent(context, field, fieldDefinition, fieldConfig);
                } else {
                    field = this.generateTransientFieldModel(context, fieldName, fieldDefinition, fieldConfig);
                    if (field == null && logger.isDebugEnabled()) {
                        logger.debug((Object)("Ignoring field \"" + fieldName + "\" as neither a field definition or sufficient configuration could be located"));
                    }
                }
            }
        }
        catch (JSONException je) {
            if (logger.isErrorEnabled()) {
                logger.error((Object)("Failed to generate field model for \"" + fieldName + "\""), (Throwable)je);
            }
            field = null;
        }
        return field;
    }

    protected boolean isFieldAmbiguous(ModelContext context, String fieldName) {
        boolean ambiguous = false;
        if (context.getPropertyDefinitions().get(fieldName) != null && context.getAssociationDefinitions().get(fieldName) != null) {
            ambiguous = true;
            if (logger.isWarnEnabled()) {
                logger.warn((Object)("\"" + fieldName + "\" is ambiguous, a property and an association exists with this name, prefix with either \"prop:\" or \"assoc:\" to uniquely identify the field"));
            }
        }
        return ambiguous;
    }

    protected Field generateTransientFieldModel(String fieldName, String template) {
        Field field = new Field();
        String name = fieldName.replace(":", "_");
        field.setConfigName(fieldName);
        field.setName(name);
        field.setId(name);
        field.setLabel(fieldName);
        field.setValue("");
        field.setTransitory(true);
        field.setControl(new FieldControl(template));
        return field;
    }

    protected Field generateTransientFieldModel(ModelContext context, String fieldName, JSONObject fieldDefinition, FormField fieldConfig) throws JSONException {
        if (fieldConfig == null || fieldConfig.getControl() == null || fieldConfig.getControl().getTemplate() == null || fieldConfig.getAttributes() == null || fieldConfig.getAttributes().get(SET) != null && !fieldConfig.getAttributes().get(SET).isEmpty()) {
            return null;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Generating transient field for \"" + fieldName + "\""));
        }
        Field field = this.generateTransientFieldModel(fieldName, fieldConfig.getControl().getTemplate());
        List<ControlParam> params = fieldConfig.getControl().getParamsAsList();
        if (params.size() > 0) {
            FieldControl control = field.getControl();
            for (ControlParam param : params) {
                control.getParams().put(param.getName(), param.getValue());
            }
        }
        this.processFieldText(context, field, fieldDefinition, fieldConfig);
        return field;
    }

    protected void processFieldIdentification(ModelContext context, Field field, JSONObject fieldDefinition, FormField fieldConfig) throws JSONException {
        field.setConfigName(fieldDefinition.getString(MODEL_NAME));
        field.setType(fieldDefinition.getString(MODEL_TYPE));
        Object name = field.getConfigName();
        if (field.getType().equals(ASSOCIATION)) {
            if (!((String)name).startsWith(ASSOC_PREFIX)) {
                name = ASSOC_PREFIX + field.getConfigName();
            }
        } else if (!((String)name).startsWith(PROP_PREFIX)) {
            name = PROP_PREFIX + field.getConfigName();
        }
        name = ((String)name).replace(":", "_");
        field.setId((String)name);
        name = ((String)name).replace(".", "#dot#");
        field.setName((String)name);
    }

    protected void processFieldState(ModelContext context, Field field, JSONObject fieldDefinition, FormField fieldConfig) throws JSONException {
        boolean disabled = false;
        if (fieldDefinition.has(MODEL_PROTECTED_FIELD)) {
            disabled = fieldDefinition.getBoolean(MODEL_PROTECTED_FIELD);
        }
        if (!disabled && fieldConfig != null && fieldConfig.isReadOnly()) {
            disabled = true;
        }
        field.setDisabled(disabled);
        boolean mandatory = false;
        if (fieldDefinition.has(MODEL_MANDATORY)) {
            mandatory = fieldDefinition.getBoolean(MODEL_MANDATORY);
        }
        if (fieldDefinition.has(MODEL_ENDPOINT_MANDATORY)) {
            mandatory = fieldDefinition.getBoolean(MODEL_ENDPOINT_MANDATORY);
        }
        if (!mandatory && fieldConfig != null && fieldConfig.isMandatory()) {
            mandatory = true;
        }
        field.setMandatory(mandatory);
        if (fieldDefinition.has(MODEL_REPEATING)) {
            field.setRepeating(fieldDefinition.getBoolean(MODEL_REPEATING));
        }
        if (fieldDefinition.has(MODEL_ENDPOINT_MANY)) {
            field.setRepeating(fieldDefinition.getBoolean(MODEL_ENDPOINT_MANY));
        }
        if (fieldDefinition.has(MODEL_ENDPOINT_DIRECTION)) {
            field.setEndpointDirection(fieldDefinition.getString(MODEL_ENDPOINT_DIRECTION));
        }
    }

    protected void processFieldText(ModelContext context, Field field, JSONObject fieldDefinition, FormField fieldConfig) throws JSONException {
        if (fieldDefinition != null) {
            if (fieldDefinition.has(MODEL_LABEL)) {
                field.setLabel(fieldDefinition.getString(MODEL_LABEL));
            }
            if (fieldDefinition.has(MODEL_DESCRIPTION)) {
                field.setDescription(fieldDefinition.getString(MODEL_DESCRIPTION));
            }
        }
        if (fieldConfig != null) {
            String configLabel = null;
            if (fieldConfig.getLabelId() != null) {
                configLabel = this.retrieveMessage(fieldConfig.getLabelId(), new Object[0]);
            } else if (fieldConfig.getLabel() != null) {
                configLabel = fieldConfig.getLabel();
            }
            if (configLabel != null) {
                field.setLabel(configLabel);
            }
            String configDesc = null;
            if (fieldConfig.getDescriptionId() != null) {
                configDesc = this.retrieveMessage(fieldConfig.getDescriptionId(), new Object[0]);
            } else if (fieldConfig.getDescription() != null) {
                configDesc = fieldConfig.getDescription();
            }
            if (configDesc != null) {
                field.setDescription(configDesc);
            }
            String configHelp = null;
            if (fieldConfig.getHelpTextId() != null) {
                configHelp = this.retrieveMessage(fieldConfig.getHelpTextId(), new Object[0]);
            } else if (fieldConfig.getHelpText() != null) {
                configHelp = fieldConfig.getHelpText();
            }
            if (configHelp != null) {
                field.setHelp(configHelp);
            }
            if (fieldConfig.getHelpEncodeHtml() != null) {
                field.setHelpEncodeHtml(fieldConfig.getHelpEncodeHtml().equalsIgnoreCase("true"));
            }
        }
    }

    protected void processFieldData(ModelContext context, Field field, JSONObject fieldDefinition, FormField fieldConfig) throws JSONException {
        JSONObject formData;
        if (fieldDefinition.has(MODEL_DATA_TYPE)) {
            field.setDataType(fieldDefinition.getString(MODEL_DATA_TYPE));
        }
        if (fieldDefinition.has(MODEL_ENDPOINT_TYPE)) {
            field.setDataType(fieldDefinition.getString(MODEL_ENDPOINT_TYPE));
        }
        field.setDataKeyName(fieldDefinition.getString(MODEL_DATA_KEY_NAME));
        field.setValue("");
        JSONObject formDefinition = context.getFormDefinition().getJSONObject(MODEL_DATA);
        if (formDefinition.has(MODEL_FORM_DATA) && (formData = formDefinition.getJSONObject(MODEL_FORM_DATA)).has(field.getDataKeyName())) {
            field.setValue(formData.get(field.getDataKeyName()));
        }
        if (field.getValue().equals("") && context.getMode().equals((Object)Mode.CREATE) && fieldDefinition.has(MODEL_DEFAULT_VALUE)) {
            field.setValue(fieldDefinition.getString(MODEL_DEFAULT_VALUE));
        }
        if (fieldDefinition.has(MODEL_INDEX_TOKENISATION_MODE) && fieldDefinition.getString(MODEL_INDEX_TOKENISATION_MODE).toUpperCase().equals("FALSE")) {
            field.setIndexTokenisationMode(fieldDefinition.getString(MODEL_INDEX_TOKENISATION_MODE));
        }
    }

    protected void processFieldConstraints(ModelContext context, Field field, JSONObject fieldDefinition, FormField fieldConfig) throws JSONException {
        Map<String, ConstraintHandlerDefinition> constraintDefinitionMap;
        Constraint constraint;
        if (!field.isDisabled()) {
            Constraint constraint2;
            if (field.isMandatory() && (constraint2 = this.generateConstraintModel(context, field, fieldDefinition, fieldConfig, CONSTRAINT_MANDATORY)) != null) {
                context.getConstraints().add(constraint2);
            }
            if (fieldConfig != null && fieldConfig.getConstraintDefinitionMap() != null) {
                Map<String, ConstraintHandlerDefinition> fieldConstraints = fieldConfig.getConstraintDefinitionMap();
                for (String constraintId : fieldConstraints.keySet()) {
                    Constraint constraint3 = null;
                    ConstraintHandlerDefinition customConstraintConfig = fieldConstraints.get(constraintId);
                    if (customConstraintConfig != null) {
                        constraint3 = this.generateConstraintModel(context, field, fieldConfig, constraintId, new JSONObject(), customConstraintConfig);
                    }
                    if (constraint3 == null) continue;
                    context.getConstraints().add(constraint3);
                }
            }
        }
        if (fieldDefinition.has(MODEL_CONSTRAINTS)) {
            JSONArray constraints = fieldDefinition.getJSONArray(MODEL_CONSTRAINTS);
            for (int x = 0; x < constraints.length(); ++x) {
                constraint = this.generateConstraintModel(context, field, fieldDefinition, fieldConfig, constraints.getJSONObject(x));
                if (constraint == null) continue;
                context.getConstraints().add(constraint);
            }
        }
        String dataType = field.getDataType();
        Map<String, ConstraintHandlerDefinition> map = constraintDefinitionMap = fieldConfig == null ? null : fieldConfig.getConstraintDefinitionMap();
        if ((this.isConstraintHandlerExist(constraintDefinitionMap, CONSTRAINT_NUMBER) || this.isDataTypeNumber(dataType)) && (constraint = this.generateConstraintModel(context, field, fieldDefinition, fieldConfig, CONSTRAINT_NUMBER)) != null) {
            if (field.isRepeating()) {
                constraint.getJSONParams().put(MODEL_REPEATING, true);
            }
            context.getConstraints().add(constraint);
        }
    }

    private boolean isConstraintHandlerExist(Map<String, ConstraintHandlerDefinition> constraintDefinitionMap, String constraint) {
        if (constraintDefinitionMap != null) {
            return constraintDefinitionMap.containsKey(constraint);
        }
        return false;
    }

    private boolean isDataTypeNumber(String dataType) {
        return TYPE_INT.equals(dataType) || TYPE_LONG.equals(dataType) || TYPE_DOUBLE.equals(dataType) || TYPE_FLOAT.equals(dataType);
    }

    protected Constraint generateConstraintModel(ModelContext context, Field field, JSONObject fieldDefinition, FormField fieldConfig, String constraintId) throws JSONException {
        JSONObject constraintDef = new JSONObject();
        constraintDef.put(MODEL_TYPE, (Object)constraintId);
        return this.generateConstraintModel(context, field, fieldDefinition, fieldConfig, constraintDef);
    }

    protected Constraint generateConstraintModel(ModelContext context, Field field, JSONObject fieldDefinition, FormField fieldConfig, JSONObject constraintDefinition) throws JSONException {
        Constraint constraint = null;
        String constraintId = null;
        JSONObject constraintParams = null;
        if (constraintDefinition.has(MODEL_TYPE)) {
            constraintId = constraintDefinition.getString(MODEL_TYPE);
        }
        constraintParams = constraintDefinition.has(MODEL_PARAMETERS) ? constraintDefinition.getJSONObject(MODEL_PARAMETERS) : new JSONObject();
        ConstraintHandlersConfigElement defaultConstraintHandlers = null;
        FormsConfigElement formsGlobalConfig = (FormsConfigElement)this.configService.getGlobalConfig().getConfigElement(CONFIG_FORMS);
        if (formsGlobalConfig != null) {
            defaultConstraintHandlers = formsGlobalConfig.getConstraintHandlers();
        }
        if (defaultConstraintHandlers == null) {
            throw new WebScriptException("Failed to locate default constraint handlers configurarion");
        }
        ConstraintHandlerDefinition defaultConstraintConfig = defaultConstraintHandlers.getItems().get(constraintId);
        if (defaultConstraintConfig != null) {
            constraint = this.generateConstraintModel(context, field, fieldConfig, constraintId, constraintParams, defaultConstraintConfig);
            this.processFieldConstraintControl(context, field, fieldConfig, constraint);
            this.processFieldConstraintHelp(context, field, fieldConfig, constraint);
        } else if (logger.isWarnEnabled()) {
            logger.warn((Object)("No default constraint configuration found for \"" + constraintId + "\" constraint whilst processing field \"" + field.getConfigName() + "\""));
        }
        return constraint;
    }

    protected Constraint generateConstraintModel(ModelContext context, Field field, FormField fieldConfig, String constraintId, JSONObject constraintParams, ConstraintHandlerDefinition defaultConstraintConfig) throws JSONException {
        String validationHandler = defaultConstraintConfig.getValidationHandler();
        Constraint constraint = new Constraint(field.getId(), constraintId, validationHandler, constraintParams);
        if (defaultConstraintConfig.getEvent() != null) {
            constraint.setEvent(defaultConstraintConfig.getEvent());
        } else {
            constraint.setEvent(DEFAULT_CONSTRAINT_EVENT);
        }
        String constraintMsg = null;
        if (fieldConfig != null && fieldConfig.getConstraintDefinitionMap().get(constraintId) != null) {
            ConstraintHandlerDefinition fieldConstraintConfig = fieldConfig.getConstraintDefinitionMap().get(constraintId);
            if (fieldConstraintConfig.getMessageId() != null) {
                constraintMsg = this.retrieveMessage(fieldConstraintConfig.getMessageId(), new Object[0]);
            } else if (fieldConstraintConfig.getMessage() != null) {
                constraintMsg = fieldConstraintConfig.getMessage();
            }
            if (fieldConstraintConfig.getValidationHandler() != null) {
                constraint.setValidationHandler(fieldConstraintConfig.getValidationHandler());
            }
            if (fieldConstraintConfig.getEvent() != null) {
                constraint.setEvent(fieldConstraintConfig.getEvent());
            }
        } else if (defaultConstraintConfig.getMessageId() != null) {
            constraintMsg = this.retrieveMessage(defaultConstraintConfig.getMessageId(), new Object[0]);
        } else if (defaultConstraintConfig.getMessage() != null) {
            constraintMsg = defaultConstraintConfig.getMessage();
        }
        if (constraintMsg == null) {
            constraintMsg = this.retrieveMessage(validationHandler + ".message", new Object[0]);
        }
        if (constraintMsg != null) {
            constraint.setMessage(constraintMsg);
        }
        return constraint;
    }

    protected void processFieldConstraintControl(ModelContext context, Field field, FormField fieldConfig, Constraint constraint) throws JSONException {
        if (CONSTRAINT_LIST.equals(constraint.getId())) {
            if (fieldConfig == null || fieldConfig.getControl() == null || fieldConfig.getControl().getTemplate() == null) {
                if (field.isRepeating()) {
                    field.getControl().setTemplate(CONTROL_SELECT_MANY);
                } else {
                    field.getControl().setTemplate(CONTROL_SELECT_ONE);
                }
            }
            if (!field.getControl().getParams().containsKey(CONTROL_PARAM_OPTIONS)) {
                JSONArray options = constraint.getJSONParams().getJSONArray("allowedValues");
                ArrayList<String> optionsList = new ArrayList<String>(options.length());
                for (int x = 0; x < options.length(); ++x) {
                    optionsList.add(options.getString(x));
                }
                if (fieldConfig != null && fieldConfig.isSorted()) {
                    Collections.sort(optionsList, new OptionsComparator());
                }
                field.getControl().getParams().put(CONTROL_PARAM_OPTIONS, StringUtils.collectionToDelimitedString(optionsList, (String)DELIMITER));
                field.getControl().getParams().put(CONTROL_PARAM_OPTION_SEPARATOR, DELIMITER);
            }
        } else if (CONSTRAINT_LENGTH.equals(constraint.getId())) {
            int maxLength = -1;
            if (constraint.getJSONParams().has(MODEL_MAX_LENGTH)) {
                maxLength = constraint.getJSONParams().getInt(MODEL_MAX_LENGTH);
            }
            if (maxLength != -1) {
                field.getControl().getParams().put(MODEL_MAX_LENGTH, Integer.toString(maxLength));
                constraint.getJSONParams().put("crop", true);
            }
        } else if (CONSTRAINT_REGEX.equals(constraint.getId()) && CM_NAME_PROP.equals(field.getName())) {
            constraint.setValidationHandler(CONSTRAINT_FILE_NAME_HANDLER);
            constraint.setJSONParams(new JSONObject());
        }
    }

    protected void processFieldConstraintHelp(ModelContext context, Field field, FormField fieldConfig, Constraint constraint) throws JSONException {
        if (field.getHelp() == null) {
            if (CONSTRAINT_LENGTH.equals(constraint.getId())) {
                String text = this.retrieveMessage(CONSTRAINT_MSG_LENGTH, constraint.getJSONParams().getInt("minLength"), constraint.getJSONParams().getInt(MODEL_MAX_LENGTH));
                field.setHelp(text);
            } else if (CONSTRAINT_MINMAX.equals(constraint.getId())) {
                String text = this.retrieveMessage(CONSTRAINT_MSG_MINMAX, constraint.getJSONParams().getInt("minValue"), constraint.getJSONParams().getInt("maxValue"));
                field.setHelp(text);
            } else if (CONSTRAINT_NUMBER.equals(constraint.getId())) {
                field.setHelp(this.retrieveMessage(CONSTRAINT_MSG_NUMBER, new Object[0]));
            }
        }
    }

    protected void processFieldControl(ModelContext context, Field field, JSONObject fieldDefinition, FormField fieldConfig) throws JSONException {
        List<ControlParam> paramsConfig;
        FieldControl control = null;
        DefaultControlsConfigElement defaultControls = null;
        FormsConfigElement formsGlobalConfig = (FormsConfigElement)this.configService.getGlobalConfig().getConfigElement(CONFIG_FORMS);
        if (formsGlobalConfig != null) {
            defaultControls = formsGlobalConfig.getDefaultControls();
        }
        if (defaultControls == null) {
            throw new WebScriptException("Failed to locate default controls configuration");
        }
        boolean isPropertyField = !ASSOCIATION.equals(fieldDefinition.getString(MODEL_TYPE));
        Control defaultControlConfig = null;
        if (isPropertyField) {
            defaultControlConfig = defaultControls.getItems().get(fieldDefinition.getString(MODEL_DATA_TYPE));
            if (defaultControlConfig == null) {
                defaultControlConfig = defaultControls.getItems().get(OLD_DATA_TYPE_PREFIX + fieldDefinition.getString(MODEL_DATA_TYPE));
            }
        } else {
            defaultControlConfig = defaultControls.getItems().get("association:" + fieldDefinition.getString(MODEL_ENDPOINT_TYPE));
            if (defaultControlConfig == null) {
                defaultControlConfig = defaultControls.getItems().get(ASSOCIATION);
            }
        }
        if (fieldConfig != null && fieldConfig.getControl() != null && fieldConfig.getControl().getTemplate() != null) {
            control = new FieldControl(fieldConfig.getControl().getTemplate());
        } else if (defaultControlConfig != null) {
            control = new FieldControl(defaultControlConfig.getTemplate());
        } else if (logger.isWarnEnabled()) {
            if (isPropertyField) {
                logger.warn((Object)("No default control found for data type \"" + fieldDefinition.getString(MODEL_DATA_TYPE) + "\" whilst processing field \"" + fieldDefinition.getString(MODEL_NAME) + "\""));
            } else {
                logger.warn((Object)("No default control found for associations\" whilst processing field \"" + fieldDefinition.getString(MODEL_NAME) + "\""));
            }
        }
        if (isPropertyField && control != null && fieldDefinition.has(MODEL_DATA_TYPE_PARAMETERS)) {
            control.getParams().put(MODEL_DATA_TYPE_PARAMETERS, fieldDefinition.get(MODEL_DATA_TYPE_PARAMETERS).toString());
        }
        if (defaultControlConfig != null && control != null) {
            paramsConfig = defaultControlConfig.getParamsAsList();
            for (ControlParam param : paramsConfig) {
                control.getParams().put(param.getName(), param.getValue());
            }
        }
        if (fieldConfig != null && control != null) {
            paramsConfig = fieldConfig.getControl().getParamsAsList();
            for (ControlParam param : paramsConfig) {
                control.getParams().put(param.getName(), param.getValue());
            }
        }
        field.setControl(control);
    }

    protected void processFieldContent(ModelContext context, Field field, JSONObject fieldDefinition, FormField fieldConfig) throws JSONException {
        block5: {
            if (context.getFormUIModel().get(MODEL_CAPABILITIES) != null && "content".equals(field.getDataType())) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Retrieving content for \"" + field.getConfigName() + "\" as JavaScript is disabled"));
                }
                String nodeRef = this.getParameter(context.getRequest(), PARAM_ITEM_ID);
                try {
                    ConnectorService connService = FrameworkUtil.getConnectorService();
                    RequestContext requestContext = ThreadLocalRequestContext.getRequestContext();
                    String currentUserId = requestContext.getUserId();
                    HttpSession currentSession = ServletUtil.getSession((boolean)true);
                    Connector connector = connService.getConnector(ENDPOINT_ID, currentUserId, currentSession);
                    Response response = connector.call("/api/node/content/" + nodeRef.replace("://", "/"));
                    if (response.getStatus().getCode() == 200) {
                        field.setContent(response.getText());
                    }
                }
                catch (Exception e) {
                    if (!logger.isErrorEnabled()) break block5;
                    logger.error((Object)"Failed to get field content: ", (Throwable)e);
                }
            }
        }
    }

    protected Map<String, Object> generateErrorModel(Response errorResponse) {
        return this.generateErrorModel(errorResponse, null);
    }

    protected Map<String, Object> generateErrorModel(Response errorResponse, String errorKey) {
        String id;
        String error = "";
        try {
            JSONObject json = new JSONObject(new JSONTokener(errorResponse.getResponse()));
            if (json.has(MODEL_MESSAGE) && (error = json.getString(MODEL_MESSAGE)).indexOf("org.alfresco.repo.security.permissions.AccessDeniedException") == -1 && (errorKey == null || errorKey.isEmpty()) && logger.isErrorEnabled()) {
                logger.error((Object)error);
            }
        }
        catch (JSONException je) {
            error = "";
        }
        if (errorKey == null || errorKey.isEmpty()) {
            errorKey = MSG_DEFAULT_FORM_ERROR;
        }
        if ((error = this.retrieveMessage(id = errorKey + "." + errorResponse.getStatus().getCode(), new Object[0])).equals(id)) {
            error = this.retrieveMessage(errorKey, new Object[0]);
        }
        HashMap<String, Object> model = new HashMap<String, Object>(1);
        model.put(MODEL_ERROR, error);
        return model;
    }

    protected void dumpFormUIModel(Map<String, Object> model) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("formUIModel = " + this.dumpMap(model, INDENT)));
        }
    }

    protected String dumpMap(Map<String, Object> map, String indent) {
        StringBuilder builder = new StringBuilder();
        builder.append("\n");
        if (indent.length() > INDENT.length()) {
            builder.append(indent.substring(INDENT.length()));
        }
        builder.append("{");
        boolean firstKey = true;
        for (String key : map.keySet()) {
            if (firstKey) {
                firstKey = false;
            } else {
                builder.append(",");
            }
            builder.append("\n");
            builder.append(indent);
            builder.append(key);
            builder.append(": ");
            Object value = map.get(key);
            if (value instanceof String) {
                builder.append("\"");
                builder.append(value);
                builder.append("\"");
                continue;
            }
            if (value instanceof Map) {
                builder.append(this.dumpMap((Map)value, indent + INDENT));
                continue;
            }
            if (value instanceof List) {
                boolean firstItem = true;
                builder.append("\n").append(INDENT).append("[");
                for (Object item : (List)value) {
                    if (firstItem) {
                        firstItem = false;
                    } else {
                        builder.append(",");
                    }
                    builder.append("\n").append(INDENT).append(INDENT);
                    builder.append(item);
                }
                builder.append("\n").append(INDENT).append("]");
                continue;
            }
            builder.append(value);
        }
        builder.append("\n");
        if (indent.length() > INDENT.length()) {
            builder.append(indent.substring(INDENT.length()));
        }
        builder.append("}");
        return builder.toString();
    }

    protected class MessageHelper
    extends AbstractMessageHelper {
        public MessageHelper(WebScript webscript) {
            super(webscript);
        }

        public String get(String id, Object ... args) {
            return this.resolveMessage(id, args);
        }
    }

    protected class ModelContext {
        private Map<String, Object> formUIModel;
        private Map<String, JSONObject> propDefs;
        private Map<String, JSONObject> assocDefs;
        private WebScriptRequest request;
        private Mode mode;
        private JSONObject formDefinition;
        private FormConfigElement formConfig;
        private List<Constraint> constraints;
        private List<Element> structure;
        private Map<String, Field> fields;

        protected ModelContext(WebScriptRequest request, Mode mode, JSONObject formDefinition, FormConfigElement formConfig) {
            this.request = request;
            this.mode = mode;
            this.formDefinition = formDefinition;
            this.formConfig = formConfig;
            this.cacheFieldDefinitions();
        }

        public void cacheFieldDefinitions() {
            block4: {
                this.propDefs = new HashMap<String, JSONObject>(8);
                this.assocDefs = new HashMap<String, JSONObject>(8);
                try {
                    JSONObject data = this.formDefinition.getJSONObject(FormUIGet.MODEL_DATA);
                    JSONObject definition = data.getJSONObject(FormUIGet.MODEL_DEFINITION);
                    JSONArray fields = definition.getJSONArray(FormUIGet.MODEL_FIELDS);
                    for (int x = 0; x < fields.length(); ++x) {
                        JSONObject fieldDef = fields.getJSONObject(x);
                        if (fieldDef.getString(FormUIGet.MODEL_TYPE).equals(FormUIGet.PROPERTY)) {
                            this.propDefs.put(fieldDef.getString(FormUIGet.MODEL_NAME), fieldDef);
                            continue;
                        }
                        if (!fieldDef.getString(FormUIGet.MODEL_TYPE).equals(FormUIGet.ASSOCIATION)) continue;
                        this.assocDefs.put(fieldDef.getString(FormUIGet.MODEL_NAME), fieldDef);
                    }
                }
                catch (JSONException je) {
                    if (!logger.isErrorEnabled()) break block4;
                    logger.error((Object)"Failed to cache field definitions", (Throwable)je);
                }
            }
        }

        public void setFormUIModel(Map<String, Object> formUIModel) {
            this.formUIModel = formUIModel;
        }

        public Map<String, Object> getFormUIModel() {
            return this.formUIModel;
        }

        public Map<String, JSONObject> getPropertyDefinitions() {
            return this.propDefs;
        }

        public Map<String, JSONObject> getAssociationDefinitions() {
            return this.assocDefs;
        }

        public WebScriptRequest getRequest() {
            return this.request;
        }

        public Mode getMode() {
            return this.mode;
        }

        public JSONObject getFormDefinition() {
            return this.formDefinition;
        }

        public FormConfigElement getFormConfig() {
            return this.formConfig;
        }

        public List<Constraint> getConstraints() {
            if (this.constraints == null) {
                this.constraints = new ArrayList<Constraint>(2);
            }
            return this.constraints;
        }

        public List<Element> getStructure() {
            if (this.structure == null) {
                this.structure = new ArrayList<Element>(4);
            }
            return this.structure;
        }

        public Map<String, Field> getFields() {
            if (this.fields == null) {
                this.fields = new HashMap<String, Field>(8);
            }
            return this.fields;
        }
    }

    public class Constraint {
        private String fieldId;
        private String id;
        private String validationHandler;
        private JSONObject params;
        private String message;
        private String event;

        Constraint(String fieldId, String id, String handler, JSONObject params) {
            this.fieldId = fieldId;
            this.id = id;
            this.validationHandler = handler;
            this.params = params;
        }

        public String getFieldId() {
            return this.fieldId;
        }

        public String getId() {
            return this.id;
        }

        public String getValidationHandler() {
            return this.validationHandler;
        }

        public void setValidationHandler(String validationHandler) {
            this.validationHandler = validationHandler;
        }

        public String getParams() {
            if (this.params == null) {
                this.params = new JSONObject();
            }
            return this.params.toString();
        }

        public JSONObject getJSONParams() {
            return this.params;
        }

        public void setJSONParams(JSONObject params) {
            this.params = params;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getEvent() {
            return this.event;
        }

        public void setEvent(String event) {
            this.event = event;
        }

        public String toString() {
            StringBuilder buffer = new StringBuilder();
            buffer.append("constraint(fieldId=").append(this.fieldId);
            buffer.append(" id=").append(this.id);
            buffer.append(" validationHandler=").append(this.validationHandler);
            buffer.append(" event=").append(this.event);
            buffer.append(" message=").append(this.message);
            buffer.append(")");
            return buffer.toString();
        }
    }

    public class Set
    extends Element {
        protected String appearance;
        protected String template;
        protected String label;
        protected List<Element> children;

        Set(FormSet setConfig) {
            this.kind = FormUIGet.SET;
            this.id = setConfig.getSetId();
            this.appearance = setConfig.getAppearance();
            this.template = setConfig.getTemplate();
            this.label = FormUIGet.this.discoverSetLabel(setConfig);
            this.children = new ArrayList<Element>(4);
        }

        Set(String id, String label) {
            this.kind = FormUIGet.SET;
            this.id = id;
            this.label = label;
            this.children = new ArrayList<Element>(1);
        }

        public void addChild(Element child) {
            this.children.add(child);
        }

        public String getAppearance() {
            return this.appearance;
        }

        public String getTemplate() {
            return this.template;
        }

        public String getLabel() {
            return this.label;
        }

        public List<Element> getChildren() {
            return this.children;
        }

        @Override
        public String toString() {
            StringBuilder buffer = new StringBuilder();
            buffer.append(this.kind);
            buffer.append("(id=").append(this.id);
            buffer.append(" appearance=").append(this.appearance);
            buffer.append(" label=").append(this.label);
            buffer.append(" template=").append(this.template);
            buffer.append(" children=[");
            boolean first = true;
            for (Element child : this.children) {
                if (first) {
                    first = false;
                } else {
                    buffer.append(", ");
                }
                buffer.append(child);
            }
            buffer.append("])");
            return buffer.toString();
        }
    }

    public abstract class Element {
        protected String kind;
        protected String id;

        public String getKind() {
            return this.kind;
        }

        public String getId() {
            return this.id;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append(this.kind);
            builder.append("(");
            builder.append(this.id);
            builder.append(")");
            return builder.toString();
        }
    }

    public class Field
    extends Element {
        protected String name;
        protected String configName;
        protected String label;
        protected String description;
        protected String help;
        protected boolean helpEncodeHtml = true;
        protected FieldControl control;
        protected String dataKeyName;
        protected String dataType;
        protected String type;
        protected String content;
        protected String endpointDirection;
        protected Object value;
        protected boolean disabled = false;
        protected boolean mandatory = false;
        protected boolean transitory = false;
        protected boolean repeating = false;
        protected String indexTokenisationMode;

        Field() {
            this.kind = FormUIGet.FIELD;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getConfigName() {
            return this.configName;
        }

        public void setConfigName(String configName) {
            this.configName = configName;
        }

        public FieldControl getControl() {
            return this.control;
        }

        public void setControl(FieldControl control) {
            this.control = control;
        }

        public String getDataKeyName() {
            return this.dataKeyName;
        }

        public void setDataKeyName(String dataKeyName) {
            this.dataKeyName = dataKeyName;
        }

        public String getDataType() {
            return this.dataType;
        }

        public void setDataType(String dataType) {
            this.dataType = dataType;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public boolean isDisabled() {
            return this.disabled;
        }

        public void setDisabled(boolean disabled) {
            this.disabled = disabled;
        }

        public String getLabel() {
            return this.label;
        }

        public void setLabel(String label) {
            this.label = label;
        }

        public boolean isMandatory() {
            return this.mandatory;
        }

        public void setMandatory(boolean mandatory) {
            this.mandatory = mandatory;
        }

        public boolean isTransitory() {
            return this.transitory;
        }

        public void setTransitory(boolean transitory) {
            this.transitory = transitory;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public boolean isRepeating() {
            return this.repeating;
        }

        public void setRepeating(boolean repeating) {
            this.repeating = repeating;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object value) {
            this.value = value;
        }

        public String getContent() {
            return this.content;
        }

        public void setContent(String content) {
            this.content = content;
        }

        public String getHelp() {
            return this.help;
        }

        public void setHelp(String help) {
            this.help = help;
        }

        public boolean getHelpEncodeHtml() {
            return this.helpEncodeHtml;
        }

        public void setHelpEncodeHtml(boolean encode) {
            this.helpEncodeHtml = encode;
        }

        public String getEndpointDirection() {
            return this.endpointDirection;
        }

        public void setEndpointDirection(String endpointDirection) {
            this.endpointDirection = endpointDirection;
        }

        public String getEndpointType() {
            return this.getDataType();
        }

        public boolean isEndpointMandatory() {
            return this.mandatory;
        }

        public boolean isEndpointMany() {
            return this.repeating;
        }

        public String getIndexTokenisationMode() {
            return this.indexTokenisationMode;
        }

        public void setIndexTokenisationMode(String indexTokenisationMode) {
            this.indexTokenisationMode = indexTokenisationMode;
        }

        @Override
        public String toString() {
            StringBuilder buffer = new StringBuilder();
            buffer.append(this.kind);
            buffer.append("(id=").append(this.id);
            buffer.append(" name=").append(this.name);
            buffer.append(" configName=").append(this.configName);
            buffer.append(" type=").append(this.type);
            buffer.append(" value=").append(this.value);
            buffer.append(" label=").append(this.label);
            buffer.append(" description=").append(this.description);
            buffer.append(" help=").append(this.help);
            buffer.append(" helpEncodeHtml=").append(this.helpEncodeHtml);
            buffer.append(" dataKeyName=").append(this.dataKeyName);
            buffer.append(" dataType=").append(this.dataType);
            buffer.append(" endpointDirection=").append(this.endpointDirection);
            buffer.append(" disabled=").append(this.disabled);
            buffer.append(" mandatory=").append(this.mandatory);
            buffer.append(" repeating=").append(this.repeating);
            buffer.append(" transitory=").append(this.transitory);
            buffer.append(" indexTokenisationMode=").append(this.indexTokenisationMode);
            buffer.append(" ").append(this.control);
            buffer.append(")");
            return buffer.toString();
        }
    }

    public class FieldPointer
    extends Element {
        FieldPointer(String id) {
            this.kind = FormUIGet.FIELD;
            this.id = id;
        }
    }

    public class FieldControl {
        protected String template;
        protected Map<String, String> params;

        FieldControl(String template) {
            this.template = template;
            this.params = new HashMap<String, String>(4);
        }

        public String getTemplate() {
            return this.template;
        }

        public void setTemplate(String template) {
            this.template = template;
        }

        public Map<String, String> getParams() {
            return this.params;
        }

        public String toString() {
            StringBuilder buffer = new StringBuilder();
            buffer.append("control(template=").append(this.template);
            buffer.append(" params=").append(this.params);
            buffer.append(")");
            return buffer.toString();
        }
    }
}

