/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_wcmquickstart.benchmark;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.alfresco.module.org_alfresco_module_wcmquickstart.benchmark.CharQueue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MarkovChain {
    private static Log logger = LogFactory.getLog(MarkovChain.class);
    private Map<String, Chain> chainMap = new HashMap<String, Chain>();
    private String bootstrapPrefix;

    public MarkovChain(InputStream in, int length) throws IOException {
        int c;
        CharQueue queue = new CharQueue(length);
        for (int i = 0; i < length; ++i) {
            c = in.read();
            if (c == -1) {
                logger.error((Object)"Input is too short");
                return;
            }
            queue.put((char)c);
        }
        this.bootstrapPrefix = queue.toString();
        boolean wasWhitespace = false;
        while ((c = in.read()) != -1) {
            if (Character.isWhitespace((char)c)) {
                if (wasWhitespace) continue;
                c = 32;
                wasWhitespace = true;
            } else {
                wasWhitespace = false;
            }
            String prefix = queue.toString();
            Chain chain = this.chainMap.get(prefix);
            if (chain == null) {
                chain = new Chain(prefix);
                this.chainMap.put(prefix, chain);
            }
            chain.add((char)c);
            queue.put((char)c);
        }
    }

    public String getBootstrapPrefix() {
        return this.bootstrapPrefix;
    }

    public int get(String prefix, Random random) {
        Chain chain = this.chainMap.get(prefix);
        if (chain == null) {
            return -1;
        }
        int index = random.nextInt(chain.getTotal());
        return chain.get(index);
    }

    public void dump() {
        Set<String> keys = this.chainMap.keySet();
        for (String key : keys) {
            Chain chain = this.chainMap.get(key);
            chain.dump();
        }
    }

    public static class Chain {
        private String prefix;
        private int total;
        private List<Link> list;

        public Chain(String prefix) {
            this.prefix = prefix;
            this.total = 0;
            this.list = new LinkedList<Link>();
        }

        public String getPrefix() {
            return this.prefix;
        }

        public int getTotal() {
            return this.total;
        }

        public char get(int index) {
            for (Link link : this.list) {
                int count = link.getCount();
                if (index < count) {
                    return link.getChar();
                }
                index -= count;
            }
            return '@';
        }

        public void add(char c) {
            Link link;
            Iterator<Link> i = this.list.iterator();
            boolean found = false;
            while (i.hasNext()) {
                link = i.next();
                if (c != link.getChar()) continue;
                link.increment();
                found = true;
                break;
            }
            if (!found) {
                link = new Link(c);
                this.list.add(link);
            }
            ++this.total;
        }

        public void dump() {
            logger.info((Object)(this.prefix + ": (" + this.total + ")"));
            for (Link link : this.list) {
                logger.info((Object)("    " + link.getChar() + " (" + link.getCount() + ")"));
            }
        }

        private static class Link {
            private char c;
            private int count;

            public Link(char c) {
                this.c = c;
                this.count = 1;
            }

            public void increment() {
                ++this.count;
            }

            public int getCount() {
                return this.count;
            }

            public char getChar() {
                return this.c;
            }
        }
    }
}

