/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_wcmquickstart.util.contextparser;

import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.alfresco.module.org_alfresco_module_wcmquickstart.util.contextparser.ContextParser;
import org.alfresco.service.cmr.repository.NodeRef;

public class ContextParserService {
    private static final Pattern MATCH_PATTERN = Pattern.compile("\\$\\{(.+)\\}");
    private Map<String, ContextParser> contextParsers = new TreeMap<String, ContextParser>();

    public void register(ContextParser queryParser) {
        this.contextParsers.put(queryParser.getName(), queryParser);
    }

    public String parse(NodeRef context, String value) {
        String result = value;
        Collection<ContextParser> parsers = this.contextParsers.values();
        Matcher matcher = MATCH_PATTERN.matcher(value);
        block0: while (matcher.find()) {
            String invocation = matcher.group(1).trim();
            for (ContextParser parser : parsers) {
                if (!parser.canHandle(invocation)) continue;
                String temp = parser.execute(context, invocation);
                if (temp == null) continue block0;
                result = result.replace(matcher.group(), temp);
                continue block0;
            }
        }
        return result;
    }
}

