/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_wcmquickstart.webscript;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_wcmquickstart.model.WebSiteModel;
import org.alfresco.module.org_alfresco_module_wcmquickstart.rendition.RenditionHelper;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.site.SiteInfo;
import org.alfresco.service.cmr.site.SiteService;
import org.alfresco.service.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.webscripts.Cache;
import org.springframework.extensions.webscripts.DeclarativeWebScript;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;

public class UpdateWebSiteRenditionsGet
extends DeclarativeWebScript
implements WebSiteModel {
    private static Log logger = LogFactory.getLog(UpdateWebSiteRenditionsGet.class);
    private static final String COMPONENT_DOCUMENT_LIBRARY = "documentLibrary";
    private static final String ARG_SITE_NAME = "site";
    private SiteService siteService;
    private FileFolderService fileFolderService;
    private DictionaryService dictionaryService;
    private NodeService nodeService;
    private RenditionHelper renditionHelper;

    public void setSiteService(SiteService siteService) {
        this.siteService = siteService;
    }

    public void setFileFolderService(FileFolderService fileFolderService) {
        this.fileFolderService = fileFolderService;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setRenditionHelper(RenditionHelper renditionHelper) {
        this.renditionHelper = renditionHelper;
    }

    public Map<String, Object> executeImpl(WebScriptRequest req, Status status, Cache cache) {
        NodeRef website;
        String siteName = null;
        if (req.getParameter(ARG_SITE_NAME) == null) {
            throw new WebScriptException(400, "No site name specified.");
        }
        siteName = req.getParameter(ARG_SITE_NAME);
        SiteInfo site = this.siteService.getSite(siteName);
        if (site == null) {
            throw new WebScriptException(400, "The site specified (" + siteName + ") does not exist.");
        }
        NodeRef docLib = this.siteService.getContainer(siteName, COMPONENT_DOCUMENT_LIBRARY);
        if (docLib == null) {
            docLib = this.siteService.createContainer(siteName, COMPONENT_DOCUMENT_LIBRARY, null, null);
        }
        if ((website = this.getWebSite(docLib)) != null) {
            this.renditionChildren(website);
        }
        HashMap<String, Object> model = new HashMap<String, Object>(1, 1.0f);
        model.put("success", true);
        return model;
    }

    private void renditionChildren(NodeRef nodeRef) {
        List children = this.fileFolderService.list(nodeRef);
        for (FileInfo child : children) {
            NodeRef childNodeRef = child.getNodeRef();
            QName childType = this.nodeService.getType(childNodeRef);
            if (this.dictionaryService.isSubClass(childType, TYPE_SECTION)) {
                this.renditionChildren(childNodeRef);
                continue;
            }
            if (!this.nodeService.hasAspect(childNodeRef, ASPECT_WEBASSET) || this.nodeService.hasAspect(childNodeRef, ContentModel.ASPECT_WORKING_COPY)) continue;
            this.renditionHelper.createRenditions(childNodeRef, true);
        }
    }

    private NodeRef getWebSite(NodeRef docLib) {
        NodeRef result = this.fileFolderService.searchSimple(docLib, "Alfresco Quick Start");
        if (result != null) {
            result = this.fileFolderService.searchSimple(result, "Quick Start Editorial");
        }
        return result;
    }
}

