/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_wcmquickstart.util;

import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_wcmquickstart.model.WebSiteModel;
import org.alfresco.repo.site.SiteModel;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.MLText;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.ResultSetRow;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.cmr.site.SiteInfo;
import org.alfresco.service.cmr.site.SiteService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.GUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.surf.util.I18NUtil;

public class SiteHelper
implements WebSiteModel {
    private static final Log log = LogFactory.getLog(SiteHelper.class);
    private static final String URL_WEBASSET = "http://{0}:{1}/{2}/asset/{3}/{4}";
    private static final QName TYPE_DATA_LIST = QName.createQName((String)"http://www.alfresco.org/model/datalist/1.0", (String)"dataList");
    private static final QName PROP_DATA_LIST_ITEM_TYPE = QName.createQName((String)"http://www.alfresco.org/model/datalist/1.0", (String)"dataListItemType");
    private static final String DATA_LISTS_FOLDER_NAME = "dataLists";
    private static final String FEEDBACK_DATA_LIST_NAME = "wcmqs.feedback.dataListNameFormat";
    private SiteService siteService;
    private NodeService nodeService;
    private DictionaryService dictionaryService;
    private SearchService searchService;
    private NamespaceService namespaceService;
    private Map<NodeRef, List<Locale>> websiteLocales = new ConcurrentHashMap<NodeRef, List<Locale>>();
    private Map<NodeRef, Date> websiteLocaleLoadTimes = new ConcurrentHashMap<NodeRef, Date>();
    private List<Locale> defaultWebsiteLocales = new ArrayList<Locale>();

    public void setDefaultWebsiteLocales(List<Locale> defaultWebsiteLocales) {
        this.defaultWebsiteLocales = defaultWebsiteLocales;
    }

    public String getWebAssetURL(NodeRef nodeRef) {
        NodeRef webSite;
        String result = null;
        if (this.nodeService.hasAspect(nodeRef, ASPECT_WEBASSET) && (webSite = this.getRelevantWebSite(nodeRef)) != null) {
            Map webSiteProps = this.nodeService.getProperties(webSite);
            String hostName = (String)webSiteProps.get(PROP_HOST_NAME);
            String hostPort = ((Integer)webSiteProps.get(PROP_HOST_PORT)).toString();
            String webappName = (String)webSiteProps.get(PROP_WEB_APP_CONTEXT);
            String id = nodeRef.getId();
            String fileName = (String)((Object)this.nodeService.getProperty(nodeRef, ContentModel.PROP_NAME));
            result = MessageFormat.format(URL_WEBASSET, hostName, hostPort, webappName, id, fileName);
        }
        return result;
    }

    public SiteInfo getRelevantShareSite(NodeRef noderef) {
        SiteInfo siteInfo = null;
        NodeRef parentNode = this.findNearestParent(noderef, SiteModel.TYPE_SITE);
        if (parentNode != null && this.nodeService.exists(parentNode)) {
            siteInfo = this.siteService.getSite(parentNode);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Found the corresponding Share site for the specified node: " + siteInfo.getShortName()));
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("Specified node is not within a Share site: " + String.valueOf(noderef)));
        }
        return siteInfo;
    }

    public NodeRef getRelevantWebSite(NodeRef noderef) {
        return this.findNearestParent(noderef, WebSiteModel.TYPE_WEB_SITE);
    }

    public NodeRef getRelevantWebRoot(NodeRef nodeRef) {
        return this.findNearestParent(nodeRef, WebSiteModel.TYPE_WEB_ROOT);
    }

    public NodeRef getRelevantSection(NodeRef nodeRef) {
        return this.getRelevantSection(nodeRef, true);
    }

    public NodeRef getRelevantSection(NodeRef nodeRef, boolean allowSelf) {
        return this.findNearestParent(nodeRef, WebSiteModel.TYPE_SECTION, allowSelf);
    }

    public List<Locale> getWebSiteLocales(NodeRef website) {
        List<Locale> locales = Collections.emptyList();
        if (website != null && this.nodeService.exists(website) && this.dictionaryService.isSubClass(TYPE_WEB_SITE, this.nodeService.getType(website))) {
            Date lastModifiedTime = (Date)this.nodeService.getProperty(website, ContentModel.PROP_MODIFIED);
            Date lastLoadTime = this.websiteLocaleLoadTimes.get(website);
            locales = this.websiteLocales.get(website);
            if (locales == null || lastModifiedTime.after(lastLoadTime)) {
                locales = this.loadWebSiteLocales(website);
            }
        }
        return locales;
    }

    private List<Locale> loadWebSiteLocales(NodeRef website) {
        List<Locale> results = this.defaultWebsiteLocales;
        List languages = (List)((Object)this.nodeService.getProperty(website, PROP_SITE_LOCALES));
        if (languages != null) {
            results = new ArrayList<Locale>(languages.size());
            for (String locale : languages) {
                results.add(new Locale(locale));
            }
        }
        this.websiteLocales.put(website, results);
        this.websiteLocaleLoadTimes.put(website, new Date());
        return results;
    }

    public NodeRef getWebSiteContainer(NodeRef noderef, String containerName) {
        NodeRef shareSiteId;
        NodeRef container = null;
        SiteInfo siteInfo = this.getRelevantShareSite(noderef);
        NodeRef websiteId = this.getRelevantWebSite(noderef);
        NodeRef nodeRef = shareSiteId = siteInfo == null ? null : siteInfo.getNodeRef();
        if (siteInfo != null && this.nodeService.exists(shareSiteId) && !this.nodeService.getNodeStatus(shareSiteId).isDeleted() && !this.nodeService.hasAspect(shareSiteId, ContentModel.ASPECT_PENDING_DELETE)) {
            if (websiteId == null) {
                websiteId = siteInfo.getNodeRef();
            }
            if (this.siteService.getSite(siteInfo.getShortName()) != null) {
                NodeRef containerParent = this.siteService.getContainer(siteInfo.getShortName(), websiteId.getId());
                if (containerParent == null) {
                    containerParent = this.siteService.createContainer(siteInfo.getShortName(), websiteId.getId(), null, null);
                }
                if ((container = this.nodeService.getChildByName(containerParent, ContentModel.ASSOC_CONTAINS, containerName)) == null) {
                    HashMap<QName, String> props = new HashMap<QName, String>();
                    props.put(ContentModel.PROP_NAME, containerName);
                    container = this.nodeService.createNode(containerParent, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/website/1.0", (String)containerName), ContentModel.TYPE_FOLDER, props).getChildRef();
                }
            }
        }
        return container;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeRef getFeedbackList(String websiteName, String shareSiteName, boolean create) {
        NodeRef dataListsFolder;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Found the corresponding Share site for the specified website: " + shareSiteName));
        }
        if ((dataListsFolder = this.siteService.getContainer(shareSiteName, DATA_LISTS_FOLDER_NAME)) == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Failed to find data lists container for site " + shareSiteName + ". Attempting to create it."));
            }
            dataListsFolder = this.siteService.createContainer(shareSiteName, DATA_LISTS_FOLDER_NAME, null, null);
        }
        String listTitle = I18NUtil.getMessage((String)FEEDBACK_DATA_LIST_NAME, (Object[])new Object[]{websiteName});
        NodeRef visitorFeedbackList = null;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Searching for data list with title: " + listTitle));
        }
        String query = "+PARENT:\"" + String.valueOf(dataListsFolder) + "\" +@cm\\:title:\"" + listTitle + "\"";
        if (log.isDebugEnabled()) {
            log.debug((Object)("Running query: " + query));
        }
        try (ResultSet rs = null;){
            rs = this.searchService.query(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, "lucene", query);
            for (ResultSetRow row : rs) {
                MLText title = (MLText)row.getValue(ContentModel.PROP_TITLE);
                if (!listTitle.equals(title.getDefaultValue())) continue;
                visitorFeedbackList = row.getNodeRef();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Found the appropriate data list: " + String.valueOf(visitorFeedbackList)));
                }
                break;
            }
        }
        if (visitorFeedbackList == null && create) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Failed to find required data list. Creating...");
            }
            HashMap<QName, String> props = new HashMap<QName, String>();
            String name = GUID.generate();
            props.put(ContentModel.PROP_NAME, name);
            props.put(ContentModel.PROP_TITLE, listTitle);
            props.put(PROP_DATA_LIST_ITEM_TYPE, TYPE_VISITOR_FEEDBACK.toPrefixString((NamespacePrefixResolver)this.namespaceService));
            visitorFeedbackList = this.nodeService.createNode(dataListsFolder, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)name), TYPE_DATA_LIST, props).getChildRef();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Created data list with properties " + String.valueOf(props) + " as node " + String.valueOf(visitorFeedbackList)));
            }
        }
        return visitorFeedbackList;
    }

    public void renameFeedbackList(NodeRef feedbackList, String newName) {
        if (this.nodeService.getType(feedbackList).equals((Object)TYPE_DATA_LIST)) {
            String listTitle = I18NUtil.getMessage((String)FEEDBACK_DATA_LIST_NAME, (Object[])new Object[]{newName});
            this.nodeService.setProperty(feedbackList, ContentModel.PROP_TITLE, (Serializable)((Object)listTitle));
        }
    }

    public boolean isTranslationParentLimitReached(NodeRef nodeRef) {
        if (nodeRef == null) {
            return true;
        }
        QName nodeType = this.nodeService.getType(nodeRef);
        if (this.dictionaryService.isSubClass(nodeType, SiteModel.TYPE_SITE)) {
            return true;
        }
        return this.dictionaryService.isSubClass(nodeType, WebSiteModel.TYPE_WEB_SITE);
    }

    public void setSiteService(SiteService siteService) {
        this.siteService = siteService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public void setSearchService(SearchService searchService) {
        this.searchService = searchService;
    }

    public void setNamespaceService(NamespaceService namespaceService) {
        this.namespaceService = namespaceService;
    }

    private NodeRef findNearestParent(NodeRef noderef, QName parentType) {
        return this.findNearestParent(noderef, parentType, true);
    }

    private NodeRef findNearestParent(NodeRef noderef, QName parentType, boolean allowSelf) {
        NodeRef parentNode;
        NodeRef nodeRef = parentNode = allowSelf ? noderef : this.nodeService.getPrimaryParent(noderef).getParentRef();
        while (parentNode != null && this.nodeService.exists(parentNode) && !this.dictionaryService.isSubClass(this.nodeService.getType(parentNode), parentType)) {
            parentNode = this.nodeService.getPrimaryParent(parentNode).getParentRef();
        }
        return parentNode;
    }
}

