/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_wcmquickstart.rendition;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.module.org_alfresco_module_wcmquickstart.model.WebSiteModel;
import org.alfresco.module.org_alfresco_module_wcmquickstart.rendition.BootstrapCompositeRenditionDefinition;
import org.alfresco.module.org_alfresco_module_wcmquickstart.rendition.BootstrapRenditionDefinition;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.ParameterDefinition;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.rendition.CompositeRenditionDefinition;
import org.alfresco.service.cmr.rendition.RenderingEngineDefinition;
import org.alfresco.service.cmr.rendition.RenditionDefinition;
import org.alfresco.service.cmr.rendition.RenditionService;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ApplicationContextEvent;
import org.springframework.extensions.surf.util.AbstractLifecycleBean;

public class RenditionBootstrap
implements ApplicationContextAware,
ApplicationListener<ApplicationContextEvent>,
WebSiteModel {
    private Lifecycle lifecycle = new Lifecycle();
    private NodeService nodeService;
    private RenditionService renditionService;
    private DictionaryService dictionaryService;
    private TransactionService transactionService;
    private List<BootstrapRenditionDefinition> definitions;

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setRenditionService(RenditionService renditionService) {
        this.renditionService = renditionService;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    public void setDefinitions(List<BootstrapRenditionDefinition> definitions) {
        this.definitions = definitions;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.lifecycle.setApplicationContext(applicationContext);
    }

    private void initRenditions() {
        if (this.definitions != null) {
            for (final BootstrapRenditionDefinition definition : this.definitions) {
                AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

                    public Void doWork() throws Exception {
                        RenditionDefinition existingRenDef = RenditionBootstrap.this.renditionService.loadRenditionDefinition(definition.getQName());
                        if (existingRenDef != null) {
                            RenditionBootstrap.this.nodeService.deleteNode(existingRenDef.getNodeRef());
                        }
                        RenditionDefinition renDef = RenditionBootstrap.this.getRenditionDefinition(definition);
                        RenditionBootstrap.this.renditionService.saveRenditionDefinition(renDef);
                        return null;
                    }
                }, (String)AuthenticationUtil.getSystemUserName());
            }
        }
    }

    private RenditionDefinition getRenditionDefinition(BootstrapRenditionDefinition definition) {
        CompositeRenditionDefinition renDef = null;
        RenderingEngineDefinition engine = this.renditionService.getRenderingEngineDefinition(definition.getRenderingEngineName());
        if (engine == null) {
            throw new AlfrescoRuntimeException("Rendering engine " + definition.getRenderingEngineName() + " does not exist.");
        }
        if (definition instanceof BootstrapCompositeRenditionDefinition) {
            renDef = this.renditionService.createCompositeRenditionDefinition(definition.getQName());
            List<BootstrapRenditionDefinition> childDefs = ((BootstrapCompositeRenditionDefinition)definition).getDefinitions();
            for (BootstrapRenditionDefinition bootstrapRenditionDefinition : childDefs) {
                RenditionDefinition childRenDef = this.getRenditionDefinition(bootstrapRenditionDefinition);
                renDef.addAction((Action)childRenDef);
            }
        } else {
            renDef = this.renditionService.createRenditionDefinition(definition.getQName(), definition.getRenderingEngineName());
        }
        renDef.setExecuteAsynchronously(definition.isExecuteAsynchronously().booleanValue());
        HashMap<String, Object> convertedValues = new HashMap<String, Object>(definition.getParameters().size());
        convertedValues.put("renderingActionName", definition.getQName());
        for (Map.Entry entry : definition.getParameters().entrySet()) {
            String key = (String)entry.getKey();
            Serializable value = (Serializable)entry.getValue();
            ParameterDefinition paramDef = engine.getParameterDefintion(key);
            if (paramDef == null) {
                throw new AlfrescoRuntimeException("No parameter definition for " + key + " found for rendering engine " + definition.getRenderingEngineName());
            }
            QName paramType = paramDef.getType();
            DataTypeDefinition paramTypeDef = this.dictionaryService.getDataType(paramType);
            if (paramTypeDef == null) {
                throw new AlfrescoRuntimeException("No type definition for parameter " + key + " with type " + paramType.toString() + " and rendering engine " + definition.getRenderingEngineName());
            }
            Serializable convertedValue = (Serializable)DefaultTypeConverter.INSTANCE.convert(paramTypeDef, (Object)value);
            convertedValues.put((String)entry.getKey(), convertedValue);
        }
        renDef.setParameterValues(convertedValues);
        return renDef;
    }

    public void onApplicationEvent(ApplicationContextEvent event) {
        this.lifecycle.onApplicationEvent((ApplicationEvent)event);
    }

    private class Lifecycle
    extends AbstractLifecycleBean {
        private Lifecycle() {
        }

        protected void onBootstrap(ApplicationEvent event) {
            if (!RenditionBootstrap.this.transactionService.isReadOnly()) {
                AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

                    public Object doWork() throws Exception {
                        return RenditionBootstrap.this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

                            public Object execute() throws Throwable {
                                RenditionBootstrap.this.initRenditions();
                                return null;
                            }
                        });
                    }
                }, (String)AuthenticationUtil.getSystemUserName());
            }
        }

        protected void onShutdown(ApplicationEvent event) {
        }
    }
}

