/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_wcmquickstart.jobs.feedback;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_wcmquickstart.jobs.feedback.FeedbackProcessorHandlerBase;
import org.alfresco.module.org_alfresco_module_wcmquickstart.model.WebSiteModel;
import org.alfresco.repo.transaction.AlfrescoTransactionSupport;
import org.alfresco.service.cmr.repository.AssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CommentFeedbackProcessorHandler
extends FeedbackProcessorHandlerBase {
    private static final Log log = LogFactory.getLog(CommentFeedbackProcessorHandler.class);
    private static final String FEEDBACK_SUMMARIES_CONTAINER_NAME = "feedbackSummaries";
    private static final String KEY_SUMMARY_MAP = "summaryMap";

    @Override
    public void processFeedback(NodeRef feedback) {
        NodeRef relatedAsset;
        HashMap<NodeRef, SummaryInfo> nodeSummaryMap = (HashMap<NodeRef, SummaryInfo>)AlfrescoTransactionSupport.getResource((Object)KEY_SUMMARY_MAP);
        if (nodeSummaryMap == null) {
            nodeSummaryMap = new HashMap<NodeRef, SummaryInfo>(87);
            AlfrescoTransactionSupport.bindResource((Object)KEY_SUMMARY_MAP, nodeSummaryMap);
        }
        if ((relatedAsset = (NodeRef)this.nodeService.getProperty(feedback, PROP_RELEVANT_ASSET)) != null) {
            Integer rating;
            SummaryInfo info = (SummaryInfo)nodeSummaryMap.get(relatedAsset);
            if (info == null && this.nodeService.exists(relatedAsset)) {
                List assocs = this.nodeService.getSourceAssocs(relatedAsset, (QNamePattern)WebSiteModel.ASSOC_SUMMARISED_ASSET);
                NodeRef summaryNode = null;
                if (assocs.isEmpty()) {
                    NodeRef summaryParent = this.siteHelper.getWebSiteContainer(relatedAsset, FEEDBACK_SUMMARIES_CONTAINER_NAME);
                    if (summaryParent != null) {
                        String name = "FeedbackSummary_" + relatedAsset.getId();
                        HashMap<QName, Object> props = new HashMap<QName, Object>();
                        props.put(ContentModel.PROP_NAME, name);
                        props.put(WebSiteModel.PROP_AVERAGE_RATING, 0.0);
                        props.put(WebSiteModel.PROP_PROCESSED_RATINGS, 0);
                        props.put(WebSiteModel.PROP_COMMENT_COUNT, 0);
                        props.put(WebSiteModel.PROP_SUMMARISED_ASSET, relatedAsset);
                        summaryNode = this.nodeService.createNode(summaryParent, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)name), WebSiteModel.TYPE_VISITOR_FEEDBACK_SUMMARY, props).getChildRef();
                        this.nodeService.createAssociation(summaryNode, relatedAsset, WebSiteModel.ASSOC_SUMMARISED_ASSET);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Created a new feedback summary node for asset " + String.valueOf(relatedAsset)));
                        }
                    } else if (log.isDebugEnabled()) {
                        log.debug((Object)("Unable to create feedback summary node for asset " + String.valueOf(relatedAsset) + " because parent container could not be found."));
                    }
                } else {
                    summaryNode = ((AssociationRef)assocs.get(0)).getSourceRef();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Found an existing feedback summary node for asset " + String.valueOf(relatedAsset)));
                    }
                }
                info = new SummaryInfo(summaryNode);
                nodeSummaryMap.put(relatedAsset, info);
            }
            if (this.nodeService.getProperty(feedback, WebSiteModel.PROP_COMMENT) != null) {
                ++info.commentCount;
            }
            if ((rating = (Integer)this.nodeService.getProperty(feedback, WebSiteModel.PROP_RATING)) != null) {
                info.totalRating += rating.intValue();
                ++info.ratingCount;
            }
        } else if (log.isInfoEnabled()) {
            log.info((Object)("Skipping a piece of feedback that is related to no asset: " + String.valueOf(feedback)));
        }
    }

    @Override
    public void processorCallback() {
        HashMap nodeSummaryMap = (HashMap)AlfrescoTransactionSupport.getResource((Object)KEY_SUMMARY_MAP);
        if (nodeSummaryMap != null) {
            for (Map.Entry entry : nodeSummaryMap.entrySet()) {
                float averageRating;
                SummaryInfo summaryInfo = (SummaryInfo)entry.getValue();
                NodeRef summaryNode = summaryInfo.summaryNode;
                Map props = this.nodeService.getProperties(summaryNode);
                Integer commentCountObj = (Integer)this.nodeService.getProperty(summaryNode, WebSiteModel.PROP_COMMENT_COUNT);
                Integer processedRatingsObj = (Integer)this.nodeService.getProperty(summaryNode, WebSiteModel.PROP_PROCESSED_RATINGS);
                Float averageRatingObj = (Float)this.nodeService.getProperty(summaryNode, WebSiteModel.PROP_AVERAGE_RATING);
                int commentCount = commentCountObj == null ? 0 : commentCountObj;
                int processedRatings = processedRatingsObj == null ? 0 : processedRatingsObj;
                float f = averageRating = averageRatingObj == null ? 0.0f : averageRatingObj.floatValue();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("About to update feedback summary for asset " + String.valueOf(entry.getKey()) + ". Current values are: commentCount = " + commentCount + "; processedRatings = " + processedRatings + "; averageRating = " + averageRating));
                }
                commentCount += summaryInfo.commentCount;
                float totalRatingSoFar = averageRating * (float)processedRatings;
                if (summaryInfo.ratingCount > 0) {
                    averageRating = (totalRatingSoFar += (float)summaryInfo.totalRating) / (float)(processedRatings += summaryInfo.ratingCount);
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("About to update feedback summary for asset " + String.valueOf(entry.getKey()) + ". New values are: commentCount = " + commentCount + "; processedRatings = " + processedRatings + "; averageRating = " + averageRating));
                }
                props.put(WebSiteModel.PROP_COMMENT_COUNT, commentCount);
                props.put(WebSiteModel.PROP_PROCESSED_RATINGS, processedRatings);
                props.put(WebSiteModel.PROP_AVERAGE_RATING, Float.valueOf(averageRating));
                this.nodeService.setProperties(summaryNode, props);
            }
        }
    }

    private static class SummaryInfo {
        public int commentCount = 0;
        public int totalRating = 0;
        public int ratingCount = 0;
        public final NodeRef summaryNode;

        public SummaryInfo(NodeRef summaryNode) {
            this.summaryNode = summaryNode;
        }
    }
}

