/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_wcmquickstart.publish;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Set;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.repo.transfer.Transfer;
import org.alfresco.repo.transfer.TransferCommons;
import org.alfresco.repo.transfer.TransferTransmitter;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.transfer.TransferException;
import org.alfresco.service.cmr.transfer.TransferProgress;
import org.alfresco.service.cmr.transfer.TransferReceiver;
import org.alfresco.service.cmr.transfer.TransferTarget;
import org.alfresco.service.cmr.transfer.TransferVersion;
import org.alfresco.service.transaction.TransactionService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class InProcessTransmitterImpl
implements TransferTransmitter {
    private static final Log log = LogFactory.getLog(InProcessTransmitterImpl.class);
    private TransferReceiver receiver;
    private ContentService contentService;
    private TransactionService transactionService;

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    public Transfer begin(final TransferTarget target, final String fromRepositoryId, final TransferVersion fromVersion) throws TransferException {
        return (Transfer)this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Transfer>(){

            public Transfer execute() throws Throwable {
                Transfer transfer = new Transfer();
                String transferId = InProcessTransmitterImpl.this.receiver.start(fromRepositoryId, true, fromVersion);
                transfer.setToVersion(InProcessTransmitterImpl.this.receiver.getVersion());
                transfer.setTransferId(transferId);
                transfer.setTransferTarget(target);
                return transfer;
            }
        }, false, true);
    }

    public void abort(final Transfer transfer) throws TransferException {
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Transfer>(){

            public Transfer execute() throws Throwable {
                String transferId = transfer.getTransferId();
                InProcessTransmitterImpl.this.receiver.cancel(transferId);
                return null;
            }
        }, false, true);
    }

    public void commit(final Transfer transfer) throws TransferException {
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Transfer>(){

            public Transfer execute() throws Throwable {
                String transferId = transfer.getTransferId();
                InProcessTransmitterImpl.this.receiver.commit(transferId);
                return null;
            }
        }, false, true);
    }

    public void prepare(final Transfer transfer) throws TransferException {
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                String transferId = transfer.getTransferId();
                InProcessTransmitterImpl.this.receiver.prepare(transferId);
                return null;
            }
        }, false, true);
    }

    public void sendContent(final Transfer transfer, final Set<ContentData> data) {
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                String transferId = transfer.getTransferId();
                for (ContentData content : data) {
                    String contentUrl = content.getContentUrl();
                    String fileName = TransferCommons.URLToPartName((String)contentUrl);
                    InputStream contentStream = InProcessTransmitterImpl.this.getContentService().getRawReader(contentUrl).getContentInputStream();
                    InProcessTransmitterImpl.this.receiver.saveContent(transferId, fileName, contentStream);
                }
                return null;
            }
        }, false, true);
    }

    public void sendManifest(final Transfer transfer, final File manifest, final OutputStream results) throws TransferException {
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                try {
                    String transferId = transfer.getTransferId();
                    FileInputStream fs = new FileInputStream(manifest);
                    InProcessTransmitterImpl.this.receiver.saveSnapshot(transferId, (InputStream)fs);
                    InProcessTransmitterImpl.this.receiver.generateRequsite(transferId, results);
                    results.close();
                    return null;
                }
                catch (FileNotFoundException error) {
                    throw new TransferException("Failed to find snapshot file: " + manifest.getPath(), (Throwable)error);
                }
                catch (IOException e) {
                    throw new TransferException("Failed to either read snapshot file or write requisite file: " + manifest.getPath(), (Throwable)e);
                }
            }
        }, false, true);
    }

    public void verifyTarget(TransferTarget target) throws TransferException {
    }

    public TransferProgress getStatus(final Transfer transfer) throws TransferException {
        return (TransferProgress)this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<TransferProgress>(){

            public TransferProgress execute() throws Throwable {
                String transferId = transfer.getTransferId();
                return InProcessTransmitterImpl.this.receiver.getStatus(transferId);
            }
        }, false, true);
    }

    public void getTransferReport(Transfer transfer, OutputStream results) {
        String transferId = transfer.getTransferId();
        InputStream is = this.receiver.getTransferReport(transferId);
        try {
            BufferedInputStream br = new BufferedInputStream(is);
            byte[] buffer = new byte[1000];
            int i = br.read(buffer);
            while (i >= 0) {
                results.write(buffer, 0, i);
                i = br.read(buffer);
            }
            results.flush();
            results.close();
            br.close();
        }
        catch (IOException ie) {
            log.warn((Object)"Failed to write transfer report.", (Throwable)ie);
            return;
        }
    }

    public void setReceiver(TransferReceiver receiver) {
        this.receiver = receiver;
    }

    private ContentService getContentService() {
        return this.contentService;
    }
}

