/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_wcmquickstart.model;

import jakarta.transaction.UserTransaction;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Locale;
import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_wcmquickstart.WCMQuickStartTest;
import org.alfresco.module.org_alfresco_module_wcmquickstart.model.WebSiteModel;
import org.alfresco.service.cmr.ml.MultilingualContentService;
import org.alfresco.service.cmr.repository.AssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;

public class TemporaryMultilingualAspectTest
extends WCMQuickStartTest
implements WebSiteModel {
    private MultilingualContentService multilingualContentService;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.multilingualContentService = (MultilingualContentService)this.appContext.getBean("multilingualContentService");
    }

    public void testSiblingTranslationDocs() throws Exception {
        UserTransaction userTransaction = this.transactionService.getUserTransaction();
        userTransaction.begin();
        NodeRef french = this.nodeService.createNode(this.editorialSiteRoot, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"French"), TYPE_ARTICLE).getChildRef();
        this.multilingualContentService.makeTranslation(french, Locale.FRENCH);
        NodeRef spanish = this.nodeService.createNode(this.editorialSiteRoot, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"Spanish"), TYPE_ARTICLE).getChildRef();
        HashMap<QName, Object> props = new HashMap<QName, Object>();
        props.put(PROP_TRANSLATION_OF, french);
        props.put(PROP_LANGUAGE, "Spanish");
        this.nodeService.addAspect(spanish, ASPECT_TEMPORARY_MULTILINGUAL, props);
        TemporaryMultilingualAspectTest.assertEquals((boolean)true, (boolean)this.nodeService.hasAspect(spanish, ASPECT_TEMPORARY_MULTILINGUAL));
        TemporaryMultilingualAspectTest.assertEquals((boolean)false, (boolean)this.nodeService.hasAspect(spanish, ContentModel.ASPECT_MULTILINGUAL_DOCUMENT));
        TemporaryMultilingualAspectTest.assertEquals((boolean)false, (boolean)this.multilingualContentService.isTranslation(spanish));
        userTransaction.commit();
        userTransaction = this.transactionService.getUserTransaction();
        userTransaction.begin();
        TemporaryMultilingualAspectTest.assertEquals((boolean)false, (boolean)this.nodeService.hasAspect(spanish, ASPECT_TEMPORARY_MULTILINGUAL));
        TemporaryMultilingualAspectTest.assertEquals((boolean)true, (boolean)this.nodeService.hasAspect(spanish, ContentModel.ASPECT_LOCALIZED));
        TemporaryMultilingualAspectTest.assertEquals((boolean)true, (boolean)this.nodeService.hasAspect(spanish, ContentModel.ASPECT_MULTILINGUAL_DOCUMENT));
        TemporaryMultilingualAspectTest.assertEquals((boolean)true, (boolean)this.multilingualContentService.isTranslation(spanish));
        NodeRef german = this.nodeService.createNode(this.editorialSiteRoot, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"German"), TYPE_ARTICLE).getChildRef();
        props = new HashMap();
        props.put(PROP_TRANSLATION_OF, french);
        this.nodeService.addAspect(german, ASPECT_TEMPORARY_MULTILINGUAL, props);
        userTransaction.commit();
        userTransaction = this.transactionService.getUserTransaction();
        userTransaction.begin();
        TemporaryMultilingualAspectTest.assertEquals((boolean)false, (boolean)this.nodeService.hasAspect(german, ASPECT_TEMPORARY_MULTILINGUAL));
        TemporaryMultilingualAspectTest.assertEquals((boolean)false, (boolean)this.nodeService.hasAspect(german, ContentModel.ASPECT_MULTILINGUAL_DOCUMENT));
        TemporaryMultilingualAspectTest.assertEquals((boolean)false, (boolean)this.multilingualContentService.isTranslation(german));
        userTransaction.commit();
    }

    public void testSiblingTranslationFolders() throws Exception {
        UserTransaction userTransaction = this.transactionService.getUserTransaction();
        userTransaction.begin();
        NodeRef french = this.nodeService.createNode(this.editorialSiteRoot, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"French"), TYPE_SECTION).getChildRef();
        this.multilingualContentService.makeTranslation(french, Locale.FRENCH);
        userTransaction.commit();
        userTransaction = this.transactionService.getUserTransaction();
        userTransaction.begin();
        NodeRef frenchIndex = this.nodeService.getChildByName(french, ContentModel.ASSOC_CONTAINS, "index.html");
        TemporaryMultilingualAspectTest.assertNotNull((Object)frenchIndex);
        TemporaryMultilingualAspectTest.assertEquals((boolean)false, (boolean)this.multilingualContentService.isTranslation(frenchIndex));
        NodeRef frenchCollection = this.nodeService.getChildByName(french, ContentModel.ASSOC_CONTAINS, "collections");
        NodeRef collectionMisc = this.nodeService.createNode(frenchCollection, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"Misc"), ContentModel.TYPE_CONTENT).getChildRef();
        this.nodeService.setProperty(collectionMisc, ContentModel.PROP_NAME, (Serializable)((Object)"Misc"));
        AssociationRef collectionFeatured = this.nodeService.createAssociation(this.nodeService.getChildByName(frenchCollection, ContentModel.ASSOC_CONTAINS, "featured.articles"), collectionMisc, ContentModel.ASSOC_REFERENCES);
        userTransaction.commit();
        userTransaction = this.transactionService.getUserTransaction();
        userTransaction.begin();
        NodeRef spanish = this.nodeService.createNode(this.editorialSiteRoot, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"Spanish"), TYPE_SECTION).getChildRef();
        HashMap<QName, Object> props = new HashMap<QName, Object>();
        props.put(PROP_TRANSLATION_OF, french);
        props.put(PROP_LANGUAGE, "Spanish");
        this.nodeService.addAspect(spanish, ASPECT_TEMPORARY_MULTILINGUAL, props);
        TemporaryMultilingualAspectTest.assertEquals((boolean)true, (boolean)this.nodeService.hasAspect(spanish, ASPECT_TEMPORARY_MULTILINGUAL));
        TemporaryMultilingualAspectTest.assertEquals((boolean)false, (boolean)this.nodeService.hasAspect(spanish, ContentModel.ASPECT_MULTILINGUAL_DOCUMENT));
        TemporaryMultilingualAspectTest.assertEquals((boolean)false, (boolean)this.multilingualContentService.isTranslation(spanish));
        userTransaction.commit();
        userTransaction = this.transactionService.getUserTransaction();
        userTransaction.begin();
        TemporaryMultilingualAspectTest.assertEquals((boolean)false, (boolean)this.nodeService.hasAspect(spanish, ASPECT_TEMPORARY_MULTILINGUAL));
        TemporaryMultilingualAspectTest.assertEquals((boolean)true, (boolean)this.nodeService.hasAspect(spanish, ContentModel.ASPECT_LOCALIZED));
        TemporaryMultilingualAspectTest.assertEquals((boolean)true, (boolean)this.multilingualContentService.isTranslation(spanish));
        Locale spanishLocale = (Locale)this.nodeService.getProperty(spanish, ContentModel.PROP_LOCALE);
        TemporaryMultilingualAspectTest.assertEquals((String)"spanish", (String)spanishLocale.toString());
        NodeRef spanishCollection = this.nodeService.getChildByName(spanish, ContentModel.ASSOC_CONTAINS, "collections");
        TemporaryMultilingualAspectTest.assertNotNull((Object)spanishCollection);
        NodeRef collectionMiscES = this.nodeService.getChildByName(spanishCollection, ContentModel.ASSOC_CONTAINS, "Misc");
        TemporaryMultilingualAspectTest.assertNotNull((Object)collectionMiscES);
        NodeRef collectionFeaturedES = this.nodeService.getChildByName(this.nodeService.getChildByName(spanishCollection, ContentModel.ASSOC_CONTAINS, "featured.articles"), ContentModel.ASSOC_CONTAINS, "Misc");
        TemporaryMultilingualAspectTest.assertNull((Object)collectionFeaturedES);
        NodeRef spanishIndex = this.nodeService.getChildByName(spanish, ContentModel.ASSOC_CONTAINS, "index.html");
        TemporaryMultilingualAspectTest.assertNotNull((Object)spanishIndex);
        TemporaryMultilingualAspectTest.assertEquals((boolean)true, (boolean)this.multilingualContentService.isTranslation(frenchIndex));
        TemporaryMultilingualAspectTest.assertEquals((boolean)true, (boolean)this.multilingualContentService.isTranslation(spanishIndex));
        TemporaryMultilingualAspectTest.assertEquals((Object)spanishIndex, this.multilingualContentService.getTranslations(frenchIndex).get(spanishLocale));
        userTransaction.commit();
    }

    public void testTranslationDocAllFoldersExist() throws Exception {
        UserTransaction userTransaction = this.transactionService.getUserTransaction();
        userTransaction.begin();
        NodeRef french = this.nodeService.createNode(this.editorialSiteRoot, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"French"), TYPE_SECTION).getChildRef();
        this.multilingualContentService.makeTranslation(french, Locale.FRENCH);
        NodeRef fr_F1 = this.nodeService.createNode(french, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"Sub1"), TYPE_SECTION).getChildRef();
        NodeRef fr_F2 = this.nodeService.createNode(fr_F1, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"Sub2"), TYPE_SECTION).getChildRef();
        userTransaction.commit();
        userTransaction = this.transactionService.getUserTransaction();
        userTransaction.begin();
        NodeRef spanish = this.nodeService.createNode(this.editorialSiteRoot, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"Spanish"), TYPE_SECTION).getChildRef();
        HashMap<QName, Object> props = new HashMap<QName, Object>();
        props.put(PROP_TRANSLATION_OF, french);
        props.put(PROP_LANGUAGE, "Spanish");
        this.nodeService.addAspect(spanish, ASPECT_TEMPORARY_MULTILINGUAL, props);
        NodeRef es_F1 = this.nodeService.createNode(spanish, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"Sub1"), TYPE_SECTION).getChildRef();
        NodeRef es_F2 = this.nodeService.createNode(es_F1, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"Sub2"), TYPE_SECTION).getChildRef();
        userTransaction.commit();
        userTransaction = this.transactionService.getUserTransaction();
        userTransaction.begin();
        NodeRef fr_Doc = this.nodeService.createNode(fr_F2, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"French"), TYPE_ARTICLE).getChildRef();
        props = new HashMap();
        this.nodeService.addAspect(fr_Doc, ASPECT_TEMPORARY_MULTILINGUAL, props);
        NodeRef es_Doc = this.nodeService.createNode(es_F2, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"Spanish"), TYPE_ARTICLE).getChildRef();
        props = new HashMap();
        props.put(PROP_TRANSLATION_OF, fr_Doc);
        this.nodeService.addAspect(es_Doc, ASPECT_TEMPORARY_MULTILINGUAL, props);
        userTransaction.commit();
        userTransaction = this.transactionService.getUserTransaction();
        userTransaction.begin();
        TemporaryMultilingualAspectTest.assertEquals((boolean)false, (boolean)this.nodeService.hasAspect(french, ASPECT_TEMPORARY_MULTILINGUAL));
        TemporaryMultilingualAspectTest.assertEquals((boolean)true, (boolean)this.nodeService.hasAspect(french, ContentModel.ASPECT_LOCALIZED));
        TemporaryMultilingualAspectTest.assertEquals((boolean)true, (boolean)this.nodeService.hasAspect(french, ContentModel.ASPECT_MULTILINGUAL_DOCUMENT));
        TemporaryMultilingualAspectTest.assertEquals((boolean)true, (boolean)this.multilingualContentService.isTranslation(french));
        TemporaryMultilingualAspectTest.assertEquals((String)"fr", (String)this.nodeService.getProperty(french, ContentModel.PROP_LOCALE).toString());
        TemporaryMultilingualAspectTest.assertEquals((boolean)false, (boolean)this.nodeService.hasAspect(spanish, ASPECT_TEMPORARY_MULTILINGUAL));
        TemporaryMultilingualAspectTest.assertEquals((boolean)true, (boolean)this.nodeService.hasAspect(spanish, ContentModel.ASPECT_LOCALIZED));
        TemporaryMultilingualAspectTest.assertEquals((boolean)true, (boolean)this.nodeService.hasAspect(spanish, ContentModel.ASPECT_MULTILINGUAL_DOCUMENT));
        TemporaryMultilingualAspectTest.assertEquals((boolean)true, (boolean)this.multilingualContentService.isTranslation(spanish));
        TemporaryMultilingualAspectTest.assertEquals((String)"spanish", (String)this.nodeService.getProperty(spanish, ContentModel.PROP_LOCALE).toString());
        TemporaryMultilingualAspectTest.assertEquals((boolean)false, (boolean)this.nodeService.hasAspect(fr_Doc, ASPECT_TEMPORARY_MULTILINGUAL));
        TemporaryMultilingualAspectTest.assertEquals((boolean)true, (boolean)this.nodeService.hasAspect(fr_Doc, ContentModel.ASPECT_LOCALIZED));
        TemporaryMultilingualAspectTest.assertEquals((boolean)true, (boolean)this.multilingualContentService.isTranslation(fr_Doc));
        TemporaryMultilingualAspectTest.assertEquals((String)"fr", (String)this.nodeService.getProperty(fr_Doc, ContentModel.PROP_LOCALE).toString());
        TemporaryMultilingualAspectTest.assertEquals((boolean)false, (boolean)this.nodeService.hasAspect(es_Doc, ASPECT_TEMPORARY_MULTILINGUAL));
        TemporaryMultilingualAspectTest.assertEquals((boolean)true, (boolean)this.nodeService.hasAspect(es_Doc, ContentModel.ASPECT_LOCALIZED));
        TemporaryMultilingualAspectTest.assertEquals((boolean)true, (boolean)this.multilingualContentService.isTranslation(es_Doc));
        TemporaryMultilingualAspectTest.assertEquals((String)"spanish", (String)this.nodeService.getProperty(es_Doc, ContentModel.PROP_LOCALE).toString());
        userTransaction.commit();
    }

    public void testTranslationDocFoldersToBeCreated() throws Exception {
        UserTransaction userTransaction = this.transactionService.getUserTransaction();
        userTransaction.begin();
        NodeRef french = this.nodeService.createNode(this.editorialSiteRoot, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"French"), TYPE_SECTION).getChildRef();
        this.nodeService.setProperty(french, ContentModel.PROP_NAME, (Serializable)((Object)"French"));
        this.multilingualContentService.makeTranslation(french, Locale.FRENCH);
        NodeRef fr_F1 = this.nodeService.createNode(french, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"Sub1"), TYPE_SECTION).getChildRef();
        this.nodeService.setProperty(fr_F1, ContentModel.PROP_NAME, (Serializable)((Object)"Sub1"));
        NodeRef fr_F2 = this.nodeService.createNode(fr_F1, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"Sub2"), TYPE_SECTION).getChildRef();
        this.nodeService.setProperty(fr_F2, ContentModel.PROP_NAME, (Serializable)((Object)"Sub2"));
        userTransaction.commit();
        userTransaction = this.transactionService.getUserTransaction();
        userTransaction.begin();
        NodeRef spanish = this.nodeService.createNode(this.editorialSiteRoot, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"Spanish"), TYPE_SECTION).getChildRef();
        this.nodeService.setProperty(spanish, ContentModel.PROP_NAME, (Serializable)((Object)"Spanish"));
        HashMap<QName, Object> props = new HashMap<QName, Object>();
        props.put(PROP_TRANSLATION_OF, french);
        props.put(PROP_LANGUAGE, "Spanish");
        this.nodeService.addAspect(spanish, ASPECT_TEMPORARY_MULTILINGUAL, props);
        userTransaction.commit();
        userTransaction = this.transactionService.getUserTransaction();
        userTransaction.begin();
        NodeRef fr_Doc = this.nodeService.createNode(fr_F2, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"French Document.txt"), TYPE_ARTICLE).getChildRef();
        this.nodeService.setProperty(fr_Doc, ContentModel.PROP_NAME, (Serializable)((Object)"French Document.txt"));
        props = new HashMap();
        this.nodeService.addAspect(fr_Doc, ASPECT_TEMPORARY_MULTILINGUAL, props);
        NodeRef es_Doc = this.nodeService.createNode(spanish, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"Spanish Document.txt"), TYPE_ARTICLE).getChildRef();
        this.nodeService.setProperty(es_Doc, ContentModel.PROP_NAME, (Serializable)((Object)"Spanish Document.txt"));
        props = new HashMap();
        props.put(PROP_TRANSLATION_OF, fr_Doc);
        props.put(PROP_INITIALLY_ORPHANED, true);
        this.nodeService.addAspect(es_Doc, ASPECT_TEMPORARY_MULTILINGUAL, props);
        userTransaction.commit();
        userTransaction = this.transactionService.getUserTransaction();
        userTransaction.begin();
        NodeRef spanishSub1 = this.nodeService.getChildByName(spanish, ContentModel.ASSOC_CONTAINS, "Sub1");
        TemporaryMultilingualAspectTest.assertNotNull((String)"Spanish Sub Folder 1 not created", (Object)spanishSub1);
        NodeRef spanishSub2 = this.nodeService.getChildByName(spanishSub1, ContentModel.ASSOC_CONTAINS, "Sub2");
        TemporaryMultilingualAspectTest.assertNotNull((String)"Spanish Sub Folder 2 not created", (Object)spanishSub2);
        TemporaryMultilingualAspectTest.assertEquals((boolean)true, (boolean)this.multilingualContentService.isTranslation(spanishSub1));
        TemporaryMultilingualAspectTest.assertEquals((boolean)true, (boolean)this.multilingualContentService.isTranslation(spanishSub2));
        TemporaryMultilingualAspectTest.assertEquals((Object)fr_F1, (Object)this.multilingualContentService.getTranslationForLocale(spanishSub1, Locale.FRENCH));
        TemporaryMultilingualAspectTest.assertEquals((Object)fr_F2, (Object)this.multilingualContentService.getTranslationForLocale(spanishSub2, Locale.FRENCH));
        NodeRef spanishSub2Index = this.nodeService.getChildByName(spanishSub2, ContentModel.ASSOC_CONTAINS, "index.html");
        TemporaryMultilingualAspectTest.assertNotNull((Object)spanishSub2Index);
        NodeRef frenchhSub2Index = this.nodeService.getChildByName(fr_F2, ContentModel.ASSOC_CONTAINS, "index.html");
        TemporaryMultilingualAspectTest.assertNotNull((Object)frenchhSub2Index);
        TemporaryMultilingualAspectTest.assertEquals((boolean)true, (boolean)this.multilingualContentService.isTranslation(frenchhSub2Index));
        TemporaryMultilingualAspectTest.assertEquals((boolean)true, (boolean)this.multilingualContentService.isTranslation(spanishSub2Index));
        TemporaryMultilingualAspectTest.assertEquals((Object)frenchhSub2Index, (Object)this.multilingualContentService.getTranslationForLocale(spanishSub2Index, Locale.FRENCH));
        TemporaryMultilingualAspectTest.assertNotNull((String)"Spanish doc isn't in Sub Folder 2", (Object)this.nodeService.getChildByName(spanishSub2, ContentModel.ASSOC_CONTAINS, "Spanish Document.txt"));
        TemporaryMultilingualAspectTest.assertNull((String)"Spanish doc has gone from the root", (Object)this.nodeService.getChildByName(spanish, ContentModel.ASSOC_CONTAINS, "Spanish Document.txt"));
        TemporaryMultilingualAspectTest.assertEquals((Object)spanishSub2, (Object)this.nodeService.getPrimaryParent(es_Doc).getParentRef());
        TemporaryMultilingualAspectTest.assertEquals((String)"Spanish Document.txt", (String)this.nodeService.getPrimaryParent(es_Doc).getQName().getLocalName());
        userTransaction.commit();
    }

    public void testTranslationDocFoldersClaiming() throws Exception {
        UserTransaction userTransaction = this.transactionService.getUserTransaction();
        userTransaction.begin();
        NodeRef french = this.nodeService.createNode(this.editorialSiteRoot, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"French"), TYPE_SECTION).getChildRef();
        this.nodeService.setProperty(french, ContentModel.PROP_NAME, (Serializable)((Object)"French"));
        this.multilingualContentService.makeTranslation(french, Locale.FRENCH);
        NodeRef fr_F1 = this.nodeService.createNode(french, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"Sub1"), TYPE_SECTION).getChildRef();
        this.nodeService.setProperty(fr_F1, ContentModel.PROP_NAME, (Serializable)((Object)"Sub1"));
        NodeRef fr_F2 = this.nodeService.createNode(fr_F1, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"Sub2"), TYPE_SECTION).getChildRef();
        this.nodeService.setProperty(fr_F2, ContentModel.PROP_NAME, (Serializable)((Object)"Sub2"));
        userTransaction.commit();
        userTransaction = this.transactionService.getUserTransaction();
        userTransaction.begin();
        NodeRef spanish = this.nodeService.createNode(this.editorialSiteRoot, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"Spanish"), TYPE_SECTION).getChildRef();
        this.nodeService.setProperty(spanish, ContentModel.PROP_NAME, (Serializable)((Object)"Spanish"));
        HashMap<QName, Object> props = new HashMap<QName, Object>();
        props.put(PROP_TRANSLATION_OF, french);
        props.put(PROP_LANGUAGE, "Spanish");
        this.nodeService.addAspect(spanish, ASPECT_TEMPORARY_MULTILINGUAL, props);
        NodeRef es_F1 = this.nodeService.createNode(spanish, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"Sub1"), TYPE_SECTION).getChildRef();
        this.nodeService.setProperty(es_F1, ContentModel.PROP_NAME, (Serializable)((Object)"Sub1"));
        NodeRef es_F2 = this.nodeService.createNode(es_F1, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"Sub2"), TYPE_SECTION).getChildRef();
        this.nodeService.setProperty(es_F2, ContentModel.PROP_NAME, (Serializable)((Object)"Sub2"));
        userTransaction.commit();
        userTransaction = this.transactionService.getUserTransaction();
        userTransaction.begin();
        NodeRef fr_Doc = this.nodeService.createNode(fr_F2, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"French Document.txt"), TYPE_ARTICLE).getChildRef();
        this.nodeService.setProperty(fr_Doc, ContentModel.PROP_NAME, (Serializable)((Object)"French Document.txt"));
        props = new HashMap();
        this.nodeService.addAspect(fr_Doc, ASPECT_TEMPORARY_MULTILINGUAL, props);
        NodeRef es_Doc = this.nodeService.createNode(spanish, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"Spanish Document.txt"), TYPE_ARTICLE).getChildRef();
        this.nodeService.setProperty(es_Doc, ContentModel.PROP_NAME, (Serializable)((Object)"Spanish Document.txt"));
        props = new HashMap();
        props.put(PROP_TRANSLATION_OF, fr_Doc);
        props.put(PROP_INITIALLY_ORPHANED, true);
        this.nodeService.addAspect(es_Doc, ASPECT_TEMPORARY_MULTILINGUAL, props);
        userTransaction.commit();
        userTransaction = this.transactionService.getUserTransaction();
        userTransaction.begin();
        TemporaryMultilingualAspectTest.assertEquals((boolean)true, (boolean)this.multilingualContentService.isTranslation(es_F1));
        TemporaryMultilingualAspectTest.assertEquals((boolean)true, (boolean)this.multilingualContentService.isTranslation(es_F2));
        TemporaryMultilingualAspectTest.assertEquals((Object)fr_F1, (Object)this.multilingualContentService.getTranslationForLocale(es_F1, Locale.FRENCH));
        TemporaryMultilingualAspectTest.assertEquals((Object)fr_F2, (Object)this.multilingualContentService.getTranslationForLocale(es_F2, Locale.FRENCH));
        NodeRef spanishSub2Index = this.nodeService.getChildByName(es_F2, ContentModel.ASSOC_CONTAINS, "index.html");
        TemporaryMultilingualAspectTest.assertNotNull((Object)spanishSub2Index);
        NodeRef frenchhSub2Index = this.nodeService.getChildByName(fr_F2, ContentModel.ASSOC_CONTAINS, "index.html");
        TemporaryMultilingualAspectTest.assertNotNull((Object)frenchhSub2Index);
        TemporaryMultilingualAspectTest.assertEquals((boolean)true, (boolean)this.multilingualContentService.isTranslation(frenchhSub2Index));
        TemporaryMultilingualAspectTest.assertEquals((boolean)true, (boolean)this.multilingualContentService.isTranslation(spanishSub2Index));
        TemporaryMultilingualAspectTest.assertEquals((Object)frenchhSub2Index, (Object)this.multilingualContentService.getTranslationForLocale(spanishSub2Index, Locale.FRENCH));
        TemporaryMultilingualAspectTest.assertNotNull((String)"Spanish doc isn't in Sub Folder 2", (Object)this.nodeService.getChildByName(es_F2, ContentModel.ASSOC_CONTAINS, "Spanish Document.txt"));
        TemporaryMultilingualAspectTest.assertNull((String)"Spanish doc has gone from the root", (Object)this.nodeService.getChildByName(spanish, ContentModel.ASSOC_CONTAINS, "Spanish Document.txt"));
        TemporaryMultilingualAspectTest.assertEquals((Object)es_F2, (Object)this.nodeService.getPrimaryParent(es_Doc).getParentRef());
        TemporaryMultilingualAspectTest.assertEquals((String)"Spanish Document.txt", (String)this.nodeService.getPrimaryParent(es_Doc).getQName().getLocalName());
        userTransaction.commit();
    }
}

