/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_wcmquickstart.webscript;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_wcmquickstart.util.AssetSerializerFactory;
import org.alfresco.module.org_alfresco_module_wcmquickstart.util.SiteHelper;
import org.alfresco.service.cmr.repository.AssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.SearchParameters;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.webscripts.AbstractWebScript;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;
import org.springframework.extensions.webscripts.WebScriptResponse;

public class AssetGet
extends AbstractWebScript {
    private static final String PARAM_NODEREF = "noderef";
    private static final String PARAM_MODIFIED_TIME_ONLY = "modifiedTimeOnly";
    private static final String PARAM_SITE_ID = "siteid";
    private static final String PARAM_SECTION_ID = "sectionid";
    private static final String PARAM_NODE_NAME = "nodename";
    private static final Log log = LogFactory.getLog(AssetGet.class);
    private NodeService nodeService;
    private SearchService searchService;
    private AssetSerializerFactory assetSerializerFactory;
    private SiteHelper siteHelper;

    public void setAssetSerializerFactory(AssetSerializerFactory assetSerializerFactory) {
        this.assetSerializerFactory = assetSerializerFactory;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setSearchService(SearchService searchService) {
        this.searchService = searchService;
    }

    public void setSiteHelper(SiteHelper siteHelper) {
        this.siteHelper = siteHelper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void execute(WebScriptRequest req, WebScriptResponse res) throws IOException {
        try {
            foundNodes = new ArrayList<NodeRef>();
            nodeRefs = req.getParameterValues("noderef");
            v0 = onlyModifiedTime = req.getParameter("modifiedTimeOnly") != null;
            if (nodeRefs == null || nodeRefs.length == 0) {
                sectionIdText = req.getParameter("sectionid");
                nodeName = req.getParameter("nodename");
                if (sectionIdText == null || sectionIdText.length() == 0 || nodeName == null || nodeName.length() == 0) {
                    throw new WebScriptException("Either noderef or sectionid and nodename are required parameters");
                }
                if (AssetGet.log.isDebugEnabled()) {
                    AssetGet.log.debug((Object)("Received request for named asset in section " + (String)sectionIdText + ": " + nodeName + (onlyModifiedTime != false ? "   (modified time only)" : "")));
                }
                siteId = null;
                siteIdText = req.getParameter("siteid");
                siteId = siteIdText == null ? this.siteHelper.getRelevantWebSite(new NodeRef((String)sectionIdText)) : new NodeRef(siteIdText);
                query = "+@ws\\:parentSections:\"" + (String)sectionIdText + "\" +@cm\\:name:\"" + nodeName + "\"";
                searchParameters = new SearchParameters();
                searchParameters.addStore(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE);
                searchParameters.setLanguage("lucene");
                searchParameters.setQuery(query);
                locales = this.siteHelper.getWebSiteLocales(siteId);
                for (Locale locale : locales) {
                    searchParameters.addLocale(locale);
                }
                rs = null;
                try {
                    rs = this.searchService.query(searchParameters);
                    if (rs.length() <= 0) ** GOTO lbl47
                    foundNodes.add(rs.getNodeRef(0));
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                }
            } else {
                if (AssetGet.log.isDebugEnabled()) {
                    AssetGet.log.debug((Object)("Received request for specific node(s): " + Arrays.toString(nodeRefs) + (onlyModifiedTime != false ? "   (modified time only)" : "")));
                }
                for (Object nodeRefString : nodeRefs) {
                    try {
                        nodeRef = new NodeRef((String)nodeRefString);
                        if (!this.nodeService.exists(nodeRef) || this.nodeService.getProperty(nodeRef, ContentModel.PROP_NODE_UUID) == null) continue;
                        foundNodes.add(nodeRef);
                    }
                    catch (Exception nodeRef) {
                        // empty catch block
                    }
                }
            }
lbl47:
            // 3 sources

            res.setContentEncoding("UTF-8");
            writer = res.getWriter();
            assetSerializer = this.assetSerializerFactory.getAssetSerializer();
            res.setContentType(assetSerializer.getMimeType());
            assetSerializer.start(writer);
            for (NodeRef nodeRef : foundNodes) {
                typeName = this.nodeService.getType(nodeRef);
                if (onlyModifiedTime) {
                    properties = new HashMap<K, V>(3);
                    properties.put(ContentModel.PROP_MODIFIED, this.nodeService.getProperty(nodeRef, ContentModel.PROP_MODIFIED));
                } else {
                    properties = this.nodeService.getProperties(nodeRef);
                    associations = this.nodeService.getTargetAssocs(nodeRef, RegexQNamePattern.MATCH_ALL);
                    if (!associations.isEmpty()) {
                        sourceRelationshipMap = new HashMap<QName, ArrayList<NodeRef>>();
                        for (AssociationRef assoc : associations) {
                            assocType = assoc.getTypeQName();
                            endpoints = (ArrayList<NodeRef>)sourceRelationshipMap.get(assocType);
                            if (endpoints == null) {
                                endpoints = new ArrayList<NodeRef>();
                                sourceRelationshipMap.put(assocType, endpoints);
                            }
                            endpoints.add(assoc.getTargetRef());
                        }
                        properties.put(QName.createQName((String)"http://www.alfresco.org/model/website/1.0", (String)"sourceRelationships"), sourceRelationshipMap);
                    }
                }
                assetSerializer.writeNode(nodeRef, typeName, properties);
            }
            assetSerializer.end();
        }
        catch (Throwable e) {
            throw this.createStatusException(e, req, res);
        }
    }
}

