/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_wcmquickstart.jobs;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicBoolean;
import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_wcmquickstart.model.WebSiteModel;
import org.alfresco.repo.admin.RepositoryState;
import org.alfresco.repo.lock.JobLockService;
import org.alfresco.repo.lock.LockAcquisitionException;
import org.alfresco.repo.policy.BehaviourFilter;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.ResultSetRow;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.VmShutdownListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AvailabilityProcessor {
    private static final Log log = LogFactory.getLog(AvailabilityProcessor.class);
    private RetryingTransactionHelper txHelper;
    private SearchService searchService;
    private NodeService nodeService;
    private BehaviourFilter behaviourFilter;
    private RepositoryState repositoryState;
    private JobLockService jobLockService;
    private static final long LOCK_TTL = 60000L;
    private static final QName LOCK_QNAME = QName.createQName((String)"http://www.alfresco.org/model/system/1.0", (String)"org.alfresco.module.org_alfresco_module_wcmquickstart.jobs.AvailabilityProcessor");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (this.repositoryState.isBootstrapping()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Availability processor can not be executed while the repository is bootstrapping");
            }
            return;
        }
        LockCallback lockCallback = new LockCallback(this);
        String lockToken = null;
        try {
            lockToken = this.jobLockService.getLock(LOCK_QNAME, 60000L);
            if (lockToken == null) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)"Can't get lock.");
                }
                return;
            }
            if (log.isDebugEnabled()) {
                log.trace((Object)"Activities availability processor started");
            }
            this.jobLockService.refreshLock(lockToken, LOCK_QNAME, 60000L, (JobLockService.JobLockRefreshCallback)lockCallback);
            this.runInternal();
            if (log.isDebugEnabled()) {
                log.trace((Object)"Activities availability processor completed");
            }
        }
        catch (LockAcquisitionException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Activities availability processor already underway");
            }
        }
        catch (VmShutdownListener.VmShutdownException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Activities availability processor aborted");
            }
        }
        finally {
            lockCallback.running.set(false);
            if (lockToken != null) {
                this.jobLockService.releaseLock(lockToken, LOCK_QNAME);
            }
        }
    }

    private void runInternal() {
        this.txHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            public Object execute() throws Throwable {
                return AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public Object doWork() throws Exception {
                        AvailabilityProcessor.this.behaviourFilter.disableBehaviour(ContentModel.ASPECT_AUDITABLE);
                        try (ResultSet rs = null;){
                            rs = AvailabilityProcessor.this.searchService.query(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, "lucene", "+@ws\\:availableFromDate:today +@ws\\:published:\"false\"");
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("Number of assets found that are due to become available: " + rs.length()));
                            }
                            for (ResultSetRow row : rs) {
                                AvailabilityProcessor.this.nodeService.setProperty(row.getNodeRef(), WebSiteModel.PROP_AVAILABLE, (Serializable)Boolean.TRUE);
                            }
                        }
                        rs = null;
                        try {
                            rs = AvailabilityProcessor.this.searchService.query(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, "lucene", "+@ws\\:availableToDate:today +@ws\\:published:\"true\"");
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("Number of assets found that are due to expire: " + rs.length()));
                            }
                            for (ResultSetRow row : rs) {
                                AvailabilityProcessor.this.nodeService.setProperty(row.getNodeRef(), WebSiteModel.PROP_AVAILABLE, (Serializable)Boolean.FALSE);
                            }
                        }
                        finally {
                            AvailabilityProcessor.this.behaviourFilter.enableBehaviour(ContentModel.ASPECT_AUDITABLE);
                            rs.close();
                        }
                        return null;
                    }
                }, (String)"System");
            }
        });
    }

    public void setTxHelper(RetryingTransactionHelper txHelper) {
        this.txHelper = txHelper;
    }

    public void setSearchService(SearchService searchService) {
        this.searchService = searchService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setBehaviourFilter(BehaviourFilter behaviourFilter) {
        this.behaviourFilter = behaviourFilter;
    }

    public void setRepositoryState(RepositoryState repositoryState) {
        this.repositoryState = repositoryState;
    }

    public void setJobLockService(JobLockService jobLockService) {
        this.jobLockService = jobLockService;
    }

    private class LockCallback
    implements JobLockService.JobLockRefreshCallback {
        final AtomicBoolean running = new AtomicBoolean(true);

        private LockCallback(AvailabilityProcessor availabilityProcessor) {
        }

        public boolean isActive() {
            return this.running.get();
        }

        public void lockReleased() {
            this.running.set(false);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Lock released : " + String.valueOf(LOCK_QNAME)));
            }
        }
    }
}

