/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_wcmquickstart.util;

import java.io.Serializable;
import java.io.Writer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.model.ApplicationModel;
import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_wcmquickstart.model.WebSiteModel;
import org.alfresco.module.org_alfresco_module_wcmquickstart.util.AssetSerializationException;
import org.alfresco.module.org_alfresco_module_wcmquickstart.util.AssetSerializer;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.MLText;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.dom4j.CDATA;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.dom4j.tree.FlyweightCDATA;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class AssetSerializerXmlImpl
implements AssetSerializer {
    private static final AttributesImpl EMPTY_ATTRIBUTES = new AttributesImpl();
    private static Set<QName> DEFAULT_PROPERTIES_TO_IGNORE;
    private static ThreadLocal<DateFormat> dateFormat;
    private XMLWriter writer;
    private NamespaceService namespaceService;
    private Set<QName> propertiesToIgnore = DEFAULT_PROPERTIES_TO_IGNORE;

    public void setNamespaceService(NamespaceService namespaceService) {
        this.namespaceService = namespaceService;
    }

    @Override
    public void start(Writer underlyingWriter) throws AssetSerializationException {
        try {
            OutputFormat format = OutputFormat.createCompactFormat();
            format.setEncoding("UTF-8");
            this.writer = new XMLWriter(underlyingWriter, format);
            this.writer.startDocument();
            this.startElement("assets", EMPTY_ATTRIBUTES);
        }
        catch (Exception ex) {
            throw new AssetSerializationException(ex);
        }
    }

    @Override
    public void end() throws AssetSerializationException {
        try {
            this.endElement("assets");
        }
        catch (Exception ex) {
            throw new AssetSerializationException(ex);
        }
    }

    @Override
    public void writeHeader(Map<QName, Serializable> properties) throws AssetSerializationException {
        try {
            this.startElement("header", EMPTY_ATTRIBUTES);
            for (Map.Entry<QName, Serializable> property : properties.entrySet()) {
                if (this.propertiesToIgnore.contains(property.getKey())) continue;
                this.writeProperty(property.getKey(), property.getValue());
            }
            this.endElement("header");
        }
        catch (Exception ex) {
            throw new AssetSerializationException(ex);
        }
    }

    @Override
    public void writeNode(NodeRef nodeRef, QName type, Map<QName, Serializable> properties) throws AssetSerializationException {
        try {
            AttributesImpl attributes = new AttributesImpl();
            attributes.addAttribute(null, "id", "id", "String", nodeRef.toString());
            attributes.addAttribute(null, "type", "type", "String", type.toPrefixString((NamespacePrefixResolver)this.namespaceService));
            this.startElement("asset", attributes);
            for (Map.Entry<QName, Serializable> property : properties.entrySet()) {
                if (this.propertiesToIgnore.contains(property.getKey())) continue;
                this.writeProperty(property.getKey(), property.getValue());
            }
            this.endElement("asset");
        }
        catch (Exception ex) {
            throw new AssetSerializationException(ex);
        }
    }

    private void writeProperty(QName name, Object value) throws Exception {
        AttributesImpl attrs = new AttributesImpl();
        attrs.addAttribute(null, "name", "name", "String", name.toPrefixString((NamespacePrefixResolver)this.namespaceService));
        this.startElement("property", attrs);
        this.writeValue(value);
        this.endElement("property");
    }

    private void writeValue(Object value) throws Exception {
        Class<?> valueClass;
        Class<?> clazz = valueClass = value == null ? null : value.getClass();
        if (valueClass != null && List.class.isAssignableFrom(valueClass)) {
            List listValue = (List)value;
            this.startElement("list", EMPTY_ATTRIBUTES);
            for (Object element : listValue) {
                this.writeValue(element);
            }
            this.endElement("list");
        } else if (valueClass != null && Map.class.isAssignableFrom(valueClass)) {
            Map mapValue = (Map)value;
            this.startElement("map", EMPTY_ATTRIBUTES);
            for (Map.Entry element : mapValue.entrySet()) {
                this.writeProperty((QName)element.getKey(), element.getValue());
            }
            this.endElement("map");
        } else {
            ValueType valueType = this.getValueType(value);
            AttributesImpl attrs = new AttributesImpl();
            attrs.addAttribute(null, "type", "type", "String", valueType.toString());
            this.startElement("value", attrs);
            this.writeValue(valueType, value);
            this.endElement("value");
        }
    }

    private void writeValue(ValueType valueType, Object value) throws Exception {
        switch (valueType.ordinal()) {
            case 0: 
            case 2: 
            case 3: 
            case 4: {
                this.writer.write(value.toString());
                break;
            }
            case 1: {
                this.writer.write((CDATA)new FlyweightCDATA(value.toString()));
                break;
            }
            case 6: {
                ContentData contentData = (ContentData)value;
                AttributesImpl attrs = new AttributesImpl();
                attrs.addAttribute(null, "mime", "mime", "String", contentData.getMimetype());
                attrs.addAttribute(null, "size", "size", "String", Long.toString(contentData.getSize()));
                attrs.addAttribute(null, "enc", "enc", "String", contentData.getEncoding());
                this.startElement("content", attrs);
                this.endElement("content");
                break;
            }
            case 5: {
                this.writer.write(this.getDateFormat().format((Date)value));
                break;
            }
        }
    }

    private DateFormat getDateFormat() {
        return dateFormat.get();
    }

    private void startElement(String elementName, Attributes attributes) throws SAXException {
        this.writer.startElement(null, elementName, elementName, attributes);
    }

    private void endElement(String elementName) throws SAXException {
        this.writer.endElement(null, elementName, elementName);
    }

    private ValueType getValueType(Object value) {
        ValueType valueType = ValueType.text;
        if (value == null) {
            valueType = ValueType.missing;
        } else {
            Class<?> valueClass = value.getClass();
            if (String.class.isAssignableFrom(valueClass)) {
                valueType = ValueType.text;
            }
            valueType = MLText.class.isAssignableFrom(valueClass) ? ValueType.text : (Integer.class.isAssignableFrom(valueClass) ? ValueType.integer : (Long.class.isAssignableFrom(valueClass) ? ValueType.integer : (ContentData.class.isAssignableFrom(valueClass) ? ValueType.content : (Float.class.isAssignableFrom(valueClass) ? ValueType.number : (Double.class.isAssignableFrom(valueClass) ? ValueType.number : (Date.class.isAssignableFrom(valueClass) ? ValueType.time : (Boolean.class.isAssignableFrom(valueClass) ? ValueType.bool : (NodeRef.class.isAssignableFrom(valueClass) ? ValueType.id : ValueType.text))))))));
        }
        return valueType;
    }

    @Override
    public String getMimeType() {
        return "text/xml";
    }

    static {
        dateFormat = new ThreadLocal<DateFormat>(){

            @Override
            protected DateFormat initialValue() {
                return new SimpleDateFormat("yyyyMMdd-HH:mm:ss.SSSZ");
            }
        };
        HashSet<QName> ignoreSet = new HashSet<QName>();
        ignoreSet.add(ContentModel.PROP_STORE_IDENTIFIER);
        ignoreSet.add(ContentModel.PROP_STORE_NAME);
        ignoreSet.add(ContentModel.PROP_STORE_PROTOCOL);
        ignoreSet.add(ContentModel.PROP_NODE_DBID);
        ignoreSet.add(ContentModel.PROP_NODE_REF);
        ignoreSet.add(ContentModel.PROP_NODE_UUID);
        ignoreSet.add(ContentModel.PROP_TAGS);
        ignoreSet.add(ApplicationModel.PROP_EDITINLINE);
        ignoreSet.add(WebSiteModel.PROP_ANCESTOR_SECTIONS);
        DEFAULT_PROPERTIES_TO_IGNORE = Collections.unmodifiableSet(ignoreSet);
    }

    private static enum ValueType {
        id,
        text,
        integer,
        number,
        bool,
        time,
        content,
        missing;

    }
}

