/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.config.forms;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import org.alfresco.web.config.forms.ConstraintHandlerDefinition;
import org.alfresco.web.config.forms.ControlParam;
import org.alfresco.web.config.forms.FormConfigElement;
import org.alfresco.web.config.forms.FormField;

public class FormFieldTest
extends TestCase {
    public FormFieldTest(String name) {
        super(name);
    }

    public void testFieldConstruction_PositiveFlow() {
        FormConfigElement testElement = new FormConfigElement();
        testElement.addField("id1", Arrays.asList("aa", "bb", "cc"), Arrays.asList("AA", "BB", "CC"));
        testElement.addConstraintForField("id1", "REGEX", "Test message", "Test msg ID", null, null);
        testElement.addControlForField("id1", "test1.ftl", Arrays.asList("cp1", "cp2"), Arrays.asList("CP1", "CP2"));
        testElement.addField("id2", Arrays.asList("xx", "yy", "zz"), Arrays.asList("XX", "YY", "ZZ"));
        testElement.addControlForField("id2", "test2.ftl", null, null);
        Map fields = testElement.getFields();
        FormFieldTest.assertNotNull((Object)fields);
        FormFieldTest.assertEquals((int)2, (int)fields.size());
        FormField fieldID1 = (FormField)fields.get("id1");
        FormField fieldID2 = (FormField)fields.get("id2");
        FormFieldTest.assertEquals((String)"id1", (String)fieldID1.getId());
        FormFieldTest.assertEquals((String)"id2", (String)fieldID2.getId());
        LinkedHashMap<String, String> expectedAttributes = new LinkedHashMap<String, String>();
        expectedAttributes.put("aa", "AA");
        expectedAttributes.put("bb", "BB");
        expectedAttributes.put("cc", "CC");
        FormFieldTest.assertEquals(expectedAttributes, (Object)fieldID1.getAttributes());
        expectedAttributes = new LinkedHashMap();
        expectedAttributes.put("xx", "XX");
        expectedAttributes.put("yy", "YY");
        expectedAttributes.put("zz", "ZZ");
        FormFieldTest.assertEquals(expectedAttributes, (Object)fieldID2.getAttributes());
        FormFieldTest.assertEquals((String)"test1.ftl", (String)fieldID1.getControl().getTemplate());
        FormFieldTest.assertEquals((String)"test2.ftl", (String)fieldID2.getControl().getTemplate());
        Map fieldID1Constraints = fieldID1.getConstraintDefinitionMap();
        Map fieldID2Constraints = fieldID2.getConstraintDefinitionMap();
        ConstraintHandlerDefinition firstFieldID1Constraint = (ConstraintHandlerDefinition)fieldID1Constraints.values().iterator().next();
        FormFieldTest.assertEquals((String)"Test message", (String)firstFieldID1Constraint.getMessage());
        FormFieldTest.assertEquals(Collections.emptyMap(), (Object)fieldID2Constraints);
        FormFieldTest.assertEquals((String)"Test msg ID", (String)firstFieldID1Constraint.getMessageId());
        FormFieldTest.assertEquals(Collections.emptyMap(), (Object)fieldID2Constraints);
        FormFieldTest.assertEquals((String)"REGEX", (String)firstFieldID1Constraint.getType());
        FormFieldTest.assertEquals(Collections.emptyMap(), (Object)fieldID2Constraints);
        ArrayList<ControlParam> expectedCPs = new ArrayList<ControlParam>();
        expectedCPs.add(new ControlParam("cp1", "CP1"));
        expectedCPs.add(new ControlParam("cp2", "CP2"));
        FormFieldTest.assertEquals(expectedCPs, (Object)fieldID1.getControl().getParamsAsList());
        FormFieldTest.assertEquals(Collections.emptyList(), (Object)fieldID2.getControl().getParamsAsList());
    }

    public void testGetAttributesViaExplicitGetters() {
        FormConfigElement testElement = new FormConfigElement();
        testElement.addField("name", Arrays.asList("id", "label", "label-id", "read-only", "set", "help", "help-id", "help-encode-html"), Arrays.asList("name", "Name", "field_label_name", "true", "details", "This is the name of the node", "field_help_name", "true"));
        FormField testField = (FormField)testElement.getFields().get("name");
        FormFieldTest.assertEquals((String)"name", (String)testField.getId());
        FormFieldTest.assertEquals((String)"Name", (String)testField.getLabel());
        FormFieldTest.assertEquals((String)"field_label_name", (String)testField.getLabelId());
        FormFieldTest.assertEquals((String)"true", (String)testField.getHelpEncodeHtml());
        FormFieldTest.assertEquals((boolean)true, (boolean)testField.isReadOnly());
        FormFieldTest.assertEquals((String)"details", (String)testField.getSet());
        FormFieldTest.assertEquals((String)"This is the name of the node", (String)testField.getHelpText());
        FormFieldTest.assertEquals((String)"field_help_name", (String)testField.getHelpTextId());
    }

    public void testConstructionWithNulls() {
        FormConfigElement fce = new FormConfigElement();
        fce.addField("id1", null, null);
        fce.addConstraintForField("id1", "REGEX", null, null, null, null);
        fce.addControlForField("id1", null, null, null);
        FormField recoveredFce = (FormField)fce.getFields().get("id1");
        FormFieldTest.assertEquals((String)"Expected no attributes.", Collections.emptyMap(), (Object)recoveredFce.getAttributes());
        FormFieldTest.assertEquals((String)"Expected no template.", null, (String)recoveredFce.getControl().getTemplate());
        FormFieldTest.assertEquals((String)"Expected no control params.", Collections.emptyList(), (Object)recoveredFce.getControl().getParamsAsList());
        fce = new FormConfigElement();
        fce.addField("id1", null, null);
        recoveredFce = (FormField)fce.getFields().get("id1");
        FormFieldTest.assertEquals((String)"Expected no attributes.", Collections.emptyMap(), (Object)recoveredFce.getAttributes());
        FormFieldTest.assertEquals((String)"Expected no template.", null, (String)recoveredFce.getControl().getTemplate());
        FormFieldTest.assertEquals((String)"Expected no control params.", Collections.emptyList(), (Object)recoveredFce.getControl().getParamsAsList());
        FormFieldTest.assertEquals((String)"Expected no constraint msg.", Collections.emptyMap(), (Object)recoveredFce.getConstraintDefinitionMap());
    }

    public void testExtraControlParamValueIsIgnored() {
        FormConfigElement fce = new FormConfigElement();
        fce.addField("id1", null, null);
        fce.addControlForField("id1", "test1.ftl", Arrays.asList("cp1", "cp2"), Arrays.asList("CP1", "CP2", "CP3"));
        List params = ((FormField)fce.getFields().get("id1")).getControl().getParamsAsList();
        FormFieldTest.assertEquals((int)2, (int)params.size());
        ArrayList<ControlParam> expectedParams = new ArrayList<ControlParam>(2);
        expectedParams.add(new ControlParam("cp1", "CP1"));
        expectedParams.add(new ControlParam("cp2", "CP2"));
        FormFieldTest.assertEquals(expectedParams, (Object)params);
    }

    public void testCombineFormFieldsWithAdditiveChanges() {
        LinkedHashMap<String, String> attrs1 = new LinkedHashMap<String, String>();
        attrs1.put("label", "Name");
        attrs1.put("disabled", "true");
        FormField firstInstance = new FormField("name", attrs1);
        LinkedHashMap<String, String> attrs2 = new LinkedHashMap<String, String>();
        attrs2.put("label", "Name");
        attrs2.put("disabled", "true");
        FormField secondInstance = new FormField("name", attrs2);
        secondInstance.getControl().setTemplate("test.ftl");
        secondInstance.getControl().addControlParam("foo", "bar");
        secondInstance.addConstraintDefinition("REGEX", "msg", "msg-id", null, null);
        FormField combinedField = firstInstance.combine(secondInstance);
        FormFieldTest.assertEquals((String)"name", (String)combinedField.getId());
        FormFieldTest.assertEquals((String)"Name", (String)combinedField.getLabel());
        FormFieldTest.assertEquals(null, (String)combinedField.getLabelId());
        FormFieldTest.assertEquals((String)"", (String)combinedField.getSet());
        FormFieldTest.assertEquals(null, (String)combinedField.getHelpText());
        FormFieldTest.assertEquals(null, (String)combinedField.getHelpTextId());
    }

    public void testCombineFormFieldsWithModificationChanges() {
        LinkedHashMap<String, String> attrs1 = new LinkedHashMap<String, String>();
        attrs1.put("label", "Name");
        attrs1.put("disabled", "true");
        FormField firstInstance = new FormField("name", attrs1);
        firstInstance.getControl().setTemplate("test.ftl");
        firstInstance.getControl().addControlParam("foo", "bar");
        firstInstance.addConstraintDefinition("REGEX", "msg", "msg-id", null, null);
        LinkedHashMap<String, String> attrs2 = new LinkedHashMap<String, String>();
        attrs2.put("label", "Name");
        attrs2.put("disabled", "false");
        FormField secondInstance = new FormField("name", attrs2);
        secondInstance.getControl().setTemplate("newtest.ftl");
        secondInstance.getControl().addControlParam("foo", "barrr");
        secondInstance.addConstraintDefinition("REGEX", "newmsg", "newmsg-id", null, null);
        FormField combinedField = firstInstance.combine(secondInstance);
        FormFieldTest.assertEquals((String)"name", (String)combinedField.getId());
        FormFieldTest.assertEquals((String)"Name", (String)combinedField.getLabel());
        FormFieldTest.assertEquals(null, (String)combinedField.getLabelId());
        FormFieldTest.assertEquals((String)"", (String)combinedField.getSet());
        FormFieldTest.assertEquals(null, (String)combinedField.getHelpText());
        FormFieldTest.assertEquals(null, (String)combinedField.getHelpTextId());
    }
}

