/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.config.forms;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.alfresco.util.BaseTest;
import org.alfresco.web.config.forms.ConstraintHandlerDefinition;
import org.alfresco.web.config.forms.ConstraintHandlersConfigElement;
import org.alfresco.web.config.forms.Control;
import org.alfresco.web.config.forms.ControlParam;
import org.alfresco.web.config.forms.DefaultControlsConfigElement;
import org.alfresco.web.config.forms.DependenciesConfigElement;
import org.alfresco.web.config.forms.FormConfigElement;
import org.alfresco.web.config.forms.FormField;
import org.alfresco.web.config.forms.FormsConfigElement;
import org.alfresco.web.config.forms.Mode;
import org.springframework.extensions.config.Config;
import org.springframework.extensions.config.ConfigElement;
import org.springframework.extensions.config.ConfigException;
import org.springframework.extensions.config.xml.XMLConfigService;

public class FormConfigBasicTest
extends BaseTest {
    private static final String TEST_CONFIG_FORMS_BASIC_XML = "test-config-forms-basic.xml";
    protected XMLConfigService configService;
    protected Config globalConfig;
    protected ConfigElement globalDefaultControls;
    protected ConfigElement globalConstraintHandlers;
    protected FormsConfigElement myExampleFormsConfigElement;
    protected FormConfigElement myExampleDefaultForm;
    protected FormsConfigElement noAppearanceFormsConfigElement;
    protected FormConfigElement noAppearanceDefaultForm;
    protected FormsConfigElement noVisibilityFormsConfigElement;
    protected FormConfigElement noVisibilityDefaultForm;
    protected FormsConfigElement hiddenFieldsFormsConfigElement;
    protected FormConfigElement hiddenFieldsDefaultForm;
    protected DefaultControlsConfigElement defltCtrlsConfElement;

    protected List<String> getConfigFiles() {
        ArrayList<String> result = new ArrayList<String>(1);
        result.add(TEST_CONFIG_FORMS_BASIC_XML);
        return result;
    }

    public String getResourcesDir() {
        return "classpath:";
    }

    protected String getExpectedMessageForNumericConstraint() {
        return "Test Message";
    }

    protected List<ControlParam> getExpectedControlParamsForDText() {
        return Arrays.asList(new ControlParam("size", "50"));
    }

    protected List<ControlParam> getExpectedControlParamsForDTest() {
        return Arrays.asList(new ControlParam("a", "Hello"), new ControlParam("b", null));
    }

    protected List<String> getExpectedTemplatesForNoAppearanceDefaultForm() {
        return Arrays.asList("/view/template", "/edit/template", "/create/template");
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.configService = this.initXMLConfigService(this.getConfigFiles());
        FormConfigBasicTest.assertNotNull((String)"configService was null.", (Object)this.configService);
        Config myExampleConfigObj = this.configService.getConfig((Object)"my:example");
        FormConfigBasicTest.assertNotNull((Object)myExampleConfigObj);
        ConfigElement myExampleFormsConfigObj = myExampleConfigObj.getConfigElement("forms");
        FormConfigBasicTest.assertNotNull((Object)myExampleFormsConfigObj);
        FormConfigBasicTest.assertTrue((String)"formsConfigObj should be instanceof FormsConfigElement.", (boolean)(myExampleFormsConfigObj instanceof FormsConfigElement));
        this.myExampleFormsConfigElement = (FormsConfigElement)myExampleFormsConfigObj;
        this.myExampleDefaultForm = this.myExampleFormsConfigElement.getDefaultForm();
        FormConfigBasicTest.assertNotNull((Object)this.myExampleDefaultForm);
        Config noAppearanceConfigObj = this.configService.getConfig((Object)"no-appearance");
        FormConfigBasicTest.assertNotNull((Object)noAppearanceConfigObj);
        ConfigElement noAppearanceFormsConfigObj = noAppearanceConfigObj.getConfigElement("forms");
        FormConfigBasicTest.assertNotNull((Object)noAppearanceFormsConfigObj);
        FormConfigBasicTest.assertTrue((String)"noAppearanceFormsConfigObj should be instanceof FormsConfigElement.", (boolean)(noAppearanceFormsConfigObj instanceof FormsConfigElement));
        this.noAppearanceFormsConfigElement = (FormsConfigElement)noAppearanceFormsConfigObj;
        this.noAppearanceDefaultForm = this.noAppearanceFormsConfigElement.getDefaultForm();
        FormConfigBasicTest.assertNotNull((Object)this.noAppearanceDefaultForm);
        Config noVisibilityConfigObj = this.configService.getConfig((Object)"no-visibility");
        FormConfigBasicTest.assertNotNull((Object)noVisibilityConfigObj);
        ConfigElement noVisibilityFormsConfigObj = noVisibilityConfigObj.getConfigElement("forms");
        FormConfigBasicTest.assertNotNull((Object)noVisibilityFormsConfigObj);
        FormConfigBasicTest.assertTrue((String)"noVisibilityFormsConfigObj should be instanceof FormsConfigElement.", (boolean)(noVisibilityFormsConfigObj instanceof FormsConfigElement));
        this.noVisibilityFormsConfigElement = (FormsConfigElement)noVisibilityFormsConfigObj;
        this.noVisibilityDefaultForm = this.noVisibilityFormsConfigElement.getDefaultForm();
        FormConfigBasicTest.assertNotNull((Object)this.noVisibilityDefaultForm);
        Config hiddenFieldsConfigObj = this.configService.getConfig((Object)"hidden-fields");
        FormConfigBasicTest.assertNotNull((Object)hiddenFieldsConfigObj);
        ConfigElement hiddenFieldsFormsConfigObj = hiddenFieldsConfigObj.getConfigElement("forms");
        FormConfigBasicTest.assertNotNull((Object)hiddenFieldsFormsConfigObj);
        FormConfigBasicTest.assertTrue((String)"hiddenFieldsFormsConfigObj should be instanceof FormsConfigElement.", (boolean)(hiddenFieldsFormsConfigObj instanceof FormsConfigElement));
        this.hiddenFieldsFormsConfigElement = (FormsConfigElement)hiddenFieldsFormsConfigObj;
        this.hiddenFieldsDefaultForm = this.hiddenFieldsFormsConfigElement.getDefaultForm();
        FormConfigBasicTest.assertNotNull((Object)this.hiddenFieldsDefaultForm);
        this.globalConfig = this.configService.getGlobalConfig();
        FormsConfigElement globalForms = (FormsConfigElement)this.globalConfig.getConfigElement("forms");
        this.globalDefaultControls = globalForms.getDefaultControls();
        FormConfigBasicTest.assertNotNull((String)"global default-controls element should not be null", (Object)this.globalDefaultControls);
        FormConfigBasicTest.assertTrue((String)"config element should be an instance of DefaultControlsConfigElement", (boolean)(this.globalDefaultControls instanceof DefaultControlsConfigElement));
        this.defltCtrlsConfElement = (DefaultControlsConfigElement)this.globalDefaultControls;
        this.globalConstraintHandlers = globalForms.getConstraintHandlers();
        FormConfigBasicTest.assertNotNull((String)"global constraint-handlers element should not be null", (Object)this.globalConstraintHandlers);
        FormConfigBasicTest.assertTrue((String)"config element should be an instance of ConstraintHandlersConfigElement", (boolean)(this.globalConstraintHandlers instanceof ConstraintHandlersConfigElement));
    }

    public void testGetDefaultFormElement() throws Exception {
        FormConfigElement defaultFormCE = this.myExampleFormsConfigElement.getDefaultForm();
        FormConfigBasicTest.assertNotNull((Object)defaultFormCE);
        FormConfigBasicTest.assertEquals((String)"submit/default/form", (String)defaultFormCE.getSubmissionURL());
        FormConfigBasicTest.assertNull((Object)defaultFormCE.getId());
    }

    public void testGetNonexistentDefaultFormElement() throws Exception {
        Config noDefaultConfigObj = this.configService.getConfig((Object)"no-default-form");
        FormConfigBasicTest.assertNotNull((Object)noDefaultConfigObj);
        ConfigElement noDefaultFormsConfigObj = noDefaultConfigObj.getConfigElement("forms");
        FormConfigBasicTest.assertNotNull((Object)noDefaultFormsConfigObj);
        FormConfigBasicTest.assertTrue((String)"noDefaultFormsConfigObj should be instanceof FormsConfigElement.", (boolean)(noDefaultFormsConfigObj instanceof FormsConfigElement));
        FormsConfigElement noDefaultFormsConfigElement = (FormsConfigElement)noDefaultFormsConfigObj;
        FormConfigElement noDefaultForm = noDefaultFormsConfigElement.getDefaultForm();
        FormConfigBasicTest.assertNull((Object)noDefaultForm);
    }

    public void testGetFormElementById() throws Exception {
        FormConfigElement formCE = this.myExampleFormsConfigElement.getForm("id");
        FormConfigBasicTest.assertNotNull((Object)formCE);
        FormConfigBasicTest.assertEquals((String)"submit/id/form", (String)formCE.getSubmissionURL());
        FormConfigBasicTest.assertEquals((String)"id", (String)formCE.getId());
    }

    public void testGetNonexistentFormElementById() throws Exception {
        FormConfigElement noSuchFormCE = this.myExampleFormsConfigElement.getForm("rubbish");
        FormConfigBasicTest.assertNull((Object)noSuchFormCE);
    }

    public void testFormSubmissionUrl() {
        FormConfigBasicTest.assertEquals((String)"Submission URL was incorrect.", (String)"submit/default/form", (String)this.myExampleDefaultForm.getSubmissionURL());
    }

    public void testGetFormTemplatesForViewEditCreate() throws Exception {
        FormConfigElement testForm = this.noAppearanceFormsConfigElement.getDefaultForm();
        FormConfigBasicTest.assertEquals((String)this.getExpectedTemplatesForNoAppearanceDefaultForm().get(0), (String)testForm.getViewTemplate());
        FormConfigBasicTest.assertEquals((String)this.getExpectedTemplatesForNoAppearanceDefaultForm().get(1), (String)testForm.getEditTemplate());
        FormConfigBasicTest.assertEquals((String)this.getExpectedTemplatesForNoAppearanceDefaultForm().get(2), (String)testForm.getCreateTemplate());
    }

    public void testGlobalConstraintHandlers() {
        FormConfigBasicTest.assertEquals(ConstraintHandlersConfigElement.class, (Object)this.globalConstraintHandlers.getClass());
        ConstraintHandlersConfigElement constraintHandlers = (ConstraintHandlersConfigElement)this.globalConstraintHandlers;
        Map constraintItems = constraintHandlers.getItems();
        FormConfigBasicTest.assertEquals((String)"Incorrect count for global constraint-handlers.", (int)3, (int)constraintItems.size());
        HashSet<String> expectedTypeNames = new HashSet<String>();
        expectedTypeNames.add("MANDATORY");
        expectedTypeNames.add("REGEX");
        expectedTypeNames.add("NUMERIC");
        FormConfigBasicTest.assertEquals((String)"Incorrect global constraint-handler types.", expectedTypeNames, constraintItems.keySet());
        ConstraintHandlerDefinition mandatoryItem = (ConstraintHandlerDefinition)constraintItems.get("MANDATORY");
        FormConfigBasicTest.assertNotNull((Object)mandatoryItem);
        ConstraintHandlerDefinition regexItem = (ConstraintHandlerDefinition)constraintItems.get("REGEX");
        FormConfigBasicTest.assertNotNull((Object)regexItem);
        ConstraintHandlerDefinition numericItem = (ConstraintHandlerDefinition)constraintItems.get("NUMERIC");
        FormConfigBasicTest.assertNotNull((Object)numericItem);
        FormConfigBasicTest.assertEquals((String)"Alfresco.forms.validation.mandatory", (String)mandatoryItem.getValidationHandler());
        FormConfigBasicTest.assertEquals((String)"Alfresco.forms.validation.regexMatch", (String)regexItem.getValidationHandler());
        FormConfigBasicTest.assertEquals((String)"Alfresco.forms.validation.numericMatch", (String)numericItem.getValidationHandler());
        FormConfigBasicTest.assertEquals((String)"blur", (String)mandatoryItem.getEvent());
        FormConfigBasicTest.assertEquals(null, (String)regexItem.getEvent());
        FormConfigBasicTest.assertEquals(null, (String)numericItem.getEvent());
        FormConfigBasicTest.assertEquals(null, (String)mandatoryItem.getMessage());
        FormConfigBasicTest.assertEquals(null, (String)regexItem.getMessage());
        FormConfigBasicTest.assertEquals((String)this.getExpectedMessageForNumericConstraint(), (String)numericItem.getMessage());
        FormConfigBasicTest.assertEquals(null, (String)mandatoryItem.getMessageId());
        FormConfigBasicTest.assertEquals(null, (String)regexItem.getMessageId());
        FormConfigBasicTest.assertEquals((String)"regex_error", (String)numericItem.getMessageId());
    }

    public void testGlobalDefaultControls() {
        FormConfigBasicTest.assertEquals(DefaultControlsConfigElement.class, (Object)this.globalDefaultControls.getClass());
        DefaultControlsConfigElement defaultControls = (DefaultControlsConfigElement)this.globalDefaultControls;
        Map defCtrlItems = defaultControls.getItems();
        FormConfigBasicTest.assertEquals((String)"Incorrect count for global default-controls.", (int)6, (int)defCtrlItems.size());
        HashSet<String> expectedTypeNames = new HashSet<String>();
        expectedTypeNames.add("d:long");
        expectedTypeNames.add("d:text");
        expectedTypeNames.add("d:test");
        expectedTypeNames.add("d:boolean");
        expectedTypeNames.add("association");
        expectedTypeNames.add("abc");
        FormConfigBasicTest.assertEquals((String)"Incorrect global default-control types.", expectedTypeNames, defCtrlItems.keySet());
        Control longItem = (Control)defCtrlItems.get("d:long");
        FormConfigBasicTest.assertNotNull((Object)longItem);
        Control textItem = (Control)defCtrlItems.get("d:text");
        FormConfigBasicTest.assertNotNull((Object)textItem);
        Control testItem = (Control)defCtrlItems.get("d:test");
        FormConfigBasicTest.assertNotNull((Object)testItem);
        FormConfigBasicTest.assertEquals((String)"/form-controls/mytextfield.ftl", (String)longItem.getTemplate());
        FormConfigBasicTest.assertEquals((String)"/form-controls/mytextfield.ftl", (String)textItem.getTemplate());
        FormConfigBasicTest.assertEquals((String)"/form-controls/test.ftl", (String)testItem.getTemplate());
        FormConfigBasicTest.assertEquals(Collections.emptyList(), (Object)longItem.getParamsAsList());
        FormConfigBasicTest.assertEquals(this.getExpectedControlParamsForDText(), (Object)textItem.getParamsAsList());
        FormConfigBasicTest.assertEquals(this.getExpectedControlParamsForDTest(), (Object)testItem.getParamsAsList());
    }

    public void testControlParamsAreConsistentBetweenGlobalAndFieldLevel() {
        DefaultControlsConfigElement defaultControls = (DefaultControlsConfigElement)this.globalDefaultControls;
        Map defCtrlItems = defaultControls.getItems();
        List controlParamsGlobal = ((Control)defCtrlItems.get("d:test")).getParamsAsList();
        List controlParamsField = ((FormField)this.myExampleDefaultForm.getFields().get("my:text")).getControl().getParamsAsList();
        FormConfigBasicTest.assertEquals(controlParamsGlobal.getClass(), controlParamsField.getClass());
    }

    public void testFormConfigElementShouldHaveNoChildren() {
        try {
            this.myExampleDefaultForm.getChildren();
            FormConfigBasicTest.fail((String)"getChildren() did not throw an exception.");
        }
        catch (ConfigException configException) {
            // empty catch block
        }
    }

    public void testEmptyConstraintsMsgs() {
        FormField field = (FormField)this.myExampleDefaultForm.getFields().get("cm:name");
        FormConfigBasicTest.assertNotNull((String)"Expecting cm:name to be present", (Object)field);
        Map constraints = field.getConstraintDefinitionMap();
        FormConfigBasicTest.assertNotNull((Object)constraints);
        ConstraintHandlerDefinition constraint = (ConstraintHandlerDefinition)constraints.get("REGEX");
        FormConfigBasicTest.assertNotNull((Object)constraint);
        FormConfigBasicTest.assertNull((Object)constraint.getMessageId());
        FormConfigBasicTest.assertEquals((String)"You can't have these characters in a name: /*", (String)constraint.getMessage());
        field = (FormField)this.myExampleDefaultForm.getFields().get("my:text");
        FormConfigBasicTest.assertNotNull((String)"Expecting cm:text to be present", (Object)field);
        constraints = field.getConstraintDefinitionMap();
        FormConfigBasicTest.assertNotNull((Object)constraints);
        constraint = (ConstraintHandlerDefinition)constraints.get("REGEX");
        FormConfigBasicTest.assertNotNull((Object)constraint);
        FormConfigBasicTest.assertNull((Object)constraint.getMessage());
        FormConfigBasicTest.assertEquals((String)"custom_msg", (String)constraint.getMessageId());
    }

    public void testFieldsVisibleInViewModeShouldStillBeVisibleWithNoAppearanceTag() {
        List fieldNames = this.noAppearanceDefaultForm.getVisibleViewFieldNamesAsList();
        ArrayList<String> expectedFieldNames = new ArrayList<String>();
        expectedFieldNames.add("cm:name");
        expectedFieldNames.add("cm:title");
        expectedFieldNames.add("cm:description");
        expectedFieldNames.add("cm:content");
        expectedFieldNames.add("my:text");
        expectedFieldNames.add("my:mltext");
        expectedFieldNames.add("my:date");
        FormConfigBasicTest.assertEquals((String)"Visible fields wrong.", expectedFieldNames, (Object)fieldNames);
    }

    public void testGetFormFieldVisibilitiesForModes() {
        FormConfigBasicTest.assertTrue((String)"Field should be visible.", (boolean)this.noAppearanceDefaultForm.isFieldVisible("cm:name", Mode.CREATE));
        FormConfigBasicTest.assertTrue((String)"Field should be visible.", (boolean)this.noAppearanceDefaultForm.isFieldVisible("cm:title", Mode.CREATE));
        FormConfigBasicTest.assertFalse((String)"Field should be invisible.", (boolean)this.noAppearanceDefaultForm.isFieldVisible("rubbish", Mode.CREATE));
        FormConfigBasicTest.assertTrue((String)"Field should be visible.", (boolean)this.noAppearanceDefaultForm.isFieldVisible("cm:name", Mode.EDIT));
        FormConfigBasicTest.assertFalse((String)"Field should be invisible.", (boolean)this.noAppearanceDefaultForm.isFieldVisible("cm:title", Mode.EDIT));
        FormConfigBasicTest.assertFalse((String)"Field should be invisible.", (boolean)this.noAppearanceDefaultForm.isFieldVisible("rubbish", Mode.EDIT));
        FormConfigBasicTest.assertTrue((String)"Field should be visible.", (boolean)this.noAppearanceDefaultForm.isFieldVisible("cm:name", Mode.VIEW));
        FormConfigBasicTest.assertTrue((String)"Field should be visible.", (boolean)this.noAppearanceDefaultForm.isFieldVisible("cm:title", Mode.VIEW));
        FormConfigBasicTest.assertFalse((String)"Field should be invisible.", (boolean)this.noAppearanceDefaultForm.isFieldVisible("rubbish", Mode.VIEW));
    }

    public void testGetForcedFields() {
        List forcedFields = this.noAppearanceDefaultForm.getForcedFieldsAsList();
        FormConfigBasicTest.assertEquals((String)"Expecting one forced field", (int)1, (int)forcedFields.size());
        FormConfigBasicTest.assertTrue((String)"Expected cm:name to be forced", (boolean)this.noAppearanceDefaultForm.isFieldForced("cm:name"));
        FormConfigBasicTest.assertFalse((String)"Expected cm:title not to be forced", (boolean)this.noAppearanceDefaultForm.isFieldForced("cm:title"));
    }

    public void testGetVisibleFieldsForFormWithoutFieldVisibilityReturnsNull() {
        FormConfigBasicTest.assertEquals(null, (Object)this.noVisibilityDefaultForm.getVisibleCreateFieldNamesAsList());
        FormConfigBasicTest.assertEquals(null, (Object)this.noVisibilityDefaultForm.getVisibleEditFieldNamesAsList());
        FormConfigBasicTest.assertEquals(null, (Object)this.noVisibilityDefaultForm.getVisibleViewFieldNamesAsList());
    }

    public void testFieldVisibilityForTwoCombinedFormTags() {
        FormConfigElement combinedConfig = (FormConfigElement)this.myExampleDefaultForm.combine((ConfigElement)this.noVisibilityFormsConfigElement.getDefaultForm());
        LinkedHashSet<String> expectedFields = new LinkedHashSet<String>();
        expectedFields.add("cm:name");
        expectedFields.add("my:text");
        expectedFields.add("my:mltext");
        expectedFields.add("my:date");
        expectedFields.add("my:duplicate");
        expectedFields.add("my:int");
        expectedFields.add("my:broken");
        FormConfigBasicTest.assertEquals(new ArrayList(expectedFields), (Object)this.myExampleDefaultForm.getVisibleCreateFieldNamesAsList());
        FormConfigBasicTest.assertEquals(new ArrayList(expectedFields), (Object)this.myExampleDefaultForm.getVisibleEditFieldNamesAsList());
        FormConfigBasicTest.assertEquals(new ArrayList(expectedFields), (Object)this.myExampleDefaultForm.getVisibleViewFieldNamesAsList());
        FormConfigBasicTest.assertEquals(new ArrayList(expectedFields), (Object)combinedConfig.getVisibleCreateFieldNamesAsList());
        FormConfigBasicTest.assertEquals(new ArrayList(expectedFields), (Object)combinedConfig.getVisibleEditFieldNamesAsList());
        FormConfigBasicTest.assertEquals(new ArrayList(expectedFields), (Object)combinedConfig.getVisibleViewFieldNamesAsList());
    }

    public void testConstraintHandlerOnField() throws Exception {
        ConstraintHandlersConfigElement defaultConstraintHandlers = (ConstraintHandlersConfigElement)this.globalConstraintHandlers;
        Map handlers = defaultConstraintHandlers.getItems();
        ConstraintHandlerDefinition regexConstraintHandler = (ConstraintHandlerDefinition)handlers.get("REGEX");
        FormConfigBasicTest.assertNotNull((Object)regexConstraintHandler);
        FormConfigBasicTest.assertEquals((String)"REGEX", (String)regexConstraintHandler.getType());
        FormConfigBasicTest.assertEquals((String)"Alfresco.forms.validation.regexMatch", (String)regexConstraintHandler.getValidationHandler());
        FormConfigBasicTest.assertNull((Object)regexConstraintHandler.getMessage());
        FormConfigBasicTest.assertNull((Object)regexConstraintHandler.getMessageId());
        FormConfigBasicTest.assertNull((Object)regexConstraintHandler.getEvent());
        ConstraintHandlerDefinition regexFieldConstr = (ConstraintHandlerDefinition)((FormField)this.myExampleDefaultForm.getFields().get("cm:name")).getConstraintDefinitionMap().get("REGEX");
        FormConfigBasicTest.assertNotNull((Object)regexFieldConstr);
        FormConfigBasicTest.assertEquals((String)"REGEX", (String)regexFieldConstr.getType());
        FormConfigBasicTest.assertEquals((String)"Alfresco.forms.validation.regexMatch", (String)regexFieldConstr.getValidationHandler());
        FormConfigBasicTest.assertEquals((String)"You can't have these characters in a name: /*", (String)regexFieldConstr.getMessage());
        FormConfigBasicTest.assertNull((Object)regexFieldConstr.getMessageId());
        FormConfigBasicTest.assertNull((Object)regexFieldConstr.getEvent());
        ConstraintHandlerDefinition numericFieldConstr = (ConstraintHandlerDefinition)((FormField)this.myExampleDefaultForm.getFields().get("cm:name")).getConstraintDefinitionMap().get("NUMERIC");
        FormConfigBasicTest.assertNotNull((Object)numericFieldConstr);
    }

    public void testGetDependencies() throws Exception {
        FormsConfigElement globalForms = (FormsConfigElement)this.globalConfig.getConfigElement("forms");
        DependenciesConfigElement depsCE = globalForms.getDependencies();
        FormConfigBasicTest.assertNotNull((Object)depsCE);
        String[] expectedCssDependencies = new String[]{"/css/path/1", "/css/path/2"};
        String[] expectedJsDependencies = new String[]{"/js/path/1", "/js/path/2"};
        FormConfigBasicTest.assertEquals(Arrays.asList(expectedCssDependencies), Arrays.asList(depsCE.getCss()));
        FormConfigBasicTest.assertEquals(Arrays.asList(expectedJsDependencies), Arrays.asList(depsCE.getJs()));
    }

    public void testNoVisibility() throws Exception {
        FormField nameField = (FormField)this.noVisibilityDefaultForm.getFields().get("cm:name");
        FormConfigBasicTest.assertNotNull((Object)nameField);
        FormConfigBasicTest.assertEquals((String)"Name From Config", (String)nameField.getLabel());
        FormConfigBasicTest.assertNull((Object)nameField.getDescription());
        FormField xxField = (FormField)this.noVisibilityDefaultForm.getFields().get("xx:irrelevant");
        FormConfigBasicTest.assertNotNull((Object)xxField);
        FormConfigBasicTest.assertEquals((String)"label-text", (String)xxField.getLabel());
        FormConfigBasicTest.assertEquals((String)"optional", (String)xxField.getSet());
        FormConfigBasicTest.assertNull((Object)xxField.getDescription());
        FormConfigBasicTest.assertNull((Object)this.noVisibilityDefaultForm.getVisibleCreateFieldNamesAsList());
        FormConfigBasicTest.assertNull((Object)this.noVisibilityDefaultForm.getVisibleCreateFieldNames());
        FormConfigBasicTest.assertNull((Object)this.noVisibilityDefaultForm.getVisibleEditFieldNamesAsList());
        FormConfigBasicTest.assertNull((Object)this.noVisibilityDefaultForm.getVisibleEditFieldNames());
        FormConfigBasicTest.assertNull((Object)this.noVisibilityDefaultForm.getVisibleViewFieldNamesAsList());
        FormConfigBasicTest.assertNull((Object)this.noVisibilityDefaultForm.getVisibleViewFieldNames());
        FormConfigBasicTest.assertNull((Object)this.noVisibilityDefaultForm.getHiddenCreateFieldNamesAsList());
        FormConfigBasicTest.assertNull((Object)this.noVisibilityDefaultForm.getHiddenCreateFieldNames());
        FormConfigBasicTest.assertNull((Object)this.noVisibilityDefaultForm.getHiddenEditFieldNamesAsList());
        FormConfigBasicTest.assertNull((Object)this.noVisibilityDefaultForm.getHiddenEditFieldNames());
        FormConfigBasicTest.assertNull((Object)this.noVisibilityDefaultForm.getHiddenViewFieldNamesAsList());
        FormConfigBasicTest.assertNull((Object)this.noVisibilityDefaultForm.getHiddenViewFieldNames());
    }

    public void testHiddenFields() throws Exception {
        FormConfigBasicTest.assertNotNull((Object)this.hiddenFieldsDefaultForm.getHiddenCreateFieldNamesAsList());
        FormConfigBasicTest.assertNotNull((Object)this.hiddenFieldsDefaultForm.getHiddenCreateFieldNames());
        FormConfigBasicTest.assertNotNull((Object)this.hiddenFieldsDefaultForm.getHiddenEditFieldNamesAsList());
        FormConfigBasicTest.assertNotNull((Object)this.hiddenFieldsDefaultForm.getHiddenEditFieldNames());
        FormConfigBasicTest.assertNotNull((Object)this.hiddenFieldsDefaultForm.getHiddenViewFieldNamesAsList());
        FormConfigBasicTest.assertNotNull((Object)this.hiddenFieldsDefaultForm.getHiddenViewFieldNames());
        List hiddenViewFields = this.hiddenFieldsDefaultForm.getHiddenViewFieldNamesAsList();
        String[] hiddenViewFieldsArray = this.hiddenFieldsDefaultForm.getHiddenViewFieldNames();
        FormConfigBasicTest.assertEquals((int)2, (int)hiddenViewFieldsArray.length);
        FormConfigBasicTest.assertEquals((int)2, (int)hiddenViewFields.size());
        FormConfigBasicTest.assertEquals((String)"custom:first", (String)((String)hiddenViewFields.get(0)));
        FormConfigBasicTest.assertEquals((String)"custom:second", (String)((String)hiddenViewFields.get(1)));
        List hiddenEditFields = this.hiddenFieldsDefaultForm.getHiddenEditFieldNamesAsList();
        String[] hiddenEditFieldsArray = this.hiddenFieldsDefaultForm.getHiddenEditFieldNames();
        FormConfigBasicTest.assertEquals((int)3, (int)hiddenEditFieldsArray.length);
        FormConfigBasicTest.assertEquals((int)3, (int)hiddenEditFields.size());
        FormConfigBasicTest.assertEquals((String)"custom:first", (String)((String)hiddenEditFields.get(0)));
        FormConfigBasicTest.assertEquals((String)"custom:second", (String)((String)hiddenEditFields.get(1)));
        FormConfigBasicTest.assertEquals((String)"sys:dbid", (String)((String)hiddenEditFields.get(2)));
        List hiddenCreateFields = this.hiddenFieldsDefaultForm.getHiddenCreateFieldNamesAsList();
        String[] hiddenCreateFieldsArray = this.hiddenFieldsDefaultForm.getHiddenCreateFieldNames();
        FormConfigBasicTest.assertEquals((int)3, (int)hiddenCreateFieldsArray.length);
        FormConfigBasicTest.assertEquals((int)3, (int)hiddenCreateFields.size());
        FormConfigBasicTest.assertEquals((String)"custom:first", (String)((String)hiddenCreateFields.get(0)));
        FormConfigBasicTest.assertEquals((String)"custom:second", (String)((String)hiddenCreateFields.get(1)));
        FormConfigBasicTest.assertEquals((String)"sys:dbid", (String)((String)hiddenCreateFields.get(2)));
        Map fields = this.hiddenFieldsDefaultForm.getFields();
        FormConfigBasicTest.assertNotNull((Object)fields);
        FormField nameField = (FormField)fields.get("custom:name");
        FormConfigBasicTest.assertNotNull((Object)nameField);
        FormConfigBasicTest.assertEquals((String)"main", (String)nameField.getSet());
        FormConfigBasicTest.assertTrue((boolean)this.hiddenFieldsDefaultForm.isFieldHidden("custom:first", Mode.VIEW));
        FormConfigBasicTest.assertTrue((boolean)this.hiddenFieldsDefaultForm.isFieldHidden("custom:first", Mode.EDIT));
        FormConfigBasicTest.assertTrue((boolean)this.hiddenFieldsDefaultForm.isFieldHidden("custom:first", Mode.CREATE));
        FormConfigBasicTest.assertTrue((boolean)this.hiddenFieldsDefaultForm.isFieldHidden("custom:second", Mode.VIEW));
        FormConfigBasicTest.assertTrue((boolean)this.hiddenFieldsDefaultForm.isFieldHidden("custom:second", Mode.EDIT));
        FormConfigBasicTest.assertTrue((boolean)this.hiddenFieldsDefaultForm.isFieldHidden("custom:second", Mode.CREATE));
        FormConfigBasicTest.assertFalse((boolean)this.hiddenFieldsDefaultForm.isFieldHidden("sys:dbid", Mode.VIEW));
        FormConfigBasicTest.assertTrue((boolean)this.hiddenFieldsDefaultForm.isFieldHidden("sys:dbid", Mode.EDIT));
        FormConfigBasicTest.assertTrue((boolean)this.hiddenFieldsDefaultForm.isFieldHidden("sys:dbid", Mode.CREATE));
        FormConfigBasicTest.assertFalse((boolean)this.hiddenFieldsDefaultForm.isFieldHiddenInMode("sys:dbid", "view"));
        FormConfigBasicTest.assertTrue((boolean)this.hiddenFieldsDefaultForm.isFieldHiddenInMode("sys:dbid", "edit"));
        FormConfigBasicTest.assertTrue((boolean)this.hiddenFieldsDefaultForm.isFieldHiddenInMode("sys:dbid", "create"));
        FormConfigBasicTest.assertFalse((boolean)this.hiddenFieldsDefaultForm.isFieldHidden("non:existent", Mode.VIEW));
        FormConfigBasicTest.assertFalse((boolean)this.hiddenFieldsDefaultForm.isFieldHidden("non:existent", Mode.EDIT));
        FormConfigBasicTest.assertFalse((boolean)this.hiddenFieldsDefaultForm.isFieldHidden("non:existent", Mode.CREATE));
    }

    public void testMandatoryField() throws Exception {
        FormField duplicateField = (FormField)this.myExampleDefaultForm.getFields().get("my:duplicate");
        FormConfigBasicTest.assertNotNull((Object)duplicateField);
        FormConfigBasicTest.assertFalse((boolean)duplicateField.isMandatory());
        FormField mandatoryField = (FormField)this.myExampleDefaultForm.getFields().get("my:mandatory");
        FormConfigBasicTest.assertNotNull((Object)mandatoryField);
        FormConfigBasicTest.assertTrue((boolean)mandatoryField.isMandatory());
    }
}

