/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.config.forms;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.web.config.forms.ControlParam;
import org.alfresco.web.config.forms.FieldVisibilityManager;
import org.alfresco.web.config.forms.FormField;
import org.alfresco.web.config.forms.FormSet;
import org.alfresco.web.config.forms.Mode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.config.ConfigElement;
import org.springframework.extensions.config.ConfigException;
import org.springframework.extensions.config.element.ConfigElementAdapter;

public class FormConfigElement
extends ConfigElementAdapter {
    private static final long serialVersionUID = -7008510360503886308L;
    private static Log logger = LogFactory.getLog(FormConfigElement.class);
    public static final String FORM_NAME_ID = "form";
    public static final String DEFAULT_SET_ID = "";
    private String formId;
    private String submissionURL;
    private String createTemplate;
    private String editTemplate;
    private String viewTemplate;
    FieldVisibilityManager fieldVisibilityManager = new FieldVisibilityManager();
    private final Map<String, FormSet> sets = new LinkedHashMap<String, FormSet>(4);
    private Map<String, FormField> fields = new LinkedHashMap<String, FormField>(8);
    private List<String> forcedFields = new ArrayList<String>(4);

    public FormConfigElement() {
        this(FORM_NAME_ID);
    }

    public FormConfigElement(String name) {
        super(name);
        FormSet defaultSet = new FormSet(DEFAULT_SET_ID);
        this.sets.put(DEFAULT_SET_ID, defaultSet);
    }

    public List<ConfigElement> getChildren() {
        throw new ConfigException("Reading the form config via the generic interfaces is not supported");
    }

    public ConfigElement combine(ConfigElement otherConfigElement) {
        if (otherConfigElement == null) {
            return this;
        }
        FormConfigElement otherFormElem = (FormConfigElement)otherConfigElement;
        FormConfigElement result = new FormConfigElement();
        this.combineSubmissionURL(otherFormElem, result);
        this.combineTemplates(otherFormElem, result);
        this.combineFieldVisibilities(otherFormElem, result);
        this.combineSets(otherFormElem, result);
        this.combineFields(otherFormElem, result);
        return result;
    }

    private void combineFields(FormConfigElement otherFormElem, FormConfigElement result) {
        LinkedHashMap<String, FormField> newFields = new LinkedHashMap<String, FormField>();
        for (String nextFieldId : this.fields.keySet()) {
            FormField nextFieldFromThis = this.fields.get(nextFieldId);
            if (otherFormElem.getFields().containsKey(nextFieldId)) {
                FormField combinedField = nextFieldFromThis.combine(otherFormElem.getFields().get(nextFieldId));
                newFields.put(nextFieldId, combinedField);
                continue;
            }
            newFields.put(nextFieldId, nextFieldFromThis);
        }
        for (String nextFieldId : otherFormElem.fields.keySet()) {
            if (this.fields.containsKey(nextFieldId)) continue;
            newFields.put(nextFieldId, otherFormElem.fields.get(nextFieldId));
        }
        result.setFields(newFields);
        result.forcedFields.addAll(this.forcedFields);
        for (String fieldName : otherFormElem.forcedFields) {
            if (result.forcedFields.contains(fieldName)) continue;
            result.forcedFields.add(fieldName);
        }
    }

    private void combineSets(FormConfigElement otherFormElem, FormConfigElement result) {
        String template;
        String labelId;
        String label;
        String appearance;
        String parentId;
        String setId;
        for (String nextOldSet : this.sets.keySet()) {
            FormSet nextOldSetData = this.sets.get(nextOldSet);
            setId = nextOldSetData.getSetId();
            parentId = nextOldSetData.getParentId();
            appearance = nextOldSetData.getAppearance();
            label = nextOldSetData.getLabel();
            labelId = nextOldSetData.getLabelId();
            template = nextOldSetData.getTemplate();
            result.addSet(setId, parentId, appearance, label, labelId, template);
        }
        for (String nextNewSet : otherFormElem.sets.keySet()) {
            FormSet nextNewSetData = otherFormElem.sets.get(nextNewSet);
            setId = nextNewSetData.getSetId();
            parentId = nextNewSetData.getParentId();
            appearance = nextNewSetData.getAppearance();
            label = nextNewSetData.getLabel();
            labelId = nextNewSetData.getLabelId();
            template = nextNewSetData.getTemplate();
            result.addSet(setId, parentId, appearance, label, labelId, template);
        }
    }

    private void combineFieldVisibilities(FormConfigElement otherFormElem, FormConfigElement result) {
        FieldVisibilityManager combinedManager;
        result.fieldVisibilityManager = combinedManager = this.fieldVisibilityManager.combine(otherFormElem.fieldVisibilityManager);
    }

    private void combineTemplates(FormConfigElement otherFormElem, FormConfigElement result) {
        result.setFormTemplate("create-form", otherFormElem.createTemplate == null ? this.createTemplate : otherFormElem.createTemplate);
        result.setFormTemplate("edit-form", otherFormElem.editTemplate == null ? this.editTemplate : otherFormElem.editTemplate);
        result.setFormTemplate("view-form", otherFormElem.viewTemplate == null ? this.viewTemplate : otherFormElem.viewTemplate);
    }

    private void combineSubmissionURL(FormConfigElement otherFormElem, FormConfigElement result) {
        String otherSubmissionURL = otherFormElem.getSubmissionURL();
        result.setSubmissionURL(otherSubmissionURL == null ? this.submissionURL : otherSubmissionURL);
    }

    public String getId() {
        return this.formId;
    }

    public String getSubmissionURL() {
        return this.submissionURL;
    }

    public Map<String, FormSet> getSets() {
        return Collections.unmodifiableMap(this.sets);
    }

    public String[] getSetIDs() {
        return this.getSetIDsAsList().toArray(new String[0]);
    }

    public List<String> getSetIDsAsList() {
        Set<String> keySet = this.sets.keySet();
        ArrayList<String> result = new ArrayList<String>(keySet.size());
        result.addAll(keySet);
        return Collections.unmodifiableList(result);
    }

    public FormSet[] getRootSets() {
        return this.getRootSetsAsList().toArray(new FormSet[0]);
    }

    public List<FormSet> getRootSetsAsList() {
        ArrayList<FormSet> result = new ArrayList<FormSet>(this.sets.size());
        for (String nextKey : this.sets.keySet()) {
            FormSet nextSet = this.sets.get(nextKey);
            String nextParentID = nextSet.getParentId();
            if (nextParentID != null) continue;
            result.add(nextSet);
        }
        return result;
    }

    public Map<String, FormField> getFields() {
        LinkedHashSet<String> fieldsVisibleInAnyMode = new LinkedHashSet<String>();
        for (Mode m : Mode.values()) {
            List<String> newFields = this.fieldVisibilityManager.getFieldNamesVisibleInMode(m);
            if (newFields == null) continue;
            fieldsVisibleInAnyMode.addAll(newFields);
        }
        LinkedHashMap<String, FormField> result = new LinkedHashMap<String, FormField>();
        result.putAll(this.fields);
        for (String s : fieldsVisibleInAnyMode) {
            if (result.containsKey(s)) continue;
            result.put(s, new FormField(s, null));
        }
        return Collections.unmodifiableMap(result);
    }

    public String[] getHiddenCreateFieldNames() {
        List<String> names = this.getHiddenCreateFieldNamesAsList();
        if (names != null) {
            return names.toArray(new String[0]);
        }
        return null;
    }

    public String[] getHiddenEditFieldNames() {
        List<String> names = this.getHiddenEditFieldNamesAsList();
        if (names != null) {
            return names.toArray(new String[0]);
        }
        return null;
    }

    public String[] getHiddenViewFieldNames() {
        List<String> names = this.getHiddenViewFieldNamesAsList();
        if (names != null) {
            return names.toArray(new String[0]);
        }
        return null;
    }

    public String[] getVisibleCreateFieldNames() {
        List<String> names = this.getVisibleCreateFieldNamesAsList();
        if (names != null) {
            return names.toArray(new String[0]);
        }
        return null;
    }

    public String[] getVisibleEditFieldNames() {
        List<String> names = this.getVisibleEditFieldNamesAsList();
        if (names != null) {
            return names.toArray(new String[0]);
        }
        return null;
    }

    public String[] getVisibleViewFieldNames() {
        List<String> names = this.getVisibleViewFieldNamesAsList();
        if (names != null) {
            return names.toArray(new String[0]);
        }
        return null;
    }

    public List<String> getHiddenCreateFieldNamesAsList() {
        return this.getFieldNamesHiddenInMode(Mode.CREATE);
    }

    public List<String> getHiddenEditFieldNamesAsList() {
        return this.getFieldNamesHiddenInMode(Mode.EDIT);
    }

    public List<String> getHiddenViewFieldNamesAsList() {
        return this.getFieldNamesHiddenInMode(Mode.VIEW);
    }

    public List<String> getVisibleCreateFieldNamesAsList() {
        return this.getFieldNamesVisibleInMode(Mode.CREATE);
    }

    public List<String> getVisibleEditFieldNamesAsList() {
        return this.getFieldNamesVisibleInMode(Mode.EDIT);
    }

    public List<String> getVisibleViewFieldNamesAsList() {
        return this.getFieldNamesVisibleInMode(Mode.VIEW);
    }

    public List<String> getVisibleCreateFieldNamesForSetAsList(String setId) {
        return this.getVisibleFieldNamesFor(setId, Mode.CREATE);
    }

    public String[] getVisibleCreateFieldNamesForSet(String setId) {
        List<String> result = this.getVisibleCreateFieldNamesForSetAsList(setId);
        if (result == null) {
            return null;
        }
        return result.toArray(new String[0]);
    }

    public List<String> getVisibleEditFieldNamesForSetAsList(String setId) {
        return this.getVisibleFieldNamesFor(setId, Mode.EDIT);
    }

    public String[] getVisibleEditFieldNamesForSet(String setId) {
        List<String> result = this.getVisibleEditFieldNamesForSetAsList(setId);
        if (result == null) {
            return null;
        }
        return result.toArray(new String[0]);
    }

    public List<String> getVisibleViewFieldNamesForSetAsList(String setId) {
        return this.getVisibleFieldNamesFor(setId, Mode.VIEW);
    }

    public String[] getVisibleViewFieldNamesForSet(String setId) {
        List<String> result = this.getVisibleViewFieldNamesForSetAsList(setId);
        if (result == null) {
            return null;
        }
        return result.toArray(new String[0]);
    }

    private List<String> getVisibleFieldNamesFor(String setId, Mode mode) {
        ArrayList<String> result = new ArrayList<String>();
        FormSet specifiedSet = this.getSets().get(setId);
        if (specifiedSet == null) {
            return null;
        }
        List<String> visibleFields = this.getFieldNamesVisibleInMode(mode);
        if (visibleFields == null) {
            return null;
        }
        for (String fieldName : visibleFields) {
            FormField appearanceField = this.fields.get(fieldName);
            FormField formField = appearanceField != null ? appearanceField : new FormField(fieldName, null);
            String set = null;
            if (formField != null) {
                set = formField.getSet();
            }
            if (set == null) {
                set = DEFAULT_SET_ID;
            }
            if (!set.equals(setId)) continue;
            result.add(fieldName);
        }
        return result;
    }

    public String getCreateTemplate() {
        return this.createTemplate;
    }

    public String getEditTemplate() {
        return this.editTemplate;
    }

    public String getViewTemplate() {
        return this.viewTemplate;
    }

    void setFormId(String formId) {
        this.formId = formId;
    }

    public String getFormTemplate(Mode m) {
        switch (m) {
            case CREATE: {
                return this.getCreateTemplate();
            }
            case EDIT: {
                return this.getEditTemplate();
            }
            case VIEW: {
                return this.getViewTemplate();
            }
        }
        return null;
    }

    public boolean isFieldVisible(String fieldId, Mode m) {
        return this.fieldVisibilityManager.isFieldVisible(fieldId, m);
    }

    public boolean isFieldHidden(String fieldId, Mode m) {
        return this.fieldVisibilityManager.isFieldHidden(fieldId, m);
    }

    public boolean isFieldVisibleInMode(String fieldId, String modeString) {
        Mode m = Mode.modeFromString(modeString);
        return this.isFieldVisible(fieldId, m);
    }

    public boolean isFieldHiddenInMode(String fieldId, String modeString) {
        Mode m = Mode.modeFromString(modeString);
        return this.isFieldHidden(fieldId, m);
    }

    public boolean isFieldForced(String fieldId) {
        return this.forcedFields.contains(fieldId);
    }

    public String[] getForcedFields() {
        return this.getForcedFieldsAsList().toArray(new String[0]);
    }

    public List<String> getForcedFieldsAsList() {
        return this.forcedFields;
    }

    private List<String> getFieldNamesHiddenInMode(Mode mode) {
        List<String> result = this.fieldVisibilityManager.getFieldNamesHiddenInMode(mode);
        return result;
    }

    private List<String> getFieldNamesVisibleInMode(Mode mode) {
        List<String> result = this.fieldVisibilityManager.getFieldNamesVisibleInMode(mode);
        return result;
    }

    void setSubmissionURL(String newURL) {
        this.submissionURL = newURL;
    }

    void setFormTemplate(String nodeName, String newTemplate) {
        if (nodeName.equals("create-form")) {
            this.createTemplate = newTemplate;
        } else if (nodeName.equals("edit-form")) {
            this.editTemplate = newTemplate;
        } else if (nodeName.equals("view-form")) {
            this.viewTemplate = newTemplate;
        } else {
            if (logger.isWarnEnabled()) {
                logger.warn((Object)("Unrecognised mode: " + nodeName));
            }
            return;
        }
    }

    void addFieldVisibility(String showOrHide, String fieldId, String mode, String forceString) {
        this.fieldVisibilityManager.addInstruction(showOrHide, fieldId, mode);
        boolean isForced = new Boolean(forceString);
        if (isForced && !this.forcedFields.contains(fieldId)) {
            this.forcedFields.add(fieldId);
        }
    }

    void addSet(String setId, String parentSetId, String appearance, String label, String labelId) {
        this.addSet(setId, parentSetId, appearance, label, labelId, null);
    }

    void addSet(String setId, String parentSetId, String appearance, String label, String labelId, String template) {
        FormSet newFormSetObject = new FormSet(setId, parentSetId, appearance, label, labelId, template);
        if (parentSetId != null && !this.sets.containsKey(parentSetId)) {
            StringBuilder errorMsg = new StringBuilder();
            errorMsg.append("Set [").append(setId).append("] has undefined parent [").append(parentSetId).append("].");
            throw new ConfigException(errorMsg.toString());
        }
        if (setId.equals(DEFAULT_SET_ID) && parentSetId != null) {
            StringBuilder errorMsg = new StringBuilder();
            errorMsg.append("Default set cannot have any parent set. Parent specified was: [").append(parentSetId).append("].");
            throw new ConfigException(errorMsg.toString());
        }
        this.sets.put(setId, newFormSetObject);
        if (parentSetId != null) {
            FormSet parentObject = this.sets.get(parentSetId);
            newFormSetObject.setParent(parentObject);
            parentObject.addChild(newFormSetObject);
        }
    }

    void addField(String fieldId, List<String> attributeNames, List<String> attributeValues) {
        if (attributeNames == null) {
            attributeNames = Collections.emptyList();
        }
        if (attributeValues == null) {
            attributeValues = Collections.emptyList();
        }
        if (attributeNames.size() < attributeValues.size() && logger.isWarnEnabled()) {
            StringBuilder msg = new StringBuilder();
            msg.append("field ").append(fieldId).append(" has ").append(attributeNames.size()).append(" xml attribute names and ").append(attributeValues.size()).append(" xml attribute values. The trailing extra data will be ignored.");
            logger.warn((Object)msg.toString());
        }
        LinkedHashMap<String, String> attrs = new LinkedHashMap<String, String>();
        for (int i = 0; i < attributeNames.size(); ++i) {
            attrs.put(attributeNames.get(i), attributeValues.get(i));
        }
        this.fields.put(fieldId, new FormField(fieldId, attrs));
    }

    void setFields(Map<String, FormField> newFieldsMap) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Setting new fields map " + String.valueOf(newFieldsMap)));
        }
        this.fields = newFieldsMap;
    }

    void addControlForField(String fieldId, String template, List<String> controlParamNames, List<String> controlParamValues) {
        if (controlParamNames == null) {
            controlParamNames = Collections.emptyList();
        }
        if (controlParamValues == null) {
            controlParamValues = Collections.emptyList();
        }
        if (controlParamNames.size() < controlParamValues.size() && logger.isWarnEnabled()) {
            StringBuilder msg = new StringBuilder();
            msg.append("field ").append(fieldId).append(" has ").append(controlParamNames.size()).append(" control-param names and ").append(controlParamValues.size()).append(" control-param values. The trailing extra data will be ignored.");
            logger.warn((Object)msg.toString());
        }
        FormField field = this.fields.get(fieldId);
        field.getControl().setTemplate(template);
        for (int i = 0; i < controlParamNames.size(); ++i) {
            ControlParam cp = new ControlParam(controlParamNames.get(i), controlParamValues.get(i));
            field.getControl().addControlParam(cp);
        }
    }

    void addConstraintForField(String fieldId, String type, String message, String messageId, String validationHandler, String event) {
        FormField field = this.fields.get(fieldId);
        field.addConstraintDefinition(type, message, messageId, validationHandler, event);
    }
}

