/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.officeservices.docproc;

import org.apache.poi.ooxml.POIXMLProperties;
import org.openxmlformats.schemas.officeDocument.x2006.customProperties.CTProperties;
import org.openxmlformats.schemas.officeDocument.x2006.customProperties.CTProperty;

public class OOXMLCustomPropertiesModifier {
    public static final String FORMAT_ID = "{D5CDD505-2E9C-101B-9397-08002B2CF9AE}";
    protected POIXMLProperties.CustomProperties custProp;
    protected CTProperties underlyingProperties;

    public OOXMLCustomPropertiesModifier(POIXMLProperties.CustomProperties cp) {
        this.custProp = cp;
        this.underlyingProperties = this.custProp.getUnderlyingProperties();
    }

    public boolean contains(String name) {
        for (int i = 0; i < this.underlyingProperties.sizeOfPropertyArray(); ++i) {
            if (!this.underlyingProperties.getPropertyArray(i).getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    protected int nextPid() {
        int propid = 1;
        for (int i = 0; i < this.underlyingProperties.sizeOfPropertyArray(); ++i) {
            if (this.underlyingProperties.getPropertyArray(i).getPid() <= propid) continue;
            propid = this.underlyingProperties.getPropertyArray(i).getPid();
        }
        return propid + 1;
    }

    public void setProperty(String propertyName, String value) {
        int propertyPosition = -1;
        for (int i = 0; i < this.underlyingProperties.sizeOfPropertyArray(); ++i) {
            if (!this.underlyingProperties.getPropertyArray(i).getName().equals(propertyName)) continue;
            propertyPosition = i;
            break;
        }
        if (propertyPosition >= 0) {
            this.underlyingProperties.removeProperty(propertyPosition);
        }
        if (value != null) {
            int pid = this.nextPid();
            CTProperty p = this.underlyingProperties.addNewProperty();
            p.setPid(pid);
            p.setFmtid(FORMAT_ID);
            p.setName(propertyName);
            p.setLpwstr(value);
        }
    }
}

