/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.officeservices;

import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.List;
import org.alfresco.officeservices.AbstractSoapService;
import org.alfresco.officeservices.GetWebCollectionWebDescription;
import org.alfresco.officeservices.GetWebWebDescription;
import org.alfresco.officeservices.ServiceLogger;
import org.alfresco.officeservices.UserData;
import org.alfresco.officeservices.WebsGetContentTypeContentType;
import org.alfresco.officeservices.WebsGetContentTypesContentType;
import org.alfresco.officeservices.exceptions.AuthenticationRequiredException;
import org.alfresco.officeservices.protocol.HtmlEncoder;
import org.alfresco.officeservices.protocol.SimpleSoapParser;
import org.alfresco.officeservices.protocol.SoapParameter;

public abstract class AbstractWebsService
extends AbstractSoapService {
    private static final long serialVersionUID = 4410897234802139744L;
    private static final ServiceLogger logger = new ServiceLogger(AbstractWebsService.class);
    public static final String METHODNAME_WEBURLFROMPAGEURL = "WebUrlFromPageUrl";
    public static final String METHODNAME_GETWEBCOLLECTION = "GetWebCollection";
    public static final String METHODNAME_GETCONTENTTYPES = "GetContentTypes";
    public static final String METHODNAME_GETCONTENTTYPE = "GetContentType";
    public static final String METHODNAME_UPDATECONTENTTYPEXMLDOCUMENT = "UpdateContentTypeXmlDocument";
    public static final String METHODNAME_GETWEB = "GetWeb";
    public static final String METHODPARAMETER_PAGEURL = "pageurl";
    public static final String METHODPARAMETER_CONTENTTYPEID = "contentTypeId";
    public static final String METHODPARAMETER_NEWDOCUMENT = "newDocument";
    public static final String METHODPARAMETER_WEBURL = "webUrl";
    protected static final String RESPONSE_CONTENT_TYPE = "text/xml; charset=utf-8";

    @Override
    public void soapService(UserData userData, String methodName, SimpleSoapParser parser, HttpServletRequest request, HttpServletResponse response) throws IOException, AuthenticationRequiredException {
        if (logger.isTraceEnabled()) {
            logger.traceEnter();
        }
        if (methodName.equals(METHODNAME_WEBURLFROMPAGEURL)) {
            this.handleWebUrlFromPageUrl(userData, parser, request, response);
        } else if (methodName.equals(METHODNAME_GETWEBCOLLECTION)) {
            this.handleGetWebCollection(userData, parser, request, response);
        } else if (methodName.equals(METHODNAME_GETCONTENTTYPES)) {
            this.handleGetContentTypes(userData, parser, request, response);
        } else if (methodName.equals(METHODNAME_GETCONTENTTYPE)) {
            this.handleGetContentType(userData, parser, request, response);
        } else if (methodName.equals(METHODNAME_UPDATECONTENTTYPEXMLDOCUMENT)) {
            this.handleUpdateContentTypeXmlDocument(userData, parser, request, response);
        } else if (methodName.equals(METHODNAME_GETWEB)) {
            this.handleGetWeb(userData, parser, request, response);
        } else {
            logger.error("soapService: unknown RPC methodname " + methodName);
            SimpleSoapParser.soapErrorResponse(response, "Unknown methodname.");
        }
        if (logger.isTraceEnabled()) {
            logger.traceExit();
        }
    }

    protected void handleWebUrlFromPageUrl(UserData userData, SimpleSoapParser parser, HttpServletRequest request, HttpServletResponse response) throws IOException, AuthenticationRequiredException {
        String payload;
        String pageUrl;
        if (logger.isTraceEnabled()) {
            logger.traceEnter();
        }
        if ((pageUrl = parser.getParameter(METHODPARAMETER_PAGEURL)) == null) {
            logger.error("handleWebUrlFromPageUrl: Parameter \"pageurl\" missing.");
            SimpleSoapParser.soapErrorResponse(response, "Missing parameter pageurl");
            if (logger.isTraceEnabled()) {
                logger.traceExit();
            }
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("handleWebUrlFromPageUrl: pageUrl=" + pageUrl);
        }
        if ((payload = this.getWebUrlFromPageUrlResult(pageUrl, parser, request)) == null) {
            logger.debug("handleWebUrlFromPageUrl: No webUrl for this pageUrl available. pageUrl=" + pageUrl);
            SimpleSoapParser.soapErrorResponse(response, "Invalid page url.");
            if (logger.isTraceEnabled()) {
                logger.traceExit();
            }
            return;
        }
        ServletOutputStream out = response.getOutputStream();
        response.setContentType(RESPONSE_CONTENT_TYPE);
        out.print("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        out.print("<soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\">");
        out.print("<soap:Body>");
        out.print("<WebUrlFromPageUrlResponse xmlns=\"http://schemas.microsoft.com/sharepoint/soap/\">");
        out.print("<WebUrlFromPageUrlResult>");
        HtmlEncoder.writeEncoded(out, payload, "UTF-8");
        out.print("</WebUrlFromPageUrlResult>");
        out.print("</WebUrlFromPageUrlResponse>");
        out.print("</soap:Body>");
        out.print("</soap:Envelope>");
        if (logger.isTraceEnabled()) {
            logger.traceExit();
        }
    }

    public abstract String getWebUrlFromPageUrlResult(String var1, SimpleSoapParser var2, HttpServletRequest var3);

    protected void handleGetWebCollection(UserData userData, SimpleSoapParser parser, HttpServletRequest request, HttpServletResponse response) throws IOException, AuthenticationRequiredException {
        if (logger.isTraceEnabled()) {
            logger.traceEnter();
        }
        List<GetWebCollectionWebDescription> webDescriptions = this.getWebCollection(parser, request);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        PrintStream out = new PrintStream(bos);
        out.print("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        out.print("<soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\">");
        out.print("<soap:Body>");
        out.print("<GetWebCollectionResponse xmlns=\"http://schemas.microsoft.com/sharepoint/soap/\">");
        out.print("<GetWebCollectionResult>");
        if (webDescriptions == null || webDescriptions.size() == 0) {
            out.print("<Webs />");
        } else {
            out.print("<Webs>");
            for (GetWebCollectionWebDescription webDescription : webDescriptions) {
                webDescription.write(out);
            }
            out.print("</Webs>");
        }
        out.print("</GetWebCollectionResult>");
        out.print("</GetWebCollectionResponse>");
        out.print("</soap:Body>");
        out.print("</soap:Envelope>");
        out.flush();
        response.setContentType(RESPONSE_CONTENT_TYPE);
        response.setContentLength(bos.size());
        bos.writeTo((OutputStream)response.getOutputStream());
        if (logger.isTraceEnabled()) {
            logger.traceExit();
        }
    }

    public abstract List<GetWebCollectionWebDescription> getWebCollection(SimpleSoapParser var1, HttpServletRequest var2);

    protected void handleGetContentTypes(UserData userData, SimpleSoapParser parser, HttpServletRequest request, HttpServletResponse response) throws IOException, AuthenticationRequiredException {
        if (logger.isTraceEnabled()) {
            logger.traceEnter();
        }
        WebsGetContentTypesContentType[] contentTypes = this.getContentTypes(parser, request);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        PrintStream out = new PrintStream(bos);
        out.print("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        out.print("<soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\">");
        out.print("<soap:Body>");
        out.print("<GetContentTypesResponse xmlns=\"http://schemas.microsoft.com/sharepoint/soap/\">");
        out.print("<GetContentTypesResult>");
        if (contentTypes == null || contentTypes.length == 0) {
            out.print("<ContentTypes />");
        } else {
            out.print("<ContentTypes>");
            for (int i = 0; i < contentTypes.length; ++i) {
                contentTypes[i].write(out);
            }
            out.print("</ContentTypes>");
        }
        out.print("</GetContentTypesResult>");
        out.print("</GetContentTypesResponse>");
        out.print("</soap:Body>");
        out.print("</soap:Envelope>");
        out.flush();
        response.setContentType(RESPONSE_CONTENT_TYPE);
        response.setContentLength(bos.size());
        bos.writeTo((OutputStream)response.getOutputStream());
        if (logger.isTraceEnabled()) {
            logger.traceExit();
        }
    }

    public abstract WebsGetContentTypesContentType[] getContentTypes(SimpleSoapParser var1, HttpServletRequest var2);

    protected void handleGetContentType(UserData userData, SimpleSoapParser parser, HttpServletRequest request, HttpServletResponse response) throws IOException, AuthenticationRequiredException {
        WebsGetContentTypeContentType contentType;
        String contentTypeId;
        if (logger.isTraceEnabled()) {
            logger.traceEnter();
        }
        if ((contentTypeId = parser.getParameter(METHODPARAMETER_CONTENTTYPEID)) == null) {
            logger.error("handleGetContentType: Parameter \"contentTypeId\" missing.");
            SimpleSoapParser.soapErrorResponse(response, "Missing parameter contentTypeId");
            if (logger.isTraceEnabled()) {
                logger.traceExit();
            }
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("handleGetContentType: Parameter contentTypeId=" + contentTypeId);
        }
        if ((contentType = this.getContentType(userData, contentTypeId, request)) == null) {
            logger.error("handleGetContentType: unknown ContentType " + contentTypeId);
            SimpleSoapParser.soapErrorResponse(response, "Unknown content type.");
            return;
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        PrintStream out = new PrintStream(bos);
        out.print("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        out.print("<soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\">");
        out.print("<soap:Body>");
        out.print("<GetContentTypeResponse xmlns=\"http://schemas.microsoft.com/sharepoint/soap/\">");
        out.print("<GetContentTypeResult>");
        contentType.write(out);
        out.print("</GetContentTypeResult>");
        out.print("</GetContentTypeResponse>");
        out.print("</soap:Body>");
        out.print("</soap:Envelope>");
        out.flush();
        response.setContentType(RESPONSE_CONTENT_TYPE);
        response.setContentLength(bos.size());
        bos.writeTo((OutputStream)response.getOutputStream());
        if (logger.isTraceEnabled()) {
            logger.traceExit();
        }
    }

    protected abstract WebsGetContentTypeContentType getContentType(UserData var1, String var2, HttpServletRequest var3) throws AuthenticationRequiredException;

    protected void handleUpdateContentTypeXmlDocument(UserData userData, SimpleSoapParser parser, HttpServletRequest request, HttpServletResponse response) throws IOException, AuthenticationRequiredException {
        String contentTypeId;
        if (logger.isTraceEnabled()) {
            logger.traceEnter();
        }
        if ((contentTypeId = parser.getParameter(METHODPARAMETER_CONTENTTYPEID)) == null) {
            logger.error("handleUpdateContentTypeXmlDocument: Parameter \"contentTypeId\" missing.");
            SimpleSoapParser.soapErrorResponse(response, "Missing parameter contentTypeId");
            if (logger.isTraceEnabled()) {
                logger.traceExit();
            }
            return;
        }
        SoapParameter newDocument = parser.getSoapParameter(METHODPARAMETER_NEWDOCUMENT);
        if (logger.isDebugEnabled()) {
            logger.debug("handleUpdateContentTypeXmlDocument: Parameter contentTypeId=" + contentTypeId);
        }
        boolean success = this.updateContentTypeXmlDocument(userData, contentTypeId, newDocument, request);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        PrintStream out = new PrintStream(bos);
        out.print("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        out.print("<soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\">");
        out.print("<soap:Body>");
        out.print("<UpdateContentTypeXmlDocumentResponse xmlns=\"http://schemas.microsoft.com/sharepoint/soap/\">");
        out.print("<UpdateContentTypeXmlDocumentResult>");
        if (success) {
            out.print("<Success />");
        }
        out.print("</UpdateContentTypeXmlDocumentResult>");
        out.print("</UpdateContentTypeXmlDocumentResponse>");
        out.print("</soap:Body>");
        out.print("</soap:Envelope>");
        out.flush();
        response.setContentType(RESPONSE_CONTENT_TYPE);
        response.setContentLength(bos.size());
        bos.writeTo((OutputStream)response.getOutputStream());
        if (logger.isTraceEnabled()) {
            logger.traceExit();
        }
    }

    protected abstract boolean updateContentTypeXmlDocument(UserData var1, String var2, SoapParameter var3, HttpServletRequest var4) throws AuthenticationRequiredException;

    protected void handleGetWeb(UserData userData, SimpleSoapParser parser, HttpServletRequest request, HttpServletResponse response) throws IOException, AuthenticationRequiredException {
        GetWebWebDescription webDescription;
        String webUrl;
        if (logger.isTraceEnabled()) {
            logger.traceEnter();
        }
        if ((webUrl = parser.getParameter(METHODPARAMETER_WEBURL)) == null) {
            logger.error("handleGetWeb: Parameter \"webUrl\" missing.");
            SimpleSoapParser.soapErrorResponse(response, "Missing parameter webUrl");
            if (logger.isTraceEnabled()) {
                logger.traceExit();
            }
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("handleGetWeb: webUrl=" + webUrl);
        }
        if ((webDescription = this.getWebResult(userData, webUrl, parser, request)) == null) {
            logger.error("handleGetWeb: unknown web " + webUrl);
            SimpleSoapParser.soapErrorResponse(response, "Unknown Web.");
            return;
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        PrintStream out = new PrintStream(bos);
        out.print("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        out.print("<soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\">");
        out.print("<soap:Body>");
        out.print("<GetWebResponse xmlns=\"http://schemas.microsoft.com/sharepoint/soap/\">");
        out.print("<GetWebResult>");
        webDescription.write(out);
        out.print("</GetWebResult>");
        out.print("</GetWebResponse>");
        out.print("</soap:Body>");
        out.print("</soap:Envelope>");
        out.flush();
        response.setContentType(RESPONSE_CONTENT_TYPE);
        response.setContentLength(bos.size());
        bos.writeTo((OutputStream)response.getOutputStream());
        if (logger.isTraceEnabled()) {
            logger.traceExit();
        }
    }

    protected abstract GetWebWebDescription getWebResult(UserData var1, String var2, SimpleSoapParser var3, HttpServletRequest var4);
}

