/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.officeservices.lists;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.List;
import org.alfresco.officeservices.AbstractSoapService;
import org.alfresco.officeservices.ServiceLogger;
import org.alfresco.officeservices.URLPathDecoder;
import org.alfresco.officeservices.UserData;
import org.alfresco.officeservices.exceptions.AuthenticationRequiredException;
import org.alfresco.officeservices.lists.CheckinType;
import org.alfresco.officeservices.lists.ListChanges;
import org.alfresco.officeservices.lists.ListDescription;
import org.alfresco.officeservices.lists.ListItem;
import org.alfresco.officeservices.lists.ListType;
import org.alfresco.officeservices.lists.ListUpdatesBatch;
import org.alfresco.officeservices.lists.ListsGetListContentTypeContentType;
import org.alfresco.officeservices.lists.ListsGetListContentTypesContentType;
import org.alfresco.officeservices.lists.ListsGetListList;
import org.alfresco.officeservices.lists.UpdateListItemsResults;
import org.alfresco.officeservices.lists.ViewDescription;
import org.alfresco.officeservices.protocol.SimpleSoapParser;
import org.alfresco.officeservices.protocol.SoapParameter;

public abstract class AbstractListsService
extends AbstractSoapService {
    private static final long serialVersionUID = 3609021953659945210L;
    private static final ServiceLogger logger = new ServiceLogger(AbstractListsService.class);
    public static final String METHODNAME_GETLIST = "GetList";
    public static final String METHODNAME_GETLISTITEMCHANGES = "GetListItemChanges";
    public static final String METHODNAME_GETLISTITEMCHANGESSINCETOKEN = "GetListItemChangesSinceToken";
    public static final String METHODNAME_GETATTACHMENTCOLLECTION = "GetAttachmentCollection";
    public static final String METHODNAME_CHECKOUTFILE = "CheckOutFile";
    public static final String METHODNAME_CHECKINFILE = "CheckInFile";
    public static final String METHODNAME_UNDOCHECKOUT = "UndoCheckOut";
    public static final String METHODNAME_GETLISTCONTENTTYPES = "GetListContentTypes";
    public static final String METHODNAME_GETLISTITEMS = "GetListItems";
    public static final String METHODNAME_GETLISTCONTENTTYPE = "GetListContentType";
    public static final String METHODNAME_UPDATELISTITEMS = "UpdateListItems";
    public static final String METHODNAME_GETLISTCOLLECTION = "GetListCollection";
    public static final String METHODNAME_GETLISTANDVIEW = "GetListAndView";
    public static final String METHODNAME_GETLISTCONTENTTYPESANDPROPERTIES = "GetListContentTypesAndProperties";
    public static final String METHODPARAMETER_LISTNAME = "listName";
    public static final String METHODPARAMETER_SINCE = "since";
    public static final String METHODPARAMETER_CHANGETOKEN = "changeToken";
    public static final String METHODPARAMETER_PAGEURL = "pageUrl";
    public static final String METHODPARAMETER_CHECKOUTTOLOCAL = "checkoutToLocal";
    public static final String METHODPARAMETER_LASTMODIFIED = "lastmodified";
    public static final String METHODPARAMETER_COMMENT = "comment";
    public static final String METHODPARAMETER_VIEWFIELDS = "viewFields";
    public static final String METHODPARAMETER_ROWLIMIT = "rowLimit";
    public static final String METHODPARAMETER_QUERYOPTIONS = "queryOptions";
    public static final String METHODPARAMETER_CONTAINS = "contains";
    public static final String METHODPARAMETER_QUERY = "query";
    public static final String METHODPARAMETER_CONTENTTYPEID = "contentTypeId";
    public static final String METHODPARAMETER_UPDATES = "updates";
    public static final String METHODPARAMETER_BATCH = "Batch";
    public static final String METHODPARAMETER_VIEWNAME = "viewName";
    public static final String METHODPARAMETER_PROPERTYPREFIX = "propertyPrefix";
    public static final String METHODPARAMETER_INCLUDEWEBPROPERTIES = "includeWebProperties";
    public static final String METHODPARAMETER_CHECKINTYPE = "CheckinType";
    protected static final String RESPONSE_CONTENT_TYPE = "text/xml; charset=utf-8";

    @Override
    public void soapService(UserData userData, String methodName, SimpleSoapParser parser, HttpServletRequest request, HttpServletResponse response) throws IOException, AuthenticationRequiredException {
        if (logger.isTraceEnabled()) {
            logger.traceEnter();
        }
        if (methodName.equals(METHODNAME_GETLIST)) {
            this.handleGetList(userData, parser, request, response);
        } else if (methodName.equals(METHODNAME_GETLISTITEMCHANGES)) {
            this.handleGetListItemChanges(userData, parser, request, response);
        } else if (methodName.equals(METHODNAME_GETLISTITEMS)) {
            this.handleGetListItems(userData, parser, request, response);
        } else if (methodName.equals(METHODNAME_GETLISTCONTENTTYPE)) {
            this.handleGetListContentType(userData, parser, request, response);
        } else if (methodName.equals(METHODNAME_GETLISTITEMCHANGESSINCETOKEN)) {
            this.handleGetListItemChangesSinceToken(userData, parser, request, response);
        } else if (methodName.equals(METHODNAME_CHECKOUTFILE)) {
            this.handleCheckOutFile(userData, parser, request, response);
        } else if (methodName.equals(METHODNAME_CHECKINFILE)) {
            this.handleCheckInFile(userData, parser, request, response);
        } else if (methodName.equals(METHODNAME_UNDOCHECKOUT)) {
            this.handleUndoCheckOut(userData, parser, request, response);
        } else if (methodName.equals(METHODNAME_GETLISTCONTENTTYPES)) {
            this.handleGetListContentTypes(userData, parser, request, response);
        } else if (methodName.equals(METHODNAME_GETLISTCONTENTTYPESANDPROPERTIES)) {
            this.handleGetListContentTypesAndProperties(userData, parser, request, response);
        } else if (methodName.equals(METHODNAME_UPDATELISTITEMS)) {
            this.handleUpdateListItems(userData, parser, request, response);
        } else if (methodName.equals(METHODNAME_GETLISTCOLLECTION)) {
            this.handleGetListCollection(userData, parser, request, response);
        } else if (methodName.equals(METHODNAME_GETLISTANDVIEW)) {
            this.handleGetListAndView(userData, parser, request, response);
        } else {
            logger.error("soapService: unknown RPC methodname " + methodName);
            SimpleSoapParser.soapErrorResponse(response, "Unknown methodname.");
        }
        if (logger.isTraceEnabled()) {
            logger.traceExit();
        }
    }

    protected void handleGetList(UserData userData, SimpleSoapParser parser, HttpServletRequest request, HttpServletResponse response) throws IOException, AuthenticationRequiredException {
        ListsGetListList list;
        String listName;
        if (logger.isTraceEnabled()) {
            logger.traceEnter();
        }
        if ((listName = parser.getParameter(METHODPARAMETER_LISTNAME)) == null) {
            logger.error("handleGetList: Parameter \"listName\" missing.");
            SimpleSoapParser.soapErrorResponse(response, "Missing parameter listName");
            if (logger.isTraceEnabled()) {
                logger.traceExit();
            }
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("handleGetList: Parameter listName=" + listName);
        }
        if ((list = this.getList(userData, listName, request)) == null) {
            logger.error("handleGetList: The requested list does not exist. listName=" + listName);
            SimpleSoapParser.soapErrorResponse(response, "The requested list does not exist.");
            return;
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        PrintStream out = new PrintStream((OutputStream)bos, false, "utf-8");
        out.print("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        out.print("<soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\">");
        out.print("<soap:Body>");
        out.print("<GetListResponse xmlns=\"http://schemas.microsoft.com/sharepoint/soap/\">");
        out.print("<GetListResult>");
        list.write(out);
        out.print("</GetListResult>");
        out.print("</GetListResponse>");
        out.print("</soap:Body>");
        out.print("</soap:Envelope>");
        out.flush();
        response.setContentType(RESPONSE_CONTENT_TYPE);
        response.setContentLength(bos.size());
        bos.writeTo((OutputStream)response.getOutputStream());
        if (logger.isTraceEnabled()) {
            logger.traceExit();
        }
    }

    protected abstract ListsGetListList getList(UserData var1, String var2, HttpServletRequest var3) throws AuthenticationRequiredException;

    protected void writeFieldElement(PrintStream out, String fieldName, String fieldDataType) throws IOException {
        out.print("<Field");
        AbstractListsService.writeXmlAttribute(out, "Name", fieldName, true);
        AbstractListsService.writeXmlAttribute(out, "DisplayName", fieldName, true);
        AbstractListsService.writeXmlAttribute(out, "ColName", fieldName, true);
        AbstractListsService.writeXmlAttribute(out, "Type", fieldDataType, true);
        out.print("/>");
    }

    protected void writeListElement(PrintStream out, UserData userData, String listName, String listTitle, String contextPath, boolean includeDetails) throws IOException {
        ListType listType = this.getListType(userData, listName);
        out.print("<List");
        AbstractListsService.writeXmlAttribute(out, "DocTemplateUrl", "", true);
        AbstractListsService.writeXmlAttribute(out, "DefaultViewUrl", "/Docs/Documents/Forms/AllItems.aspx", true);
        AbstractListsService.writeXmlAttribute(out, "MobileDefaultViewUrl", "", true);
        AbstractListsService.writeXmlAttribute(out, "ID", listName, true);
        AbstractListsService.writeXmlAttribute(out, "Title", listTitle, true);
        AbstractListsService.writeXmlAttribute(out, "Description", "", true);
        AbstractListsService.writeXmlAttribute(out, "ImageUrl", "/_layouts/images/itdl.gif", true);
        AbstractListsService.writeXmlAttribute(out, "Name", listName, true);
        if (listType == ListType.DOCUMENTS) {
            AbstractListsService.writeXmlAttribute(out, "BaseType", "1", true);
            AbstractListsService.writeXmlAttribute(out, "ServerTemplate", "101", true);
        } else {
            AbstractListsService.writeXmlAttribute(out, "BaseType", "0", true);
            AbstractListsService.writeXmlAttribute(out, "ServerTemplate", "105", true);
        }
        AbstractListsService.writeXmlAttribute(out, "Created", "20050117 07:38:36", true);
        AbstractListsService.writeXmlAttribute(out, "Modified", "20050410 00:09:37", true);
        AbstractListsService.writeXmlAttribute(out, "LastDeleted", "20090403 12:48:41", true);
        AbstractListsService.writeXmlAttribute(out, "Version", "0", true);
        AbstractListsService.writeXmlAttribute(out, "Direction", "none", true);
        AbstractListsService.writeXmlAttribute(out, "ThumbnailSize", "0", true);
        AbstractListsService.writeXmlAttribute(out, "WebImageWidth", "0", true);
        AbstractListsService.writeXmlAttribute(out, "WebImageHeight", "0", true);
        AbstractListsService.writeXmlAttribute(out, "Flags", "4096", true);
        AbstractListsService.writeXmlAttribute(out, "ItemCount", "100", true);
        AbstractListsService.writeXmlAttribute(out, "AnonymousPermMask", "0", true);
        if (listType == ListType.DOCUMENTS) {
            AbstractListsService.writeXmlAttribute(out, "RootFolder", this.getRootFolder(userData, listName), true);
        }
        AbstractListsService.writeXmlAttribute(out, "ReadSecurity", "1", true);
        AbstractListsService.writeXmlAttribute(out, "WriteSecurity", "1", true);
        AbstractListsService.writeXmlAttribute(out, "Author", "1", true);
        AbstractListsService.writeXmlAttribute(out, "EventSinkAssembly", "", true);
        AbstractListsService.writeXmlAttribute(out, "EventSinkClass", "", true);
        AbstractListsService.writeXmlAttribute(out, "EventSinkData", "", true);
        AbstractListsService.writeXmlAttribute(out, "EmailInsertsFolder", "", true);
        AbstractListsService.writeXmlAttribute(out, "AllowDeletion", "True", true);
        AbstractListsService.writeXmlAttribute(out, "AllowMultiResponses", "False", true);
        AbstractListsService.writeXmlAttribute(out, "EnableAttachments", "True", true);
        AbstractListsService.writeXmlAttribute(out, "EnableModeration", "False", true);
        AbstractListsService.writeXmlAttribute(out, "EnableVersioning", "False", true);
        AbstractListsService.writeXmlAttribute(out, "Hidden", "False", true);
        AbstractListsService.writeXmlAttribute(out, "MultipleDataList", "False", true);
        AbstractListsService.writeXmlAttribute(out, "Ordered", "False", true);
        AbstractListsService.writeXmlAttribute(out, "ShowUser", "True", true);
        if (!includeDetails) {
            out.print(" />");
            return;
        }
        out.print(">");
        if (listType == ListType.DOCUMENTS) {
            out.print("<Fields>");
            out.print("<Field ID=\"{1d22ea11-1e32-424e-89ab-9fedbadb6ce1}\" ColName=\"tp_ID\" RowOrdinal=\"0\" ReadOnly=\"TRUE\" Type=\"Counter\" Name=\"ID\" DisplayName=\"ID\" SourceID=\"http://schemas.microsoft.com/sharepoint/v3\" StaticName=\"ID\" FromBaseType=\"TRUE\"/>");
            out.print("<Field ID=\"{03e45e84-1992-4d42-9116-26f756012634}\" RowOrdinal=\"0\" Type=\"ContentTypeId\" Sealed=\"TRUE\" ReadOnly=\"TRUE\" Hidden=\"TRUE\" DisplayName=\"Inhaltstyp-ID\" Name=\"ContentTypeId\" DisplaceOnUpgrade=\"TRUE\" SourceID=\"http://schemas.microsoft.com/sharepoint/v3\" StaticName=\"ContentTypeId\" ColName=\"tp_ContentTypeId\" FromBaseType=\"TRUE\"/>");
            out.print("<Field ID=\"{c042a256-787d-4a6f-8a8a-cf6ab767f12d}\" RowOrdinal=\"0\" Type=\"Text\" DisplayName=\"Inhaltstyp\" ReadOnly=\"TRUE\" Name=\"ContentType\" DisplaceOnUpgrade=\"TRUE\" SourceID=\"http://schemas.microsoft.com/sharepoint/v3\" StaticName=\"ContentType\" ColName=\"tp_ContentType\" Group=\"_Hidden\" PITarget=\"MicrosoftWindowsSharePointServices\" PIAttribute=\"ContentTypeID\" FromBaseType=\"TRUE\"/>");
            out.print("<Field ID=\"{8c06beca-0777-48f7-91c7-6da68bc07b69}\" ColName=\"tp_Created\" RowOrdinal=\"0\" ReadOnly=\"TRUE\" Type=\"DateTime\" Name=\"Created\" DisplayName=\"Erstellt\" StorageTZ=\"TRUE\" SourceID=\"http://schemas.microsoft.com/sharepoint/v3\" StaticName=\"Created\" FromBaseType=\"TRUE\"/>");
            out.print("<Field ID=\"{1df5e554-ec7e-46a6-901d-d85a3881cb18}\" ColName=\"tp_Author\" RowOrdinal=\"0\" ReadOnly=\"TRUE\" Type=\"User\" List=\"UserInfo\" Name=\"Author\" DisplayName=\"Erstellt von\" SourceID=\"http://schemas.microsoft.com/sharepoint/v3\" StaticName=\"Author\" FromBaseType=\"TRUE\"/>");
            out.print("<Field ID=\"{28cf69c5-fa48-462a-b5cd-27b6f9d2bd5f}\" ColName=\"tp_Modified\" RowOrdinal=\"0\" ReadOnly=\"TRUE\" Type=\"DateTime\" Name=\"Modified\" DisplayName=\"Ge..ndert\" StorageTZ=\"TRUE\" SourceID=\"http://schemas.microsoft.com/sharepoint/v3\" StaticName=\"Modified\" FromBaseType=\"TRUE\"/>");
            out.print("<Field ID=\"{d31655d1-1d5b-4511-95a1-7a09e9b75bf2}\" ColName=\"tp_Editor\" RowOrdinal=\"0\" ReadOnly=\"TRUE\" Type=\"User\" List=\"UserInfo\" Name=\"Editor\" DisplayName=\"Ge..ndert von\" SourceID=\"http://schemas.microsoft.com/sharepoint/v3\" StaticName=\"Editor\" FromBaseType=\"TRUE\"/>");
            out.print("<Field ID=\"{26d0756c-986a-48a7-af35-bf18ab85ff4a}\" ColName=\"tp_HasCopyDestinations\" RowOrdinal=\"0\" Sealed=\"TRUE\" Hidden=\"TRUE\" ReadOnly=\"TRUE\" Type=\"Boolean\" Name=\"_HasCopyDestinations\" DisplaceOnUpgrade=\"TRUE\" DisplayName=\"Hat Kopierziele\" SourceID=\"http://schemas.microsoft.com/sharepoint/v3\" StaticName=\"_HasCopyDestinations\" FromBaseType=\"TRUE\"/>");
            out.print("<Field ID=\"{6b4e226d-3d88-4a36-808d-a129bf52bccf}\" ColName=\"tp_CopySource\" RowOrdinal=\"0\" Sealed=\"TRUE\" Hidden=\"FALSE\" ReadOnly=\"TRUE\" Type=\"Text\" Name=\"_CopySource\" DisplaceOnUpgrade=\"TRUE\" DisplayName=\"Kopiequelle\" SourceID=\"http://schemas.microsoft.com/sharepoint/v3\" StaticName=\"_CopySource\" FromBaseType=\"TRUE\"/>");
            out.print("<Field ID=\"{fdc3b2ed-5bf2-4835-a4bc-b885f3396a61}\" ColName=\"tp_ModerationStatus\" RowOrdinal=\"0\" ReadOnly=\"TRUE\" Type=\"ModStat\" Name=\"_ModerationStatus\" DisplayName=\"Genehmigungsstatus\" Hidden=\"TRUE\" CanToggleHidden=\"TRUE\" Required=\"FALSE\" SourceID=\"http://schemas.microsoft.com/sharepoint/v3\" StaticName=\"_ModerationStatus\" FromBaseType=\"TRUE\"><CHOICES><CHOICE>0;#Genehmigt</CHOICE><CHOICE>1;#Abgelehnt</CHOICE><CHOICE>2;#Ausstehend</CHOICE><CHOICE>3;#Entwurf</CHOICE><CHOICE>4;#Geplant</CHOICE></CHOICES><Default>0</Default></Field>");
            out.print("<Field ID=\"{34ad21eb-75bd-4544-8c73-0e08330291fe}\" ReadOnly=\"TRUE\" Type=\"Note\" Name=\"_ModerationComments\" DisplayName=\"Kommentare zur Genehmigung\" Hidden=\"TRUE\" CanToggleHidden=\"TRUE\" Filterable=\"FALSE\" Sortable=\"FALSE\" SourceID=\"http://schemas.microsoft.com/sharepoint/v3\" StaticName=\"_ModerationComments\" FromBaseType=\"TRUE\" ColName=\"ntext1\"/>");
            out.print("<Field ID=\"{94f89715-e097-4e8b-ba79-ea02aa8b7adb}\" Name=\"FileRef\" ReadOnly=\"TRUE\" Hidden=\"TRUE\" Type=\"Lookup\" DisplayName=\"URL-Pfad\" List=\"Docs\" FieldRef=\"ID\" ShowField=\"FullUrl\" JoinColName=\"DoclibRowId\" JoinRowOrdinal=\"0\" JoinType=\"INNER\" SourceID=\"http://schemas.microsoft.com/sharepoint/v3\" StaticName=\"FileRef\" FromBaseType=\"TRUE\"/>");
            out.print("<Field ID=\"{56605df6-8fa1-47e4-a04c-5b384d59609f}\" Name=\"FileDirRef\" ReadOnly=\"TRUE\" Hidden=\"TRUE\" Type=\"Lookup\" DisplayName=\"Pfad\" List=\"Docs\" FieldRef=\"ID\" ShowField=\"DirName\" JoinColName=\"DoclibRowId\" JoinRowOrdinal=\"0\" JoinType=\"INNER\" SourceID=\"http://schemas.microsoft.com/sharepoint/v3\" StaticName=\"FileDirRef\" FromBaseType=\"TRUE\"/>");
            out.print("<Field ID=\"{173f76c8-aebd-446a-9bc9-769a2bd2c18f}\" Name=\"Last_x0020_Modified\" ReadOnly=\"TRUE\" Hidden=\"TRUE\" DisplayName=\"Ge..ndert\" Type=\"Lookup\" List=\"Docs\" FieldRef=\"ID\" ShowField=\"TimeLastModified\" Format=\"TRUE\" JoinColName=\"DoclibRowId\" JoinRowOrdinal=\"0\" JoinType=\"INNER\" SourceID=\"http://schemas.microsoft.com/sharepoint/v3\" StaticName=\"Last_x0020_Modified\" FromBaseType=\"TRUE\"/>");
            out.print("<Field ID=\"{998b5cff-4a35-47a7-92f3-3914aa6aa4a2}\" Name=\"Created_x0020_Date\" ReadOnly=\"TRUE\" Hidden=\"TRUE\" DisplayName=\"Erstellt\" Type=\"Lookup\" List=\"Docs\" FieldRef=\"ID\" ShowField=\"TimeCreated\" Format=\"TRUE\" JoinColName=\"DoclibRowId\" JoinRowOrdinal=\"0\" JoinType=\"INNER\" SourceID=\"http://schemas.microsoft.com/sharepoint/v3\" StaticName=\"Created_x0020_Date\" FromBaseType=\"TRUE\"/>");
            out.print("<Field ID=\"{8fca95c0-9b7d-456f-8dae-b41ee2728b85}\" Name=\"File_x0020_Size\" Hidden=\"TRUE\" ReadOnly=\"TRUE\" Type=\"Lookup\" DisplayName=\"Dateigr....e\" List=\"Docs\" FieldRef=\"ID\" ShowField=\"SizeInKB\" Format=\"TRUE\" JoinColName=\"DoclibRowId\" JoinRowOrdinal=\"0\" JoinType=\"INNER\" SourceID=\"http://schemas.microsoft.com/sharepoint/v3\" StaticName=\"File_x0020_Size\" FromBaseType=\"TRUE\"/>");
            out.print("<Field ID=\"{30bb605f-5bae-48fe-b4e3-1f81d9772af9}\" Name=\"FSObjType\" ReadOnly=\"TRUE\" Hidden=\"TRUE\" ShowInFileDlg=\"FALSE\" Type=\"Lookup\" DisplayName=\"Elementtyp\" List=\"Docs\" FieldRef=\"ID\" ShowField=\"FSType\" JoinColName=\"DoclibRowId\" JoinRowOrdinal=\"0\" JoinType=\"INNER\" SourceID=\"http://schemas.microsoft.com/sharepoint/v3\" StaticName=\"FSObjType\" FromBaseType=\"TRUE\"/>");
            out.print("<Field ID=\"{ba3c27ee-4791-4867-8821-ff99000bac98}\" Name=\"PermMask\" DisplaceOnUpgrade=\"TRUE\" ReadOnly=\"TRUE\" Hidden=\"TRUE\" RenderXMLUsingPattern=\"TRUE\" ShowInFileDlg=\"FALSE\" Type=\"Computed\" DisplayName=\"Maske der effektiven Berechtigungen\" SourceID=\"http://schemas.microsoft.com/sharepoint/v3\" StaticName=\"PermMask\" FromBaseType=\"TRUE\">");
            out.print("<FieldRefs><FieldRef Name=\"ID\"/></FieldRefs><DisplayPattern><CurrentRights/></DisplayPattern></Field>");
            out.print("<Field ID=\"{a7b731a3-1df1-4d74-a5c6-e2efba617ae2}\" Name=\"CheckedOutUserId\" ReadOnly=\"TRUE\" Hidden=\"TRUE\" ShowInFileDlg=\"FALSE\" Type=\"Lookup\" DisplayName=\"ID des Benutzers, der das Element ausgecheckt hat\" List=\"Docs\" FieldRef=\"ID\" ShowField=\"CheckoutUserId\" JoinColName=\"DoclibRowId\" JoinRowOrdinal=\"0\" JoinType=\"INNER\" SourceID=\"http://schemas.microsoft.com/sharepoint/v3\" StaticName=\"CheckedOutUserId\" FromBaseType=\"TRUE\"/>");
            out.print("<Field ID=\"{cfaabd0f-bdbd-4bc2-b375-1e779e2cad08}\" Name=\"IsCheckedoutToLocal\" DisplaceOnUpgrade=\"TRUE\" ReadOnly=\"TRUE\" Hidden=\"TRUE\" ShowInFileDlg=\"FALSE\" Type=\"Lookup\" DisplayName=\"Ist lokal ausgecheckt\" List=\"Docs\" FieldRef=\"ID\" ShowField=\"IsCheckoutToLocal\" JoinColName=\"DoclibRowId\" JoinRowOrdinal=\"0\" JoinType=\"INNER\" SourceID=\"http://schemas.microsoft.com/sharepoint/v3\" StaticName=\"IsCheckedoutToLocal\" FromBaseType=\"TRUE\"/>");
            out.print("<Field ID=\"{3881510a-4e4a-4ee8-b102-8ee8e2d0dd4b}\" ColName=\"tp_CheckoutUserId\" RowOrdinal=\"0\" ReadOnly=\"TRUE\" Type=\"User\" List=\"UserInfo\" Name=\"CheckoutUser\" DisplaceOnUpgrade=\"TRUE\" DisplayName=\"Ausgecheckt von\" SourceID=\"http://schemas.microsoft.com/sharepoint/v3\" StaticName=\"CheckoutUser\" FromBaseType=\"TRUE\"/>");
            out.print("<Field ID=\"{8553196d-ec8d-4564-9861-3dbe931050c8}\" ShowInFileDlg=\"FALSE\" ShowInVersionHistory=\"FALSE\" Type=\"File\" Name=\"FileLeafRef\" DisplayName=\"Name\" AuthoringInfo=\"(zur Verwendung in Formularen)\" List=\"Docs\" FieldRef=\"ID\" ShowField=\"LeafName\" JoinColName=\"DoclibRowId\" JoinRowOrdinal=\"0\" JoinType=\"INNER\" Required=\"TRUE\" SourceID=\"http://schemas.microsoft.com/sharepoint/v3\" StaticName=\"FileLeafRef\" FromBaseType=\"TRUE\"/>");
            out.print("<Field ID=\"{4b7403de-8d94-43e8-9f0f-137a3e298126}\" Name=\"UniqueId\" DisplaceOnUpgrade=\"TRUE\" ReadOnly=\"TRUE\" Hidden=\"TRUE\" ShowInFileDlg=\"FALSE\" Type=\"Lookup\" DisplayName=\"Eindeutige ID\" List=\"Docs\" FieldRef=\"ID\" ShowField=\"UniqueId\" JoinColName=\"DoclibRowId\" JoinRowOrdinal=\"0\" JoinType=\"INNER\" SourceID=\"http://schemas.microsoft.com/sharepoint/v3\" StaticName=\"UniqueId\" FromBaseType=\"TRUE\"/>");
            out.print("<Field ID=\"{c5c4b81c-f1d9-4b43-a6a2-090df32ebb68}\" Name=\"ProgId\" DisplaceOnUpgrade=\"TRUE\" ReadOnly=\"TRUE\" Hidden=\"TRUE\" ShowInFileDlg=\"FALSE\" Type=\"Lookup\" DisplayName=\"ProgId\" List=\"Docs\" FieldRef=\"ID\" ShowField=\"ProgId\" JoinColName=\"DoclibRowId\" JoinRowOrdinal=\"0\" JoinType=\"INNER\" SourceID=\"http://schemas.microsoft.com/sharepoint/v3\" StaticName=\"ProgId\" FromBaseType=\"TRUE\"/>");
            out.print("<Field ID=\"{dddd2420-b270-4735-93b5-92b713d0944d}\" Name=\"ScopeId\" DisplaceOnUpgrade=\"TRUE\" ReadOnly=\"TRUE\" Hidden=\"TRUE\" ShowInFileDlg=\"FALSE\" Type=\"Lookup\" DisplayName=\"ScopeId\" List=\"Docs\" FieldRef=\"ID\" ShowField=\"ScopeId\" JoinColName=\"DoclibRowId\" JoinRowOrdinal=\"0\" JoinType=\"INNER\" SourceID=\"http://schemas.microsoft.com/sharepoint/v3\" StaticName=\"ScopeId\" FromBaseType=\"TRUE\"/>");
            out.print("<Field ID=\"{4a389cb9-54dd-4287-a71a-90ff362028bc}\" Name=\"VirusStatus\" Hidden=\"TRUE\" ReadOnly=\"TRUE\" Type=\"Lookup\" DisplayName=\"Virenstatus\" List=\"Docs\" FieldRef=\"ID\" ShowField=\"Size\" Format=\"TRUE\" JoinColName=\"DoclibRowId\" JoinRowOrdinal=\"0\" JoinType=\"INNER\" SourceID=\"http://schemas.microsoft.com/sharepoint/v3\" StaticName=\"VirusStatus\" FromBaseType=\"TRUE\"/>");
            out.print("<Field ID=\"{9d4adc35-7cc8-498c-8424-ee5fd541e43a}\" Name=\"CheckedOutTitle\" Hidden=\"TRUE\" ReadOnly=\"TRUE\" Type=\"Lookup\" DisplayName=\"Ausgecheckt von\" List=\"Docs\" FieldRef=\"ID\" ShowField=\"CheckedOutTitle\" Format=\"TRUE\" JoinColName=\"DoclibRowId\" JoinType=\"INNER\" SourceID=\"http://schemas.microsoft.com/sharepoint/v3\" StaticName=\"CheckedOutTitle\" FromBaseType=\"TRUE\"/>");
            out.print("<Field ID=\"{58014f77-5463-437b-ab67-eec79532da67}\" Name=\"_CheckinComment\" DisplaceOnUpgrade=\"TRUE\" ReadOnly=\"TRUE\" Type=\"Lookup\" DisplayName=\"Kommentar zum Einchecken\" List=\"Docs\" FieldRef=\"ID\" ShowField=\"CheckinComment\" Filterable=\"FALSE\" Format=\"TRUE\" JoinColName=\"DoclibRowId\" JoinType=\"INNER\" Sortable=\"FALSE\" SourceID=\"http://schemas.microsoft.com/sharepoint/v3\" StaticName=\"_CheckinComment\" FromBaseType=\"TRUE\"/>");
            out.print("<Field ID=\"{e2a15dfd-6ab8-4aec-91ab-02f6b64045b0}\" ReadOnly=\"TRUE\" Hidden=\"TRUE\" Type=\"Computed\" Name=\"LinkCheckedOutTitle\" DisplayName=\"Ausgecheckt von\" Filterable=\"TRUE\" AuthoringInfo=\"(Hyperlink zum Benutzernamen auf der Benutzerdetailseite)\" SourceID=\"http://schemas.microsoft.com/sharepoint/v3\" StaticName=\"LinkCheckedOutTitle\" FromBaseType=\"TRUE\">");
            out.print("<FieldRefs><FieldRef Name=\"CheckedOutTitle\"/><FieldRef Name=\"CheckedOutUserId\"/></FieldRefs><DisplayPattern><IfEqual><Expr1><Field Name=\"CheckedOutUserId\"/></Expr1><Expr2/><Then/><Else><HTML><![CDATA[<a href=\"]]></HTML><HttpVDir CurrentWeb=\"TRUE\"/><HTML><![CDATA[/_layouts/userdisp.aspx?ID=]]></HTML><Field Name=\"CheckedOutUserId\"/><HTML><![CDATA[\">]]></HTML><Field HTMLEncode=\"TRUE\" Name=\"CheckedOutTitle\"/><HTML><![CDATA[</a>]]></HTML></Else></IfEqual></DisplayPattern></Field>");
            out.print("<Field ID=\"{822c78e3-1ea9-4943-b449-57863ad33ca9}\" ReadOnly=\"TRUE\" Hidden=\"TRUE\" Type=\"Text\" Name=\"Modified_x0020_By\" DisplayName=\"Dokument ge..ndert von\" SourceID=\"http://schemas.microsoft.com/sharepoint/v3\" StaticName=\"Modified_x0020_By\" FromBaseType=\"TRUE\" ColName=\"nvarchar1\"/>");
            out.print("<Field ID=\"{4dd7e525-8d6b-4cb4-9d3e-44ee25f973eb}\" ReadOnly=\"TRUE\" Hidden=\"TRUE\" Type=\"Text\" Name=\"Created_x0020_By\" DisplayName=\"Dokument erstellt von\" SourceID=\"http://schemas.microsoft.com/sharepoint/v3\" StaticName=\"Created_x0020_By\" FromBaseType=\"TRUE\" ColName=\"nvarchar2\"/>");
            out.print("<Field ID=\"{39360f11-34cf-4356-9945-25c44e68dade}\" ReadOnly=\"TRUE\" Hidden=\"TRUE\" Type=\"Text\" Name=\"File_x0020_Type\" DisplayName=\"Dateityp\" SourceID=\"http://schemas.microsoft.com/sharepoint/v3\" StaticName=\"File_x0020_Type\" FromBaseType=\"TRUE\" ColName=\"nvarchar3\"/>");
            out.print("<Field ID=\"{0c5e0085-eb30-494b-9cdd-ece1d3c649a2}\" ReadOnly=\"TRUE\" Hidden=\"TRUE\" Type=\"Text\" Name=\"HTML_x0020_File_x0020_Type\" DisplayName=\"HTML-Dateityp\" SourceID=\"http://schemas.microsoft.com/sharepoint/v3\" StaticName=\"HTML_x0020_File_x0020_Type\" FromBaseType=\"TRUE\" ColName=\"nvarchar4\"/>");
            out.print("<Field ID=\"{c63a459d-54ba-4ab7-933a-dcf1c6fadec2}\" Name=\"_SourceUrl\" Hidden=\"TRUE\" ShowInFileDlg=\"FALSE\" Type=\"Text\" DisplayName=\"Quell-URL\" SourceID=\"http://schemas.microsoft.com/sharepoint/v3\" StaticName=\"_SourceUrl\" FromBaseType=\"TRUE\" ColName=\"nvarchar5\"/>");
            out.print("<Field ID=\"{034998e9-bf1c-4288-bbbd-00eacfc64410}\" Name=\"_SharedFileIndex\" Hidden=\"TRUE\" ShowInFileDlg=\"FALSE\" Type=\"Text\" DisplayName=\"Index f..r freigegebene Dateien\" SourceID=\"http://schemas.microsoft.com/sharepoint/v3\" StaticName=\"_SharedFileIndex\" FromBaseType=\"TRUE\" ColName=\"nvarchar6\"/>");
            out.print("<Field ID=\"{3c6303be-e21f-4366-80d7-d6d0a3b22c7a}\" Hidden=\"TRUE\" ReadOnly=\"TRUE\" Type=\"Computed\" Name=\"_EditMenuTableStart\" DisplaceOnUpgrade=\"TRUE\" DisplayName=\"Anfang der Men..tabelle bearbeiten\" ClassInfo=\"Menu\" SourceID=\"http://schemas.microsoft.com/sharepoint/v3\" StaticName=\"_EditMenuTableStart\" FromBaseType=\"TRUE\">");
            out.print("<FieldRefs><FieldRef Name=\"FileLeafRef\"/><FieldRef Name=\"FileDirRef\"/><FieldRef Name=\"FSObjType\"/><FieldRef Name=\"ID\"/><FieldRef Name=\"ServerUrl\"/><FieldRef Name=\"HTML_x0020_File_x0020_Type\"/><FieldRef Name=\"File_x0020_Type\"/><FieldRef Name=\"PermMask\"/><FieldRef Name=\"IsCheckedoutToLocal\"/><FieldRef Name=\"CheckoutUser\"/><FieldRef Name=\"_SourceUrl\"/><FieldRef Name=\"_HasCopyDestinations\"/><FieldRef Name=\"_CopySource\"/><FieldRef Name=\"ContentType\"/><FieldRef Name=\"ContentTypeId\"/><FieldRef Name=\"_ModerationStatus\"/><FieldRef Name=\"_UIVersion\"/></FieldRefs><DisplayPattern><HTML><![CDATA[<table height=\"100%\" cellspacing=0 class=\"ms-unselectedtitle\" onmouseover=\"OnItem(this)\" CTXName=\"ctx]]></HTML><Counter Type=\"View\"/><HTML>&quot; Id=&quot;</HTML><Column Name=\"ID\" HTMLEncode=\"TRUE\"/><HTML>&quot; Url=&quot;</HTML><Field Name=\"ServerUrl\" URLEncodeAsURL=\"TRUE\"/><HTML>&quot; DRef=&quot;</HTML><Field Name=\"FileDirRef\"/><HTML>&quot; Perm=&quot;</HTML><Field Name=\"PermMask\"/><HTML>&quot; Type=&quot;</HTML><Column Name=\"HTML_x0020_File_x0020_Type\"/><HTML>&quot; Ext=&quot;</HTML><Column Name=\"File_x0020_Type\"/><HTML>&quot; Icon=&quot;</HTML><MapToAll><Column Name=\"HTML_x0020_File_x0020_Type\"/><HTML>|</HTML><Column Name=\"File_x0020_Type\"/></MapToAll><HTML>&quot; OType=&quot;</HTML><LookupColumn Name=\"FSObjType\"/><HTML>&quot; COUId=&quot;</HTML><Column Name=\"CheckoutUser\" HTMLEncode=\"TRUE\"/><HTML>&quot; SRed=&quot;</HTML><ServerProperty Select=\"GetServerFileRedirect\"><Field Name=\"ServerUrl\" HTMLEncode=\"TRUE\"/><HTML>|</HTML><Column Name=\"HTML_x0020_File_x0020_Type\"/></ServerProperty><HTML>&quot; COut=&quot;</HTML><Field Name=\"IsCheckedoutToLocal\"/><HTML>&quot; HCD=&quot;</HTML><Column Name=\"_HasCopyDestinations\"/><HTML>&quot; CSrc=&quot;</HTML><Column Name=\"_CopySource\" URLEncodeAsURL=\"TRUE\"/><HTML>&quot; MS=&quot;</HTML><Column Name=\"_ModerationStatus\"/><HTML><![CDATA[\" CType=\"]]></HTML><Column Name=\"ContentType\" HTMLEncode=\"TRUE\"/><HTML><![CDATA[\" CId=\"]]></HTML><Column Name=\"ContentTypeId\"/><HTML>&quot; UIS=&quot;</HTML><Column Name=\"_UIVersion\"/><GetVar Name=\"_EditMenuTableExtra\"/><HTML>&quot; SUrl=&quot;</HTML><Column Name=\"_SourceUrl\" URLEncode=\"TRUE\"/><HTML><![CDATA[\"><tr><td width=\"100%\" Class=\"ms-vb\">]]></HTML></DisplayPattern></Field>");
            out.print("<Field ID=\"{2ea78cef-1bf9-4019-960a-02c41636cb47}\" Hidden=\"TRUE\" ReadOnly=\"TRUE\" Type=\"Computed\" Name=\"_EditMenuTableEnd\" DisplaceOnUpgrade=\"TRUE\" DisplayName=\"Ende der Men..tabelle bearbeiten\" ClassInfo=\"Menu\" SourceID=\"http://schemas.microsoft.com/sharepoint/v3\" StaticName=\"_EditMenuTableEnd\" FromBaseType=\"TRUE\">");
            out.print("<FieldRefs><FieldRef Name=\"ID\"/></FieldRefs><DisplayPattern><HTML><![CDATA[</td><td><img src=\"/_layouts/images/blank.gif\" width=13 style=\"visibility:hidden\" alt=\"\"></td></tr></table>]]></HTML></DisplayPattern></Field><Field ID=\"{9d30f126-ba48-446b-b8f9-83745f322ebe}\" ReadOnly=\"TRUE\" Type=\"Computed\" Name=\"LinkFilenameNoMenu\" DisplayName=\"Name\" DisplayNameSrcField=\"FileLeafRef\" Filterable=\"FALSE\" AuthoringInfo=\"(mit Dokument verkn..pft)\" SourceID=\"http://schemas.microsoft.com/sharepoint/v3\" StaticName=\"LinkFilenameNoMenu\" FromBaseType=\"TRUE\"><FieldRefs><FieldRef Name=\"FileLeafRef\"/><FieldRef Name=\"FSObjType\"/><FieldRef Name=\"Created_x0020_Date\"/><FieldRef Name=\"FileRef\"/><FieldRef Name=\"File_x0020_Type\"/><FieldRef Name=\"ContentTypeId\"/><FieldRef Name=\"PermMask\"/><FieldRef Name=\"CheckoutUser\"/><FieldRef Name=\"IsCheckedoutToLocal\"/></FieldRefs><DisplayPattern><IfEqual><Expr1><LookupColumn Name=\"FSObjType\"/></Expr1><Expr2>1</Expr2><Then><FieldSwitch><Expr><GetVar Name=\"RecursiveView\"/></Expr><Case Value=\"1\"><LookupColumn Name=\"FileLeafRef\" HTMLEncode=\"TRUE\"/></Case><Default><SetVar Name=\"UnencodedFilterLink\"><SetVar Name=\"RootFolder\"><HTML>/</HTML><LookupColumn Name=\"FileRef\"/></SetVar><SetVar Name=\"FolderCTID\"><FieldSwitch><Expr><ListProperty Select=\"EnableContentTypes\"/></Expr><Case Value=\"1\"><Column Name=\"ContentTypeId\"/></Case></FieldSwitch></SetVar><FilterLink Default=\"\" Paged=\"FALSE\"/></SetVar><HTML><![CDATA[<A onfocus=\"OnLink(this)\" HREF=\"]]></HTML><GetVar Name=\"UnencodedFilterLink\" HTMLEncode=\"TRUE\"/><HTML><![CDATA[\" onclick=\"javascript:EnterFolder(']]></HTML><ScriptQuote NotAddingQuote=\"TRUE\"><GetVar Name=\"UnencodedFilterLink\"/></ScriptQuote><HTML><![CDATA[');return false;\">]]></HTML><LookupColumn Name=\"FileLeafRef\" HTMLEncode=\"TRUE\"/><IfEqual><Expr1><GetVar Name=\"ShowAccessibleIcon\"/></Expr1><Expr2>1</Expr2><Then><HTML><![CDATA[<img src=\"/_layouts/images/blank.gif\" class=\"ms-hidden\" border=0 width=1 height=1 alt=\"]]></HTML><HTML>Mit UMSCHALT+EINGABETASTE ..ffnen Sie das Men.. (neues Fenster).</HTML><HTML><![CDATA[\">]]></HTML></Then></IfEqual><HTML><![CDATA[</A>]]></HTML></Default></FieldSwitch></Then><Else><HTML><![CDATA[<A onfocus=\"OnLink(this)\" HREF=\"]]></HTML><Field Name=\"ServerUrl\" URLEncodeAsURL=\"TRUE\"/><HTML><![CDATA[\" onclick=\"return DispEx(this,event,']]></HTML><ScriptQuote NotAddingQuote=\"TRUE\"><ServerProperty Select=\"HtmlTransform\"/></ScriptQuote><HTML><![CDATA[',']]></HTML><ScriptQuote NotAddingQuote=\"TRUE\"><ServerProperty Select=\"HtmlTrAcceptType\"><Column Name=\"File_x0020_Type\"/></ServerProperty></ScriptQuote><HTML><![CDATA[',']]></HTML><ScriptQuote NotAddingQuote=\"TRUE\"><ServerProperty Select=\"HtmlTrHandleUrl\"><Column Name=\"File_x0020_Type\"/></ServerProperty></ScriptQuote><HTML><![CDATA[',']]></HTML><ScriptQuote NotAddingQuote=\"TRUE\"><ServerProperty Select=\"HtmlTrProgId\"><Column Name=\"File_x0020_Type\"/></ServerProperty></ScriptQuote><HTML><![CDATA[',']]></HTML><ScriptQuote NotAddingQuote=\"TRUE\"><ListProperty Select=\"DefaultItemOpen\"/></ScriptQuote><HTML><![CDATA[',']]></HTML><ScriptQuote NotAddingQuote=\"TRUE\"><MapToControl><Column Name=\"HTML_x0020_File_x0020_Type\"/><HTML>|</HTML><Column Name=\"File_x0020_Type\"/></MapToControl></ScriptQuote><HTML><![CDATA[',']]></HTML><ScriptQuote NotAddingQuote=\"TRUE\"><Column Name=\"HTML_x0020_File_x0020_Type\"/></ScriptQuote><HTML><![CDATA[',']]></HTML><ScriptQuote NotAddingQuote=\"TRUE\"><ServerProperty Select=\"GetServerFileRedirect\"><Field Name=\"ServerUrl\"/><HTML>|</HTML><Column Name=\"HTML_x0020_File_x0020_Type\"/></ServerProperty></ScriptQuote><HTML><![CDATA[',']]></HTML><ScriptQuote NotAddingQuote=\"TRUE\"><Column Name=\"CheckoutUser\"/></ScriptQuote><HTML><![CDATA[',']]></HTML><ScriptQuote NotAddingQuote=\"TRUE\"><UserID AllowAnonymous=\"TRUE\"/></ScriptQuote><HTML><![CDATA[',']]></HTML><ScriptQuote NotAddingQuote=\"TRUE\"><ListProperty Select=\"ForceCheckout\"/></ScriptQuote><HTML><![CDATA[',']]></HTML><ScriptQuote NotAddingQuote=\"TRUE\"><Field Name=\"IsCheckedoutToLocal\"/></ScriptQuote><HTML><![CDATA[',']]></HTML><ScriptQuote NotAddingQuote=\"TRUE\"><Field Name=\"PermMask\"/></ScriptQuote><HTML><![CDATA[')\">]]></HTML><UrlBaseName HTMLEncode=\"TRUE\"><LookupColumn Name=\"FileLeafRef\"/></UrlBaseName><IfEqual><Expr1><GetVar Name=\"ShowAccessibleIcon\"/></Expr1><Expr2>1</Expr2><Then><HTML><![CDATA[<img src=\"/_layouts/images/blank.gif\" class=\"ms-hidden\" border=0 width=1 height=1 alt=\"]]></HTML><HTML>Mit UMSCHALT+EINGABETASTE ..ffnen Sie das Men.. (neues Fenster).</HTML><HTML><![CDATA[\">]]></HTML></Then></IfEqual><HTML><![CDATA[</A>]]></HTML><IfNew Name=\"Created_x0020_Date\"><HTML><![CDATA[<IMG SRC=\"/_layouts/1031/images/new.gif\" alt=\"]]></HTML><HTML>Neu</HTML><HTML><![CDATA[\">]]></HTML></IfNew></Else></IfEqual></DisplayPattern></Field>");
            out.print("<Field ID=\"{5cc6dc79-3710-4374-b433-61cb4a686c12}\" ReadOnly=\"TRUE\" Type=\"Computed\" Name=\"LinkFilename\" DisplayName=\"Name\" DisplayNameSrcField=\"FileLeafRef\" Filterable=\"FALSE\" ClassInfo=\"Menu\" AuthoringInfo=\"(Hyperlink zu Dokument mit Bearbeitungsmen..)\" SourceID=\"http://schemas.microsoft.com/sharepoint/v3\" StaticName=\"LinkFilename\" FromBaseType=\"TRUE\"><FieldRefs><FieldRef Name=\"FileLeafRef\"/><FieldRef Name=\"LinkFilenameNoMenu\"/><FieldRef Name=\"_EditMenuTableStart\"/><FieldRef Name=\"_EditMenuTableEnd\"/></FieldRefs><DisplayPattern><FieldSwitch><Expr><GetVar Name=\"FreeForm\"/></Expr><Case Value=\"TRUE\"><Field Name=\"LinkFilenameNoMenu\"/></Case><Default><Field Name=\"_EditMenuTableStart\"/><SetVar Name=\"ShowAccessibleIcon\" Value=\"1\"/><Field Name=\"LinkFilenameNoMenu\"/><SetVar Name=\"ShowAccessibleIcon\" Value=\"0\"/>");
            out.print("<Field Name=\"_EditMenuTableEnd\"/></Default></FieldSwitch></DisplayPattern></Field>");
            out.print("<Field ID=\"{081c6e4c-5c14-4f20-b23e-1a71ceb6a67c}\" Type=\"Computed\" ReadOnly=\"TRUE\" Name=\"DocIcon\" DisplayName=\"Typ\" TextOnly=\"TRUE\" ClassInfo=\"Icon\" AuthoringInfo=\"(mit Dokument verkn..pftes Symbol)\" SourceID=\"http://schemas.microsoft.com/sharepoint/v3\" StaticName=\"DocIcon\" FromBaseType=\"TRUE\"><FieldRefs><FieldRef Name=\"File_x0020_Type\"/><FieldRef Name=\"FSObjType\"/><FieldRef Name=\"FileRef\"/><FieldRef Name=\"FileLeafRef\"/><FieldRef Name=\"HTML_x0020_File_x0020_Type\"/><FieldRef Name=\"PermMask\"/><FieldRef Name=\"CheckoutUser\" ShowField=\"Title\"/><FieldRef Name=\"IsCheckedoutToLocal\"/></FieldRefs><DisplayPattern><IfEqual><Expr1><LookupColumn Name=\"FSObjType\"/></Expr1><Expr2>1</Expr2><Then><FieldSwitch><Expr><GetVar Name=\"RecursiveView\"/></Expr><Case Value=\"1\"><HTML><![CDATA[<IMG BORDER=0 alt=\"]]></HTML><HTML>Ordner: </HTML><LookupColumn Name=\"FileLeafRef\" HTMLEncode=\"TRUE\"/><HTML><![CDATA[\" SRC=\"/_layouts/images/folder.gif\">]]></HTML></Case><Default><SetVar Name=\"UnencodedFilterLink\"><SetVar Name=\"RootFolder\"><HTML>/</HTML><LookupColumn Name=\"FileRef\"/></SetVar><SetVar Name=\"FolderCTID\"><FieldSwitch><Expr><ListProperty Select=\"EnableContentTypes\"/></Expr><Case Value=\"1\"><Column Name=\"ContentTypeId\"/></Case></FieldSwitch></SetVar><FilterLink Default=\"\" Paged=\"FALSE\"/></SetVar><HTML><![CDATA[<A TABINDEX=-1 HREF=\"]]></HTML><GetVar Name=\"UnencodedFilterLink\" HTMLEncode=\"TRUE\"/><HTML><![CDATA[\" onclick=\"javascript:EnterFolder(']]></HTML><ScriptQuote NotAddingQuote=\"TRUE\"><GetVar Name=\"UnencodedFilterLink\"/></ScriptQuote><HTML><![CDATA[');javascript:return false;\">]]></HTML><HTML><![CDATA[<IMG BORDER=0 alt=\"]]></HTML><HTML>Ordner: </HTML><LookupColumn Name=\"FileLeafRef\" HTMLEncode=\"TRUE\"/><HTML><![CDATA[\" title=\"]]></HTML><HTML>Folder: </HTML><LookupColumn Name=\"FileLeafRef\" HTMLEncode=\"TRUE\"/><HTML><![CDATA[\" SRC=\"/_layouts/images/folder.gif\"></A>]]></HTML></Default></FieldSwitch></Then><Else><HTML><![CDATA[<A TABINDEX=-1 HREF=\"]]></HTML><Field Name=\"ServerUrl\" URLEncodeAsURL=\"TRUE\"/><HTML><![CDATA[\" onclick=\"return DispEx(this,event,']]></HTML><ScriptQuote NotAddingQuote=\"TRUE\"><ServerProperty Select=\"HtmlTransform\"/></ScriptQuote><HTML><![CDATA[',']]></HTML><ScriptQuote NotAddingQuote=\"TRUE\"><ServerProperty Select=\"HtmlTrAcceptType\"><Column Name=\"File_x0020_Type\"/></ServerProperty></ScriptQuote><HTML><![CDATA[',']]></HTML><ScriptQuote NotAddingQuote=\"TRUE\"><ServerProperty Select=\"HtmlTrHandleUrl\"><Column Name=\"File_x0020_Type\"/></ServerProperty></ScriptQuote><HTML><![CDATA[',']]></HTML><ScriptQuote NotAddingQuote=\"TRUE\"><ServerProperty Select=\"HtmlTrProgId\"><Column Name=\"File_x0020_Type\"/></ServerProperty></ScriptQuote><HTML><![CDATA[',']]></HTML><ScriptQuote NotAddingQuote=\"TRUE\"><ListProperty Select=\"DefaultItemOpen\"/></ScriptQuote><HTML><![CDATA[',']]></HTML><ScriptQuote NotAddingQuote=\"TRUE\"><MapToControl><Column Name=\"HTML_x0020_File_x0020_Type\"/><HTML>|</HTML><Column Name=\"File_x0020_Type\"/></MapToControl></ScriptQuote><HTML><![CDATA[',']]></HTML><ScriptQuote NotAddingQuote=\"TRUE\"><Column Name=\"HTML_x0020_File_x0020_Type\"/></ScriptQuote><HTML><![CDATA[',']]></HTML><ScriptQuote NotAddingQuote=\"TRUE\"><ServerProperty Select=\"GetServerFileRedirect\"><Field Name=\"ServerUrl\"/><HTML>|</HTML><Column Name=\"HTML_x0020_File_x0020_Type\"/></ServerProperty></ScriptQuote><HTML><![CDATA[',']]></HTML><ScriptQuote NotAddingQuote=\"TRUE\"><Column Name=\"CheckoutUser\"/></ScriptQuote><HTML><![CDATA[',']]></HTML><ScriptQuote NotAddingQuote=\"TRUE\"><UserID AllowAnonymous=\"TRUE\"/></ScriptQuote><HTML><![CDATA[',']]></HTML><ScriptQuote NotAddingQuote=\"TRUE\"><ListProperty Select=\"ForceCheckout\"/></ScriptQuote><HTML><![CDATA[',']]></HTML><ScriptQuote NotAddingQuote=\"TRUE\"><Field Name=\"IsCheckedoutToLocal\"/></ScriptQuote><HTML><![CDATA[',']]></HTML><ScriptQuote NotAddingQuote=\"TRUE\"><Field Name=\"PermMask\"/></ScriptQuote><HTML><![CDATA[')\">]]></HTML><Switch><Expr><Column Name=\"CheckoutUser\"/></Expr><Case Value=\"\"><HTML><![CDATA[<IMG BORDER=0 ALT=\"]]></HTML><LookupColumn Name=\"FileLeafRef\" HTMLEncode=\"TRUE\"/><HTML><![CDATA[\" title=\"]]></HTML><LookupColumn Name=\"FileLeafRef\" HTMLEncode=\"TRUE\"/><HTML><![CDATA[\" SRC=\"/_layouts/images/]]></HTML><MapToIcon><Column Name=\"HTML_x0020_File_x0020_Type\"/><HTML>|</HTML><Column Name=\"File_x0020_Type\"/></MapToIcon><HTML><![CDATA[\">]]></HTML></Case><Default><HTML><![CDATA[<IMG BORDER=0 ALT=\"]]></HTML><LookupColumn Name=\"FileLeafRef\" HTMLEncode=\"TRUE\"/><HTML><![CDATA[&#10;Ausgecheckt von: ]]></HTML><LookupColumn Name=\"CheckoutUser\" ShowField=\"Title\" HTMLEncode=\"TRUE\"/><HTML><![CDATA[\" title=\"]]></HTML><LookupColumn Name=\"FileLeafRef\" HTMLEncode=\"TRUE\"/><HTML><![CDATA[&#10;Ausgecheckt von: ]]></HTML><LookupColumn Name=\"CheckoutUser\" ShowField=\"Title\" HTMLEncode=\"TRUE\"/><HTML><![CDATA[\" SRC=\"/_layouts/images/]]></HTML><MapToIcon><Column Name=\"HTML_x0020_File_x0020_Type\"/><HTML>|</HTML><Column Name=\"File_x0020_Type\"/></MapToIcon><HTML><![CDATA[\">]]></HTML><HTML><![CDATA[<img src=\"/_layouts/images/checkoutoverlay.gif\" class=\"ms-vb-icon-overlay\" alt=']]></HTML><LookupColumn Name=\"FileLeafRef\" HTMLEncode=\"TRUE\"/><HTML><![CDATA[&#10;Ausgecheckt von: ]]></HTML><LookupColumn Name=\"CheckoutUser\" ShowField=\"Title\" HTMLEncode=\"TRUE\"/><HTML><![CDATA[<' title=']]></HTML><LookupColumn Name=\"FileLeafRef\" HTMLEncode=\"TRUE\"/><HTML><![CDATA[&#10;Ausgecheckt von: ]]></HTML><LookupColumn Name=\"CheckoutUser\" ShowField=\"Title\" HTMLEncode=\"TRUE\"/><HTML><![CDATA['>]]></HTML></Default></Switch><HTML><![CDATA[</A>]]></HTML></Else></IfEqual></DisplayPattern></Field>");
            out.print("<Field ID=\"{105f76ce-724a-4bba-aece-f81f2fce58f5}\" ReadOnly=\"TRUE\" Hidden=\"TRUE\" Type=\"Computed\" Name=\"ServerUrl\" DisplayName=\"Serverrelative URL\" Filterable=\"FALSE\" RenderXMLUsingPattern=\"TRUE\" SourceID=\"http://schemas.microsoft.com/sharepoint/v3\" StaticName=\"ServerUrl\" FromBaseType=\"TRUE\"><FieldRefs><FieldRef Name=\"FileRef\"/></FieldRefs><DisplayPattern><HTML>/</HTML><LookupColumn Name=\"FileRef\"/></DisplayPattern></Field>");
            out.print("<Field ID=\"{7177cfc7-f399-4d4d-905d-37dd51bc90bf}\" ReadOnly=\"TRUE\" Hidden=\"TRUE\" Type=\"Computed\" Name=\"EncodedAbsUrl\" DisplayName=\"Codierte absolute URL\" Filterable=\"FALSE\" RenderXMLUsingPattern=\"TRUE\" SourceID=\"http://schemas.microsoft.com/sharepoint/v3\" StaticName=\"EncodedAbsUrl\" FromBaseType=\"TRUE\"><FieldRefs><FieldRef Name=\"FileRef\"/></FieldRefs><DisplayPattern><HttpHost URLEncodeAsURL=\"TRUE\"/><HTML>/</HTML><LookupColumn Name=\"FileRef\" URLEncodeAsURL=\"TRUE\"/></DisplayPattern></Field>");
            out.print("<Field ID=\"{7615464b-559e-4302-b8e2-8f440b913101}\" ReadOnly=\"TRUE\" Hidden=\"TRUE\" Type=\"Computed\" Name=\"BaseName\" DisplayName=\"Name\" Filterable=\"FALSE\" RenderXMLUsingPattern=\"TRUE\" SourceID=\"http://schemas.microsoft.com/sharepoint/v3\" StaticName=\"BaseName\" FromBaseType=\"TRUE\"><FieldRefs><FieldRef Name=\"FileLeafRef\"/><FieldRef Name=\"FSObjType\"/></FieldRefs><DisplayPattern><IfEqual><Expr1><LookupColumn Name=\"FSObjType\"/></Expr1><Expr2>1</Expr2><Then><LookupColumn Name=\"FileLeafRef\" HTMLEncode=\"TRUE\"/></Then><Else><UrlBaseName HTMLEncode=\"TRUE\"><LookupColumn Name=\"FileLeafRef\"/></UrlBaseName></Else></IfEqual></DisplayPattern></Field>");
            out.print("<Field ID=\"{78a07ba4-bda8-4357-9e0f-580d64487583}\" Type=\"Computed\" ReadOnly=\"TRUE\" Name=\"FileSizeDisplay\" DisplayName=\"Dateigr....e\" AuthoringInfo=\"\" SourceID=\"http://schemas.microsoft.com/sharepoint/v3\" StaticName=\"FileSizeDisplay\" FromBaseType=\"TRUE\"><FieldRefs><FieldRef Name=\"File_x0020_Size\"/><FieldRef Name=\"FSObjType\"/></FieldRefs><DisplayPattern><Switch><Expr><LookupColumn Name=\"FSObjType\"/></Expr><Case Value=\"0\"><LookupColumn Name=\"File_x0020_Size\"/><HTML> KB</HTML></Case></Switch></DisplayPattern></Field>");
            out.print("<Field ID=\"{687c7f94-686a-42d3-9b67-2782eac4b4f8}\" Name=\"MetaInfo\" DisplaceOnUpgrade=\"TRUE\" Hidden=\"TRUE\" ShowInFileDlg=\"FALSE\" Type=\"Lookup\" DisplayName=\"Eigenschaftenbeh..lter\" List=\"Docs\" FieldRef=\"ID\" ShowField=\"MetaInfo\" JoinColName=\"DoclibRowId\" JoinType=\"INNER\" SourceID=\"http://schemas.microsoft.com/sharepoint/v3\" StaticName=\"MetaInfo\" FromBaseType=\"TRUE\"/>");
            out.print("<Field ID=\"{43bdd51b-3c5b-4e78-90a8-fb2087f71e70}\" ColName=\"tp_Level\" RowOrdinal=\"0\" ReadOnly=\"TRUE\" Type=\"Integer\" Name=\"_Level\" DisplaceOnUpgrade=\"TRUE\" DisplayName=\"Ebene\" Hidden=\"TRUE\" Required=\"FALSE\" SourceID=\"http://schemas.microsoft.com/sharepoint/v3\" StaticName=\"_Level\" FromBaseType=\"TRUE\"/>");
            out.print("<Field ID=\"{c101c3e7-122d-4d4d-bc34-58e94a38c816}\" ColName=\"tp_IsCurrentVersion\" DisplaceOnUpgrade=\"TRUE\" RowOrdinal=\"0\" ReadOnly=\"TRUE\" Type=\"Boolean\" Name=\"_IsCurrentVersion\" DisplayName=\"Ist aktuelle Version\" Hidden=\"TRUE\" Required=\"FALSE\" SourceID=\"http://schemas.microsoft.com/sharepoint/v3\" StaticName=\"_IsCurrentVersion\" FromBaseType=\"TRUE\"/>");
            out.print("<Field ID=\"{b1f7969b-ea65-42e1-8b54-b588292635f2}\" ReadOnly=\"TRUE\" Type=\"Computed\" Name=\"SelectTitle\" Filterable=\"FALSE\" Sortable=\"FALSE\" Hidden=\"TRUE\" CanToggleHidden=\"TRUE\" DisplayName=\"Ausw..hlen\" Dir=\"\" AuthoringInfo=\"(Webpartverbindung)\" HeaderImage=\"blank.gif\" SourceID=\"http://schemas.microsoft.com/sharepoint/v3\" StaticName=\"SelectTitle\" FromBaseType=\"TRUE\"><FieldRefs><FieldRef Name=\"ID\"/></FieldRefs><DisplayPattern><IfEqual><Expr1><GetVar Name=\"SelectedID\"/></Expr1><Expr2><Column Name=\"ID\"/></Expr2><Then><HTML><![CDATA[<img border=\"0\" align=\"absmiddle\" style=\"cursor: pointer\" src=\"/_layouts/images/rbsel.gif\" alt=\"]]></HTML><HTML>Selected</HTML><HTML><![CDATA[\">]]></HTML></Then><Else><HTML><![CDATA[<a href=\"javascript:SelectField(']]></HTML><GetVar Name=\"View\"/><HTML><![CDATA[',']]></HTML><ScriptQuote NotAddingQuote=\"TRUE\"><Column Name=\"ID\"/></ScriptQuote><HTML><![CDATA[');return false;\" onclick=\"javascript:SelectField(']]></HTML><GetVar Name=\"View\"/><HTML><![CDATA[',']]></HTML><ScriptQuote NotAddingQuote=\"TRUE\"><Column Name=\"ID\"/></ScriptQuote><HTML><![CDATA[');return false;\" target=\"_self\">]]></HTML><HTML><![CDATA[<img border=\"0\" align=\"absmiddle\" style=\"cursor: pointer\" src=\"/_layouts/images/rbunsel.gif\"  alt=\"]]></HTML><HTML>Normal</HTML><HTML><![CDATA[\">]]></HTML><HTML><![CDATA[</a>]]></HTML></Else></IfEqual></DisplayPattern></Field>");
            out.print("<Field ID=\"{5f47e085-2150-41dc-b661-442f3027f552}\" ReadOnly=\"TRUE\" Type=\"Computed\" Name=\"SelectFilename\" DisplayName=\"Ausw..hlen\" Hidden=\"TRUE\" CanToggleHidden=\"TRUE\" Sortable=\"FALSE\" Filterable=\"FALSE\" AuthoringInfo=\"(Webpartverbindung)\" HeaderImage=\"blank.gif\" SourceID=\"http://schemas.microsoft.com/sharepoint/v3\" StaticName=\"SelectFilename\" FromBaseType=\"TRUE\"><FieldRefs><FieldRef Name=\"ID\"/></FieldRefs><DisplayPattern><IfEqual><Expr1><GetVar Name=\"SelectedID\"/></Expr1><Expr2><Column Name=\"ID\"/></Expr2><Then><HTML><![CDATA[<img align=\"absmiddle\" style=\"cursor: pointer\" src=\"/_layouts/images/rbsel.gif\" alt=\"]]></HTML><HTML>Selected</HTML><HTML><![CDATA[\">]]></HTML></Then><Else><HTML><![CDATA[<a href=\"javascript:SelectField(']]></HTML><GetVar Name=\"View\"/><HTML><![CDATA[',']]></HTML><ScriptQuote NotAddingQuote=\"TRUE\"><Column Name=\"ID\"/></ScriptQuote><HTML><![CDATA[');return false;\" onclick=\"javascript:SelectField(']]></HTML><GetVar Name=\"View\"/><HTML><![CDATA[',']]></HTML><ScriptQuote NotAddingQuote=\"TRUE\"><Column Name=\"ID\"/></ScriptQuote><HTML><![CDATA[');return false;\" target=\"_self\">]]></HTML><HTML><![CDATA[<img border=\"0\" align=\"absmiddle\" style=\"cursor: pointer\" src=\"/_layouts/images/rbunsel.gif\"  alt=\"]]></HTML><HTML>Normal</HTML><HTML><![CDATA[\">]]></HTML><HTML><![CDATA[</a>]]></HTML></Else></IfEqual></DisplayPattern></Field>");
            out.print("<Field ID=\"{503f1caa-358e-4918-9094-4a2cdc4bc034}\" ReadOnly=\"TRUE\" Type=\"Computed\" Name=\"Edit\" Sortable=\"FALSE\" Filterable=\"FALSE\" DisplayName=\"Bearbeiten\" ClassInfo=\"Icon\" AuthoringInfo=\"(Hyperlink zum Bearbeitungselement)\" SourceID=\"http://schemas.microsoft.com/sharepoint/v3\" StaticName=\"Edit\" FromBaseType=\"TRUE\"><FieldRefs><FieldRef Name=\"IsCheckedoutToLocal\"/><FieldRef Name=\"ServerUrl\"/><FieldRef Name=\"CheckedOutUserId\"/></FieldRefs><DisplayPattern><IfHasRights><RightsChoices><RightsGroup PermEditListItems=\"required\"/></RightsChoices><Then><HTML><![CDATA[<a href=\"]]></HTML><URL Cmd=\"Edit\"/><HTML><![CDATA[\" onclick=\"STSNavigateWithCheckoutAlert(this.href, ']]></HTML><IfEqual><Expr1><Field Name=\"CheckedOutUserId\"/></Expr1><Expr2/><Then><ScriptQuote NotAddingQuote=\"TRUE\"><ListProperty Select=\"ForceCheckout\"/></ScriptQuote></Then><Else><HTML><![CDATA[0]]></HTML></Else></IfEqual><HTML><![CDATA[',']]></HTML><ScriptQuote NotAddingQuote=\"TRUE\"><Field Name=\"IsCheckedoutToLocal\"/></ScriptQuote><HTML><![CDATA[',']]></HTML><ScriptQuote NotAddingQuote=\"TRUE\"><Field Name=\"ServerUrl\"/></ScriptQuote><HTML><![CDATA[',']]></HTML><ScriptQuote NotAddingQuote=\"TRUE\"><HttpVDir/></ScriptQuote><HTML><![CDATA[') ;return false;\" target=\"_self\">]]></HTML><HTML><![CDATA[<img border=\"0\" alt=\"]]></HTML><HTML>Dokumenteigenschaften bearbeiten</HTML><HTML><![CDATA[\" src=\"/_layouts/images/edititem.gif\">]]></HTML><HTML><![CDATA[</a>]]></HTML></Then><Else><HTML><![CDATA[&nbsp;]]></HTML></Else></IfHasRights></DisplayPattern></Field>");
            out.print("<Field ID=\"{d4e44a66-ee3a-4d02-88c9-4ec5ff3f4cd5}\" ColName=\"tp_Version\" RowOrdinal=\"0\" Hidden=\"TRUE\" ReadOnly=\"TRUE\" Type=\"Integer\" SetAs=\"owshiddenversion\" Name=\"owshiddenversion\" DisplayName=\"owshiddenversion\" SourceID=\"http://schemas.microsoft.com/sharepoint/v3\" StaticName=\"owshiddenversion\" FromBaseType=\"TRUE\"/>");
            out.print("<Field ID=\"{7841bf41-43d0-4434-9f50-a673baef7631}\" ColName=\"tp_UIVersion\" RowOrdinal=\"0\" ReadOnly=\"TRUE\" Type=\"Integer\" Name=\"_UIVersion\" DisplaceOnUpgrade=\"TRUE\" DisplayName=\"Benutzeroberfl..chenversion\" Hidden=\"TRUE\" CanToggleHidden=\"TRUE\" Required=\"FALSE\" SourceID=\"http://schemas.microsoft.com/sharepoint/v3\" StaticName=\"_UIVersion\" FromBaseType=\"TRUE\"/>");
            out.print("<Field ID=\"{dce8262a-3ae9-45aa-aab4-83bd75fb738a}\" ColName=\"tp_UIVersionString\" RowOrdinal=\"0\" ReadOnly=\"TRUE\" Type=\"Text\" Name=\"_UIVersionString\" DisplaceOnUpgrade=\"TRUE\" DisplayName=\"Version\" CanToggleHidden=\"TRUE\" Required=\"FALSE\" SourceID=\"http://schemas.microsoft.com/sharepoint/v3\" StaticName=\"_UIVersionString\" FromBaseType=\"TRUE\"/>");
            out.print("<Field ID=\"{50a54da4-1528-4e67-954a-e2d24f1e9efb}\" Name=\"InstanceID\" DisplayName=\"Instanz-ID\" ColName=\"tp_InstanceID\" RowOrdinal=\"0\" ReadOnly=\"TRUE\" Hidden=\"TRUE\" Type=\"Integer\" Min=\"0\" Max=\"99991231\" Filterable=\"TRUE\" Sortable=\"TRUE\" SourceID=\"http://schemas.microsoft.com/sharepoint/v3\" StaticName=\"InstanceID\" FromBaseType=\"TRUE\"/>");
            out.print("<Field ID=\"{ca4addac-796f-4b23-b093-d2a3f65c0774}\" ColName=\"tp_ItemOrder\" RowOrdinal=\"0\" Name=\"Order\" DisplayName=\"Reihenfolge\" Type=\"Number\" Hidden=\"TRUE\" SourceID=\"http://schemas.microsoft.com/sharepoint/v3\" StaticName=\"Order\" FromBaseType=\"TRUE\"/>");
            out.print("<Field ID=\"{ae069f25-3ac2-4256-b9c3-15dbc15da0e0}\" ColName=\"tp_GUID\" RowOrdinal=\"0\" ReadOnly=\"TRUE\" Hidden=\"TRUE\" Type=\"Guid\" Name=\"GUID\" DisplaceOnUpgrade=\"TRUE\" DisplayName=\"GUID\" SourceID=\"http://schemas.microsoft.com/sharepoint/v3\" StaticName=\"GUID\" FromBaseType=\"TRUE\"/>");
            out.print("<Field ID=\"{f1e020bc-ba26-443f-bf2f-b68715017bbc}\" ColName=\"tp_WorkflowVersion\" RowOrdinal=\"0\" Hidden=\"TRUE\" ReadOnly=\"TRUE\" Type=\"Integer\" Name=\"WorkflowVersion\" DisplaceOnUpgrade=\"TRUE\" DisplayName=\"Workflowversion\" SourceID=\"http://schemas.microsoft.com/sharepoint/v3\" StaticName=\"WorkflowVersion\" FromBaseType=\"TRUE\"/>");
            out.print("<Field ID=\"{de8beacf-5505-47cd-80a6-aa44e7ffe2f4}\" ColName=\"tp_WorkflowInstanceID\" RowOrdinal=\"0\" ReadOnly=\"TRUE\" Hidden=\"TRUE\" Type=\"Guid\" Name=\"WorkflowInstanceID\" DisplaceOnUpgrade=\"TRUE\" DisplayName=\"Workflowinstanz-ID\" SourceID=\"http://schemas.microsoft.com/sharepoint/v3\" StaticName=\"WorkflowInstanceID\" FromBaseType=\"TRUE\"/>");
            out.print("<Field ID=\"{bc1a8efb-0f4c-49f8-a38f-7fe22af3d3e0}\" Name=\"ParentVersionString\" DisplaceOnUpgrade=\"TRUE\" ReadOnly=\"TRUE\" DisplayName=\"Quellenversion (konvertiertes Dokument)\" ShowInFileDlg=\"FALSE\" Type=\"Lookup\" List=\"Docs\" FieldRef=\"ID\" ShowField=\"ParentVersionString\" JoinColName=\"DoclibRowId\" JoinType=\"INNER\" SourceID=\"http://schemas.microsoft.com/sharepoint/v3\" StaticName=\"ParentVersionString\" FromBaseType=\"TRUE\"/>");
            out.print("<Field ID=\"{774eab3a-855f-4a34-99da-69dc21043bec}\" Name=\"ParentLeafName\" DisplaceOnUpgrade=\"TRUE\" ReadOnly=\"TRUE\" DisplayName=\"Quellenname (konvertiertes Dokument)\" ShowInFileDlg=\"FALSE\" Type=\"Lookup\" List=\"Docs\" FieldRef=\"ID\" ShowField=\"ParentLeafName\" JoinColName=\"DoclibRowId\" JoinType=\"INNER\" SourceID=\"http://schemas.microsoft.com/sharepoint/v3\" StaticName=\"ParentLeafName\" FromBaseType=\"TRUE\"/>");
            out.print("<Field ID=\"{fa564e0f-0c70-4ab9-b863-0177e6ddd247}\" Type=\"Text\" Name=\"Title\" ShowInNewForm=\"FALSE\" ShowInFileDlg=\"FALSE\" DisplayName=\"Titel\" Sealed=\"TRUE\" SourceID=\"http://schemas.microsoft.com/sharepoint/v3\" StaticName=\"Title\" ColName=\"nvarchar7\"/>");
            out.print("<Field ID=\"{4b1bf6c6-4f39-45ac-acd5-16fe7a214e5e}\" Type=\"Text\" Name=\"TemplateUrl\" DisplaceOnUpgrade=\"TRUE\" DisplayName=\"Vorlageverkn..pfung\" XName=\"TemplateUrl\" Filterable=\"TRUE\" Sortable=\"TRUE\" Hidden=\"TRUE\" FromBaseType=\"TRUE\" PITarget=\"mso-infoPathSolution\" PIAttribute=\"href\" SourceID=\"http://schemas.microsoft.com/sharepoint/v3\" StaticName=\"TemplateUrl\" ColName=\"nvarchar8\"/>");
            out.print("<Field ID=\"{cd1ecb9f-dd4e-4f29-ab9e-e9ff40048d64}\" Type=\"Text\" Name=\"xd_ProgID\" DisplaceOnUpgrade=\"TRUE\" DisplayName=\"HTML-Dateiverkn..pfung\" XName=\"ProgID\" Filterable=\"TRUE\" Sortable=\"TRUE\" Hidden=\"TRUE\" FromBaseType=\"TRUE\" SourceID=\"http://schemas.microsoft.com/sharepoint/v3\" StaticName=\"xd_ProgID\" ColName=\"nvarchar9\"/>");
            out.print("<Field ID=\"{fbf29b2d-cae5-49aa-8e0a-29955b540122}\" Type=\"Boolean\" Group=\"_Hidden\" Name=\"xd_Signature\" DisplaceOnUpgrade=\"TRUE\" SourceID=\"http://schemas.microsoft.com/sharepoint/v3\" StaticName=\"xd_Signature\" DisplayName=\"Ist signiert\" XName=\"{FBF29B2D-CAE5-49aa-8E0A-29955B540122}\" Filterable=\"TRUE\" Sortable=\"TRUE\" Sealed=\"TRUE\" Hidden=\"TRUE\" FromBaseType=\"TRUE\" ReadOnly=\"TRUE\" ColName=\"bit1\"/>");
            out.print("<Field ID=\"{e52012a0-51eb-4c0c-8dfb-9b8a0ebedcb6}\" ReadOnly=\"TRUE\" Type=\"Computed\" Name=\"Combine\" DisplaceOnUpgrade=\"TRUE\" DisplayName=\"Zusammenf..hren\" Filterable=\"FALSE\" Sortable=\"FALSE\" Hidden=\"TRUE\" SourceID=\"http://schemas.microsoft.com/sharepoint/v3\" StaticName=\"Combine\"><FieldRefs><FieldRef Name=\"FSObjType\" Key=\"Primary\"/><FieldRef Name=\"EncodedAbsUrl\"/><FieldRef Name=\"TemplateUrl\"/></FieldRefs><DisplayPattern><IfEqual><Expr1><Field Name=\"FSObjType\"/></Expr1><Expr2>0</Expr2><Then><HTML><![CDATA[<INPUT ID=\"chkCombine\" TYPE=\"CHECKBOX\" Title=\"Zusammenf..hren]]\" HREF=\"]]></HTML><Field Name=\"EncodedAbsUrl\"/><HTML><![CDATA[\">]]></HTML><HTML><![CDATA[<INPUT ID=\"chkUrl\" TYPE=\"HIDDEN\" HREF=\"]]></HTML><Column Name=\"TemplateUrl\" HTMLEncode=\"TRUE\"/><HTML><![CDATA[\">]]></HTML><HTML><![CDATA[<INPUT ID=\"chkProgID\" TYPE=\"HIDDEN\" HREF=\"]]></HTML><MapToControl><HTML>|</HTML><GetFileExtension><Column Name=\"TemplateUrl\" HTMLEncode=\"TRUE\"/></GetFileExtension></MapToControl><HTML><![CDATA[\">]]></HTML></Then></IfEqual></DisplayPattern></Field>");
            out.print("<Field ID=\"{5d36727b-bcb2-47d2-a231-1f0bc63b7439}\" ReadOnly=\"TRUE\" Type=\"Computed\" Name=\"RepairDocument\" DisplaceOnUpgrade=\"TRUE\" DisplayName=\"Verkn..pfung erneuern\" Filterable=\"FALSE\" Sortable=\"FALSE\" Hidden=\"TRUE\" SourceID=\"http://schemas.microsoft.com/sharepoint/v3\" StaticName=\"RepairDocument\"><FieldRefs><FieldRef Name=\"FSObjType\" Key=\"Primary\"/><FieldRef Name=\"ID\"/></FieldRefs><DisplayPattern><IfEqual><Expr1><Field Name=\"FSObjType\"/></Expr1><Expr2>0</Expr2><Then><HTML><![CDATA[<INPUT ID=\"chkRepair\" TYPE=\"CHECKBOX\" Title=\"Verkn..pfung erneuern\" docID=\"]]></HTML><Field Name=\"ID\"/><HTML><![CDATA[\">]]></HTML></Then></IfEqual></DisplayPattern></Field>");
            out.print("</Fields>");
        } else {
            out.print("<Fields>");
            out.print("<Field ColName=\"tp_ID\" ReadOnly=\"TRUE\" Type=\"Counter\" Name=\"ID\" PrimaryKey=\"TRUE\" DisplayName=\"ID\" FromBaseType=\"TRUE\"/>");
            out.print("<Field Type=\"Text\" Name=\"Title\" DisplayName=\"Titel\" Required=\"TRUE\" FromBaseType=\"TRUE\" ColName=\"nvarchar1\"/>");
            out.print("<Field ColName=\"tp_Modified\" ReadOnly=\"TRUE\" Type=\"DateTime\" Name=\"Modified\" DisplayName=\"Ge..ndert\" StorageTZ=\"TRUE\" FromBaseType=\"TRUE\"/>");
            out.print("<Field ColName=\"tp_Created\" ReadOnly=\"TRUE\" Type=\"DateTime\" Name=\"Created\" DisplayName=\"Erstellt\" StorageTZ=\"TRUE\" FromBaseType=\"TRUE\"/>");
            out.print("<Field ColName=\"tp_Author\" ReadOnly=\"TRUE\" Type=\"User\" List=\"UserInfo\" Name=\"Author\" DisplayName=\"Erstellt von\" FromBaseType=\"TRUE\"/>");
            out.print("<Field ColName=\"tp_Editor\" ReadOnly=\"TRUE\" Type=\"User\" List=\"UserInfo\" Name=\"Editor\" DisplayName=\"Ge..ndert von\" FromBaseType=\"TRUE\"/>");
            out.print("<Field ColName=\"tp_Version\" Hidden=\"TRUE\" ReadOnly=\"TRUE\" Type=\"Integer\" SetAs=\"owshiddenversion\" Name=\"owshiddenversion\" DisplayName=\"owshiddenversion\" FromBaseType=\"TRUE\"/>");
            out.print("<Field ColName=\"tp_HasAttachment\" Type=\"Attachments\" Name=\"Attachments\" DisplayName=\"Anlagen\" FromBaseType=\"TRUE\"/>");
            out.print("<Field ColName=\"tp_ModerationStatus\" ReadOnly=\"TRUE\" Type=\"ModStat\" Name=\"_ModerationStatus\" DisplayName=\"Genehmigungsstatus\" Hidden=\"TRUE\" CanToggleHidden=\"TRUE\" Required=\"FALSE\" FromBaseType=\"TRUE\"/>");
            out.print("<Field ReadOnly=\"TRUE\" Type=\"Note\" Name=\"_ModerationComments\" DisplayName=\"Kommentare zur Genehmigung\" Hidden=\"TRUE\" CanToggleHidden=\"TRUE\" Sortable=\"FALSE\" FromBaseType=\"TRUE\" ColName=\"ntext1\"/>");
            out.print("<Field ReadOnly=\"TRUE\" Type=\"Computed\" Name=\"Edit\" Sortable=\"FALSE\" Filterable=\"FALSE\" DisplayName=\"Bearbeiten\" AuthoringInfo=\"(Hyperlink zum Bearbeiten des Eintrags)\" FromBaseType=\"TRUE\"/>");
            out.print("<Field ReadOnly=\"TRUE\" Type=\"Computed\" Name=\"LinkTitleNoMenu\" DisplayName=\"Titel\" Dir=\"\" DisplayNameSrcField=\"Title\" AuthoringInfo=\"(Hyperlink zum Eintrag)\" FromBaseType=\"TRUE\"/>");
            out.print("<Field ReadOnly=\"TRUE\" Type=\"Computed\" Name=\"LinkTitle\" DisplayName=\"Titel\" DisplayNameSrcField=\"Title\" ClassInfo=\"Menu\" AuthoringInfo=\"(Hyperlink zum Eintrag mit Bearbeitungsmen..)\" FromBaseType=\"TRUE\"/>");
            out.print("<Field ReadOnly=\"TRUE\" Type=\"Computed\" Name=\"SelectTitle\" Hidden=\"TRUE\" CanToggleHidden=\"TRUE\" DisplayName=\"Ausw..hlen\" Dir=\"\" AuthoringInfo=\"(Webpartverbindung)\" HeaderImage=\"blank.gif\" Sortable=\"FALSE\" FromBaseType=\"TRUE\"/>");
            out.print("<Field Name=\"InstanceID\" DisplayName=\"\" ColName=\"\" ReadOnly=\"TRUE\" Hidden=\"TRUE\" Type=\"Integer\" Min=\"0\" Max=\"99991231\" Filterable=\"TRUE\" Sortable=\"TRUE\" FromBaseType=\"TRUE\"/>");
            out.print("<Field Name=\"Order\" DisplayName=\"\" ColName=\"\" Type=\"Number\" Hidden=\"TRUE\" FromBaseType=\"TRUE\"/>");
            out.print("<Field Name=\"GUID\" DisplayName=\"\" ColName=\"\" Type=\"Guid\" ReadOnly=\"TRUE\" Hidden=\"TRUE\" FromBaseType=\"TRUE\"/>");
            switch (listType) {
                case CONTACTS: {
                    this.writeFieldElement(out, "LastNamePhonetic", "Text");
                    this.writeFieldElement(out, "FirstName", "Text");
                    this.writeFieldElement(out, "FirstNamePhonetic", "Text");
                    this.writeFieldElement(out, "FullName", "Text");
                    this.writeFieldElement(out, "Email", "Text");
                    this.writeFieldElement(out, "CompanyPhonetic", "Text");
                    this.writeFieldElement(out, "Company", "Text");
                    this.writeFieldElement(out, "JobTitle", "Text");
                    this.writeFieldElement(out, "WorkPhone", "Text");
                    this.writeFieldElement(out, "HomePhone", "Text");
                    this.writeFieldElement(out, "CellPhone", "Text");
                    this.writeFieldElement(out, "WorkFax", "Text");
                    this.writeFieldElement(out, "WorkAddress", "Note");
                    this.writeFieldElement(out, "WorkCity", "Text");
                    this.writeFieldElement(out, "WorkState", "Text");
                    this.writeFieldElement(out, "WorkZip", "Text");
                    this.writeFieldElement(out, "WorkCountry", "Text");
                    this.writeFieldElement(out, "WebPage", "URL");
                    this.writeFieldElement(out, "Comments", "Note");
                    break;
                }
                case EVENTS: {
                    this.writeFieldElement(out, "EventDate", "DateTime");
                    this.writeFieldElement(out, "EndDate", "DateTime");
                    this.writeFieldElement(out, "Description", "Note");
                    this.writeFieldElement(out, "Location", "Text");
                    this.writeFieldElement(out, "fRecurrence", "Recurrence");
                    this.writeFieldElement(out, "WorkspaceLink", "CrossProjectLink");
                    this.writeFieldElement(out, "EventType", "Integer");
                    this.writeFieldElement(out, "UID", "Guid");
                    this.writeFieldElement(out, "RecurrenceID", "DateTime");
                    this.writeFieldElement(out, "EventCanceled", "Boolean");
                    this.writeFieldElement(out, "Duration", "Integer");
                    this.writeFieldElement(out, "RecurrenceData", "Note");
                    this.writeFieldElement(out, "TimeZone", "Integer");
                    this.writeFieldElement(out, "XMLTZone", "Note");
                    this.writeFieldElement(out, "MasterSeriesItemID", "Integer");
                    this.writeFieldElement(out, "Workspace", "URL");
                    break;
                }
                case TASKS: {
                    this.writeFieldElement(out, "Priority", "Choice");
                    this.writeFieldElement(out, "Status", "Choice");
                    this.writeFieldElement(out, "PercentComplete", "Number");
                    this.writeFieldElement(out, "AssignedTo", "User");
                    this.writeFieldElement(out, "TaskGroup", "User");
                    this.writeFieldElement(out, "Body", "Note");
                    this.writeFieldElement(out, "StartDate", "DateTime");
                    this.writeFieldElement(out, "DueDate", "DateTime");
                    break;
                }
                case DOCUMENTS: {
                    break;
                }
            }
            out.print("</Fields>");
        }
        out.print("<RegionalSettings>");
        out.print("<Language>1031</Language>");
        out.print("<Locale>1031</Locale>");
        out.print("<AdvanceHijri>0</AdvanceHijri>");
        out.print("<CalendarType>1</CalendarType>");
        out.print("<Time24>True</Time24>");
        out.print("<TimeZone>-60</TimeZone>");
        out.print("<SortOrder>2070</SortOrder>");
        out.print("<Presence>True</Presence>");
        out.print("</RegionalSettings>");
        if (this.isWSS3List(userData, listName)) {
            out.print("<ServerSettings>");
            out.print("<ServerVersion>12.0.0.4518</ServerVersion>");
            out.print("<RecycleBinEnabled>True</RecycleBinEnabled>");
            out.print("<ServerRelativeUrl>" + contextPath + "</ServerRelativeUrl>");
            out.print("</ServerSettings>");
        }
        out.print("</List>");
    }

    protected abstract boolean isWSS3List(UserData var1, String var2);

    protected abstract ListType getListType(UserData var1, String var2);

    protected abstract boolean isValidListName(UserData var1, String var2);

    protected abstract String getAlternateServerURL(UserData var1, String var2, HttpServletRequest var3);

    protected abstract String getRootFolder(UserData var1, String var2);

    protected void handleGetListItemChanges(UserData userData, SimpleSoapParser parser, HttpServletRequest request, HttpServletResponse response) throws IOException, AuthenticationRequiredException {
        String listName;
        if (logger.isTraceEnabled()) {
            logger.traceEnter();
        }
        if ((listName = parser.getParameter(METHODPARAMETER_LISTNAME)) == null) {
            logger.error("handleGetList: Parameter \"listName\" missing.");
            SimpleSoapParser.soapErrorResponse(response, "Missing parameter listName");
            if (logger.isTraceEnabled()) {
                logger.traceExit();
            }
            return;
        }
        String since = parser.getParameter(METHODPARAMETER_SINCE);
        if (logger.isDebugEnabled()) {
            logger.debug("handleGetList: Parameter listName=" + listName);
            logger.debug("handleGetList: Parameter since=" + (since == null ? "null" : since));
        }
        ListChanges listItemChanges = this.getListItemChanges(userData, listName, since, request);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        PrintStream out = new PrintStream((OutputStream)bos, false, "utf-8");
        out.print("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        out.print("<soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\">");
        out.print("<soap:Body>");
        out.print("<GetListItemChangesResponse xmlns=\"http://schemas.microsoft.com/sharepoint/soap/\">");
        out.print("<GetListItemChangesResult>");
        out.print("<listitems");
        out.print(" xmlns:s=\"uuid:BDC6E3F0-6DA3-11d1-A2A3-00AA00C14882\"");
        out.print(" xmlns:dt=\"uuid:C2F41010-65B3-11d1-A29F-00AA00C14882\"");
        out.print(" xmlns:rs=\"urn:schemas-microsoft-com:rowset\"");
        out.print(" xmlns:z=\"#RowsetSchema\"");
        out.print(" TimeStamp=\"" + listItemChanges.getCurrentTimestamp() + "\">");
        List<ListItem> changedListItems = listItemChanges.getModifiedAndNewItems();
        out.print("<rs:data ItemCount=\"" + Integer.toString(changedListItems.size()) + "\">");
        for (ListItem listItem : changedListItems) {
            listItem.write(out, true, false);
        }
        out.print("</rs:data>");
        List<String> deletedListItems = listItemChanges.getDeletedItemIDs();
        if (deletedListItems.size() > 0) {
            out.print("<rs:data ItemCount=\"" + Integer.toString(deletedListItems.size()) + "\">");
            for (String id : deletedListItems) {
                out.print("<z:row ows_ID=\"" + id + "\"");
                out.print(" ows_owshiddenversion=\"1\"");
                out.print(" />");
            }
            out.print("</rs:data>");
        }
        out.print("</listitems>");
        out.print("</GetListItemChangesResult>");
        out.print("</GetListItemChangesResponse>");
        out.print("</soap:Body>");
        out.print("</soap:Envelope>");
        out.flush();
        response.setContentType(RESPONSE_CONTENT_TYPE);
        response.setContentLength(bos.size());
        bos.writeTo((OutputStream)response.getOutputStream());
        if (logger.isTraceEnabled()) {
            logger.traceExit();
        }
    }

    protected abstract ListChanges getListItemChanges(UserData var1, String var2, String var3, HttpServletRequest var4) throws AuthenticationRequiredException;

    protected void handleGetListItems(UserData userData, SimpleSoapParser parser, HttpServletRequest request, HttpServletResponse response) throws IOException, AuthenticationRequiredException {
        String listName;
        if (logger.isTraceEnabled()) {
            logger.traceEnter();
        }
        if ((listName = parser.getParameter(METHODPARAMETER_LISTNAME)) == null) {
            logger.error("handleGetList: Parameter \"listName\" missing.");
            SimpleSoapParser.soapErrorResponse(response, "Missing parameter listName");
            if (logger.isTraceEnabled()) {
                logger.traceExit();
            }
            return;
        }
        SoapParameter query = parser.getSoapParameter(METHODPARAMETER_QUERY);
        SoapParameter queryOptions = parser.getSoapParameter(METHODPARAMETER_QUERYOPTIONS);
        SoapParameter viewFields = parser.getSoapParameter(METHODPARAMETER_VIEWFIELDS);
        if (logger.isDebugEnabled()) {
            logger.debug("handleGetList: Parameter listName=" + listName);
        }
        ListChanges listItems = this.getListItems(userData, listName, query, queryOptions, viewFields, request);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        PrintStream out = new PrintStream((OutputStream)bos, false, "utf-8");
        out.print("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        out.print("<soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\">");
        out.print("<soap:Body>");
        out.print("<GetListItemsResponse xmlns=\"http://schemas.microsoft.com/sharepoint/soap/\">");
        out.print("<GetListItemsResult>");
        out.print("<listitems");
        out.print(" xmlns:s='uuid:BDC6E3F0-6DA3-11d1-A2A3-00AA00C14882'");
        out.print(" xmlns:dt='uuid:C2F41010-65B3-11d1-A29F-00AA00C14882'");
        out.print(" xmlns:rs='urn:schemas-microsoft-com:rowset'");
        out.print(" xmlns:z='#RowsetSchema'>");
        List<ListItem> items = listItems.getModifiedAndNewItems();
        out.print("<rs:data ItemCount=\"" + Integer.toString(items.size()) + "\">");
        for (ListItem listItem : items) {
            listItem.write(out, false, false);
        }
        out.print("</rs:data>");
        out.print("</listitems>");
        out.print("</GetListItemsResult>");
        out.print("</GetListItemsResponse>");
        out.print("</soap:Body>");
        out.print("</soap:Envelope>");
        out.flush();
        response.setContentType(RESPONSE_CONTENT_TYPE);
        response.setContentLength(bos.size());
        bos.writeTo((OutputStream)response.getOutputStream());
        if (logger.isTraceEnabled()) {
            logger.traceExit();
        }
    }

    protected abstract ListChanges getListItems(UserData var1, String var2, SoapParameter var3, SoapParameter var4, SoapParameter var5, HttpServletRequest var6) throws AuthenticationRequiredException;

    protected void handleUpdateListItems(UserData userData, SimpleSoapParser parser, HttpServletRequest request, HttpServletResponse response) throws IOException, AuthenticationRequiredException {
        SoapParameter batch;
        String listName;
        if (logger.isTraceEnabled()) {
            logger.traceEnter();
        }
        if ((listName = parser.getParameter(METHODPARAMETER_LISTNAME)) == null) {
            logger.error("handleUpdateListItems: Parameter \"listName\" missing.");
            SimpleSoapParser.soapErrorResponse(response, "Missing parameter listName");
            if (logger.isTraceEnabled()) {
                logger.traceExit();
            }
            return;
        }
        SoapParameter updates = parser.getSoapParameter(METHODPARAMETER_UPDATES);
        if (updates == null) {
            logger.error("handleUpdateListItems: Parameter \"updates\" missing.");
            SimpleSoapParser.soapErrorResponse(response, "Missing parameter updates");
            if (logger.isTraceEnabled()) {
                logger.traceExit();
            }
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("handleUpdateListItems: Parameter listName=" + listName);
        }
        if ((batch = updates.getFirstSubParameterByName(METHODPARAMETER_BATCH)) == null) {
            logger.error("handleUpdateListItems: Parameter \"Batch\" missing.");
            SimpleSoapParser.soapErrorResponse(response, "Missing parameter Batch");
            if (logger.isTraceEnabled()) {
                logger.traceExit();
            }
            return;
        }
        ListUpdatesBatch listUpdatesBatch = new ListUpdatesBatch(batch);
        UpdateListItemsResults results = this.updateListItems(userData, listName, listUpdatesBatch, request);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        PrintStream out = new PrintStream((OutputStream)bos, false, "utf-8");
        out.print("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        out.print("<soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\">");
        out.print("<soap:Body>");
        out.print("<UpdateListItemsResponse xmlns=\"http://schemas.microsoft.com/sharepoint/soap/\">");
        out.print("<UpdateListItemsResult>");
        results.write(out);
        out.print("</UpdateListItemsResult>");
        out.print("</UpdateListItemsResponse>");
        out.print("</soap:Body>");
        out.print("</soap:Envelope>");
        out.flush();
        response.setContentType(RESPONSE_CONTENT_TYPE);
        response.setContentLength(bos.size());
        bos.writeTo((OutputStream)response.getOutputStream());
        if (logger.isTraceEnabled()) {
            logger.traceExit();
        }
    }

    protected abstract UpdateListItemsResults updateListItems(UserData var1, String var2, ListUpdatesBatch var3, HttpServletRequest var4) throws AuthenticationRequiredException;

    protected void handleGetListItemChangesSinceToken(UserData userData, SimpleSoapParser parser, HttpServletRequest request, HttpServletResponse response) throws IOException, AuthenticationRequiredException {
        List<String> deletedListItems;
        ListsGetListList list;
        String listName;
        if (logger.isTraceEnabled()) {
            logger.traceEnter();
        }
        if ((listName = parser.getParameter(METHODPARAMETER_LISTNAME)) == null) {
            logger.error("handleGetListItemChangesSinceToken: Parameter \"listName\" missing.");
            SimpleSoapParser.soapErrorResponse(response, "Missing parameter listName");
            if (logger.isTraceEnabled()) {
                logger.traceExit();
            }
            return;
        }
        SoapParameter viewFields = parser.getSoapParameter(METHODPARAMETER_VIEWFIELDS);
        String rowLimit = parser.getParameter(METHODPARAMETER_ROWLIMIT);
        SoapParameter queryOptions = parser.getSoapParameter(METHODPARAMETER_QUERYOPTIONS);
        String changeToken = parser.getParameter(METHODPARAMETER_CHANGETOKEN);
        SoapParameter contains = parser.getSoapParameter(METHODPARAMETER_CONTAINS);
        if (logger.isDebugEnabled()) {
            logger.debug("handleGetListItemChangesSinceToken: Parameter listName=" + listName);
            logger.debug("handleGetListItemChangesSinceToken: Parameter changeToken=" + (changeToken == null ? "null" : changeToken));
            logger.debug("handleGetListItemChangesSinceToken: Parameter rowLimit=" + (rowLimit == null ? "null" : rowLimit));
        }
        if ((list = this.getList(userData, listName, request)) == null) {
            logger.error("handleGetListItemChangesSinceToken: The requested list does not exist. listName=" + listName);
            SimpleSoapParser.soapErrorResponse(response, "The requested list does not exist.");
            return;
        }
        ListChanges listChanges = this.getListChangesSinceToken(userData, listName, viewFields, rowLimit, queryOptions, changeToken, contains, request);
        if (listChanges == null) {
            logger.error("handleGetListItemChangesSinceToken: Error getting list changes since token. listName=" + listName);
            SimpleSoapParser.soapErrorResponse(response, "Error getting list changes since token.");
            return;
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        PrintStream out = new PrintStream((OutputStream)bos, false, "utf-8");
        out.print("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        out.print("<soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\">");
        out.print("<soap:Body>");
        out.print("<GetListItemChangesSinceTokenResponse xmlns=\"http://schemas.microsoft.com/sharepoint/soap/\">");
        out.print("<GetListItemChangesSinceTokenResult>");
        out.print("<listitems");
        out.print(" MinTimeBetweenSyncs='0' RecommendedTimeBetweenSyncs='180' MaxBulkDocumentSyncSize='500' AlternateUrls='");
        out.print(this.getAlternateServerURL(userData, listName, request) + "/");
        out.print("' EffectivePermMask='FullMask'");
        out.print(" xmlns:s='uuid:BDC6E3F0-6DA3-11d1-A2A3-00AA00C14882'");
        out.print(" xmlns:dt='uuid:C2F41010-65B3-11d1-A29F-00AA00C14882'");
        out.print(" xmlns:rs='urn:schemas-microsoft-com:rowset'");
        out.print(" xmlns:z='#RowsetSchema'");
        out.print(">");
        out.print("<Changes LastChangeToken=\"" + listChanges.getLastChangeToken() + "\">");
        if (changeToken == null) {
            list.write(out);
        }
        if ((deletedListItems = listChanges.getDeletedItemIDs()).size() > 0) {
            for (String id : deletedListItems) {
                out.print("<Id ChangeType=\"Delete\">" + id + "</Id>");
            }
        }
        out.print("</Changes>");
        List<ListItem> changedListItems = listChanges.getModifiedAndNewItems();
        out.print("<rs:data ItemCount=\"" + Integer.toString(changedListItems.size()) + "\">");
        for (ListItem listItem : changedListItems) {
            listItem.write(out, false, false);
        }
        out.print("</rs:data>");
        out.print("</listitems>");
        out.print("</GetListItemChangesSinceTokenResult>");
        out.print("</GetListItemChangesSinceTokenResponse>");
        out.print("</soap:Body>");
        out.print("</soap:Envelope>");
        out.flush();
        response.setContentType(RESPONSE_CONTENT_TYPE);
        response.setContentLength(bos.size());
        bos.writeTo((OutputStream)response.getOutputStream());
        if (logger.isTraceEnabled()) {
            logger.traceExit();
        }
    }

    protected abstract ListChanges getListChangesSinceToken(UserData var1, String var2, SoapParameter var3, String var4, SoapParameter var5, String var6, SoapParameter var7, HttpServletRequest var8) throws AuthenticationRequiredException;

    protected void handleCheckOutFile(UserData userData, SimpleSoapParser parser, HttpServletRequest request, HttpServletResponse response) throws IOException, AuthenticationRequiredException {
        boolean bCheckoutToLocal;
        if (logger.isTraceEnabled()) {
            logger.traceEnter();
        }
        String pageUrl = parser.getParameter(METHODPARAMETER_PAGEURL);
        String checkoutToLocal = parser.getParameter(METHODPARAMETER_CHECKOUTTOLOCAL);
        String lastmodified = parser.getParameter(METHODPARAMETER_LASTMODIFIED);
        if (pageUrl == null) {
            logger.error("handleCheckOutFile: Parameter \"pageUrl\" missing.");
            SimpleSoapParser.soapErrorResponse(response, "Missing parameter pageUrl");
            if (logger.isTraceEnabled()) {
                logger.traceExit();
            }
            return;
        }
        pageUrl = URLPathDecoder.decode(pageUrl, "UTF-8");
        boolean bl = bCheckoutToLocal = checkoutToLocal != null && checkoutToLocal.equalsIgnoreCase("true");
        if (logger.isDebugEnabled()) {
            logger.debug("handleCheckOutFile: Parameter pageUrl=" + pageUrl);
            logger.debug("handleCheckOutFile: Parameter checkoutToLocal=" + checkoutToLocal);
            logger.debug("handleCheckOutFile: Parameter lastmodified=" + lastmodified);
        }
        String sitePrefix = this.getSitePrefix(request);
        boolean checkoutSuccessfull = false;
        if (pageUrl.toLowerCase().startsWith(sitePrefix.toLowerCase())) {
            String relativeUrl = pageUrl.substring(sitePrefix.length());
            checkoutSuccessfull = this.checkoutFile(userData, relativeUrl, bCheckoutToLocal, lastmodified);
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        PrintStream out = new PrintStream((OutputStream)bos, false, "utf-8");
        out.print("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        out.print("<soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\">");
        out.print("<soap:Body>");
        out.print("<CheckOutFileResponse xmlns=\"http://schemas.microsoft.com/sharepoint/soap/\">");
        out.print("<CheckOutFileResult>");
        out.print(checkoutSuccessfull ? "true" : "false");
        out.print("</CheckOutFileResult>");
        out.print("</CheckOutFileResponse>");
        out.print("</soap:Body>");
        out.print("</soap:Envelope>");
        out.flush();
        response.setContentType(RESPONSE_CONTENT_TYPE);
        response.setContentLength(bos.size());
        bos.writeTo((OutputStream)response.getOutputStream());
        if (logger.isTraceEnabled()) {
            logger.traceExit();
        }
    }

    protected String getSitePrefix(HttpServletRequest request) {
        String protocol = request.isSecure() ? "https://" : "http://";
        int defaultPort = request.isSecure() ? 443 : 80;
        String portString = request.getLocalPort() != defaultPort ? ":" + Integer.toString(request.getLocalPort()) : "";
        return protocol + request.getServerName() + portString + request.getContextPath();
    }

    protected abstract boolean checkoutFile(UserData var1, String var2, boolean var3, String var4) throws AuthenticationRequiredException;

    protected void handleCheckInFile(UserData userData, SimpleSoapParser parser, HttpServletRequest request, HttpServletResponse response) throws IOException, AuthenticationRequiredException {
        if (logger.isTraceEnabled()) {
            logger.traceEnter();
        }
        String pageUrl = parser.getParameter(METHODPARAMETER_PAGEURL);
        String comment = parser.getParameter(METHODPARAMETER_COMMENT);
        String checkinTypeStr = parser.getParameter(METHODPARAMETER_CHECKINTYPE);
        if (pageUrl == null) {
            logger.error("handleCheckInFile: Parameter \"pageUrl\" missing.");
            SimpleSoapParser.soapErrorResponse(response, "Missing parameter pageUrl");
            if (logger.isTraceEnabled()) {
                logger.traceExit();
            }
            return;
        }
        pageUrl = URLPathDecoder.decode(pageUrl, "UTF-8");
        CheckinType checkinType = CheckinType.parse(checkinTypeStr);
        if (logger.isDebugEnabled()) {
            logger.debug("handleCheckInFile: Parameter pageUrl=" + pageUrl);
            logger.debug("handleCheckInFile: Parameter comment=" + comment);
            logger.debug("handleCheckInFile: Parameter CheckinType=" + checkinTypeStr + " -> " + checkinType);
        }
        String sitePrefix = this.getSitePrefix(request);
        boolean checkinSuccessfull = false;
        if (pageUrl.toLowerCase().startsWith(sitePrefix.toLowerCase())) {
            String relativeUrl = pageUrl.substring(sitePrefix.length());
            checkinSuccessfull = this.checkinFile(userData, relativeUrl, comment, checkinType);
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        PrintStream out = new PrintStream((OutputStream)bos, false, "utf-8");
        out.print("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        out.print("<soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\">");
        out.print("<soap:Body>");
        out.print("<CheckInFileResponse xmlns=\"http://schemas.microsoft.com/sharepoint/soap/\">");
        out.print("<CheckInFileResult>");
        out.print(checkinSuccessfull ? "true" : "false");
        out.print("</CheckInFileResult>");
        out.print("</CheckInFileResponse>");
        out.print("</soap:Body>");
        out.print("</soap:Envelope>");
        out.flush();
        response.setContentType(RESPONSE_CONTENT_TYPE);
        response.setContentLength(bos.size());
        bos.writeTo((OutputStream)response.getOutputStream());
        if (logger.isTraceEnabled()) {
            logger.traceExit();
        }
    }

    protected abstract boolean checkinFile(UserData var1, String var2, String var3, CheckinType var4) throws AuthenticationRequiredException;

    protected void handleUndoCheckOut(UserData userData, SimpleSoapParser parser, HttpServletRequest request, HttpServletResponse response) throws IOException, AuthenticationRequiredException {
        String pageUrl;
        if (logger.isTraceEnabled()) {
            logger.traceEnter();
        }
        if ((pageUrl = parser.getParameter(METHODPARAMETER_PAGEURL)) == null) {
            logger.error("handleCheckInFile: Parameter \"pageUrl\" missing.");
            SimpleSoapParser.soapErrorResponse(response, "Missing parameter pageUrl");
            if (logger.isTraceEnabled()) {
                logger.traceExit();
            }
            return;
        }
        pageUrl = URLPathDecoder.decode(pageUrl, "UTF-8");
        if (logger.isDebugEnabled()) {
            logger.debug("handleCheckInFile: Parameter pageUrl=" + pageUrl);
        }
        String sitePrefix = this.getSitePrefix(request);
        boolean undoCheckoutSuccessfull = false;
        if (pageUrl.toLowerCase().startsWith(sitePrefix.toLowerCase())) {
            String relativeUrl = pageUrl.substring(sitePrefix.length());
            undoCheckoutSuccessfull = this.undoCheckOut(userData, relativeUrl);
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        PrintStream out = new PrintStream((OutputStream)bos, false, "utf-8");
        out.print("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        out.print("<soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\">");
        out.print("<soap:Body>");
        out.print("<UndoCheckOutResponse xmlns=\"http://schemas.microsoft.com/sharepoint/soap/\">");
        out.print("<UndoCheckOutResult>");
        out.print(undoCheckoutSuccessfull ? "true" : "false");
        out.print("</UndoCheckOutResult>");
        out.print("</UndoCheckOutResponse>");
        out.print("</soap:Body>");
        out.print("</soap:Envelope>");
        out.flush();
        response.setContentType(RESPONSE_CONTENT_TYPE);
        response.setContentLength(bos.size());
        bos.writeTo((OutputStream)response.getOutputStream());
        if (logger.isTraceEnabled()) {
            logger.traceExit();
        }
    }

    protected abstract boolean undoCheckOut(UserData var1, String var2) throws AuthenticationRequiredException;

    protected void handleGetListContentType(UserData userData, SimpleSoapParser parser, HttpServletRequest request, HttpServletResponse response) throws IOException, AuthenticationRequiredException {
        ListsGetListContentTypeContentType contentType;
        String listName;
        if (logger.isTraceEnabled()) {
            logger.traceEnter();
        }
        if ((listName = parser.getParameter(METHODPARAMETER_LISTNAME)) == null) {
            logger.error("handleGetListContentType: Parameter \"listName\" missing.");
            SimpleSoapParser.soapErrorResponse(response, "Missing parameter listName");
            if (logger.isTraceEnabled()) {
                logger.traceExit();
            }
            return;
        }
        String contentTypeId = parser.getParameter(METHODPARAMETER_CONTENTTYPEID);
        if (contentTypeId == null) {
            logger.error("handleGetListContentType: Parameter \"contentTypeId\" missing.");
            SimpleSoapParser.soapErrorResponse(response, "Missing parameter contentTypeId");
            if (logger.isTraceEnabled()) {
                logger.traceExit();
            }
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("handleGetListContentType: Parameter listName=" + listName);
            logger.debug("handleGetListContentType: Parameter contentTypeId=" + contentTypeId);
        }
        if ((contentType = this.getListContentType(userData, listName, contentTypeId, request)) == null) {
            logger.error("handleGetListContentType: unknown ContentType " + contentTypeId + " in list " + listName);
            SimpleSoapParser.soapErrorResponse(response, "Unknown content type.");
            return;
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        PrintStream out = new PrintStream((OutputStream)bos, false, "utf-8");
        out.print("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        out.print("<soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\">");
        out.print("<soap:Body>");
        out.print("<GetListContentTypeResponse xmlns=\"http://schemas.microsoft.com/sharepoint/soap/\">");
        out.print("<GetListContentTypeResult>");
        contentType.write(out);
        out.print("</GetListContentTypeResult>");
        out.print("</GetListContentTypeResponse>");
        out.print("</soap:Body>");
        out.print("</soap:Envelope>");
        out.flush();
        response.setContentType(RESPONSE_CONTENT_TYPE);
        response.setContentLength(bos.size());
        bos.writeTo((OutputStream)response.getOutputStream());
        if (logger.isTraceEnabled()) {
            logger.traceExit();
        }
    }

    protected abstract ListsGetListContentTypeContentType getListContentType(UserData var1, String var2, String var3, HttpServletRequest var4) throws AuthenticationRequiredException;

    protected void handleGetListContentTypes(UserData userData, SimpleSoapParser parser, HttpServletRequest request, HttpServletResponse response) throws IOException, AuthenticationRequiredException {
        String listName;
        if (logger.isTraceEnabled()) {
            logger.traceEnter();
        }
        if ((listName = parser.getParameter(METHODPARAMETER_LISTNAME)) == null) {
            logger.error("handlGetListContentTypes: Parameter \"listName\" missing.");
            SimpleSoapParser.soapErrorResponse(response, "Missing parameter listName");
            if (logger.isTraceEnabled()) {
                logger.traceExit();
            }
            return;
        }
        String contentTypeId = parser.getParameter(METHODPARAMETER_CONTENTTYPEID);
        if (logger.isDebugEnabled()) {
            logger.debug("handlGetListContentTypes: Parameter listName=" + listName);
            logger.debug("handlGetListContentTypes: Parameter contentTypeId=" + contentTypeId);
        }
        ListsGetListContentTypesContentType[] contentTypes = this.getListContentTypes(userData, listName, contentTypeId, request);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        PrintStream out = new PrintStream((OutputStream)bos, false, "utf-8");
        out.print("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        out.print("<soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\">");
        out.print("<soap:Body>");
        out.print("<GetListContentTypesResponse xmlns=\"http://schemas.microsoft.com/sharepoint/soap/\">");
        out.print("<GetListContentTypesResult>");
        out.print("<ContentTypes>");
        if (contentTypes != null) {
            for (int i = 0; i < contentTypes.length; ++i) {
                contentTypes[i].write(out);
            }
        }
        out.print("</ContentTypes>");
        out.print("</GetListContentTypesResult>");
        out.print("</GetListContentTypesResponse>");
        out.print("</soap:Body>");
        out.print("</soap:Envelope>");
        out.flush();
        response.setContentType(RESPONSE_CONTENT_TYPE);
        response.setContentLength(bos.size());
        bos.writeTo((OutputStream)response.getOutputStream());
        if (logger.isTraceEnabled()) {
            logger.traceExit();
        }
    }

    protected abstract ListsGetListContentTypesContentType[] getListContentTypes(UserData var1, String var2, String var3, HttpServletRequest var4) throws AuthenticationRequiredException;

    protected void handleGetListContentTypesAndProperties(UserData userData, SimpleSoapParser parser, HttpServletRequest request, HttpServletResponse response) throws IOException, AuthenticationRequiredException {
        String listName;
        if (logger.isTraceEnabled()) {
            logger.traceEnter();
        }
        if ((listName = parser.getParameter(METHODPARAMETER_LISTNAME)) == null) {
            logger.error("handleGetListContentTypesAndProperties: Parameter \"listName\" missing.");
            SimpleSoapParser.soapErrorResponse(response, "Missing parameter listName");
            if (logger.isTraceEnabled()) {
                logger.traceExit();
            }
            return;
        }
        String contentTypeId = parser.getParameter(METHODPARAMETER_CONTENTTYPEID);
        String propertyPrefix = parser.getParameter(METHODPARAMETER_PROPERTYPREFIX);
        String includeWebProperties = parser.getParameter(METHODPARAMETER_INCLUDEWEBPROPERTIES);
        if (logger.isDebugEnabled()) {
            logger.debug("handleGetListContentTypesAndProperties: Parameter listName=" + listName);
            logger.debug("handleGetListContentTypesAndProperties: Parameter contentTypeId=" + contentTypeId);
            logger.debug("handleGetListContentTypesAndProperties: Parameter propertyPrefix=" + propertyPrefix);
            logger.debug("handleGetListContentTypesAndProperties: Parameter includeWebProperties=" + includeWebProperties);
        }
        ListsGetListContentTypesContentType[] contentTypes = this.getListContentTypes(userData, listName, contentTypeId, request);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        PrintStream out = new PrintStream((OutputStream)bos, false, "utf-8");
        out.print("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        out.print("<soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\">");
        out.print("<soap:Body>");
        out.print("<GetListContentTypesAndPropertiesResponse xmlns=\"http://schemas.microsoft.com/sharepoint/soap/\">");
        out.print("<GetListContentTypesAndPropertiesResult>");
        out.print("<ContentTypes>");
        if (contentTypes != null) {
            for (int i = 0; i < contentTypes.length; ++i) {
                contentTypes[i].write(out);
            }
        }
        out.print("</ContentTypes>");
        out.print("<Properties>");
        out.print("</Properties>");
        out.print("</GetListContentTypesAndPropertiesResult>");
        out.print("</GetListContentTypesAndPropertiesResponse>");
        out.print("</soap:Body>");
        out.print("</soap:Envelope>");
        out.flush();
        response.setContentType(RESPONSE_CONTENT_TYPE);
        response.setContentLength(bos.size());
        bos.writeTo((OutputStream)response.getOutputStream());
        if (logger.isTraceEnabled()) {
            logger.traceExit();
        }
    }

    protected void handleGetListCollection(UserData userData, SimpleSoapParser parser, HttpServletRequest request, HttpServletResponse response) throws IOException, AuthenticationRequiredException {
        if (logger.isTraceEnabled()) {
            logger.traceEnter();
        }
        List<ListDescription> listDescriptions = this.getListCollection(parser);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        PrintStream out = new PrintStream((OutputStream)bos, false, "utf-8");
        out.print("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        out.print("<soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\">");
        out.print("<soap:Body>");
        out.print("<GetListCollectionResponse xmlns=\"http://schemas.microsoft.com/sharepoint/soap/\">");
        out.print("<GetListCollectionResult>");
        if (listDescriptions == null || listDescriptions.size() == 0) {
            out.print("<Lists />");
        } else {
            out.print("<Lists>");
            for (ListDescription listDescription : listDescriptions) {
                listDescription.write(out, false);
            }
            out.print("</Lists>");
        }
        out.print("</GetListCollectionResult>");
        out.print("</GetListCollectionResponse>");
        out.print("</soap:Body>");
        out.print("</soap:Envelope>");
        out.flush();
        response.setContentType(RESPONSE_CONTENT_TYPE);
        response.setContentLength(bos.size());
        bos.writeTo((OutputStream)response.getOutputStream());
        if (logger.isTraceEnabled()) {
            logger.traceExit();
        }
    }

    public abstract List<ListDescription> getListCollection(SimpleSoapParser var1);

    protected void handleGetListAndView(UserData userData, SimpleSoapParser parser, HttpServletRequest request, HttpServletResponse response) throws IOException, AuthenticationRequiredException {
        ListsGetListList list;
        String listName;
        if (logger.isTraceEnabled()) {
            logger.traceEnter();
        }
        if ((listName = parser.getParameter(METHODPARAMETER_LISTNAME)) == null) {
            logger.error("handleGetListAndView: Parameter \"listName\" missing.");
            SimpleSoapParser.soapErrorResponse(response, "Missing parameter listName");
            if (logger.isTraceEnabled()) {
                logger.traceExit();
            }
            return;
        }
        String viewName = parser.getParameter(METHODPARAMETER_VIEWNAME);
        if (viewName == null) {
            logger.error("handleGetListAndView: Parameter \"viewName\" missing.");
            SimpleSoapParser.soapErrorResponse(response, "Missing parameter viewName");
            if (logger.isTraceEnabled()) {
                logger.traceExit();
            }
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("handleGetListAndView: Parameter listName=" + listName);
            logger.debug("handleGetListAndView: Parameter viewName=" + viewName);
        }
        if ((list = this.getList(userData, listName, request)) == null) {
            logger.error("handleGetListAndView: The requested list does not exist. listName=" + listName);
            SimpleSoapParser.soapErrorResponse(response, "The requested list does not exist.");
            return;
        }
        ViewDescription view = this.getView(userData, listName, viewName, request);
        if (view == null) {
            logger.error("handleGetListAndView: The requested view does not exist. viewName=" + listName);
            SimpleSoapParser.soapErrorResponse(response, "The requested view does not exist.");
            return;
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        PrintStream out = new PrintStream((OutputStream)bos, false, "utf-8");
        out.print("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        out.print("<soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\">");
        out.print("<soap:Body>");
        out.print("<GetListAndViewResponse xmlns=\"http://schemas.microsoft.com/sharepoint/soap/\">");
        out.print("<GetListAndViewResult>");
        out.print("<ListAndView>");
        list.write(out);
        view.write(out, true);
        out.print("</ListAndView>");
        out.print("</GetListAndViewResult>");
        out.print("</GetListAndViewResponse>");
        out.print("</soap:Body>");
        out.print("</soap:Envelope>");
        out.flush();
        response.setContentType(RESPONSE_CONTENT_TYPE);
        response.setContentLength(bos.size());
        bos.writeTo((OutputStream)response.getOutputStream());
        if (logger.isTraceEnabled()) {
            logger.traceExit();
        }
    }

    protected abstract ViewDescription getView(UserData var1, String var2, String var3, HttpServletRequest var4) throws AuthenticationRequiredException;
}

