/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.officeservices.protocol;

import java.util.ArrayList;
import java.util.List;
import org.alfresco.officeservices.exceptions.MalformedVermeerRequestException;
import org.alfresco.officeservices.protocol.VermeerRequest;

public class VermeerParameterVectorString {
    protected List<String> value = null;

    public VermeerParameterVectorString(String data) throws MalformedVermeerRequestException {
        if (data != null) {
            if (data.length() < 2 || data.charAt(0) != '[' || data.charAt(data.length() - 1) != ']') {
                throw new MalformedVermeerRequestException("invalid block marker");
            }
            this.value = new ArrayList<String>();
            StringBuffer decodedString = new StringBuffer(data.length());
            boolean escaped = false;
            int size = data.length();
            block16: for (int i = 1; i < size - 1; ++i) {
                char c = data.charAt(i);
                if (escaped) {
                    switch (c) {
                        case '\\': {
                            decodedString.append('\\');
                            break;
                        }
                        case '=': {
                            decodedString.append('=');
                            break;
                        }
                        case '[': {
                            decodedString.append('[');
                            break;
                        }
                        case ']': {
                            decodedString.append(']');
                            break;
                        }
                        case ';': {
                            decodedString.append(';');
                            break;
                        }
                        case '\"': {
                            decodedString.append('\"');
                            break;
                        }
                        default: {
                            throw new MalformedVermeerRequestException("invalid escapeing sequence");
                        }
                    }
                    escaped = false;
                    continue;
                }
                switch (c) {
                    case '\\': {
                        escaped = true;
                        continue block16;
                    }
                    case '=': {
                        throw new MalformedVermeerRequestException("invalid escapeing sequence");
                    }
                    case '[': {
                        throw new MalformedVermeerRequestException("invalid escapeing sequence");
                    }
                    case ']': {
                        throw new MalformedVermeerRequestException("invalid escapeing sequence");
                    }
                    case ';': {
                        this.value.add(decodedString.toString());
                        decodedString.setLength(0);
                        continue block16;
                    }
                    case '\"': {
                        throw new MalformedVermeerRequestException("invalid escapeing sequence");
                    }
                    default: {
                        decodedString.append(c);
                    }
                }
            }
            if (escaped) {
                throw new MalformedVermeerRequestException("invalid escapeing sequence");
            }
            if (decodedString.length() > 0) {
                this.value.add(decodedString.toString());
            }
        }
    }

    public VermeerParameterVectorString(VermeerRequest request, String parameterName, boolean required) throws MalformedVermeerRequestException {
        this(request.getParameter(parameterName));
        if (required && this.isNull()) {
            throw new MalformedVermeerRequestException(parameterName + " missing");
        }
    }

    public boolean isNull() {
        return this.value == null;
    }

    public int getSize() {
        return this.value.size();
    }

    public String get(int index) {
        return this.value.get(index);
    }
}

