/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.aosmodule.metadata;

import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.alfresco.model.ContentModel;
import org.alfresco.module.aosmodule.metadata.DataModelMappingConfiguration;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.PropertyCheck;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;

public class StandardDataModelMappingConfiguration
implements DataModelMappingConfiguration,
InitializingBean {
    protected DictionaryService dictionaryService;
    protected String documentRootType;
    protected String folderRootType;
    protected QName rootDocumentType;
    protected QName rootFolderType;
    protected List<String> includedTypesPatterns;
    protected List<String> excludedTypesPatterns;
    protected List<String> includedAspectsPatterns;
    protected List<String> excludedAspectsPatterns;
    protected List<String> includedPropertiesPatterns;
    protected List<String> excludedPropertiesPatterns;
    protected List<String> includedInstantiableTypesPatterns;
    protected List<String> excludedInstantiableTypesPatterns;
    protected List<Pattern> includedTypes;
    protected List<Pattern> excludedTypes;
    protected List<Pattern> includedAspects;
    protected List<Pattern> excludedAspects;
    protected List<Pattern> includedProperties;
    protected List<Pattern> excludedProperties;
    protected List<Pattern> includedInstantiableTypes;
    protected List<Pattern> excludedInstantiableTypes;
    protected Logger logger = LoggerFactory.getLogger(StandardDataModelMappingConfiguration.class);

    public void afterPropertiesSet() throws Exception {
        PropertyCheck.mandatory((Object)this, (String)"dictionaryService", (Object)this.dictionaryService);
        PropertyCheck.mandatory((Object)this, (String)"documentRootType", (Object)this.documentRootType);
        PropertyCheck.mandatory((Object)this, (String)"folderRootType", (Object)this.folderRootType);
        this.rootDocumentType = QName.createQName((String)this.documentRootType);
        this.rootFolderType = QName.createQName((String)this.folderRootType);
        this.includedTypes = this.compilePatterns(this.includedTypesPatterns, "includedTypesPatterns");
        this.excludedTypes = this.compilePatterns(this.excludedTypesPatterns, "excludedTypesPatterns");
        this.includedAspects = this.compilePatterns(this.includedAspectsPatterns, "includedAspectsPatterns");
        this.excludedAspects = this.compilePatterns(this.excludedAspectsPatterns, "excludedAspectsPatterns");
        this.includedProperties = this.compilePatterns(this.includedPropertiesPatterns, "includedPropertiesPatterns");
        this.excludedProperties = this.compilePatterns(this.excludedPropertiesPatterns, "excludedPropertiesPatterns");
        this.includedInstantiableTypes = this.compilePatterns(this.includedInstantiableTypesPatterns, "includedInstantiableTypesPatterns");
        this.excludedInstantiableTypes = this.compilePatterns(this.excludedInstantiableTypesPatterns, "excludedInstantiableTypesPatterns");
    }

    private List<Pattern> compilePatterns(List<String> patternStrings, String propertyName) {
        if (patternStrings == null) {
            return null;
        }
        LinkedList<Pattern> result = new LinkedList<Pattern>();
        for (String patternString : patternStrings) {
            try {
                result.add(Pattern.compile(patternString));
            }
            catch (PatternSyntaxException pse) {
                this.logger.error("Syntax error in " + propertyName + " '" + patternString + "'. Ignoring pattern.", (Throwable)pse);
            }
        }
        return result;
    }

    protected static boolean isNameAcceptedBy(QName qname, List<Pattern> patterns) {
        if (qname != null && patterns != null) {
            for (Pattern pattern : patterns) {
                if (!pattern.matcher(qname.toString()).matches()) continue;
                return true;
            }
        }
        return false;
    }

    protected static boolean isMapped(QName qname, List<Pattern> includedPatterns, List<Pattern> excludedPatterns) {
        return StandardDataModelMappingConfiguration.isNameAcceptedBy(qname, includedPatterns) && !StandardDataModelMappingConfiguration.isNameAcceptedBy(qname, excludedPatterns);
    }

    @Override
    public boolean isTypeMapped(QName qname) {
        return this.dictionaryService.isSubClass(qname, ContentModel.TYPE_CONTENT) && StandardDataModelMappingConfiguration.isMapped(qname, this.includedTypes, this.excludedTypes);
    }

    @Override
    public boolean isAspectMapped(QName qname) {
        return StandardDataModelMappingConfiguration.isMapped(qname, this.includedAspects, this.excludedAspects);
    }

    @Override
    public boolean isPropertyMapped(QName qname) {
        return StandardDataModelMappingConfiguration.isMapped(qname, this.includedProperties, this.excludedProperties);
    }

    @Override
    public QName getRootDocumentType() {
        return this.rootDocumentType;
    }

    @Override
    public QName getRootFolderType() {
        return this.rootFolderType;
    }

    @Override
    public boolean isInstantiable(QName qname) {
        return this.isTypeMapped(qname) && StandardDataModelMappingConfiguration.isMapped(qname, this.includedInstantiableTypes, this.excludedInstantiableTypes);
    }

    public DictionaryService getDictionaryService() {
        return this.dictionaryService;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public String getDocumentRootType() {
        return this.documentRootType;
    }

    public void setDocumentRootType(String documentRootType) {
        this.documentRootType = documentRootType;
    }

    public String getFolderRootType() {
        return this.folderRootType;
    }

    public void setFolderRootType(String folderRootType) {
        this.folderRootType = folderRootType;
    }

    public List<String> getIncludedTypesPatterns() {
        return this.includedTypesPatterns;
    }

    public void setIncludedTypesPatterns(List<String> includedTypesPatterns) {
        this.includedTypesPatterns = includedTypesPatterns;
    }

    public List<String> getExcludedTypesPatterns() {
        return this.excludedTypesPatterns;
    }

    public void setExcludedTypesPatterns(List<String> excludedTypesPatterns) {
        this.excludedTypesPatterns = excludedTypesPatterns;
    }

    public List<String> getIncludedAspectsPatterns() {
        return this.includedAspectsPatterns;
    }

    public void setIncludedAspectsPatterns(List<String> includedAspectsPatterns) {
        this.includedAspectsPatterns = includedAspectsPatterns;
    }

    public List<String> getExcludedAspectsPatterns() {
        return this.excludedAspectsPatterns;
    }

    public void setExcludedAspectsPatterns(List<String> ignoredAspectsPatterns) {
        this.excludedAspectsPatterns = ignoredAspectsPatterns;
    }

    public List<String> getIncludedPropertiesPatterns() {
        return this.includedPropertiesPatterns;
    }

    public void setIncludedPropertiesPatterns(List<String> includedPropertiesPatterns) {
        this.includedPropertiesPatterns = includedPropertiesPatterns;
    }

    public List<String> getExcludedPropertiesPatterns() {
        return this.excludedPropertiesPatterns;
    }

    public void setExcludedPropertiesPatterns(List<String> ignoredPropertiesPatterns) {
        this.excludedPropertiesPatterns = ignoredPropertiesPatterns;
    }

    public List<String> getIncludedInstantiableTypesPatterns() {
        return this.includedInstantiableTypesPatterns;
    }

    public void setIncludedInstantiableTypesPatterns(List<String> includedInstantiableTypesPatterns) {
        this.includedInstantiableTypesPatterns = includedInstantiableTypesPatterns;
    }

    public List<String> getExcludedInstantiableTypesPatterns() {
        return this.excludedInstantiableTypesPatterns;
    }

    public void setExcludedInstantiableTypesPatterns(List<String> excludedInstantiableTypesPatterns) {
        this.excludedInstantiableTypesPatterns = excludedInstantiableTypesPatterns;
    }
}

