/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.aosmodule.vfs;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.transaction.UserTransaction;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.io.Serializable;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.sf.acegisecurity.Authentication;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.module.aosmodule.metadata.DataModelMappingConfiguration;
import org.alfresco.module.aosmodule.metadata.IOContentFilterRegistry;
import org.alfresco.module.aosmodule.vfs.DocumentNode;
import org.alfresco.module.aosmodule.vfs.FolderNode;
import org.alfresco.officeservices.UserData;
import org.alfresco.officeservices.datamodel.Guid;
import org.alfresco.officeservices.exceptions.AuthenticationRequiredException;
import org.alfresco.officeservices.protocol.VermeerRequest;
import org.alfresco.officeservices.vfs.VFSDocumentNode;
import org.alfresco.officeservices.vfs.VFSNode;
import org.alfresco.officeservices.vfs.VirtualFileSystem;
import org.alfresco.repo.cache.SimpleCache;
import org.alfresco.repo.policy.BehaviourFilter;
import org.alfresco.repo.security.authentication.AuthenticationContext;
import org.alfresco.repo.security.permissions.AccessDeniedException;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.repo.webdav.WebDAVActivityPoster;
import org.alfresco.repo.webdav.WebDAVHelper;
import org.alfresco.repo.webdav.WebDAVServlet;
import org.alfresco.service.cmr.coci.CheckOutCheckInService;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.lock.LockService;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.model.FileNotFoundException;
import org.alfresco.service.cmr.repository.ContentIOException;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.InvalidNodeRefException;
import org.alfresco.service.cmr.repository.MimetypeService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.cmr.security.AuthenticationService;
import org.alfresco.service.cmr.site.SiteService;
import org.alfresco.service.cmr.version.Version;
import org.alfresco.service.cmr.version.VersionHistory;
import org.alfresco.service.cmr.version.VersionService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.Pair;
import org.alfresco.util.PropertyCheck;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;

public class AlfrescoVirtualFileSystem
implements InitializingBean,
VirtualFileSystem {
    public static final QName ASPECT_AOS_CHECKED_OUT_TO_LOCAL = QName.createQName((String)"http://www.alfresco.org/model/aos/1.0", (String)"checkedOutToLocal");
    public static final Guid LISTID_ROOT_DOCUMENTS = Guid.parse((String)"{00000000-0000-0000-0000-000000000000}");
    static final String KEY_ROOT_NODEREF = "AlfrescoVirtualFileSystem.root_noderef";
    private AuthenticationService authenticationService;
    private NodeService nodeService;
    private FileFolderService fileFolderService;
    private CheckOutCheckInService checkOutCheckInService;
    private LockService lockService;
    private VersionService versionService;
    private DictionaryService dictionaryService;
    private NamespaceService namespaceService;
    private MimetypeService mimetypeService;
    private SearchService searchService;
    private BehaviourFilter policyBehaviourFilter;
    private TransactionService transactionService;
    private TenantService tenantService;
    private SiteService siteService;
    private WebDAVHelper webDavHelper;
    private WebDAVServlet.WebDAVInitParameters webDavInitParams;
    private AuthenticationContext authenticationContext;
    private WebDAVActivityPoster activityPoster;
    private DataModelMappingConfiguration dataModelMappingConfiguration;
    private IOContentFilterRegistry ioContentFilterRegistry;
    private SimpleCache<String, NodeRef> singletonCache;
    private String baseUrlOverwrite;
    private String sitePathOverwrite;
    private String identityServiceScopes;
    private boolean filterIgnoresOOXMLProtected;
    protected Logger logger = LoggerFactory.getLogger(AlfrescoVirtualFileSystem.class);
    protected NodeRef defaultRootNodeRef;
    private Object defaultRootNodeRefLock = new Object();
    private String HISTORY_PATH_PREFIX = "/_aos_history/";
    private String NODEID_PATH_PREFIX = "/_aos_nodeid/";

    public void afterPropertiesSet() throws Exception {
        PropertyCheck.mandatory((Object)this, (String)"authenticationService", (Object)this.authenticationService);
        PropertyCheck.mandatory((Object)this, (String)"nodeService", (Object)this.nodeService);
        PropertyCheck.mandatory((Object)this, (String)"fileFolderService", (Object)this.fileFolderService);
        PropertyCheck.mandatory((Object)this, (String)"checkOutCheckInService", (Object)this.checkOutCheckInService);
        PropertyCheck.mandatory((Object)this, (String)"lockService", (Object)this.lockService);
        PropertyCheck.mandatory((Object)this, (String)"versionService", (Object)this.versionService);
        PropertyCheck.mandatory((Object)this, (String)"dictionaryService", (Object)this.dictionaryService);
        PropertyCheck.mandatory((Object)this, (String)"namespaceService", (Object)this.namespaceService);
        PropertyCheck.mandatory((Object)this, (String)"mimetypeService", (Object)this.mimetypeService);
        PropertyCheck.mandatory((Object)this, (String)"searchService", (Object)this.searchService);
        PropertyCheck.mandatory((Object)this, (String)"policyBehaviourFilter", (Object)this.policyBehaviourFilter);
        PropertyCheck.mandatory((Object)this, (String)"transactionService", (Object)this.transactionService);
        PropertyCheck.mandatory((Object)this, (String)"tenantService", (Object)this.tenantService);
        PropertyCheck.mandatory((Object)this, (String)"siteService", (Object)this.siteService);
        PropertyCheck.mandatory((Object)this, (String)"webDavHelper", (Object)this.webDavHelper);
        PropertyCheck.mandatory((Object)this, (String)"webDavInitParams", (Object)this.webDavInitParams);
        PropertyCheck.mandatory((Object)this, (String)"authenticationContext", (Object)this.authenticationContext);
        PropertyCheck.mandatory((Object)this, (String)"activityPoster", (Object)this.activityPoster);
        PropertyCheck.mandatory((Object)this, (String)"dataModelMappingConfiguration", (Object)this.dataModelMappingConfiguration);
        PropertyCheck.mandatory((Object)this, (String)"singletonCache", this.singletonCache);
    }

    public void prepare() throws ServletException {
        if (this.defaultRootNodeRef == null) {
            try {
                this.getDefaultRootNode();
            }
            catch (Exception e) {
                throw new ServletException("Error initializing default root node.", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected NodeRef getDefaultRootNode() throws Exception {
        if (this.defaultRootNodeRef != null) {
            return this.defaultRootNodeRef;
        }
        Object object = this.defaultRootNodeRefLock;
        synchronized (object) {
            NodeRef nodeRef;
            if (this.defaultRootNodeRef != null) {
                return this.defaultRootNodeRef;
            }
            String storeValue = this.webDavInitParams.getStoreName();
            String rootPath = this.webDavInitParams.getRootPath();
            Authentication currentUser = this.authenticationContext.getCurrentAuthentication();
            this.authenticationContext.setSystemUserAsCurrentUser();
            UserTransaction tx = this.transactionService.getUserTransaction(true);
            try {
                StoreRef storeRef;
                if (tx != null) {
                    tx.begin();
                }
                if (!this.nodeService.exists(storeRef = new StoreRef(storeValue))) {
                    throw new RuntimeException("No store for path: " + String.valueOf(storeRef));
                }
                NodeRef storeRootNodeRef = this.nodeService.getRootNode(storeRef);
                List nodeRefs = this.searchService.selectNodes(storeRootNodeRef, rootPath, null, (NamespacePrefixResolver)this.namespaceService, false);
                if (nodeRefs.size() > 1) {
                    throw new RuntimeException("Multiple possible children for : \n   path: " + rootPath + "\n   results: " + String.valueOf(nodeRefs));
                }
                if (nodeRefs.size() == 0) {
                    throw new RuntimeException("Node is not found for : \n   root path: " + rootPath);
                }
                this.defaultRootNodeRef = (NodeRef)nodeRefs.get(0);
                if (tx != null) {
                    tx.commit();
                }
                nodeRef = this.defaultRootNodeRef;
            }
            catch (Throwable throwable) {
                this.authenticationContext.clearCurrentSecurityContext();
                this.authenticationContext.setCurrentAuthentication(currentUser);
                throw throwable;
            }
            this.authenticationContext.clearCurrentSecurityContext();
            this.authenticationContext.setCurrentAuthentication(currentUser);
            return nodeRef;
        }
    }

    protected NodeRef getRootNodeRef() throws Exception {
        NodeRef rootNodeRef = (NodeRef)this.singletonCache.get((Serializable)((Object)KEY_ROOT_NODEREF));
        if (rootNodeRef == null) {
            rootNodeRef = this.tenantService.getRootNode(this.nodeService, this.searchService, this.namespaceService, this.webDavInitParams.getRootPath(), this.getDefaultRootNode());
            this.singletonCache.put((Serializable)((Object)KEY_ROOT_NODEREF), (Object)rootNodeRef);
        }
        return rootNodeRef;
    }

    public static String normalizePath(String path) {
        if (((String)(path = ((String)path).replace('\\', '/'))).length() == 0) {
            path = "/";
        } else if (((String)path).length() > 1) {
            if (!((String)path).startsWith("/")) {
                path = "/" + (String)path;
            }
            if (((String)path).endsWith("/")) {
                path = ((String)path).substring(0, ((String)path).length() - 1);
            }
        }
        return path;
    }

    public static String getFirstFolder(String normalizedPath) {
        int nextSeparator = normalizedPath.indexOf(47, 1);
        if (nextSeparator < 0) {
            return null;
        }
        return normalizedPath.substring(0, nextSeparator);
    }

    public VFSNode getNodeByPath(UserData userData, String path, int callContext) throws AuthenticationRequiredException {
        if ((path = AlfrescoVirtualFileSystem.normalizePath(path)).startsWith(this.HISTORY_PATH_PREFIX)) {
            return this.getNodeByHistoryPath(path);
        }
        if (path.contains(this.NODEID_PATH_PREFIX)) {
            return this.getNodeByNodeidPath(path);
        }
        FileInfo fileInfo = this.getFileInfoByRepositoryPath(path);
        if (fileInfo == null) {
            return null;
        }
        return this.convertFileInfo(fileInfo, path);
    }

    protected VFSNode getNodeByNodeidPath(String path) {
        FileInfo fileInfo = this.getFileInfoByNodeidPath(path);
        if (fileInfo == null) {
            return null;
        }
        return this.convertFileInfo(fileInfo, path);
    }

    protected VFSNode getNodeByHistoryPath(String path) {
        FileInfo liveNode;
        String remaining = path.substring(this.HISTORY_PATH_PREFIX.length());
        int firstSeparator = remaining.indexOf(47);
        if (firstSeparator < 1) {
            return null;
        }
        String versionLabel = remaining.substring(0, firstSeparator);
        String originalPath = remaining.substring(firstSeparator);
        FileInfo fileInfo = liveNode = originalPath.contains(this.NODEID_PATH_PREFIX) ? this.getFileInfoByNodeidPath(originalPath) : this.getFileInfoByRepositoryPath(originalPath);
        if (liveNode == null) {
            return null;
        }
        if (liveNode.isFolder()) {
            return null;
        }
        VersionHistory versionHistory = this.getVersionService().getVersionHistory(liveNode.getNodeRef());
        if (versionHistory == null) {
            if (liveNode.isLink()) {
                return null;
            }
            return new DocumentNode(liveNode, path, this, true);
        }
        for (Version version : versionHistory.getAllVersions()) {
            if (!versionLabel.equals(version.getVersionLabel())) continue;
            FileInfo frozen = this.getFileFolderService().getFileInfo(version.getFrozenStateNodeRef());
            return new DocumentNode(frozen, path, this, true);
        }
        return null;
    }

    protected FileInfo getFileInfoByRepositoryPath(String path) {
        NodeRef rootNodeRef;
        try {
            rootNodeRef = this.getRootNodeRef();
        }
        catch (Exception e) {
            AlfrescoVirtualFileSystem.checkForRetryingException(e);
            this.logger.error("Error getting root node of VFS.", (Throwable)e);
            return null;
        }
        try {
            return this.webDavHelper.getNodeForPath(rootNodeRef, path);
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }

    protected FileInfo getFileInfoByNodeidPath(String path) {
        int index = path.indexOf(this.NODEID_PATH_PREFIX) + this.NODEID_PATH_PREFIX.length();
        String remaining = path.substring(index);
        String[] pathElements = remaining.split("/");
        if (pathElements.length != 2 || pathElements[0].length() <= 0 || pathElements[0].length() <= 1) {
            return null;
        }
        NodeRef nodeRef = new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, pathElements[0]);
        try {
            return this.fileFolderService.getFileInfo(nodeRef);
        }
        catch (InvalidNodeRefException inre) {
            return null;
        }
    }

    public VFSNode convertFileInfo(FileInfo fileInfo, String path) {
        if (fileInfo.isLink()) {
            return null;
        }
        if (fileInfo.isHidden()) {
            return null;
        }
        if (fileInfo.isFolder()) {
            return this.factoryFolderNode(fileInfo, path);
        }
        if (fileInfo.getProperties().get(ContentModel.PROP_WORKING_COPY_LABEL) != null && this.getCheckOutCheckInService().isWorkingCopy(fileInfo.getNodeRef())) {
            return null;
        }
        return this.factoryDocumentNode(fileInfo, path);
    }

    protected VFSNode factoryFolderNode(FileInfo fileInfo, String path) {
        return new FolderNode(fileInfo, path, this);
    }

    protected VFSNode factoryDocumentNode(FileInfo fileInfo, String path) {
        return new DocumentNode(fileInfo, path, this);
    }

    protected String getTenantDomain() {
        String tenantDomain = this.tenantService.getCurrentUserDomain();
        if (tenantDomain == null) {
            return "";
        }
        return tenantDomain;
    }

    public VFSDocumentNode createDocument(UserData userData, String path, VermeerRequest request, int callContext) throws AuthenticationRequiredException, org.alfresco.officeservices.exceptions.AccessDeniedException {
        return this.createDocument(userData, path, request.getAttachedFileInputStream(), callContext);
    }

    public VFSDocumentNode createDocument(UserData userData, String path, InputStream content, int callContext) throws AuthenticationRequiredException, org.alfresco.officeservices.exceptions.AccessDeniedException, ContentIOException {
        FileInfo newNodeInfo;
        FileInfo parentNodeInfo;
        NodeRef rootNodeRef;
        path = AlfrescoVirtualFileSystem.normalizePath(path);
        String[] splitPath = this.webDavHelper.splitPath(path);
        try {
            rootNodeRef = this.getRootNodeRef();
        }
        catch (Exception e) {
            AlfrescoVirtualFileSystem.checkForRetryingException(e);
            this.logger.error("Error getting root node of VFS.", (Throwable)e);
            return null;
        }
        try {
            parentNodeInfo = this.webDavHelper.getNodeForPath(rootNodeRef, splitPath[0]);
        }
        catch (Exception e) {
            AlfrescoVirtualFileSystem.checkForRetryingException(e);
            return null;
        }
        try {
            newNodeInfo = this.getFileFolderService().create(parentNodeInfo.getNodeRef(), splitPath[1], ContentModel.TYPE_CONTENT);
        }
        catch (AccessDeniedException ade) {
            throw new org.alfresco.officeservices.exceptions.AccessDeniedException((Throwable)ade);
        }
        catch (Exception e) {
            AlfrescoVirtualFileSystem.checkForRetryingException(e);
            return null;
        }
        VFSDocumentNode doc = (VFSDocumentNode)this.convertFileInfo(newNodeInfo, path);
        PushbackInputStream internalContent = new PushbackInputStream(content, 1);
        boolean hasContent = false;
        try {
            byte[] tempBuffer = new byte[1];
            int bytesRead = internalContent.read(tempBuffer);
            if (bytesRead == 1) {
                hasContent = true;
                internalContent.unread(tempBuffer, 0, 1);
            }
        }
        catch (IOException ioe) {
            this.logger.error("Error accessing content stream of new document", (Throwable)ioe);
            return doc;
        }
        if (hasContent) {
            if (!doc.storeContent((InputStream)internalContent, callContext)) {
                throw new ContentIOException("Failed to store content from file: \n   path: " + path);
            }
        } else {
            ContentWriter writer = this.getFileFolderService().getWriter(newNodeInfo.getNodeRef());
            writer.guessMimetype(newNodeInfo.getName());
            writer.guessEncoding();
            writer.putContent((InputStream)new ByteArrayInputStream(new byte[0]));
        }
        return doc;
    }

    public VFSNode createFolder(UserData userData, String path, int callContext) throws AuthenticationRequiredException {
        FileInfo newNodeInfo;
        FileInfo parentNodeInfo;
        NodeRef rootNodeRef;
        path = AlfrescoVirtualFileSystem.normalizePath(path);
        String[] splitPath = this.webDavHelper.splitPath(path);
        try {
            rootNodeRef = this.getRootNodeRef();
        }
        catch (Exception e) {
            AlfrescoVirtualFileSystem.checkForRetryingException(e);
            this.logger.error("Error getting root node of VFS.", (Throwable)e);
            return null;
        }
        try {
            parentNodeInfo = this.webDavHelper.getNodeForPath(rootNodeRef, splitPath[0]);
        }
        catch (Exception e) {
            AlfrescoVirtualFileSystem.checkForRetryingException(e);
            return null;
        }
        try {
            newNodeInfo = this.getFileFolderService().create(parentNodeInfo.getNodeRef(), splitPath[1], ContentModel.TYPE_FOLDER);
        }
        catch (Exception e) {
            AlfrescoVirtualFileSystem.checkForRetryingException(e);
            return null;
        }
        try {
            Pair<String, String> activitySiteAndPath = this.getActivitySiteAndPath(newNodeInfo.getNodeRef());
            if (!"".equals(activitySiteAndPath.getFirst())) {
                this.activityPoster.postFileFolderAdded((String)activitySiteAndPath.getFirst(), this.getTenantDomain(), (String)activitySiteAndPath.getSecond(), newNodeInfo);
            }
        }
        catch (Exception e) {
            this.logger.error("AlfrescoVirtualFileSystem.createFolder: Error posting activity.", (Throwable)e);
        }
        return this.convertFileInfo(newNodeInfo, path);
    }

    public VFSNode getNodeFromList(Guid listId, String inFolder, String fileLeafRef) {
        NodeRef listRoot = null;
        if (listId.equals((Object)LISTID_ROOT_DOCUMENTS) || inFolder != null && inFolder.length() > 0) {
            try {
                listRoot = this.getRootNodeRef();
            }
            catch (Exception e) {
                AlfrescoVirtualFileSystem.checkForRetryingException(e);
                this.logger.error("Error getting root node of VFS.", (Throwable)e);
                return null;
            }
        } else {
            listRoot = new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, listId.toInnerString().toLowerCase());
        }
        String pathInList = null;
        if (inFolder != null && inFolder.length() > 0) {
            pathInList = AlfrescoVirtualFileSystem.normalizePath(inFolder);
        }
        if (fileLeafRef != null && fileLeafRef.length() > 0) {
            pathInList = pathInList != null ? pathInList + "/" + fileLeafRef : fileLeafRef;
        }
        try {
            if (pathInList != null) {
                FileInfo folderFileInfo = this.webDavHelper.getNodeForPath(listRoot, pathInList);
                return this.convertFileInfo(folderFileInfo, pathInList);
            }
            FileInfo listFileInfo = this.getFileFolderService().getFileInfo(listRoot);
            String pathToList = listId.equals((Object)LISTID_ROOT_DOCUMENTS) ? "/" : "/" + listFileInfo.getName();
            return this.convertFileInfo(listFileInfo, pathToList);
        }
        catch (FileNotFoundException | InvalidNodeRefException e) {
            return null;
        }
    }

    public Pair<String, String> getActivitySiteAndPath(NodeRef nodeRef) {
        NodeRef sitePathRelativeTo;
        String siteId;
        try {
            siteId = this.siteService.getSiteShortName(nodeRef);
            if (siteId == null) {
                siteId = "";
            }
        }
        catch (Exception e) {
            siteId = "";
        }
        try {
            if (siteId.equals("")) {
                sitePathRelativeTo = this.getRootNodeRef();
            } else {
                try {
                    sitePathRelativeTo = this.siteService.getContainer(siteId, "documentLibrary");
                }
                catch (Exception e) {
                    this.logger.debug("AlfrescoVirtualFileSystem.createFolder: No documentLibrary container found.");
                    sitePathRelativeTo = this.getRootNodeRef();
                }
            }
        }
        catch (Exception e) {
            this.logger.debug("getActivityPathForNode: Error getting root node for activity post", (Throwable)e);
            return new Pair((Object)siteId, (Object)"/");
        }
        try {
            return new Pair((Object)siteId, (Object)this.getWebDavHelper().getPathFromNode(sitePathRelativeTo, nodeRef));
        }
        catch (Exception error) {
            this.logger.debug("AlfrescoVirtualFileSystem.getActivityPathForNode: Cannot build a path for activity post.");
            return new Pair((Object)siteId, (Object)"/");
        }
    }

    public FileInfo getFileInfoForPath(NodeRef startingNode, String path) throws FileNotFoundException {
        return this.webDavHelper.getNodeForPath(startingNode, path);
    }

    public FileInfo getFileInfoForPath(String path) throws FileNotFoundException {
        NodeRef rootNodeRef;
        try {
            rootNodeRef = this.getRootNodeRef();
        }
        catch (Exception e) {
            AlfrescoVirtualFileSystem.checkForRetryingException(e);
            this.logger.error("Error getting root node of VFS.", (Throwable)e);
            throw new FileNotFoundException("Error getting root node of VFS.");
        }
        return this.getFileInfoForPath(rootNodeRef, path);
    }

    public String getSitePath(HttpServletRequest request) {
        if (this.sitePathOverwrite != null && this.sitePathOverwrite.length() > 0) {
            return this.sitePathOverwrite;
        }
        return request.getContextPath().equals("/") ? "/aos" : request.getContextPath() + "/aos";
    }

    public String getSitePrefix(HttpServletRequest request) {
        if (this.baseUrlOverwrite != null && this.baseUrlOverwrite.length() > 0) {
            return this.baseUrlOverwrite;
        }
        String protocol = request.isSecure() ? "https://" : "http://";
        int defaultPort = request.isSecure() ? 443 : 80;
        String portString = request.getLocalPort() != defaultPort ? ":" + Integer.toString(request.getLocalPort()) : "";
        return protocol + request.getServerName() + portString + this.getSitePath(request);
    }

    public String getServerRootUrl(HttpServletRequest request) {
        if (this.baseUrlOverwrite != null && this.baseUrlOverwrite.length() > 0) {
            int startIndex = this.baseUrlOverwrite.indexOf("https://") >= 0 ? 9 : 8;
            int endIndex = this.baseUrlOverwrite.indexOf("/", startIndex);
            if (endIndex != -1) {
                return this.baseUrlOverwrite.substring(0, endIndex);
            }
            this.logger.error("Invalid value for aos.baseUrlOverwrite");
        }
        String protocol = request.isSecure() ? "https://" : "http://";
        int defaultPort = request.isSecure() ? 443 : 80;
        String portString = request.getLocalPort() != defaultPort ? ":" + Integer.toString(request.getLocalPort()) : "";
        return protocol + request.getServerName() + portString;
    }

    public static void checkForRetryingException(Throwable t) {
        if (RetryingTransactionHelper.extractRetryCause((Throwable)t) != null) {
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new AlfrescoRuntimeException("Retry", t);
        }
    }

    public AuthenticationService getAuthenticationService() {
        return this.authenticationService;
    }

    public void setAuthenticationService(AuthenticationService authenticationService) {
        this.authenticationService = authenticationService;
    }

    public NodeService getNodeService() {
        return this.nodeService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public FileFolderService getFileFolderService() {
        return this.fileFolderService;
    }

    public void setFileFolderService(FileFolderService fileFolderService) {
        this.fileFolderService = fileFolderService;
    }

    public CheckOutCheckInService getCheckOutCheckInService() {
        return this.checkOutCheckInService;
    }

    public void setCheckOutCheckInService(CheckOutCheckInService checkOutCheckInService) {
        this.checkOutCheckInService = checkOutCheckInService;
    }

    public LockService getLockService() {
        return this.lockService;
    }

    public void setLockService(LockService lockService) {
        this.lockService = lockService;
    }

    public VersionService getVersionService() {
        return this.versionService;
    }

    public void setVersionService(VersionService versionService) {
        this.versionService = versionService;
    }

    public DictionaryService getDictionaryService() {
        return this.dictionaryService;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public NamespaceService getNamespaceService() {
        return this.namespaceService;
    }

    public void setNamespaceService(NamespaceService namespaceService) {
        this.namespaceService = namespaceService;
    }

    public MimetypeService getMimetypeService() {
        return this.mimetypeService;
    }

    public void setMimetypeService(MimetypeService mimetypeService) {
        this.mimetypeService = mimetypeService;
    }

    public SearchService getSearchService() {
        return this.searchService;
    }

    public void setSearchService(SearchService searchService) {
        this.searchService = searchService;
    }

    public BehaviourFilter getPolicyBehaviourFilter() {
        return this.policyBehaviourFilter;
    }

    public void setPolicyBehaviourFilter(BehaviourFilter policyBehaviourFilter) {
        this.policyBehaviourFilter = policyBehaviourFilter;
    }

    public TransactionService getTransactionService() {
        return this.transactionService;
    }

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    public TenantService getTenantService() {
        return this.tenantService;
    }

    public void setTenantService(TenantService tenantService) {
        this.tenantService = tenantService;
    }

    public SiteService getSiteService() {
        return this.siteService;
    }

    public void setSiteService(SiteService siteService) {
        this.siteService = siteService;
    }

    public WebDAVHelper getWebDavHelper() {
        return this.webDavHelper;
    }

    public void setWebDavHelper(WebDAVHelper webDavHelper) {
        this.webDavHelper = webDavHelper;
    }

    public WebDAVServlet.WebDAVInitParameters getWebDavInitParams() {
        return this.webDavInitParams;
    }

    public void setWebDavInitParams(WebDAVServlet.WebDAVInitParameters webDavInitParams) {
        this.webDavInitParams = webDavInitParams;
    }

    public AuthenticationContext getAuthenticationContext() {
        return this.authenticationContext;
    }

    public void setAuthenticationContext(AuthenticationContext authenticationContext) {
        this.authenticationContext = authenticationContext;
    }

    public WebDAVActivityPoster getActivityPoster() {
        return this.activityPoster;
    }

    public void setActivityPoster(WebDAVActivityPoster activityPoster) {
        this.activityPoster = activityPoster;
    }

    public DataModelMappingConfiguration getDataModelMappingConfiguration() {
        return this.dataModelMappingConfiguration;
    }

    public void setDataModelMappingConfiguration(DataModelMappingConfiguration dataModelMappingConfiguration) {
        this.dataModelMappingConfiguration = dataModelMappingConfiguration;
    }

    public IOContentFilterRegistry getIoContentFilterRegistry() {
        return this.ioContentFilterRegistry;
    }

    public void setIoContentFilterRegistry(IOContentFilterRegistry ioContentFilterRegistry) {
        this.ioContentFilterRegistry = ioContentFilterRegistry;
    }

    public SimpleCache<String, NodeRef> getSingletonCache() {
        return this.singletonCache;
    }

    public void setSingletonCache(SimpleCache<String, NodeRef> singletonCache) {
        this.singletonCache = singletonCache;
    }

    public String getBaseUrlOverwrite() {
        return this.baseUrlOverwrite;
    }

    public void setBaseUrlOverwrite(String baseUrlOverwrite) {
        this.baseUrlOverwrite = baseUrlOverwrite;
    }

    public String getSitePathOverwrite() {
        return this.sitePathOverwrite;
    }

    public void setSitePathOverwrite(String sitePathOverwrite) {
        this.sitePathOverwrite = sitePathOverwrite;
    }

    public boolean isFilterIgnoresOOXMLProtected() {
        return this.filterIgnoresOOXMLProtected;
    }

    public void setFilterIgnoresOOXMLProtected(boolean filterIgnoresOOXMLProtected) {
        this.filterIgnoresOOXMLProtected = filterIgnoresOOXMLProtected;
    }

    public Set<String> getIdentityServiceScopes() {
        return Stream.of(this.identityServiceScopes.split(",")).map(String::trim).collect(Collectors.toUnmodifiableSet());
    }

    public void setIdentityServiceScopes(String identityServiceScopes) {
        this.identityServiceScopes = identityServiceScopes;
    }
}

