/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.aosmodule.vfs;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.alfresco.module.aosmodule.vfs.AlfrescoVirtualFileSystem;
import org.alfresco.officeservices.UserData;
import org.alfresco.officeservices.datamodel.Guid;
import org.alfresco.officeservices.protocol.VermeerRequest;
import org.alfresco.officeservices.protocol.VermeerReturnDictionary;
import org.alfresco.officeservices.protocol.VermeerReturnDictionaryDirectory;
import org.alfresco.officeservices.protocol.VermeerReturnDictionaryLibrary;
import org.alfresco.officeservices.vfs.VFSDocumentNode;
import org.alfresco.officeservices.vfs.VFSNode;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.model.FileNotFoundException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.util.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FolderNode
implements VFSNode {
    protected AlfrescoVirtualFileSystem vfs;
    protected FileInfo fileInfo;
    protected String relativePath;
    protected static Logger logger = LoggerFactory.getLogger(FolderNode.class);

    public FolderNode(FileInfo info, String path, AlfrescoVirtualFileSystem avfs) {
        this.fileInfo = info;
        this.relativePath = path;
        this.vfs = avfs;
    }

    public FileInfo getFileInfo() {
        return this.fileInfo;
    }

    public NodeRef getNodeRef() {
        return this.fileInfo.getNodeRef();
    }

    public String getRelativePath() {
        return this.relativePath;
    }

    public String getName(int callContext) {
        return this.fileInfo.getName();
    }

    public VermeerReturnDictionary getVermeerMetaInfoDictionary(int callContext) {
        String libraryPath = AlfrescoVirtualFileSystem.getFirstFolder(this.relativePath);
        if (libraryPath != null) {
            VFSNode libraryFolder = null;
            try {
                libraryFolder = this.vfs.getNodeByPath(null, libraryPath, callContext);
                if (libraryFolder instanceof VFSDocumentNode) {
                    libraryFolder = null;
                }
            }
            catch (Exception e) {
                AlfrescoVirtualFileSystem.checkForRetryingException(e);
                libraryFolder = null;
            }
            Guid listId = libraryFolder == null ? AlfrescoVirtualFileSystem.LISTID_ROOT_DOCUMENTS : Guid.parse((String)((FolderNode)libraryFolder).getFileInfo().getNodeRef().getId());
            VermeerReturnDictionaryDirectory result = new VermeerReturnDictionaryDirectory(this.fileInfo.getCreatedDate(), this.fileInfo.getModifiedDate(), listId.toString());
            result.setMinorVersionsEnabled(true);
            return result;
        }
        Guid listId = this.relativePath.equals("/") ? AlfrescoVirtualFileSystem.LISTID_ROOT_DOCUMENTS : Guid.parse((String)this.fileInfo.getNodeRef().getId());
        return new VermeerReturnDictionaryLibrary(listId.toString(), this.fileInfo.getName(), this.fileInfo.getCreatedDate(), this.fileInfo.getModifiedDate(), true);
    }

    public VFSNode getContainmentByName(UserData userData, String name, int callContext) {
        try {
            FileInfo item = this.vfs.getFileInfoForPath(this.fileInfo.getNodeRef(), name);
            Object itemPath = this.relativePath;
            if (!((String)itemPath).endsWith("/")) {
                itemPath = (String)itemPath + "/";
            }
            itemPath = (String)itemPath + name;
            return this.vfs.convertFileInfo(item, (String)itemPath);
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }

    public List<VFSNode> getEnumerableContainees(UserData userData, int callContext) {
        List childFileInfos;
        try {
            childFileInfos = this.vfs.getWebDavHelper().getChildren(this.fileInfo);
        }
        catch (Exception e) {
            AlfrescoVirtualFileSystem.checkForRetryingException(e);
            return new ArrayList<VFSNode>();
        }
        ArrayList<VFSNode> result = new ArrayList<VFSNode>(childFileInfos.size());
        Object itemPathSuffix = this.relativePath;
        if (!((String)itemPathSuffix).endsWith("/")) {
            itemPathSuffix = (String)itemPathSuffix + "/";
        }
        for (FileInfo childFileInfo : childFileInfos) {
            VFSNode n = this.vfs.convertFileInfo(childFileInfo, (String)itemPathSuffix + childFileInfo.getName());
            if (n == null) continue;
            result.add(n);
        }
        return result;
    }

    public Date getDateLastModified(int callContext) {
        return this.fileInfo.getModifiedDate();
    }

    public boolean rename(String newName, int callContext) {
        logger.debug("FolderNode.rename ENTER newName=" + newName);
        try {
            this.vfs.getFileFolderService().rename(this.fileInfo.getNodeRef(), newName);
            logger.debug("Rename successfull");
            logger.debug("FolderNode.rename EXIT true");
            return true;
        }
        catch (Exception e) {
            AlfrescoVirtualFileSystem.checkForRetryingException(e);
            logger.debug("Rename failed", (Throwable)e);
            logger.debug("FolderNode.rename EXIT false");
            return false;
        }
    }

    public boolean delete(int callContext) {
        try {
            NodeRef parentNodeRef = this.vfs.getNodeService().getPrimaryParent(this.fileInfo.getNodeRef()).getParentRef();
            this.vfs.getFileFolderService().delete(this.fileInfo.getNodeRef());
            try {
                FileInfo parentFileInfo = this.vfs.getFileFolderService().getFileInfo(parentNodeRef);
                Pair<String, String> activitySiteAndPath = this.vfs.getActivitySiteAndPath(parentNodeRef);
                if (!"".equals(activitySiteAndPath.getFirst())) {
                    this.vfs.getActivityPoster().postFileFolderDeleted((String)activitySiteAndPath.getFirst(), this.vfs.getTenantDomain(), (String)activitySiteAndPath.getSecond(), parentFileInfo, this.fileInfo);
                }
            }
            catch (Exception e) {
                logger.error("FolderNode.delete: Error posting activity.", (Throwable)e);
            }
            return true;
        }
        catch (Exception e) {
            AlfrescoVirtualFileSystem.checkForRetryingException(e);
            logger.debug("Error deleting node", (Throwable)e);
            return false;
        }
    }

    public boolean move(UserData userData, String destinationPath, int callContext) {
        logger.debug("FolderNode.move ENTER destinationPath=" + destinationPath);
        try {
            FileInfo destination;
            String newParentPath = "/";
            String newName = destinationPath;
            int i = destinationPath.lastIndexOf(47);
            if (i >= 0) {
                newParentPath = destinationPath.substring(0, i);
                newName = destinationPath.substring(i + 1);
            }
            if ((destination = this.vfs.getFileInfoForPath(newParentPath)) == null) {
                logger.debug("Move failed. Destination folder does not exist.");
                logger.debug("FolderNode.move EXIT false");
                return false;
            }
            if (!destination.isFolder() || destination.isLink()) {
                logger.debug("Move failed. Destination is not a folder.");
                logger.debug("FolderNode.move EXIT false");
                return false;
            }
            this.vfs.getFileFolderService().move(this.fileInfo.getNodeRef(), destination.getNodeRef(), newName);
            logger.debug("Move successfull");
            logger.debug("FolderNode.move EXIT true");
            return true;
        }
        catch (Exception e) {
            AlfrescoVirtualFileSystem.checkForRetryingException(e);
            logger.debug("Move failed", (Throwable)e);
            logger.debug("FolderNode.move EXIT false");
            return false;
        }
    }

    public boolean copy(UserData userData, String destinationPath, int callContext) {
        return false;
    }

    public VFSDocumentNode createNewFile(UserData userData, String filename, InputStream content, int callContext) {
        return null;
    }

    public VFSDocumentNode createNewFile(UserData userData, String filename, VermeerRequest request, int callContext) {
        return null;
    }

    public VFSNode createNewFolder(UserData userData, String foldername, int callContext) {
        return null;
    }
}

