/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.aos;

import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.alfresco.module.aosmodule.auth.service.AosAuthenticationUriService;
import org.alfresco.module.aosmodule.auth.service.AosIDSContextService;
import org.alfresco.repo.security.authentication.identityservice.IdentityServiceConfig;
import org.alfresco.repo.security.authentication.identityservice.IdentityServiceFacade;
import org.alfresco.repo.web.scripts.aos.AbstractAosWebScript;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;
import org.springframework.extensions.webscripts.WebScriptResponse;

public class AosAuthenticate
extends AbstractAosWebScript {
    private final AosAuthenticationUriService uriService;
    private final AosIDSContextService idsContextService;

    public AosAuthenticate(AosAuthenticationUriService uriService, AosIDSContextService idsContextService) {
        this.uriService = uriService;
        this.idsContextService = idsContextService;
    }

    public void execute(WebScriptRequest req, WebScriptResponse res) throws IOException {
        HttpServletResponse servletResponse = this.findServletResponse(res);
        IdentityServiceConfig identityServiceConfig = this.idsContextService.getIdentityServiceBean(IdentityServiceConfig.class);
        IdentityServiceFacade identityServiceFacade = this.idsContextService.getIdentityServiceBean(IdentityServiceFacade.class);
        if (servletResponse != null) {
            if (identityServiceConfig == null) {
                throw new WebScriptException(404, "The integration between AOS and IDS may not be configured.");
            }
            if (identityServiceFacade == null) {
                throw new WebScriptException(404, "User not authenticated because IdentityServiceFacade was not set.");
            }
            servletResponse.sendRedirect(this.uriService.getIdpLoginURI(identityServiceConfig, identityServiceFacade));
        }
    }
}

