/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.officeservices;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import javax.xml.parsers.ParserConfigurationException;
import org.alfresco.officeservices.ServiceLogger;
import org.alfresco.officeservices.UserData;
import org.alfresco.officeservices.exceptions.AuthenticationRequiredException;
import org.alfresco.officeservices.protocol.SSPError;
import org.alfresco.officeservices.protocol.SimpleSoapParser;

public abstract class AbstractSoapService
extends HttpServlet {
    private static final long serialVersionUID = 6304008888650541548L;
    private static final ServiceLogger logger = new ServiceLogger(AbstractSoapService.class);
    protected static ThreadLocal<SimpleDateFormat> threadLocalDateFormatSoap = new ThreadLocal();

    protected static SimpleDateFormat getThreadDateFormatSoap() {
        SimpleDateFormat result = threadLocalDateFormatSoap.get();
        if (result == null) {
            result = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
            result.setTimeZone(TimeZone.getTimeZone("UTC"));
            threadLocalDateFormatSoap.set(result);
        }
        return result;
    }

    public abstract void soapService(UserData var1, String var2, SimpleSoapParser var3, HttpServletRequest var4, HttpServletResponse var5) throws IOException, AuthenticationRequiredException;

    public abstract UserData negotiateAuthentication(HttpServletRequest var1, HttpServletResponse var2) throws IOException;

    public abstract void requestAuthentication(HttpServletRequest var1, HttpServletResponse var2) throws IOException;

    public abstract void invalidateAuthentication(UserData var1, HttpServletRequest var2, HttpServletResponse var3) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        block24: {
            UserData userData;
            if (logger.isTraceEnabled()) {
                logger.traceEnter();
            }
            if (logger.isDebugEnabled()) {
                logger.debug("doPost: negogiating authentication");
            }
            if ((userData = this.negotiateAuthentication(request, response)) == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("doPost: authentication negogiation requested immediate return.");
                }
                if (logger.isTraceEnabled()) {
                    logger.traceExit();
                }
                return;
            }
            try {
                SimpleSoapParser ssp = null;
                try {
                    ssp = new SimpleSoapParser((InputStream)request.getInputStream());
                }
                catch (ParserConfigurationException pce) {
                    logger.error("doPost: Error creating SOAP message parser. Misconfigured XML framework.", pce);
                    SimpleSoapParser.soapErrorResponse(response, "Misconfigured XML framework on the server.");
                    if (logger.isTraceEnabled()) {
                        logger.traceExit();
                    }
                    this.invalidateAuthentication(userData, request, response);
                    return;
                }
                catch (IOException ioe) {
                    block23: {
                        logger.error("doPost: Error creating SOAP message parser. Can not read input stream.", ioe);
                        SimpleSoapParser.soapErrorResponse(response, "Error reading input stream.");
                        if (!logger.isTraceEnabled()) break block23;
                        logger.traceExit();
                    }
                    this.invalidateAuthentication(userData, request, response);
                    return;
                }
                if (ssp == null) break block24;
                if (ssp.getLastError() != SSPError.NONE) {
                    logger.error("doPost: Error decoding SOAP message. Last error code=" + ssp.getLastError());
                    SimpleSoapParser.soapErrorResponse(response, "Malformed soap message.");
                    break block24;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("doPost: called RPC method name is \"" + ssp.getMethodName() + "\"");
                }
                try {
                    this.soapService(userData, ssp.getMethodName(), ssp, request, response);
                }
                catch (AuthenticationRequiredException are) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("doPost: soapService requested authentication.");
                    }
                    this.requestAuthentication(request, response);
                }
                catch (Exception e) {
                    logger.error("doPost: Uncaught Exception in soapService:", e);
                    try {
                        SimpleSoapParser.soapErrorResponse(response, "Unexpected error while handling request.");
                        break block24;
                    }
                    catch (Exception e2) {
                        logger.error("doPost: Follow-up error while sending error response on unhandled Exception", e2);
                    }
                }
                break block24;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                this.invalidateAuthentication(userData, request, response);
            }
        }
        if (logger.isTraceEnabled()) {
            logger.traceExit();
        }
    }

    public static void writeXmlAttribute(PrintStream out, String attributeName, String attributeValue, boolean doubleQuoted) throws IOException {
        out.print(" ");
        out.print(attributeName);
        out.print("=");
        out.print(doubleQuoted ? "\"" : "'");
        if (attributeValue != null) {
            block9: for (int i = 0; i < attributeValue.length(); ++i) {
                char c = attributeValue.charAt(i);
                switch (c) {
                    case '\r': {
                        out.print("&#013;");
                        continue block9;
                    }
                    case '\n': {
                        out.print("&#010;");
                        continue block9;
                    }
                    case '&': {
                        out.print("&amp;");
                        continue block9;
                    }
                    case '\"': {
                        out.print("&quot;");
                        continue block9;
                    }
                    case '\'': {
                        out.print("&apos;");
                        continue block9;
                    }
                    case '<': {
                        out.print("&lt;");
                        continue block9;
                    }
                    case '>': {
                        out.print("&gt;");
                        continue block9;
                    }
                    default: {
                        out.print(c);
                    }
                }
            }
        }
        out.print(doubleQuoted ? "\"" : "'");
    }

    public static void writeEncoded(PrintStream out, String value) {
        if (value != null) {
            block9: for (int i = 0; i < value.length(); ++i) {
                char c = value.charAt(i);
                switch (c) {
                    case '\r': {
                        out.print("&#013;");
                        continue block9;
                    }
                    case '\n': {
                        out.print("&#010;");
                        continue block9;
                    }
                    case '&': {
                        out.print("&amp;");
                        continue block9;
                    }
                    case '\"': {
                        out.print("&quot;");
                        continue block9;
                    }
                    case '\'': {
                        out.print("&apos;");
                        continue block9;
                    }
                    case '<': {
                        out.print("&lt;");
                        continue block9;
                    }
                    case '>': {
                        out.print("&gt;");
                        continue block9;
                    }
                    default: {
                        out.print(c);
                    }
                }
            }
        }
    }

    public static void writeEncoded2(PrintStream out, String value) {
        if (value != null) {
            block5: for (int i = 0; i < value.length(); ++i) {
                char c = value.charAt(i);
                switch (c) {
                    case '&': {
                        out.print("&amp;");
                        continue block5;
                    }
                    case '<': {
                        out.print("&lt;");
                        continue block5;
                    }
                    case '>': {
                        out.print("&gt;");
                        continue block5;
                    }
                    default: {
                        out.print(c);
                    }
                }
            }
        }
    }

    public static String formatDate(Date d) {
        return AbstractSoapService.getThreadDateFormatSoap().format(d);
    }

    public static Date parseDate(String source) {
        if (source == null) {
            return null;
        }
        try {
            return AbstractSoapService.getThreadDateFormatSoap().parse(source);
        }
        catch (ParseException e) {
            return null;
        }
    }
}

