/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.officeservices;

import jakarta.servlet.ServletException;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import org.alfresco.officeservices.IndividualResponseRuntimeException;
import org.alfresco.officeservices.ServiceLogger;
import org.alfresco.officeservices.StandardHttpService;
import org.alfresco.officeservices.URLPathDecoder;
import org.alfresco.officeservices.UserData;
import org.alfresco.officeservices.exceptions.AccessDeniedException;
import org.alfresco.officeservices.exceptions.AuthenticationRequiredException;
import org.alfresco.officeservices.protocol.HtmlEncoder;
import org.alfresco.officeservices.vfs.CheckoutResult;
import org.alfresco.officeservices.vfs.VFSDocumentNode;
import org.alfresco.officeservices.vfs.VFSNode;
import org.alfresco.officeservices.vfs.VirtualFileSystem;

public abstract class StandardWebdavService
extends StandardHttpService {
    private static final long serialVersionUID = 1729911490069883821L;
    private static final ServiceLogger logger = new ServiceLogger(StandardWebdavService.class);
    protected int MAX_TIMEOUT_IN_MINUTES = 1440;
    protected int DEFAULT_TIMEOUT_IN_MINUTES = 10;
    public static final int SC_MULTI_STATUS = 207;
    protected ThreadLocal<SimpleDateFormat> threadLocalDateFormatPropfind = new ThreadLocal();

    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (req.getMethod().equals("PROPFIND")) {
            this.doPropfind(req, resp);
        } else if (req.getMethod().equals("PROPPATCH")) {
            this.doProppatch(req, resp);
        } else if (req.getMethod().equals("LOCK")) {
            this.doLock(req, resp);
        } else if (req.getMethod().equals("UNLOCK")) {
            this.doUnlock(req, resp);
        } else if (req.getMethod().equals("MKCOL")) {
            this.doMkcol(req, resp);
        } else if (req.getMethod().equals("MOVE")) {
            this.doMove(req, resp);
        } else {
            super.service(req, resp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doOptions(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        UserData userData;
        if (logger.isTraceEnabled()) {
            logger.traceEnter();
        }
        if (logger.isDebugEnabled()) {
            logger.debug("doOptions: negogiating authentication");
        }
        if ((userData = this.negotiateAuthentication(req, resp)) == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("doOptions: authentication negogiation requested immediate return.");
            }
            if (logger.isTraceEnabled()) {
                logger.traceExit();
            }
            return;
        }
        try {
            resp.setStatus(200);
        }
        finally {
            this.invalidateAuthentication(userData, req, resp);
        }
        if (logger.isTraceEnabled()) {
            logger.traceExit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPropfind(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        int depth;
        VFSNode node;
        Object path;
        UserData userData;
        block28: {
            block29: {
                if (logger.isTraceEnabled()) {
                    logger.traceEnter();
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("doPropfind: negogiating authentication");
                }
                if ((userData = this.negotiateAuthentication(req, resp)) == null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("doPropfind: authentication negogiation requested immediate return.");
                    }
                    if (logger.isTraceEnabled()) {
                        logger.traceExit();
                    }
                    return;
                }
                String pathInfo = req.getPathInfo();
                path = req.getServletPath();
                if (pathInfo != null) {
                    path = (String)path + pathInfo;
                }
                path = this.preProcessRequestedPath((String)path);
                if (logger.isDebugEnabled()) {
                    logger.debug("doPropfind: path=" + (String)path);
                }
                node = this.getVirtualFileSystem(userData).getNodeByPath(userData, (String)path, 516);
                depth = 0;
                String depthHeaderParameter = req.getHeader("Depth");
                if (depthHeaderParameter != null) {
                    try {
                        depth = Integer.parseInt(depthHeaderParameter);
                        if (depth < 0) {
                            depth = 0;
                        }
                        if (depth > 1) {
                            depth = 1;
                        }
                    }
                    catch (NumberFormatException nfe) {
                        depth = 0;
                    }
                }
                if (node != null) break block28;
                if (logger.isDebugEnabled()) {
                    logger.debug("doPropfind: file does not exist. path=" + (String)path);
                }
                resp.setStatus(404);
                resp.setCharacterEncoding("UTF-8");
                resp.getWriter().print("404: object not found.");
                if (!logger.isTraceEnabled()) break block29;
                logger.traceExit();
            }
            this.invalidateAuthentication(userData, req, resp);
            return;
        }
        try {
            try {
                String sitePrefix = this.getSitePrefix(req);
                resp.setContentType("text/xml");
                resp.setCharacterEncoding("UTF-8");
                PrintWriter out = resp.getWriter();
                resp.setStatus(207);
                out.print("<?xml version=\"1.0\" encoding=\"utf-8\" ?>");
                out.print("<D:multistatus xmlns:D=\"DAV:\" xmlns:Office=\"urn:schemas-microsoft-com:office:office\" xmlns:Repl=\"http://schemas.microsoft.com/repl/\" xmlns:Z=\"urn:schemas-microsoft-com:\">");
                this.emitResponseForNode(out, node, sitePrefix, (String)path, 516);
                if (depth > 0) {
                    if (!((String)path).endsWith("/")) {
                        path = (String)path + "/";
                    }
                    List<VFSNode> children = node.getEnumerableContainees(userData, 516);
                    for (VFSNode child : children) {
                        this.emitResponseForNode(out, child, sitePrefix, (String)path + child.getName(516), 516);
                    }
                }
                out.println("</D:multistatus>");
            }
            catch (AuthenticationRequiredException are) {
                if (logger.isDebugEnabled()) {
                    logger.debug("doPropfind: requested authentication.");
                }
                this.requestAuthentication(req, resp);
            }
            catch (IndividualResponseRuntimeException irre) {
                logger.debug("doPropfind: Individual Error Message Requested", irre);
                try {
                    resp.setStatus(irre.getWebdavStatus());
                    resp.setCharacterEncoding("UTF-8");
                    resp.getWriter().print(irre.getWebdavMessage());
                }
                catch (IllegalStateException illegalStateException) {
                }
            }
            catch (Exception e) {
                this.handleUnexpectedException("doPropfind", e, req, resp);
            }
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            this.invalidateAuthentication(userData, req, resp);
        }
        if (logger.isTraceEnabled()) {
            logger.traceExit();
        }
    }

    protected void emitResponseForNode(PrintWriter out, VFSNode node, String sitePrefix, String path, int callContext) {
        if (node instanceof VFSDocumentNode) {
            this.emitResponseForDocumentNode(out, (VFSDocumentNode)node, sitePrefix, path, callContext);
        } else {
            this.emitResponseForDirectoryNode(out, node, sitePrefix, path, callContext);
        }
    }

    protected SimpleDateFormat getThreadDateFormatPropfind() {
        SimpleDateFormat result = this.threadLocalDateFormatPropfind.get();
        if (result == null) {
            result = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'", Locale.US);
            result.setTimeZone(TimeZone.getTimeZone("UTC"));
            this.threadLocalDateFormatPropfind.set(result);
        }
        return result;
    }

    protected void emitResponseForDocumentNode(PrintWriter out, VFSDocumentNode documentNode, String sitePrefix, String path, int callContext) {
        String guid = this.getGuidForNode(documentNode, sitePrefix, path);
        String checkoutOwner = documentNode.getCheckoutOwner(callContext);
        out.print("\r\n");
        out.print("<D:response>");
        out.print("<D:href>" + sitePrefix + urlEncoder.encode(path) + "</D:href>");
        out.print("<D:propstat>");
        out.print("<D:prop>");
        out.print("<D:resourcetype />");
        out.print("<D:displayname>" + HtmlEncoder.encode(documentNode.getName(callContext)) + "</D:displayname>");
        out.print("<D:isFolder>f</D:isFolder>");
        if (documentNode.isLocked(callContext) || documentNode.isCheckedOut(callContext)) {
            String lockToken = documentNode.getWebdavLockToken(null, 516);
            out.print("<D:lockdiscovery>");
            out.print("<D:activelock>");
            out.print("<D:locktype><D:write/></D:locktype>");
            out.print("<D:lockscope><D:exclusive/></D:lockscope>");
            out.print("<D:depth>0</D:depth>");
            out.print("<D:owner>" + HtmlEncoder.encode(checkoutOwner) + "</D:owner>");
            out.print("<D:timeout>Second-" + (documentNode.isCheckedOut(callContext) ? "604800" : "3600") + "</D:timeout>");
            out.print("<D:locktoken><D:href>" + HtmlEncoder.encode(lockToken) + "</D:href></D:locktoken>");
            out.print("</D:activelock>");
            out.print("</D:lockdiscovery>");
        } else {
            out.print("<D:lockdiscovery/>");
        }
        out.print("<D:supportedlock>");
        out.print("<D:lockentry>");
        out.print("<D:lockscope>");
        out.print("<D:exclusive/>");
        out.print("</D:lockscope>");
        out.print("<D:locktype>");
        out.print("<D:write/>");
        out.print("</D:locktype>");
        out.print("</D:lockentry>");
        out.print("</D:supportedlock>");
        out.print("<D:getlastmodified>" + this.getThreadDateFormatPropfind().format(documentNode.getDateLastModified(callContext)) + "</D:getlastmodified>");
        out.print("<D:creationdate>" + this.getThreadDateFormatPropfind().format(documentNode.getDateLastModified(callContext)) + "</D:creationdate>");
        out.print("<D:getcontentlength>" + Long.toString(documentNode.getSize(516)) + "</D:getcontentlength>");
        out.print("<Repl:repl-uid>" + HtmlEncoder.encode("rid:{" + guid + "}") + "</Repl:repl-uid>");
        out.print("<Repl:resourcetag>" + HtmlEncoder.encode(this.getResourceTagForNode(documentNode, sitePrefix, path)) + "</Repl:resourcetag>");
        out.print("<D:getetag>" + HtmlEncoder.encode(this.getEtagForNode(documentNode, sitePrefix, path)) + "</D:getetag>");
        out.print("<Office:modifiedby>someuser</Office:modifiedby>");
        out.print("</D:prop>");
        out.print("<D:status>HTTP/1.1 200 OK</D:status>");
        out.print("</D:propstat>");
        out.print("</D:response>");
    }

    protected void emitResponseForDirectoryNode(PrintWriter out, VFSNode directoryNode, String sitePrefix, String path, int callContext) {
        String guid = this.getGuidForNode(directoryNode, sitePrefix, path);
        out.print("\r\n");
        out.print("<D:response>");
        out.print("<D:href>" + sitePrefix + urlEncoder.encode(path) + "</D:href>");
        out.print("<D:propstat>");
        out.print("<D:prop>");
        out.print("<D:displayname>" + HtmlEncoder.encode(directoryNode.getName(callContext)) + "</D:displayname>");
        out.print("<D:lockdiscovery/>");
        out.print("<D:supportedlock/>");
        out.print("<D:isFolder>t</D:isFolder>");
        out.print("<D:iscollection>1</D:iscollection>");
        out.print("<D:ishidden>0</D:ishidden>");
        out.print("<D:getcontenttype>application/octet-stream</D:getcontenttype>");
        out.print("<D:getcontentlength>0</D:getcontentlength>");
        out.print("<D:resourcetype><D:collection/></D:resourcetype>");
        out.print("<Repl:authoritative-directory>t</Repl:authoritative-directory>");
        out.print("<D:getlastmodified>" + this.getThreadDateFormatPropfind().format(directoryNode.getDateLastModified(callContext)) + "</D:getlastmodified>");
        out.print("<D:creationdate>" + this.getThreadDateFormatPropfind().format(directoryNode.getDateLastModified(callContext)) + "</D:creationdate>");
        out.print("<Repl:repl-uid>" + HtmlEncoder.encode("rid:{" + guid + "}") + "</Repl:repl-uid>");
        out.print("<Repl:resourcetag>" + HtmlEncoder.encode(this.getResourceTagForNode(directoryNode, sitePrefix, path)) + "</Repl:resourcetag>");
        out.print("<D:getetag>" + HtmlEncoder.encode(this.getEtagForNode(directoryNode, sitePrefix, path)) + "</D:getetag>");
        out.print("</D:prop>");
        out.print("<D:status>HTTP/1.1 200 OK</D:status>");
        out.print("</D:propstat>");
        out.print("</D:response>");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doProppatch(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Object path;
        UserData userData;
        block20: {
            block21: {
                VFSNode node;
                if (logger.isTraceEnabled()) {
                    logger.traceEnter();
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("doProppatch: negogiating authentication");
                }
                if ((userData = this.negotiateAuthentication(req, resp)) == null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("doProppatch: authentication negogiation requested immediate return.");
                    }
                    if (logger.isTraceEnabled()) {
                        logger.traceExit();
                    }
                    return;
                }
                String pathInfo = req.getPathInfo();
                path = req.getServletPath();
                if (pathInfo != null) {
                    path = (String)path + pathInfo;
                }
                path = this.preProcessRequestedPath((String)path);
                if (logger.isDebugEnabled()) {
                    logger.debug("doProppatch: path=" + (String)path);
                }
                if ((node = this.getVirtualFileSystem(userData).getNodeByPath(userData, (String)path, 517)) != null) break block20;
                if (logger.isDebugEnabled()) {
                    logger.debug("doProppatch: file does not exist. path=" + (String)path);
                }
                resp.setStatus(404);
                resp.setCharacterEncoding("UTF-8");
                resp.getWriter().print("404: object not found.");
                if (!logger.isTraceEnabled()) break block21;
                logger.traceExit();
            }
            this.invalidateAuthentication(userData, req, resp);
            return;
        }
        try {
            try {
                String sitePrefix = this.getSitePrefix(req);
                resp.setCharacterEncoding("UTF-8");
                PrintWriter out = resp.getWriter();
                resp.setStatus(207);
                out.println("<?xml version=\"1.0\" encoding=\"utf-8\" ?>");
                out.println("<D:multistatus xmlns:D=\"DAV:\" xmlns:Office=\"urn:schemas-microsoft-com:office:office\" xmlns:Repl=\"http://schemas.microsoft.com/repl/\" xmlns:Z=\"urn:schemas-microsoft-com:\">");
                out.println("  <D:response>");
                out.println("    <D:href>" + sitePrefix + urlEncoder.encode((String)path) + "</D:href>");
                out.println("  </D:response>");
                out.println("</D:multistatus>");
            }
            catch (AuthenticationRequiredException are) {
                if (logger.isDebugEnabled()) {
                    logger.debug("doProppatch: requested authentication.");
                }
                this.requestAuthentication(req, resp);
            }
            catch (IndividualResponseRuntimeException irre) {
                logger.debug("doProppatch: Individual Error Message Requested", irre);
                try {
                    resp.setStatus(irre.getWebdavStatus());
                    resp.setCharacterEncoding("UTF-8");
                    resp.getWriter().print(irre.getWebdavMessage());
                }
                catch (IllegalStateException illegalStateException) {
                }
            }
            catch (Exception e) {
                this.handleUnexpectedException("doProppatch", e, req, resp);
            }
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            this.invalidateAuthentication(userData, req, resp);
        }
        if (logger.isTraceEnabled()) {
            logger.traceExit();
        }
    }

    /*
     * Exception decompiling
     */
    protected void doLock(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 9[CASE]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doUnlock(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        block25: {
            VFSDocumentNode node;
            UserData userData;
            block23: {
                block24: {
                    if (logger.isTraceEnabled()) {
                        logger.traceEnter();
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug("doUnlock: negogiating authentication");
                    }
                    if ((userData = this.negotiateAuthentication(req, resp)) == null) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("doUnlock: authentication negogiation requested immediate return.");
                        }
                        if (logger.isTraceEnabled()) {
                            logger.traceExit();
                        }
                        return;
                    }
                    String pathInfo = req.getPathInfo();
                    Object path = req.getServletPath();
                    if (pathInfo != null) {
                        path = (String)path + pathInfo;
                    }
                    path = this.preProcessRequestedPath((String)path);
                    if (logger.isDebugEnabled()) {
                        logger.debug("doUnlock: path=" + (String)path);
                    }
                    node = null;
                    try {
                        node = (VFSDocumentNode)this.getVirtualFileSystem(userData).getNodeByPath(userData, (String)path, 519);
                    }
                    catch (ClassCastException cce) {
                        node = null;
                    }
                    if (node != null) break block23;
                    if (logger.isDebugEnabled()) {
                        logger.debug("doUnlock: file does not exist. path=" + (String)path);
                    }
                    resp.setStatus(404);
                    resp.setCharacterEncoding("UTF-8");
                    resp.getWriter().print("404: object not found.");
                    if (!logger.isTraceEnabled()) break block24;
                    logger.traceExit();
                }
                this.invalidateAuthentication(userData, req, resp);
                return;
            }
            try {
                try {
                    if (node.uncheckout(true, 519)) {
                        resp.setStatus(204);
                        break block25;
                    }
                    resp.setStatus(403);
                }
                catch (AuthenticationRequiredException are) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("doUnlock: requested authentication.");
                    }
                    this.requestAuthentication(req, resp);
                }
                catch (IndividualResponseRuntimeException irre) {
                    logger.debug("doUnlock: Individual Error Message Requested", irre);
                    try {
                        resp.setStatus(irre.getWebdavStatus());
                        resp.setCharacterEncoding("UTF-8");
                        resp.getWriter().print(irre.getWebdavMessage());
                    }
                    catch (IllegalStateException illegalStateException) {
                    }
                }
                catch (Exception e) {
                    this.handleUnexpectedException("doUnlock", e, req, resp);
                }
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                this.invalidateAuthentication(userData, req, resp);
            }
        }
        if (logger.isTraceEnabled()) {
            logger.traceExit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        block48: {
            VFSDocumentNode document;
            Object path;
            UserData userData;
            block47: {
                block46: {
                    if (logger.isTraceEnabled()) {
                        logger.traceEnter();
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug("doPut: negogiating authentication");
                    }
                    if ((userData = this.negotiateAuthentication(req, resp)) == null) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("doPut: authentication negogiation requested immediate return.");
                        }
                        if (logger.isTraceEnabled()) {
                            logger.traceExit();
                        }
                        return;
                    }
                    String pathInfo = req.getPathInfo();
                    path = req.getServletPath();
                    if (pathInfo != null) {
                        path = (String)path + pathInfo;
                    }
                    path = this.preProcessRequestedPath((String)path);
                    if (logger.isDebugEnabled()) {
                        logger.debug("doPut: path=" + (String)path);
                    }
                    document = null;
                    try {
                        document = (VFSDocumentNode)this.getVirtualFileSystem(userData).getNodeByPath(userData, (String)path, 515);
                    }
                    catch (ClassCastException cce) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("doPut: virtual file system returned a non-document node (i.e. a directory). Conflict. path=" + (String)path);
                        }
                        resp.sendError(409);
                        if (logger.isTraceEnabled()) {
                            logger.traceExit();
                        }
                        this.invalidateAuthentication(userData, req, resp);
                        return;
                    }
                    String ifMatchHeader = req.getHeader("If-Match");
                    if (ifMatchHeader == null) break block46;
                    if (this.checkPutPrecondition(document, this.getSitePrefix(req), (String)path, ifMatchHeader, null)) break block47;
                    if (logger.isDebugEnabled()) {
                        logger.debug("doPut: If-Match Precondition failed: " + req.getHeader("If-Match"));
                    }
                    resp.sendError(412);
                    this.invalidateAuthentication(userData, req, resp);
                    return;
                }
                String ifHeader = req.getHeader("If");
                if (ifHeader == null) break block47;
                boolean preconditionOk = false;
                if (ifHeader.startsWith("(") && ifHeader.endsWith(")")) {
                    ifHeader = ifHeader.substring(1, ifHeader.length() - 1);
                    String ifMatch = null;
                    int blankPos = ifHeader.indexOf(32);
                    if (blankPos >= 0) {
                        ifMatch = blankPos == ifHeader.length() - 1 ? null : ifHeader.substring(blankPos + 1);
                        String string = ifHeader = blankPos == 0 ? null : ifHeader.substring(0, blankPos);
                        if (ifMatch != null && ifMatch.startsWith("[") && ifMatch.endsWith("]")) {
                            ifMatch = ifMatch.substring(1, ifMatch.length() - 1);
                        }
                    }
                    if (ifHeader != null && ifHeader.startsWith("<") && ifHeader.endsWith(">")) {
                        ifHeader = ifHeader.substring(1, ifHeader.length() - 1);
                    }
                    preconditionOk = this.checkPutPrecondition(document, this.getSitePrefix(req), (String)path, ifMatch, ifHeader);
                }
                if (preconditionOk) break block47;
                if (logger.isDebugEnabled()) {
                    logger.debug("doPut: If Precondition () failed " + req.getHeader("If"));
                }
                resp.sendError(412);
                this.invalidateAuthentication(userData, req, resp);
                return;
            }
            try {
                try {
                    ServletInputStream postData = req.getInputStream();
                    String msdavext = req.getHeader("X-MSDAVEXT");
                    boolean failed = false;
                    if (msdavext != null) {
                        if (msdavext.equals("PROPPATCH")) {
                            if (!this.parseMsdavextMultipart((InputStream)postData)) {
                                logger.error("doPut: Found X-MSDAVEXT PROPPATCH but failed parsing multipart post data");
                                resp.sendError(400);
                                failed = true;
                            }
                        } else {
                            logger.error("doPut: Found X-MSDAVEXT containing command different from PROPPATCH.");
                            resp.sendError(400);
                            failed = true;
                        }
                    }
                    if (failed) break block48;
                    if (document == null) {
                        VFSDocumentNode newDocument;
                        if (logger.isDebugEnabled()) {
                            logger.debug("doPut: document not found. creating new one.");
                        }
                        if ((newDocument = this.getVirtualFileSystem(userData).createDocument(userData, (String)path, (InputStream)postData, 515)) != null) {
                            CheckoutResult checkoutResult;
                            String msdavextLockTimeout = req.getHeader("X-MSDAVEXTLockTimeout");
                            if (msdavextLockTimeout != null && (checkoutResult = newDocument.checkout(10, null, 515)) == CheckoutResult.OK) {
                                resp.setHeader("X-MSDAVEXTLockTimeout", msdavextLockTimeout);
                                resp.setHeader("Lock-Token", newDocument.getWebdavLockToken(null, 515));
                            }
                            resp.setStatus(201);
                            resp.setHeader("Last-Modified", this.getThreadDateFormatHeader().format(newDocument.getDateLastModified(515)));
                            String sitePrefix = this.getSitePrefix(req);
                            resp.setHeader("ETag", this.getEtagForNode(newDocument, sitePrefix, (String)path));
                            resp.setHeader("ResourceTag", this.getResourceTagForNode(newDocument, sitePrefix, (String)path));
                        } else {
                            if (logger.isDebugEnabled()) {
                                logger.debug("doPut: Creating new document failed.");
                            }
                            resp.sendError(409);
                        }
                        break block48;
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug("doPut: document found. updating content.");
                    }
                    if (document.storeContent((InputStream)postData, 515)) {
                        resp.setStatus(200);
                        resp.setHeader("Last-Modified", this.getThreadDateFormatHeader().format(document.getDateLastModified(515)));
                        String sitePrefix = this.getSitePrefix(req);
                        resp.setHeader("ETag", this.getEtagForNode(document, sitePrefix, (String)path));
                        resp.setHeader("ResourceTag", this.getResourceTagForNode(document, sitePrefix, (String)path));
                        break block48;
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug("doPut: Updating content of existing document failed.");
                    }
                    resp.sendError(409);
                }
                catch (AuthenticationRequiredException are) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("doPut: requested authentication.");
                    }
                    this.requestAuthentication(req, resp);
                }
                catch (AccessDeniedException ade) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("doPut: user has insufficient permissions.");
                    }
                    resp.sendError(403);
                }
                catch (IndividualResponseRuntimeException irre) {
                    logger.debug("doPut: Individual Error Message Requested", irre);
                    try {
                        resp.setStatus(irre.getWebdavStatus());
                        resp.setCharacterEncoding("UTF-8");
                        resp.getWriter().print(irre.getWebdavMessage());
                    }
                    catch (IllegalStateException illegalStateException) {
                    }
                }
                catch (Exception e) {
                    this.handleUnexpectedException("doPut", e, req, resp);
                }
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                this.invalidateAuthentication(userData, req, resp);
            }
        }
        if (logger.isTraceEnabled()) {
            logger.traceExit();
        }
    }

    protected boolean checkPutPrecondition(VFSDocumentNode document, String sitePrefix, String path, String ifMatch, String lockToken) {
        String currentLockToken;
        if (document == null) {
            return true;
        }
        if (ifMatch != null && !ifMatch.equals(this.getEtagForNode(document, sitePrefix, path))) {
            return false;
        }
        return lockToken == null || lockToken.equals(currentLockToken = document.getWebdavLockToken(null, 515));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doMkcol(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        block21: {
            UserData userData;
            if (logger.isTraceEnabled()) {
                logger.traceEnter();
            }
            if (logger.isDebugEnabled()) {
                logger.debug("doMkcol: negogiating authentication");
            }
            if ((userData = this.negotiateAuthentication(req, resp)) == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("doMkcol: authentication negogiation requested immediate return.");
                }
                if (logger.isTraceEnabled()) {
                    logger.traceExit();
                }
                return;
            }
            try {
                try {
                    String pathInfo = req.getPathInfo();
                    Object path = req.getServletPath();
                    if (pathInfo != null) {
                        path = (String)path + pathInfo;
                    }
                    path = this.preProcessRequestedPath((String)path);
                    if (logger.isDebugEnabled()) {
                        logger.debug("doMkcol: path=" + (String)path);
                    }
                    if (this.getVirtualFileSystem(userData).getNodeByPath(userData, (String)path, 520) != null) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("doMkcol: Path to be created already exists.");
                        }
                        resp.sendError(409);
                        break block21;
                    }
                    VFSNode newFolder = this.getVirtualFileSystem(userData).createFolder(userData, (String)path, 520);
                    if (newFolder != null) {
                        resp.setStatus(201);
                        break block21;
                    }
                    resp.sendError(409);
                }
                catch (AuthenticationRequiredException are) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("doMkcol: requested authentication.");
                    }
                    this.requestAuthentication(req, resp);
                }
                catch (IndividualResponseRuntimeException irre) {
                    logger.debug("doMkcol: Individual Error Message Requested", irre);
                    try {
                        resp.setStatus(irre.getWebdavStatus());
                        resp.setCharacterEncoding("UTF-8");
                        resp.getWriter().print(irre.getWebdavMessage());
                    }
                    catch (IllegalStateException illegalStateException) {
                    }
                }
                catch (Exception e) {
                    this.handleUnexpectedException("doMkcol", e, req, resp);
                }
            }
            finally {
                this.invalidateAuthentication(userData, req, resp);
            }
        }
        if (logger.isTraceEnabled()) {
            logger.traceExit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doMove(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        block43: {
            VFSNode vfsnode;
            String newName;
            String newParent;
            String oldParent;
            String destinationPath;
            UserData userData;
            block41: {
                block42: {
                    VirtualFileSystem vfs;
                    block39: {
                        block40: {
                            Object path;
                            block37: {
                                block38: {
                                    String destination;
                                    block35: {
                                        block36: {
                                            if (logger.isTraceEnabled()) {
                                                logger.traceEnter();
                                            }
                                            if (logger.isDebugEnabled()) {
                                                logger.debug("doMove: negogiating authentication");
                                            }
                                            if ((userData = this.negotiateAuthentication(req, resp)) == null) {
                                                if (logger.isDebugEnabled()) {
                                                    logger.debug("doMove: authentication negogiation requested immediate return.");
                                                }
                                                if (logger.isTraceEnabled()) {
                                                    logger.traceExit();
                                                }
                                                return;
                                            }
                                            String pathInfo = req.getPathInfo();
                                            path = req.getServletPath();
                                            if (pathInfo != null) {
                                                path = (String)path + pathInfo;
                                            }
                                            path = this.preProcessRequestedPath((String)path);
                                            destination = req.getHeader("Destination");
                                            if (logger.isDebugEnabled()) {
                                                logger.debug("doMove: path=" + (String)path + " destination=" + destination);
                                            }
                                            if (destination != null) break block35;
                                            logger.error("doMove: BAD REQUEST: Destination missing in http header");
                                            resp.sendError(400);
                                            if (!logger.isTraceEnabled()) break block36;
                                            logger.traceExit();
                                        }
                                        this.invalidateAuthentication(userData, req, resp);
                                        return;
                                    }
                                    destinationPath = this.getDestinationPathFromDestinationUrl(req, destination);
                                    if (destinationPath != null) break block37;
                                    logger.error("doMove: BAD REQUEST: Destination malformed");
                                    resp.sendError(400);
                                    if (!logger.isTraceEnabled()) break block38;
                                    logger.traceExit();
                                }
                                this.invalidateAuthentication(userData, req, resp);
                                return;
                            }
                            int p = ((String)path).lastIndexOf(47);
                            oldParent = "";
                            if (p >= 0) {
                                oldParent = ((String)path).substring(0, p);
                            }
                            newParent = "";
                            newName = destinationPath;
                            p = destinationPath.lastIndexOf(47);
                            if (p >= 0) {
                                newParent = destinationPath.substring(0, p);
                                newName = destinationPath.substring(p + 1);
                            }
                            if (logger.isDebugEnabled()) {
                                logger.debug("doMove: oldParent=" + oldParent + " newParent=" + newParent + " newName=" + newName);
                            }
                            if ((vfsnode = (vfs = this.getVirtualFileSystem(userData)).getNodeByPath(userData, (String)path, 521)) != null) break block39;
                            if (logger.isDebugEnabled()) {
                                logger.debug("doMove: requested path not found");
                            }
                            resp.sendError(404);
                            if (!logger.isTraceEnabled()) break block40;
                            logger.traceExit();
                        }
                        this.invalidateAuthentication(userData, req, resp);
                        return;
                    }
                    String overwriteHeader = req.getHeader("Overwrite");
                    boolean overwrite = overwriteHeader != null && overwriteHeader.equals("T");
                    VFSNode destinationNode = vfs.getNodeByPath(userData, destinationPath, 521);
                    if (destinationNode == null || overwrite) break block41;
                    if (logger.isDebugEnabled()) {
                        logger.debug("doMove: destination exists and Overwrite is not T. Precondition failed.");
                    }
                    resp.sendError(412);
                    if (!logger.isTraceEnabled()) break block42;
                    logger.traceExit();
                }
                this.invalidateAuthentication(userData, req, resp);
                return;
            }
            try {
                try {
                    if (oldParent.equals(newParent)) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("doMove: Renaming node.");
                        }
                        if (!vfsnode.rename(newName, 521)) {
                            if (logger.isDebugEnabled()) {
                                logger.debug("doMove: Renaming node failed.");
                            }
                            resp.sendError(409);
                        } else {
                            resp.sendError(201);
                        }
                        break block43;
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug("doMove: Moving node.");
                    }
                    if (!vfsnode.move(userData, destinationPath, 521)) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("doMove: Moving node failed.");
                        }
                        resp.sendError(409);
                        break block43;
                    }
                    resp.sendError(201);
                }
                catch (AuthenticationRequiredException are) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("doMove: requested authentication.");
                    }
                    this.requestAuthentication(req, resp);
                }
                catch (IndividualResponseRuntimeException irre) {
                    logger.debug("doMove: Individual Error Message Requested", irre);
                    try {
                        resp.setStatus(irre.getWebdavStatus());
                        resp.setCharacterEncoding("UTF-8");
                        resp.getWriter().print(irre.getWebdavMessage());
                    }
                    catch (IllegalStateException illegalStateException) {
                    }
                }
                catch (Exception e) {
                    this.handleUnexpectedException("doMove", e, req, resp);
                }
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                this.invalidateAuthentication(userData, req, resp);
            }
        }
        if (logger.isTraceEnabled()) {
            logger.traceExit();
        }
    }

    protected String getDestinationPathFromDestinationUrl(HttpServletRequest request, String destination) {
        String sitePrefix = this.getSitePrefix(request);
        if (destination.equalsIgnoreCase(sitePrefix)) {
            return "/";
        }
        if (destination.toLowerCase().startsWith(sitePrefix.toLowerCase() + "/")) {
            try {
                return URLPathDecoder.decode(destination.substring(sitePrefix.length()), "UTF8");
            }
            catch (UnsupportedEncodingException e) {
                return destination.substring(sitePrefix.length());
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Malformed destination. Destination is not within the site prefix. sitePrefix=" + sitePrefix + " destination=" + destination);
        }
        return null;
    }

    protected boolean parseMsdavextMultipart(InputStream postData) throws IOException {
        int singleByte;
        int cnt = 0;
        byte[] hexBytes = new byte[16];
        while (cnt < 16 && (singleByte = postData.read()) != -1) {
            hexBytes[cnt++] = (byte)singleByte;
        }
        if (cnt < 16) {
            return false;
        }
        long l = 0L;
        try {
            l = Long.parseLong(new String(hexBytes), 16);
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        if (l > 1000000L) {
            return false;
        }
        cnt = 0;
        while ((long)cnt < l && postData.read() != -1) {
            ++cnt;
        }
        if ((long)cnt < l) {
            return false;
        }
        cnt = 0;
        while (cnt < 16 && (singleByte = postData.read()) != -1) {
            hexBytes[cnt++] = (byte)singleByte;
        }
        if (cnt < 16) {
            return false;
        }
        try {
            Long.parseLong(new String(hexBytes), 16);
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doDelete(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        block23: {
            VFSNode node;
            UserData userData;
            block21: {
                block22: {
                    if (logger.isTraceEnabled()) {
                        logger.traceEnter();
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug("doDelete: negogiating authentication");
                    }
                    if ((userData = this.negotiateAuthentication(req, resp)) == null) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("doDelete: authentication negogiation requested immediate return.");
                        }
                        if (logger.isTraceEnabled()) {
                            logger.traceExit();
                        }
                        return;
                    }
                    String pathInfo = req.getPathInfo();
                    Object path = req.getServletPath();
                    if (pathInfo != null) {
                        path = (String)path + pathInfo;
                    }
                    path = this.preProcessRequestedPath((String)path);
                    if (logger.isDebugEnabled()) {
                        logger.debug("doDelete: path=" + (String)path);
                    }
                    if ((node = this.getVirtualFileSystem(userData).getNodeByPath(userData, (String)path, 522)) != null) break block21;
                    if (logger.isDebugEnabled()) {
                        logger.debug("doDelete: object does not exist. path=" + (String)path);
                    }
                    resp.setStatus(404);
                    resp.setCharacterEncoding("UTF-8");
                    resp.getWriter().print("404: object not found.");
                    if (!logger.isTraceEnabled()) break block22;
                    logger.traceExit();
                }
                this.invalidateAuthentication(userData, req, resp);
                return;
            }
            try {
                try {
                    if (node.delete(522)) {
                        resp.setStatus(204);
                        break block23;
                    }
                    resp.setStatus(403);
                    resp.setHeader("X-MSDAVEXT_Error", "1966082; Access%20denied%2e");
                }
                catch (AuthenticationRequiredException are) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("doDelete: requested authentication.");
                    }
                    this.requestAuthentication(req, resp);
                }
                catch (IndividualResponseRuntimeException irre) {
                    logger.debug("doDelete: Individual Error Message Requested", irre);
                    try {
                        resp.setStatus(irre.getWebdavStatus());
                        resp.setCharacterEncoding("UTF-8");
                        resp.getWriter().print(irre.getWebdavMessage());
                    }
                    catch (IllegalStateException illegalStateException) {
                    }
                }
                catch (Exception e) {
                    this.handleUnexpectedException("doDelete", e, req, resp);
                }
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                this.invalidateAuthentication(userData, req, resp);
            }
        }
        if (logger.isTraceEnabled()) {
            logger.traceExit();
        }
    }
}

