/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.officeservices.datamodel;

public enum FieldType {
    TEXT("Text"),
    NOTE("Note"),
    DATE_TIME("DateTime"),
    CHOICE("Choice"),
    BOOLEAN("Boolean"),
    NUMBER("Number");

    private String typeString;

    private FieldType(String typeString) {
        this.typeString = typeString;
    }

    public String getTypeString() {
        return this.typeString;
    }

    public static FieldType fromTypeString(String typeString) {
        for (FieldType ft : FieldType.values()) {
            if (!ft.getTypeString().equals(typeString)) continue;
            return ft;
        }
        return null;
    }

    public static FieldType fromTypeStringIgnoreCase(String typeString) {
        for (FieldType ft : FieldType.values()) {
            if (!ft.getTypeString().equalsIgnoreCase(typeString)) continue;
            return ft;
        }
        return null;
    }

    public String toString() {
        return this.getTypeString();
    }
}

