/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.officeservices.lists;

import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import org.alfresco.officeservices.AbstractSoapService;

public class ViewDescription {
    protected String id;
    protected String type;
    protected String baseViewId;
    protected String displayName;
    protected List<String> viewFields = new ArrayList<String>();
    public static final String VIEWTYPE_HTML = "HTML";
    public static final String VIEWTYPE_CALENDAR = "CALENDAR";
    public static final String BASEVIEWID_LIST = "1";
    public static final String BASEVIEWID_CALENDAR = "2";
    public static final String BASEVIEWID_DISCUSSION = "2";

    public ViewDescription(String id, String type, String baseViewId, String displayName) {
        this.id = id;
        this.type = type;
        this.baseViewId = baseViewId;
        this.displayName = displayName;
    }

    public void addViewField(String fieldRef) {
        this.viewFields.add(fieldRef);
    }

    public void write(PrintStream out, boolean includeDetails) throws IOException {
        out.print("<View");
        AbstractSoapService.writeXmlAttribute(out, "Name", this.id, true);
        AbstractSoapService.writeXmlAttribute(out, "DefaultView", "TRUE", true);
        AbstractSoapService.writeXmlAttribute(out, "Type", this.type, true);
        if (VIEWTYPE_CALENDAR.equals(this.type)) {
            AbstractSoapService.writeXmlAttribute(out, "RecurrenceRowset", "TRUE", true);
        }
        AbstractSoapService.writeXmlAttribute(out, "DisplayName", this.displayName, true);
        AbstractSoapService.writeXmlAttribute(out, "Url", "", true);
        AbstractSoapService.writeXmlAttribute(out, "Level", BASEVIEWID_LIST, true);
        AbstractSoapService.writeXmlAttribute(out, "BaseViewID", this.baseViewId, true);
        AbstractSoapService.writeXmlAttribute(out, "ContentTypeID", "0x", true);
        AbstractSoapService.writeXmlAttribute(out, "ImageUrl", "", true);
        if (!includeDetails) {
            out.print(" />");
            return;
        }
        out.print(">");
        this.writeQuery(out);
        this.writeViewFields(out);
        this.writeViewData(out);
        out.print("</View>");
    }

    protected void writeQuery(PrintStream out) throws IOException {
        out.print("<Query>");
        out.print("</Query>");
    }

    protected void writeViewFields(PrintStream out) throws IOException {
        out.print("<ViewFields>");
        for (String fieldRef : this.viewFields) {
            out.print("<FieldRef");
            AbstractSoapService.writeXmlAttribute(out, "Name", fieldRef, true);
            out.print("/>");
        }
        out.print("</ViewFields>");
    }

    protected void writeViewData(PrintStream out) throws IOException {
        out.print("<ViewData>");
        out.print("</ViewData>");
    }
}

