/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.officeservices.protocol;

import java.util.HashMap;
import java.util.Map;
import org.alfresco.officeservices.exceptions.MalformedVermeerRequestException;
import org.alfresco.officeservices.protocol.VermeerRequest;

public class VermeerParameterDictionary {
    protected Map<String, String> dictionary = null;

    public VermeerParameterDictionary(String data) throws MalformedVermeerRequestException {
        if (data != null) {
            if (data.length() < 2 || data.charAt(0) != '[' || data.charAt(data.length() - 1) != ']') {
                throw new MalformedVermeerRequestException("invalid block marker");
            }
            this.dictionary = new HashMap<String, String>();
            StringBuffer decodedString = new StringBuffer(data.length());
            String key = null;
            boolean escaped = false;
            int nestedCount = 0;
            int size = data.length();
            block19: for (int i = 1; i < size - 1; ++i) {
                char c = data.charAt(i);
                if (escaped) {
                    switch (c) {
                        case '\\': {
                            decodedString.append('\\');
                            break;
                        }
                        case '=': {
                            decodedString.append('=');
                            break;
                        }
                        case '[': {
                            decodedString.append('[');
                            break;
                        }
                        case ']': {
                            decodedString.append(']');
                            break;
                        }
                        case ';': {
                            decodedString.append(';');
                            break;
                        }
                        case '\"': {
                            decodedString.append('\"');
                            break;
                        }
                        default: {
                            throw new MalformedVermeerRequestException("invalid escapeing sequence");
                        }
                    }
                    escaped = false;
                    continue;
                }
                if (nestedCount > 0) {
                    switch (c) {
                        case '[': {
                            decodedString.append(c);
                            ++nestedCount;
                            break;
                        }
                        case ']': {
                            decodedString.append(c);
                            --nestedCount;
                            break;
                        }
                        default: {
                            decodedString.append(c);
                            break;
                        }
                    }
                    continue;
                }
                switch (c) {
                    case '\\': {
                        escaped = true;
                        continue block19;
                    }
                    case '[': {
                        decodedString.append(c);
                        ++nestedCount;
                        continue block19;
                    }
                    case ']': {
                        throw new MalformedVermeerRequestException("invalid nesting sequence");
                    }
                    case '=': {
                        key = decodedString.toString();
                        decodedString.setLength(0);
                        continue block19;
                    }
                    case ';': {
                        if (key == null) {
                            this.dictionary.put(decodedString.toString(), null);
                        } else {
                            this.dictionary.put(key, decodedString.toString());
                        }
                        key = null;
                        decodedString.setLength(0);
                        continue block19;
                    }
                    default: {
                        decodedString.append(c);
                    }
                }
            }
            if (escaped) {
                throw new MalformedVermeerRequestException("invalid escapeing sequence");
            }
            if (key == null) {
                if (decodedString.length() > 0) {
                    this.dictionary.put(decodedString.toString(), null);
                }
            } else {
                this.dictionary.put(key, decodedString.toString());
            }
        }
    }

    public VermeerParameterDictionary(VermeerRequest request, String parameterName, boolean required) throws MalformedVermeerRequestException {
        this(request.getParameter(parameterName));
        if (required && this.isNull()) {
            throw new MalformedVermeerRequestException(parameterName + " missing");
        }
    }

    public boolean isNull() {
        return this.dictionary == null;
    }

    public String get(String key) {
        return this.dictionary == null ? null : this.dictionary.get(key);
    }
}

