/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.aosmodule.service;

import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.alfresco.module.aosmodule.service.AuthenticationServiceUserData;
import org.alfresco.module.aosmodule.service.BufferedHttpServletRequest;
import org.alfresco.module.aosmodule.vfs.AlfrescoVirtualFileSystem;
import org.alfresco.officeservices.StandardAuthorService;
import org.alfresco.officeservices.UserData;
import org.alfresco.officeservices.exceptions.AuthenticationRequiredException;
import org.alfresco.officeservices.protocol.VermeerRequest;
import org.alfresco.officeservices.protocol.VermeerResponse;
import org.alfresco.officeservices.vfs.VirtualFileSystem;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.security.AuthenticationService;
import org.alfresco.service.transaction.TransactionService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class AuthorService
extends StandardAuthorService {
    private static final long serialVersionUID = -3248232004872352862L;
    protected AlfrescoVirtualFileSystem vfs;
    protected AuthenticationService authenticationService;
    protected TransactionService transactionService;
    private long webdavSizeLimit = -1L;
    protected Logger logger = LoggerFactory.getLogger(AuthorService.class);

    public void init() throws ServletException {
        super.init();
        WebApplicationContext wac = WebApplicationContextUtils.getWebApplicationContext((ServletContext)this.getServletContext());
        if (wac == null) {
            throw new ServletException("Error initializing Servlet. No WebApplicationContext available.");
        }
        this.vfs = (AlfrescoVirtualFileSystem)wac.getBean("AosVirtualFileSystem");
        if (this.vfs == null) {
            throw new ServletException("Cannot find bean AosVirtualFileSystem in WebApplicationContext.");
        }
        this.vfs.prepare();
        this.authenticationService = (AuthenticationService)wac.getBean("AuthenticationService");
        if (this.authenticationService == null) {
            throw new ServletException("Cannot find bean AuthenticationService in WebApplicationContext.");
        }
        this.transactionService = this.vfs.getTransactionService();
        this.webdavSizeLimit = this.vfs.getWebDavHelper().getSizeLimit();
    }

    protected String getServiceName(VermeerRequest vermeerRequest) {
        return this.vfs.getSitePath(vermeerRequest.getRequest());
    }

    protected String getSitePrefix(HttpServletRequest request) {
        return this.vfs.getSitePrefix(request);
    }

    public VirtualFileSystem getVirtualFileSystem(UserData userData) throws AuthenticationRequiredException {
        return this.vfs;
    }

    protected void handleUnexpectedException(Exception e, VermeerRequest vermeerRequest, VermeerResponse vermeerResponse) {
        AlfrescoVirtualFileSystem.checkForRetryingException(e);
        super.handleUnexpectedException(e, vermeerRequest, vermeerResponse);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doPost(HttpServletRequest request, final HttpServletResponse response) throws IOException, ServletException {
        final BufferedHttpServletRequest bufferedRequest = request instanceof BufferedHttpServletRequest ? (BufferedHttpServletRequest)request : new BufferedHttpServletRequest(request, this.webdavSizeLimit);
        try {
            this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

                public Void execute() throws Throwable {
                    bufferedRequest.refresh();
                    AuthorService.super.doPost((HttpServletRequest)bufferedRequest, response);
                    return null;
                }
            });
        }
        catch (Throwable t) {
            this.logger.debug("Error in transaction", t);
            try {
                response.setStatus(500);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        finally {
            bufferedRequest.cleanup();
        }
    }

    public UserData negotiateAuthentication(HttpServletRequest request, HttpServletResponse response) throws IOException {
        return new AuthenticationServiceUserData(this.authenticationService);
    }

    public void requestAuthentication(HttpServletRequest request, HttpServletResponse response) throws IOException {
    }

    public void invalidateAuthentication(UserData userData, HttpServletRequest request, HttpServletResponse response) throws IOException {
    }
}

