/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.aosmodule.service;

import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.alfresco.module.aosmodule.vfs.AlfrescoVirtualFileSystem;
import org.alfresco.officeservices.StandardDispatcherService;
import org.alfresco.officeservices.UserData;
import org.alfresco.officeservices.protocol.VermeerRequest;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class ServiceDispatcher
extends StandardDispatcherService {
    private static final long serialVersionUID = 5100357015031001729L;
    protected List<String> serviceNames = new ArrayList<String>();
    protected UserData userData = new ServiceDispatcherUserData();

    public void init(ServletConfig servletConfig_p) throws ServletException {
        super.init(servletConfig_p);
        WebApplicationContext wac = WebApplicationContextUtils.getWebApplicationContext((ServletContext)this.getServletContext());
        if (wac == null) {
            throw new ServletException("Error initializing Servlet. No WebApplicationContext available.");
        }
        AlfrescoVirtualFileSystem vfs = (AlfrescoVirtualFileSystem)wac.getBean("AosVirtualFileSystem");
        if (vfs == null) {
            throw new ServletException("Cannot find bean AosVirtualFileSystem in WebApplicationContext.");
        }
        vfs.prepare();
        if (vfs.getSitePathOverwrite() != null) {
            this.serviceNames.add(vfs.getSitePathOverwrite().equals("/") ? "" : vfs.getSitePathOverwrite());
        } else {
            this.serviceNames.add(servletConfig_p.getServletContext().getContextPath() + "/aos");
        }
    }

    public List<String> getServicePrefixes(VermeerRequest vermeerRequest) {
        return this.serviceNames;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.getWriter().print("<html><body>This is the Alfresco ServiceDispatcher</body></html>");
    }

    public UserData negotiateAuthentication(HttpServletRequest arg0, HttpServletResponse arg1) throws IOException {
        return this.userData;
    }

    public void invalidateAuthentication(UserData arg0, HttpServletRequest arg1, HttpServletResponse arg2) throws IOException {
    }

    public void requestAuthentication(HttpServletRequest arg0, HttpServletResponse arg1) throws IOException {
    }

    protected class ServiceDispatcherUserData
    implements UserData {
        protected ServiceDispatcherUserData() {
        }

        public String getUsername() {
            return "";
        }
    }
}

