/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.aosmodule.service;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.RequestDispatcher;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.alfresco.officeservices.URLPathDecoder;

public class ServiceFilter
implements Filter {
    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }

    public String toString() {
        return "Alfresco AOS ServiceFilter";
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (response instanceof HttpServletResponse) {
            ServiceFilter.appendResponseHeaders((HttpServletResponse)response);
        }
        if (request instanceof HttpServletRequest) {
            String requestedPath = "";
            try {
                requestedPath = URLPathDecoder.decode((String)((HttpServletRequest)request).getRequestURI(), (String)"UTF8");
                if (null == requestedPath) {
                    requestedPath = "";
                }
            }
            catch (UnsupportedEncodingException ex) {
                requestedPath = "";
            }
            String contextPath = ((HttpServletRequest)request).getContextPath();
            if (contextPath != null && requestedPath.substring(0, contextPath.length()).equals(contextPath)) {
                requestedPath = requestedPath.substring(contextPath.length());
            }
            while (requestedPath.length() > 0 && requestedPath.charAt(0) == '/') {
                requestedPath = requestedPath.substring(1);
            }
            if (requestedPath.endsWith("/_vti_bin/Webs.asmx")) {
                RequestDispatcher rqDispatcher = request.getRequestDispatcher("/aos/_vti_bin/webs.asmx");
                if (rqDispatcher != null) {
                    rqDispatcher.forward(request, response);
                }
                return;
            }
            if (requestedPath.endsWith("/_vti_bin/Lists.asmx")) {
                request.setAttribute("RequestedListPath", (Object)requestedPath.substring(0, requestedPath.length() - 20));
                RequestDispatcher rqDispatcher = request.getRequestDispatcher("/aos/_vti_bin/lists.asmx");
                if (rqDispatcher != null) {
                    rqDispatcher.forward(request, response);
                }
                return;
            }
            if (requestedPath.endsWith("/_vti_bin/Copy.asmx")) {
                RequestDispatcher rqDispatcher = request.getRequestDispatcher("/aos/_vti_bin/copy.asmx");
                if (rqDispatcher != null) {
                    rqDispatcher.forward(request, response);
                }
                return;
            }
        }
        chain.doFilter(request, response);
    }

    static void appendResponseHeaders(HttpServletResponse response) {
        response.addHeader("MS-Author-Via", "MS-FP/4.0,DAV");
        response.addHeader("MicrosoftOfficeWebServer", "5.0_Collab");
        response.addHeader("DocumentManagementServer", "Properties Schema;Source Control;Version History;");
        response.addHeader("DAV", "1,2");
        response.addHeader("Allow", "GET, POST, OPTIONS, HEAD, MKCOL, PUT, PROPFIND, PROPPATCH, DELETE, MOVE, COPY, GETLIB, LOCK, UNLOCK");
        response.setHeader("Accept-Ranges", "none");
        response.setHeader("Cache-Control", "no-cache");
    }
}

