/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.aos;

import org.alfresco.utility.TasProperties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;
import org.springframework.context.annotation.PropertySources;
import org.springframework.context.support.PropertySourcesPlaceholderConfigurer;

@Configuration
@PropertySources(value={@PropertySource(value={"classpath:default.properties"}), @PropertySource(value={"classpath:${environment}.properties"}, ignoreResourceNotFound=true)})
public class AOSProperties {
    @Autowired
    private TasProperties properties;
    @Value(value="${aos.windowsNetwork}")
    private String aosWindowsNetwork;
    @Value(value="${aos.path}")
    private String aosPath;
    @Value(value="${aos.linuxNetwork}")
    private String aosLinuxNetwork;

    @Bean
    public static PropertySourcesPlaceholderConfigurer propertySourcesPlaceholderConfigurer() {
        return new PropertySourcesPlaceholderConfigurer();
    }

    public TasProperties envProperty() {
        return this.properties;
    }

    public String getAosPath() {
        return this.aosPath;
    }

    public String getAosWindowsNetwork() {
        return this.aosWindowsNetwork.replace("\\", "\\\\");
    }

    public void setAosWindowsNetwork(String aosWindowsNetwork) {
        this.aosWindowsNetwork = aosWindowsNetwork;
    }

    public String getAosLinuxNetwork() {
        return this.aosLinuxNetwork;
    }

    public void setAosLinuxNetwork(String aosLinuxNetwork) {
        this.aosLinuxNetwork = aosLinuxNetwork;
    }
}

