/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.aos;

import org.alfresco.aos.AOSTest;
import org.alfresco.aos.AOSWrapper;
import org.alfresco.utility.data.RandomData;
import org.alfresco.utility.model.ContentModel;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.FileType;
import org.alfresco.utility.model.FolderModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class CopyMoveOfficeFilesSanityTests
extends AOSTest {
    private UserModel testUser;
    private FolderModel folderModel;
    private FileModel msWord2007;
    private FileModel msWord2003;
    private FileModel msExcel2007;
    private FileModel msExcel2003;
    private FileModel msPowerPoint2007;
    private FileModel msPowerPoint2003;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.testSite = this.dataSite.createPublicRandomSite();
        this.testUser = this.dataUser.getAdminUser();
        this.aosProtocol.authenticateUser(this.testUser);
        this.folderModel = FolderModel.getRandomFolderModel();
    }

    @TestRail(section={"protocols", "aos"}, executionType={ExecutionType.SANITY}, description="Verify that admin is able to copy MSWORD2007 file.")
    @Test(groups={"protocols", "aos", "sanity"})
    public void adminIsAbleToCopyWord2007File() throws Exception {
        this.msWord2007 = new FileModel(RandomData.getRandomFile((FileType)FileType.MSWORD2007), FileType.MSWORD2007, RandomData.getRandomName((String)"fileContent"));
        ((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)this.aosProtocol.usingAdmin()).usingNetworkDrive().usingSite(this.testSite).createFolder(this.folderModel).and()).assertThat().existsInRepo()).and()).assertThat().fileExistsInAOS();
        ((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)this.aosProtocol.usingAdmin()).usingNetworkDrive().usingSite(this.testSite).createFile(this.msWord2007).then()).copyTo((ContentModel)this.folderModel).and()).assertThat().existsInRepo()).and()).assertThat().fileExistsInAOS().then()).usingResource((ContentModel)this.msWord2007).assertThat().existsInRepo()).and()).assertThat().fileExistsInAOS();
    }

    @TestRail(section={"protocols", "aos"}, executionType={ExecutionType.SANITY}, description="Verify that admin is able to move MSWORD2007 file.")
    @Test(groups={"protocols", "aos", "sanity"})
    public void adminIsAbleToMoveWord2007File() throws Exception {
        this.msWord2007 = new FileModel(RandomData.getRandomFile((FileType)FileType.MSWORD2007), FileType.MSWORD2007, RandomData.getRandomName((String)"fileContent"));
        ((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)this.aosProtocol.usingAdmin()).usingNetworkDrive().usingSite(this.testSite).createFolder(this.folderModel).and()).assertThat().existsInRepo()).and()).assertThat().fileExistsInAOS();
        ((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)this.aosProtocol.usingAdmin()).usingNetworkDrive().usingSite(this.testSite).createFile(this.msWord2007).then()).moveTo((ContentModel)this.folderModel).and()).assertThat().existsInRepo()).and()).assertThat().fileExistsInAOS().then()).usingResource((ContentModel)this.msWord2007).assertThat().doesNotExistInRepo()).and()).assertThat().fileDoesNotExistInAOS();
    }

    @TestRail(section={"protocols", "aos"}, executionType={ExecutionType.SANITY}, description="Verify that admin is able to copy MSWORD2003 file.")
    @Test(groups={"protocols", "aos", "sanity"})
    public void adminIsAbleToCopyWord2003File() throws Exception {
        this.msWord2003 = new FileModel(RandomData.getRandomFile((FileType)FileType.MSWORD), FileType.MSWORD, RandomData.getRandomName((String)"fileContent"));
        ((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)this.aosProtocol.usingAdmin()).usingNetworkDrive().usingSite(this.testSite).createFolder(this.folderModel).and()).assertThat().existsInRepo()).and()).assertThat().fileExistsInAOS();
        ((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)this.aosProtocol.usingAdmin()).usingNetworkDrive().usingSite(this.testSite).createFile(this.msWord2003).then()).copyTo((ContentModel)this.folderModel).and()).assertThat().existsInRepo()).and()).assertThat().fileExistsInAOS().then()).usingResource((ContentModel)this.msWord2003).assertThat().existsInRepo()).and()).assertThat().fileExistsInAOS();
    }

    @TestRail(section={"protocols", "aos"}, executionType={ExecutionType.SANITY}, description="Verify that admin is able to move MSWORD2003 file.")
    @Test(groups={"protocols", "aos", "sanity"})
    public void adminIsAbleToMoveWord2003File() throws Exception {
        this.msWord2003 = new FileModel(RandomData.getRandomFile((FileType)FileType.MSWORD), FileType.MSWORD, RandomData.getRandomName((String)"fileContent"));
        ((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)this.aosProtocol.usingAdmin()).usingNetworkDrive().usingSite(this.testSite).createFolder(this.folderModel).and()).assertThat().existsInRepo()).and()).assertThat().fileExistsInAOS();
        ((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)this.aosProtocol.usingAdmin()).usingNetworkDrive().usingSite(this.testSite).createFile(this.msWord2003).then()).moveTo((ContentModel)this.folderModel).and()).assertThat().existsInRepo()).and()).assertThat().fileExistsInAOS().then()).usingResource((ContentModel)this.msWord2003).assertThat().doesNotExistInRepo()).and()).assertThat().fileDoesNotExistInAOS();
    }

    @TestRail(section={"protocols", "aos"}, executionType={ExecutionType.SANITY}, description="Verify that admin is able to copy MSEXCEL2007 file.")
    @Test(groups={"protocols", "aos", "sanity"})
    public void adminIsAbleToCopyMSExcel2007File() throws Exception {
        this.msExcel2007 = new FileModel(RandomData.getRandomFile((FileType)FileType.MSEXCEL2007), FileType.MSEXCEL2007, RandomData.getRandomName((String)"fileContent"));
        ((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)this.aosProtocol.usingAdmin()).usingNetworkDrive().usingSite(this.testSite).createFolder(this.folderModel).and()).assertThat().existsInRepo()).and()).assertThat().fileExistsInAOS();
        ((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)this.aosProtocol.usingAdmin()).usingNetworkDrive().usingSite(this.testSite).createFile(this.msExcel2007).then()).copyTo((ContentModel)this.folderModel).and()).assertThat().existsInRepo()).and()).assertThat().fileExistsInAOS().then()).usingResource((ContentModel)this.msExcel2007).assertThat().existsInRepo()).and()).assertThat().fileExistsInAOS();
    }

    @TestRail(section={"protocols", "aos"}, executionType={ExecutionType.SANITY}, description="Verify that admin is able to move MSEXCEL2007 file.")
    @Test(groups={"protocols", "aos", "sanity"})
    public void adminIsAbleToMoveMSExcel2007File() throws Exception {
        this.msExcel2007 = new FileModel(RandomData.getRandomFile((FileType)FileType.MSEXCEL2007), FileType.MSEXCEL2007, RandomData.getRandomName((String)"fileContent"));
        ((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)this.aosProtocol.usingAdmin()).usingNetworkDrive().usingSite(this.testSite).createFolder(this.folderModel).and()).assertThat().existsInRepo()).and()).assertThat().fileExistsInAOS();
        ((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)this.aosProtocol.usingAdmin()).usingNetworkDrive().usingSite(this.testSite).createFile(this.msExcel2007).then()).moveTo((ContentModel)this.folderModel).and()).assertThat().existsInRepo()).and()).assertThat().fileExistsInAOS().then()).usingResource((ContentModel)this.msExcel2007).assertThat().doesNotExistInRepo()).and()).assertThat().fileDoesNotExistInAOS();
    }

    @TestRail(section={"protocols", "aos"}, executionType={ExecutionType.SANITY}, description="Verify that admin is able to copy MSEXCEL2003 file.")
    @Test(groups={"protocols", "aos", "sanity"})
    public void adminIsAbleToCopyMSExcel2003File() throws Exception {
        this.msExcel2003 = new FileModel(RandomData.getRandomFile((FileType)FileType.MSEXCEL), FileType.MSEXCEL, RandomData.getRandomName((String)"fileContent"));
        ((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)this.aosProtocol.usingAdmin()).usingNetworkDrive().usingSite(this.testSite).createFolder(this.folderModel).and()).assertThat().existsInRepo()).and()).assertThat().fileExistsInAOS();
        ((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)this.aosProtocol.usingAdmin()).usingNetworkDrive().usingSite(this.testSite).createFile(this.msExcel2003).then()).copyTo((ContentModel)this.folderModel).and()).assertThat().existsInRepo()).and()).assertThat().fileExistsInAOS().then()).usingResource((ContentModel)this.msExcel2003).assertThat().existsInRepo()).and()).assertThat().fileExistsInAOS();
    }

    @TestRail(section={"protocols", "aos"}, executionType={ExecutionType.SANITY}, description="Verify that admin is able to move MSEXCEL2003 file.")
    @Test(groups={"protocols", "aos", "sanity"})
    public void adminIsAbleToMoveMSExcel2003File() throws Exception {
        this.msExcel2003 = new FileModel(RandomData.getRandomFile((FileType)FileType.MSEXCEL), FileType.MSEXCEL, RandomData.getRandomName((String)"fileContent"));
        ((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)this.aosProtocol.usingAdmin()).usingNetworkDrive().usingSite(this.testSite).createFolder(this.folderModel).and()).assertThat().existsInRepo()).and()).assertThat().fileExistsInAOS();
        ((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)this.aosProtocol.usingAdmin()).usingNetworkDrive().usingSite(this.testSite).createFile(this.msExcel2003).then()).moveTo((ContentModel)this.folderModel).and()).assertThat().existsInRepo()).and()).assertThat().fileExistsInAOS().then()).usingResource((ContentModel)this.msExcel2003).assertThat().doesNotExistInRepo()).and()).assertThat().fileDoesNotExistInAOS();
    }

    @TestRail(section={"protocols", "aos"}, executionType={ExecutionType.SANITY}, description="Verify that admin is able to copy MSPOWERPOINT2007 file.")
    @Test(groups={"protocols", "aos", "sanity"})
    public void adminIsAbleToCopyMSPowerPoint2007File() throws Exception {
        this.msPowerPoint2007 = new FileModel(RandomData.getRandomFile((FileType)FileType.MSPOWERPOINT2007), FileType.MSPOWERPOINT2007, RandomData.getRandomName((String)"fileContent"));
        ((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)this.aosProtocol.usingAdmin()).usingNetworkDrive().usingSite(this.testSite).createFolder(this.folderModel).and()).assertThat().existsInRepo()).and()).assertThat().fileExistsInAOS();
        ((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)this.aosProtocol.usingAdmin()).usingNetworkDrive().usingSite(this.testSite).createFile(this.msPowerPoint2007).then()).copyTo((ContentModel)this.folderModel).and()).assertThat().existsInRepo()).and()).assertThat().fileExistsInAOS().then()).usingResource((ContentModel)this.msPowerPoint2007).assertThat().existsInRepo()).and()).assertThat().fileExistsInAOS();
    }

    @TestRail(section={"protocols", "aos"}, executionType={ExecutionType.SANITY}, description="Verify that admin si able to move MSPOWERPOINT2007 file.")
    @Test(groups={"protocols", "aos", "sanity"})
    public void adminIsAbleToMoveMSPowerPoint2007File() throws Exception {
        this.msPowerPoint2007 = new FileModel(RandomData.getRandomFile((FileType)FileType.MSPOWERPOINT2007), FileType.MSPOWERPOINT2007, RandomData.getRandomName((String)"fileContent"));
        ((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)this.aosProtocol.usingAdmin()).usingNetworkDrive().usingSite(this.testSite).createFolder(this.folderModel).and()).assertThat().existsInRepo()).and()).assertThat().fileExistsInAOS();
        ((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)this.aosProtocol.usingAdmin()).usingNetworkDrive().usingSite(this.testSite).createFile(this.msPowerPoint2007).then()).moveTo((ContentModel)this.folderModel).and()).assertThat().existsInRepo()).and()).assertThat().fileExistsInAOS().then()).usingResource((ContentModel)this.msPowerPoint2007).assertThat().doesNotExistInRepo()).and()).assertThat().fileDoesNotExistInAOS();
    }

    @TestRail(section={"protocols", "aos"}, executionType={ExecutionType.SANITY}, description="Verify that admin si able to copy MSPOWERPOINT2003 file.")
    @Test(groups={"protocols", "aos", "sanity"})
    public void adminIsAbleToCopyMSPowerPoint2003File() throws Exception {
        this.msPowerPoint2003 = new FileModel(RandomData.getRandomFile((FileType)FileType.MSPOWERPOINT), FileType.MSPOWERPOINT, RandomData.getRandomName((String)"fileContent"));
        ((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)this.aosProtocol.usingAdmin()).usingNetworkDrive().usingSite(this.testSite).createFolder(this.folderModel).and()).assertThat().existsInRepo()).and()).assertThat().fileExistsInAOS();
        ((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)this.aosProtocol.usingAdmin()).usingNetworkDrive().usingSite(this.testSite).createFile(this.msPowerPoint2003).then()).copyTo((ContentModel)this.folderModel).and()).assertThat().existsInRepo()).and()).assertThat().fileExistsInAOS().then()).usingResource((ContentModel)this.msPowerPoint2003).assertThat().existsInRepo()).and()).assertThat().fileExistsInAOS();
    }

    @TestRail(section={"protocols", "aos"}, executionType={ExecutionType.SANITY}, description="Verify that admin si able to move MSPOWERPOINT2003 file.")
    @Test(groups={"protocols", "aos", "sanity"})
    public void adminIsAbleToMoveMSPowerPoint2003File() throws Exception {
        this.msPowerPoint2003 = new FileModel(RandomData.getRandomFile((FileType)FileType.MSPOWERPOINT), FileType.MSPOWERPOINT, RandomData.getRandomName((String)"fileContent"));
        ((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)this.aosProtocol.usingAdmin()).usingNetworkDrive().usingSite(this.testSite).createFolder(this.folderModel).and()).assertThat().existsInRepo()).and()).assertThat().fileExistsInAOS();
        ((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)this.aosProtocol.usingAdmin()).usingNetworkDrive().usingSite(this.testSite).createFile(this.msPowerPoint2003).then()).moveTo((ContentModel)this.folderModel).and()).assertThat().existsInRepo()).and()).assertThat().fileExistsInAOS().then()).usingResource((ContentModel)this.msPowerPoint2003).assertThat().doesNotExistInRepo()).and()).assertThat().fileDoesNotExistInAOS();
    }

    @TestRail(section={"protocols", "aos"}, executionType={ExecutionType.REGRESSION}, description="Verify the response code for a conflict when a file is moved in a folder that already has a file with the same name")
    @Test(groups={"protocols", "aos", "core"})
    public void conflictWhileMovingFile() throws Exception {
        FolderModel sourceFolder = FolderModel.getRandomFolderModel();
        FolderModel destinationFolder = FolderModel.getRandomFolderModel();
        ((AOSWrapper)((AOSWrapper)this.aosProtocol.usingAdmin()).usingNetworkDrive().usingSite(this.testSite).createFolder(sourceFolder).and()).assertThat().existsInRepo();
        ((AOSWrapper)((AOSWrapper)this.aosProtocol.usingAdmin()).usingNetworkDrive().usingSite(this.testSite).createFolder(destinationFolder).and()).assertThat().existsInRepo();
        this.msExcel2003 = FileModel.getRandomFileModel((FileType)FileType.MSEXCEL);
        FileModel testFileSource = new FileModel(this.msExcel2003);
        FileModel testFileDestination = new FileModel(this.msExcel2003);
        ((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)this.aosProtocol.usingAdmin()).usingNetworkDrive().usingResource((ContentModel)sourceFolder).createFile(testFileSource).and()).assertThat().existsInRepo()).and()).assertThat().fileExistsInAOS();
        ((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)this.aosProtocol.usingAdmin()).usingNetworkDrive().usingResource((ContentModel)destinationFolder).createFile(testFileDestination).and()).assertThat().existsInRepo()).and()).assertThat().fileExistsInAOS();
        ((AOSWrapper)((AOSWrapper)this.aosProtocol.usingAdmin()).usingNetworkDrive().usingResource((ContentModel)testFileSource).then()).httpMoveTo((ContentModel)destinationFolder).assertThat().hasStatus(412);
    }
}

