package org.alfresco.officeservices.testclient;

import java.util.UUID;

import org.apache.commons.codec.binary.Base64;
import org.springframework.core.io.ClassPathResource;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;

import com.fasterxml.jackson.databind.ObjectMapper;

public class RestApiClient
{
    private static final String REST_API_URI = "/alfresco/api/-default-/public/alfresco/versions/1/";
    private static final String NODES_CHILDREN_URI = REST_API_URI + "nodes/-my-/children";

    private RestTemplate restTemplate;
    private String host;

    public RestApiClient(String host)
    {
        MappingJackson2HttpMessageConverter converter = new MappingJackson2HttpMessageConverter();
        converter.setObjectMapper(new ObjectMapper());

        restTemplate = new RestTemplate();
        restTemplate.getMessageConverters().add(converter);

        this.host = host;
    }

    public String createFileFromExisting(String username, String password, String path)
    {
        String fileNameExtension = StringUtils.getFilenameExtension(path);
        String fileNameCreated = UUID.randomUUID() + "." + fileNameExtension;

        LinkedMultiValueMap<String, Object> map = new LinkedMultiValueMap<String, Object>();
        map.add("filedata", new ClassPathResource(path));
        map.add("name", fileNameCreated);

        HttpHeaders headers = createHeadersWithBasicAuth(username, password);
        headers.setContentType(MediaType.MULTIPART_FORM_DATA);

        HttpEntity<LinkedMultiValueMap<String, Object>> requestEntity = new HttpEntity<LinkedMultiValueMap<String, Object>>(map, headers);

        restTemplate.exchange(getUrl(NODES_CHILDREN_URI), HttpMethod.POST, requestEntity, String.class);

        return fileNameCreated;
    }

    private HttpHeaders createHeadersWithBasicAuth(final String username, final String password)
    {
        return new HttpHeaders()
        {
            {
                String auth = username + ":" + password;
                byte[] encodedAuth = Base64.encodeBase64(auth.getBytes());
                String authHeader = "Basic " + new String(encodedAuth);
                set("Authorization", authHeader);
            }
        };
    }

    private String getUrl(String path)
    {
        return host + path;
    }
}