/*
 * Copyright 2005-2015 Alfresco Software, Ltd.  All rights reserved.
 *
 * This file is part of a proprietary Alfresco module.
 *
 * License rights for this program are granted under the terms of the "Alfresco
 * Component License", which defines the permitted uses of the module.
 * License terms can be found in the file license.txt distributed with this module.
 */
package org.alfresco.officeservices.testclient.fpse;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;

public class PushbackLineReader
{
    
    protected ArrayList<String> pushback = new ArrayList<String>();
    
    protected BufferedReader reader;
    
    protected int lineNumber = 0;
    
    public PushbackLineReader(InputStream in)
    {
        reader = new BufferedReader(new InputStreamReader(in));
    }
    
    public String readLine() throws IOException
    {
        if(pushback.size() > 0)
        {
            String p = pushback.get(pushback.size()-1);
            pushback.remove(pushback.size()-1);
            lineNumber++;
            return p;
        }
        String s = reader.readLine();
        lineNumber++;
        return s;
    }
    
    public void pushBack(String s)
    {
        lineNumber--;
        pushback.add(s);
    }
    
    public int getLineNumber()
    {
        return lineNumber;
    }

}
