/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.config.util;

import java.io.File;
import java.lang.invoke.CallSite;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;
import org.springframework.core.io.Resource;
import org.springframework.extensions.config.ConfigSource;
import org.springframework.extensions.config.source.ClassPathConfigSource;
import org.springframework.extensions.config.source.FileConfigSource;
import org.springframework.extensions.config.xml.XMLConfigService;

public abstract class BaseTest
extends TestCase {
    protected String resourcesDir;
    protected boolean loadFromClasspath;

    public BaseTest() {
        Object resourcesDir = null;
        if (this.getResourcesDir() == null) {
            resourcesDir = System.getProperty("alfresco.test.resources.dir");
            if (resourcesDir == null || ((String)resourcesDir).equals("")) {
                resourcesDir = System.getProperty("user.dir") + File.separator + "source" + File.separator + "test-resources";
            }
        } else {
            resourcesDir = this.getResourcesDir();
        }
        this.loadFromClasspath = ((String)resourcesDir).startsWith("classpath:");
        this.resourcesDir = (String)resourcesDir + (this.loadFromClasspath ? "" : File.separator);
    }

    public String getResourcesDir() {
        return this.resourcesDir;
    }

    protected void assertFileIsValid(String fullFileName) {
        if (this.loadFromClasspath) {
            String resourceName = fullFileName.substring(fullFileName.indexOf(":") + 1);
            BaseTest.assertNotNull((Object)resourceName);
            URL configResourceUrl = ((Object)((Object)this)).getClass().getClassLoader().getResource(resourceName);
            BaseTest.assertNotNull((Object)configResourceUrl);
        } else {
            File f = new File(fullFileName);
            BaseTest.assertTrue((String)("Required file missing: " + fullFileName), (boolean)f.exists());
            BaseTest.assertTrue((String)("Required file not readable: " + fullFileName), (boolean)f.canRead());
        }
    }

    protected XMLConfigService initXMLConfigService(String xmlConfigFile) {
        XMLConfigService svc = null;
        if (this.loadFromClasspath) {
            svc = new XMLConfigService((ConfigSource)new ClassPathConfigSource(xmlConfigFile));
        } else {
            String fullFileName = this.getResourcesDir() + xmlConfigFile;
            this.assertFileIsValid(fullFileName);
            svc = new XMLConfigService((ConfigSource)new FileConfigSource(fullFileName));
        }
        svc.initConfig();
        return svc;
    }

    protected XMLConfigService initXMLConfigService(String xmlConfigFile, String overridingXmlConfigFile) {
        ArrayList<String> files = new ArrayList<String>(2);
        files.add(xmlConfigFile);
        files.add(overridingXmlConfigFile);
        return this.initXMLConfigService(files);
    }

    protected XMLConfigService initXMLConfigService(List<String> xmlConfigFilenames) {
        ArrayList<CallSite> configFiles = new ArrayList<CallSite>();
        for (String filename : xmlConfigFilenames) {
            String path = (this.loadFromClasspath ? "" : this.getResourcesDir()) + filename;
            this.assertFileIsValid(path);
            configFiles.add((CallSite)((Object)path));
        }
        ClassPathConfigSource configSource = this.loadFromClasspath ? new ClassPathConfigSource(configFiles) : new FileConfigSource(configFiles);
        XMLConfigService svc = new XMLConfigService((ConfigSource)configSource);
        svc.initConfig();
        return svc;
    }

    protected XMLConfigService initXMLConfigServiceWithProperties(List<String> xmlConfigFilenames, Resource[] resources) {
        ArrayList<CallSite> configFiles = new ArrayList<CallSite>();
        for (String filename : xmlConfigFilenames) {
            String path = (this.loadFromClasspath ? "" : this.getResourcesDir()) + filename;
            this.assertFileIsValid(path);
            configFiles.add((CallSite)((Object)path));
        }
        ClassPathConfigSource configSource = this.loadFromClasspath ? new ClassPathConfigSource(configFiles) : new FileConfigSource(configFiles);
        XMLConfigService svc = new XMLConfigService((ConfigSource)configSource);
        if (resources != null) {
            svc.setProperties(resources);
        }
        svc.initConfig();
        return svc;
    }
}

