/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.evaluator;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.web.evaluator.BaseEvaluator;
import org.json.simple.JSONObject;

public class IsBrowserEvaluator
extends BaseEvaluator {
    private String regex;

    public void setRegex(String regex) {
        this.regex = regex;
    }

    public boolean evaluate(JSONObject jsonObject) {
        if (this.regex == null) {
            return false;
        }
        try {
            String userAgent = this.getHeader("user-agent");
            if (userAgent != null) {
                Pattern p = Pattern.compile(this.regex);
                Matcher m = p.matcher(userAgent);
                return m.find();
            }
        }
        catch (Exception err) {
            throw new AlfrescoRuntimeException("Failed to run action evaluator: " + err.getMessage());
        }
        return false;
    }
}

