/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.site.servlet.config;

import java.util.Iterator;
import org.alfresco.encryptor.PublicPrivateKeyShareStringEncryptor;
import org.dom4j.Attribute;
import org.dom4j.Element;
import org.jasypt.encryption.StringEncryptor;
import org.jasypt.properties.PropertyValueEncryptionUtils;

public class AlfrescoEncryptionElementConvert {
    private final PublicPrivateKeyShareStringEncryptor stringEncryptor;

    public AlfrescoEncryptionElementConvert() {
        this.stringEncryptor = new PublicPrivateKeyShareStringEncryptor();
        this.stringEncryptor.init();
    }

    public AlfrescoEncryptionElementConvert(PublicPrivateKeyShareStringEncryptor stringEncryptor) {
        this.stringEncryptor = stringEncryptor;
    }

    public void parse(Element element) {
        if (element != null) {
            this.convertElement(element);
            this.processChildren(element);
        }
    }

    protected void processChildren(Element element) {
        Iterator children = element.elementIterator();
        while (children.hasNext()) {
            Element child = (Element)children.next();
            this.convertElement(child);
            this.processChildren(child);
        }
    }

    protected void convertElement(Element element) {
        String value;
        if (element.hasContent() && !element.hasMixedContent() && (value = element.getTextTrim()) != null && value.length() > 0) {
            value = this.convertElementValue(value);
            element.setText(value);
        }
        Iterator attrs = element.attributeIterator();
        while (attrs.hasNext()) {
            Attribute attr = (Attribute)attrs.next();
            String attrName = attr.getName();
            String attrValue = attr.getValue();
            attrValue = this.convertElementValue(attrValue);
            element.addAttribute(attrName, attrValue);
        }
    }

    protected String convertElementValue(String originalValue) {
        if (!PropertyValueEncryptionUtils.isEncryptedValue((String)originalValue)) {
            return originalValue;
        }
        if (this.stringEncryptor != null) {
            return PropertyValueEncryptionUtils.decrypt((String)originalValue, (StringEncryptor)this.stringEncryptor);
        }
        return null;
    }
}

