/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.evaluator.doclib.action;

import java.util.Map;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.web.evaluator.BaseEvaluator;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.json.simple.JSONObject;

public class IsNodeEditableAos
extends BaseEvaluator {
    private static final String PROP_NAME = "cm:name";
    private Map<String, String> mimetypeExtensionMap;

    public void setMimetypeExtensionMap(Map<String, String> mimetypeExtensionMap) {
        this.mimetypeExtensionMap = mimetypeExtensionMap;
    }

    public boolean evaluate(JSONObject jsonObject) {
        if (this.mimetypeExtensionMap.size() == 0) {
            return false;
        }
        try {
            String mimetype = this.getNodeMimetype(jsonObject);
            String name = (String)this.getProperty(jsonObject, PROP_NAME);
            if (StringUtils.isEmpty((CharSequence)mimetype) || StringUtils.isEmpty((CharSequence)name)) {
                return false;
            }
            String fileExtension = FilenameUtils.getExtension((String)name);
            if (StringUtils.isEmpty((CharSequence)fileExtension)) {
                return false;
            }
            String expectedExtension = (String)this.mimetypeExtensionMap.get(mimetype);
            if (expectedExtension == null || !expectedExtension.equals(fileExtension.toLowerCase())) {
                return false;
            }
        }
        catch (Exception ex) {
            throw new AlfrescoRuntimeException("Failed to run action evaluator: " + ex.getMessage());
        }
        return true;
    }
}

