/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.config.forms;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.alfresco.web.config.forms.FieldVisibilityInstruction;
import org.alfresco.web.config.forms.Mode;
import org.alfresco.web.config.forms.Visibility;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class FieldVisibilityManager {
    private static Log logger = LogFactory.getLog(FieldVisibilityManager.class);
    private List<FieldVisibilityInstruction> visibilityInstructions = new ArrayList<FieldVisibilityInstruction>();

    FieldVisibilityManager() {
    }

    void addInstruction(String showOrHide, String fieldId, String modesString) {
        this.visibilityInstructions.add(new FieldVisibilityInstruction(showOrHide, fieldId, modesString));
    }

    public FieldVisibilityManager combine(FieldVisibilityManager otherFVM) {
        if (otherFVM == this) {
            return this;
        }
        FieldVisibilityManager result = new FieldVisibilityManager();
        result.visibilityInstructions.addAll(this.visibilityInstructions);
        result.visibilityInstructions.addAll(otherFVM.visibilityInstructions);
        return result;
    }

    public boolean isFieldVisible(String fieldId, Mode m) {
        if (this.visibilityInstructions.isEmpty()) {
            return true;
        }
        int indexOfFirstShow = this.getIndexOfFirstShow();
        if (indexOfFirstShow != -1) {
            List<FieldVisibilityInstruction> relevantInstructions = this.visibilityInstructions.subList(indexOfFirstShow, this.visibilityInstructions.size());
            boolean showCurrentField = false;
            for (FieldVisibilityInstruction fvi : relevantInstructions) {
                if (!fvi.getFieldId().equals(fieldId) || !fvi.getModes().contains((Object)m)) continue;
                showCurrentField = fvi.getShowOrHide().equals((Object)Visibility.SHOW);
            }
            return showCurrentField;
        }
        for (FieldVisibilityInstruction fvi : this.visibilityInstructions) {
            if (!fvi.getFieldId().equals(fieldId) || !fvi.getShowOrHide().equals((Object)Visibility.HIDE) || !fvi.getModes().contains((Object)m)) continue;
            return false;
        }
        return true;
    }

    public boolean isFieldHidden(String fieldId, Mode m) {
        for (FieldVisibilityInstruction fvi : this.visibilityInstructions) {
            if (!fvi.getFieldId().equals(fieldId) || !fvi.getShowOrHide().equals((Object)Visibility.HIDE) || !fvi.getModes().contains((Object)m)) continue;
            return true;
        }
        return false;
    }

    public int getIndexOfFirstShow() {
        for (int i = 0; i < this.visibilityInstructions.size(); ++i) {
            if (!this.visibilityInstructions.get(i).getShowOrHide().equals((Object)Visibility.SHOW)) continue;
            return i;
        }
        return -1;
    }

    public boolean isManagingHiddenFields() {
        return this.getIndexOfFirstShow() != -1;
    }

    public List<String> getFieldNamesVisibleInMode(Mode mode) {
        int indexOfFirstShow = this.getIndexOfFirstShow();
        if (indexOfFirstShow == -1) {
            return null;
        }
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        List<FieldVisibilityInstruction> relevantInstructions = this.visibilityInstructions.subList(indexOfFirstShow, this.visibilityInstructions.size());
        for (FieldVisibilityInstruction fvi : relevantInstructions) {
            if (!fvi.getModes().contains((Object)mode)) continue;
            if (fvi.getShowOrHide().equals((Object)Visibility.SHOW)) {
                result.add(fvi.getFieldId());
                continue;
            }
            if (!fvi.getShowOrHide().equals((Object)Visibility.HIDE)) continue;
            result.remove(fvi.getFieldId());
        }
        return Collections.unmodifiableList(new ArrayList(result));
    }

    public List<String> getFieldNamesHiddenInMode(Mode mode) {
        int indexOfFirstShow = this.getIndexOfFirstShow();
        if (indexOfFirstShow != -1) {
            return null;
        }
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (FieldVisibilityInstruction fvi : this.visibilityInstructions) {
            if (!fvi.getModes().contains((Object)mode) || !fvi.getShowOrHide().equals((Object)Visibility.HIDE)) continue;
            result.add(fvi.getFieldId());
        }
        if (result.size() == 0) {
            return null;
        }
        return Collections.unmodifiableList(new ArrayList(result));
    }
}

