/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.evaluator;

import java.util.ArrayList;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.web.evaluator.BaseEvaluator;
import org.json.simple.JSONObject;

public class IsMimetypeEvaluator
extends BaseEvaluator {
    private ArrayList<String> mimetypes;

    public void setMimetypes(ArrayList<String> mimetypes) {
        this.mimetypes = mimetypes;
    }

    public boolean evaluate(JSONObject jsonObject) {
        if (this.mimetypes.size() == 0) {
            return false;
        }
        try {
            JSONObject node = (JSONObject)jsonObject.get((Object)"node");
            if (node == null) {
                return false;
            }
            String mimetype = (String)node.get((Object)"mimetype");
            if (mimetype == null || !this.mimetypes.contains(mimetype)) {
                return false;
            }
        }
        catch (Exception err) {
            throw new AlfrescoRuntimeException("Failed to run action evaluator: " + err.getMessage());
        }
        return true;
    }
}

