/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.directives;

import freemarker.core.Environment;
import freemarker.template.TemplateDirectiveBody;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.directives.AbstractDependencyExtensibilityDirective;
import org.springframework.extensions.surf.DependencyHandler;
import org.springframework.extensions.surf.DependencyHandlerProcessingCallback;
import org.springframework.extensions.surf.extensibility.ExtensibilityModel;
import org.springframework.extensions.surf.types.TemplateInstance;

public class ChecksumResourceDirective
extends AbstractDependencyExtensibilityDirective {
    private static final Log logger = LogFactory.getLog(ChecksumResourceDirective.class);

    public ChecksumResourceDirective(String directiveName, ExtensibilityModel model) {
        super(directiveName, model);
    }

    public void execute(Environment env, Map params, TemplateModel[] loopVars, TemplateDirectiveBody body) throws TemplateException, IOException {
        if (!(this.getModelObject() instanceof TemplateInstance) || !this.getRequestContext().isPassiveMode()) {
            String src = this.getStringProperty(params, "src", true);
            if (this.getRequestContext().dependencyAlreadyRequested(src)) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("A duplicate request was made for \"" + src + "\". This duplicate request has been removed but may potentially cause problems resulting from unexpected ordering"));
                }
                env.getOut().write("404_caused_by_duplicate_request: " + src);
            } else {
                String parm = this.getStringProperty(params, "parameter", false);
                AbstractDependencyExtensibilityDirective.ProcessedDependency pd = this.processDependency(src);
                if (this.dependencyHandler != null) {
                    if (parm == null) {
                        String checksumPath = this.dependencyHandler.getChecksumPath(this.getUpdatedSrc(pd));
                        if (checksumPath != null) {
                            env.getOut().write(this.getToInsert(pd) + checksumPath);
                            this.getRequestContext().markDependencyAsRequested(src);
                        } else {
                            logger.error((Object)("It was not possible to generate the resource request for: \"" + src + "\" because the resource could not be found"));
                        }
                    } else {
                        String checksum = this.dependencyHandler.getChecksum(this.getUpdatedSrc(pd), new DependencyHandlerProcessingCallback(){

                            @Override
                            public String process(DependencyHandler handler, String path, String contents) throws IOException {
                                String resourceContents = contents;
                                if (path.toLowerCase().endsWith(".css")) {
                                    StringBuilder processedContents = new StringBuilder(resourceContents);
                                    if (handler.getWebFrameworkConfigElement().isGenerateCssDataImagesEnabled() && handler.getCssDataImageHandler() != null) {
                                        handler.getCssDataImageHandler().processCssImages(path, processedContents);
                                    }
                                    resourceContents = handler.getCssThemeHandler() != null ? handler.getCssThemeHandler().processCssThemes(path, processedContents) : processedContents.toString();
                                }
                                return resourceContents;
                            }
                        });
                        env.getOut().write(this.getToInsert(pd) + this.getUpdatedSrc(pd) + "?" + parm + "=" + checksum);
                        this.getRequestContext().markDependencyAsRequested(src);
                    }
                }
            }
        }
    }
}

