/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.directives;

import freemarker.core.Environment;
import freemarker.template.SimpleHash;
import freemarker.template.SimpleScalar;
import freemarker.template.SimpleSequence;
import freemarker.template.TemplateDirectiveBody;
import freemarker.template.TemplateException;
import freemarker.template.TemplateHashModel;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.springframework.extensions.config.Config;
import org.springframework.extensions.config.ConfigService;
import org.springframework.extensions.config.ServerConfigElement;
import org.springframework.extensions.config.ServerProperties;
import org.springframework.extensions.config.WebFrameworkConfigElement;
import org.springframework.extensions.directives.DependencyDirectiveData;
import org.springframework.extensions.directives.JavaScriptDependencyDirective;
import org.springframework.extensions.directives.OutputCSSContentModelElement;
import org.springframework.extensions.directives.OutputJavaScriptContentModelElement;
import org.springframework.extensions.surf.DojoDependencies;
import org.springframework.extensions.surf.DojoDependencyHandler;
import org.springframework.extensions.surf.I18nDependencyHandler;
import org.springframework.extensions.surf.RequestContext;
import org.springframework.extensions.surf.extensibility.DeferredContentTargetModelElement;
import org.springframework.extensions.surf.extensibility.ExtensibilityDirectiveData;
import org.springframework.extensions.surf.extensibility.ExtensibilityModel;
import org.springframework.extensions.surf.extensibility.impl.DefaultExtensibilityDirectiveData;
import org.springframework.extensions.surf.support.ThreadLocalRequestContext;
import org.springframework.extensions.surf.types.AbstractModelObject;
import org.springframework.extensions.surf.uri.UriUtils;
import org.springframework.extensions.webscripts.LocalWebScriptContext;
import org.springframework.extensions.webscripts.LocalWebScriptRuntime;
import org.springframework.extensions.webscripts.LocalWebScriptRuntimeContainer;
import org.springframework.extensions.webscripts.Match;
import org.springframework.extensions.webscripts.RuntimeContainer;
import org.springframework.extensions.webscripts.ScriptConfigModel;
import org.springframework.extensions.webscripts.json.JSONWriter;

public class ProcessJsonModelDirective
extends JavaScriptDependencyDirective {
    private static final Log logger = LogFactory.getLog(DojoDependencyHandler.class);
    public static final String DIRECTIVE_NAME = "processJsonModel";
    public static final String MODEL_KEY = "jsonModel";
    public static final String TARGET_DOM_ID_KEY = "rootNodeId";
    public static final String PUB_SUB_SCOPE_KEY = "pubSubScope";
    public static final String GROUP_MEMBERSHIPS_KEY = "groupMemberships";
    private DojoDependencyHandler dojoDependencyHandler = null;
    private I18nDependencyHandler i18nDependencyHandler = null;
    private LocalWebScriptRuntimeContainer webScriptsContainer;
    private ConfigService configService;
    public static Pattern pattern = Pattern.compile("\\$\\$([A-Za-z0-9_\\-]*)\\$\\$");

    public ProcessJsonModelDirective(String directiveName, ExtensibilityModel model) {
        super(directiveName, model);
    }

    public void setDojoDependencyHandler(DojoDependencyHandler dojoDependencyHandler) {
        this.dojoDependencyHandler = dojoDependencyHandler;
    }

    public void setI18nDependencyHandler(I18nDependencyHandler i18nDependencyHandler) {
        this.i18nDependencyHandler = i18nDependencyHandler;
    }

    public void setWebScriptsContainer(LocalWebScriptRuntimeContainer webScriptsContainer) {
        this.webScriptsContainer = webScriptsContainer;
    }

    public void setConfigService(ConfigService configService) {
        this.configService = configService;
    }

    @Override
    public ExtensibilityDirectiveData createExtensibilityDirectiveData(String id, String action, String target, Map params, TemplateDirectiveBody body, Environment env) throws TemplateException {
        TemplateHashModel model = env.getDataModel();
        String group = this.getStringProperty(params, "group", false);
        List services = Collections.emptyList();
        List widgets = Collections.emptyList();
        List publishOnLoad = Collections.emptyList();
        String targetDomId = "content";
        String pubSubScope = null;
        String groupMemberships = null;
        TemplateModel o = model.get(MODEL_KEY);
        if (o instanceof SimpleScalar) {
            String jsonString = o.toString();
            JSONParser jp = new JSONParser();
            try {
                Object parsedObject = jp.parse(jsonString);
                if (parsedObject instanceof JSONObject) {
                    JSONObject jo = (JSONObject)parsedObject;
                    o = new SimpleHash((Map)jo);
                }
            }
            catch (ParseException e) {
                throw new TemplateException((Exception)((Object)e), env);
            }
        }
        if (o instanceof SimpleHash) {
            TemplateModel _groupMemberships;
            TemplateModel _pubSubScope;
            SimpleHash pageConfig = (SimpleHash)o;
            TemplateModel _targetDomId = pageConfig.get(TARGET_DOM_ID_KEY);
            if (_targetDomId instanceof SimpleScalar) {
                targetDomId = _targetDomId.toString().trim();
            }
            if ((_pubSubScope = pageConfig.get(PUB_SUB_SCOPE_KEY)) instanceof SimpleScalar) {
                pubSubScope = _pubSubScope.toString().trim();
            }
            if ((_groupMemberships = pageConfig.get(GROUP_MEMBERSHIPS_KEY)) instanceof SimpleScalar) {
                StringBuilder groupsJSONStr = new StringBuilder("{");
                groupMemberships = _groupMemberships.toString().trim();
                String[] groups = groupMemberships.split(",");
                for (String g : groups) {
                    if (g == null || g.trim().equals("")) continue;
                    groupsJSONStr.append("\"");
                    groupsJSONStr.append(g);
                    groupsJSONStr.append("\":true,");
                }
                if (groupsJSONStr.length() > 1) {
                    groupsJSONStr.deleteCharAt(groupsJSONStr.length() - 1);
                }
                groupsJSONStr.append("}");
                groupMemberships = groupsJSONStr.toString();
            }
            if ((o = pageConfig.get("services")) instanceof SimpleSequence) {
                services = ((SimpleSequence)o).toList();
            }
            if ((o = pageConfig.get("widgets")) instanceof SimpleSequence) {
                widgets = ((SimpleSequence)o).toList();
            }
            if ((o = pageConfig.get("publishOnReady")) instanceof SimpleSequence) {
                publishOnLoad = ((SimpleSequence)o).toList();
            }
        }
        String servicesJSONStr = UriUtils.replaceTokens(JSONWriter.encodeToJSON(services), this.getRequestContext(), pattern, 1, "");
        String widgetsJSONStr = UriUtils.replaceTokens(JSONWriter.encodeToJSON(widgets), this.getRequestContext(), pattern, 1, "");
        String publishOnLoadJSONStr = UriUtils.replaceTokens(JSONWriter.encodeToJSON(publishOnLoad), this.getRequestContext(), pattern, 1, "");
        LinkedHashMap<String, DojoDependencies> dependenciesForCurrentRequest = new LinkedHashMap<String, DojoDependencies>(256);
        String rootModule = this.getStringProperty(params, "rootModule", false);
        if (rootModule == null) {
            RequestContext rc = ThreadLocalRequestContext.getRequestContext();
            ScriptConfigModel config = rc.getExtendedScriptConfigModel(null);
            Map configs = (Map)config.getScoped().get("WebFramework");
            if (configs != null) {
                WebFrameworkConfigElement wfce = (WebFrameworkConfigElement)configs.get("web-framework");
                rootModule = wfce.getDojoPageWidget();
            } else {
                rootModule = this.getWebFrameworkConfig().getDojoPageWidget();
            }
        }
        String pagePath = this.dojoDependencyHandler.getPath(null, rootModule) + ".js";
        DojoDependencies pageDeps = this.dojoDependencyHandler.getDependencies(pagePath);
        this.dojoDependencyHandler.recursivelyProcessDependencies(pageDeps, dependenciesForCurrentRequest);
        String domReadyPath = this.dojoDependencyHandler.getPath(null, "dojo/domReady") + ".js";
        DojoDependencies domReadyDeps = this.dojoDependencyHandler.getDependencies(domReadyPath);
        dependenciesForCurrentRequest.put(domReadyPath, domReadyDeps);
        this.dojoDependencyHandler.recursivelyProcessDependencies(domReadyDeps, dependenciesForCurrentRequest);
        if (services != null) {
            for (Object service : services) {
                String servicePath = null;
                if (service instanceof Map) {
                    Map map = (Map)service;
                    Object s = map.get("name");
                    if (s instanceof String) {
                        servicePath = this.dojoDependencyHandler.getPath(null, (String)s) + ".js";
                    }
                } else if (service instanceof String) {
                    servicePath = this.dojoDependencyHandler.getPath(null, (String)service) + ".js";
                }
                if (servicePath == null) continue;
                DojoDependencies serviceDeps = this.dojoDependencyHandler.getDependencies(servicePath);
                dependenciesForCurrentRequest.put(servicePath, serviceDeps);
                this.dojoDependencyHandler.recursivelyProcessDependencies(serviceDeps, dependenciesForCurrentRequest);
            }
        }
        this.dojoDependencyHandler.processControllerWidgets(widgets, dependenciesForCurrentRequest);
        DojoDependencies dd = new DojoDependencies();
        this.dojoDependencyHandler.processString(widgetsJSONStr, dd, dependenciesForCurrentRequest);
        this.dojoDependencyHandler.processString(servicesJSONStr, dd, dependenciesForCurrentRequest);
        dependenciesForCurrentRequest.put("alfresco/dummy/module.js", dd);
        String checksum = this.dojoDependencyHandler.getChecksumForDependencies(dependenciesForCurrentRequest, pagePath, pageDeps);
        String prefix = this.dependencyAggregator.getServletContext().getContextPath() + this.dependencyHandler.getResourceControllerMapping() + "/";
        OutputCSSContentModelElement outputCss = null;
        DeferredContentTargetModelElement te = this.getModel().getDeferredContent("outputCSSDependenciesDirective", "outputCSS");
        if (te instanceof OutputCSSContentModelElement) {
            outputCss = (OutputCSSContentModelElement)te;
            this.dojoDependencyHandler.processCssDependencies(dependenciesForCurrentRequest, outputCss, prefix, group);
        }
        OutputJavaScriptContentModelElement outputJs = null;
        te = this.getModel().getDeferredContent("outputJavaScriptDirective", "outputJavaScript");
        if (te instanceof OutputJavaScriptContentModelElement) {
            outputJs = (OutputJavaScriptContentModelElement)te;
            this.dojoDependencyHandler.processNonAmdDependencies(dependenciesForCurrentRequest, outputJs, prefix, group);
        }
        String i18nContent = this.buildI18nForPage(dependenciesForCurrentRequest, model);
        DeferredContentTargetModelElement targetElement = this.getModel().getDeferredContent("outputJavaScriptDirective", "outputJavaScript");
        DependencyDirectiveData directiveData = new DependencyDirectiveData(id, action, target, this.getDirectiveName(), body, env, i18nContent, group, true, targetElement);
        try {
            this.merge((ExtensibilityDirectiveData)directiveData, params);
        }
        catch (IOException e) {
            throw new TemplateException((Exception)e, env);
        }
        String constantsContent = this.buildConstantsForPage();
        DependencyDirectiveData constantsDirectiveData = new DependencyDirectiveData(id, action, target, this.getDirectiveName(), body, env, constantsContent, group, true, targetElement);
        try {
            this.merge((ExtensibilityDirectiveData)constantsDirectiveData, params);
        }
        catch (IOException e) {
            throw new TemplateException((Exception)e, env);
        }
        String jsContent = this.buildJavaScriptForPage(checksum, servicesJSONStr, widgetsJSONStr, publishOnLoadJSONStr, targetDomId, pubSubScope, groupMemberships, dependenciesForCurrentRequest, model);
        TemplateDirectiveBody tdb = new TemplateDirectiveBody(){
            private String content = "";

            public TemplateDirectiveBody setContent(String content) {
                this.content = content;
                return this;
            }

            public void render(Writer writer) throws TemplateException, IOException {
                writer.write(this.content);
            }
        }.setContent(jsContent);
        DefaultExtensibilityDirectiveData d = new DefaultExtensibilityDirectiveData(id, "merge", target, DIRECTIVE_NAME, tdb, env);
        return d;
    }

    protected String buildI18nForPage(Map<String, DojoDependencies> dependenciesForCurrentRequest, TemplateHashModel model) {
        StringBuilder content = new StringBuilder(10240);
        content.append(">>>");
        content.append(this.i18nDependencyHandler.generateI18nJavaScript(dependenciesForCurrentRequest));
        try {
            String messages = "";
            TemplateModel _messages = model.get("messages");
            if (_messages instanceof SimpleScalar) {
                messages = ((SimpleScalar)_messages).toString();
                String globalMessagesObject = this.getWebFrameworkConfig().getDojoMessagesObject();
                content.append("var pageScopeMsgs = ");
                content.append(messages);
                content.append(";\n   if (");
                content.append(globalMessagesObject);
                content.append(".messages.pageScope) {\n   for (var key in pageScopeMsgs) { \n      ");
                content.append(globalMessagesObject);
                content.append(".messages.pageScope[key] = pageScopeMsgs[key];\n}\n}\nelse {\n   ");
                content.append(globalMessagesObject);
                content.append(".messages.pageScope = ");
                content.append(messages);
                content.append(";\n}\n");
            }
        }
        catch (TemplateModelException templateModelException) {
            // empty catch block
        }
        return content.toString();
    }

    protected String buildJavaScriptForPage(String checksum, String servicesJSONStr, String widgetsJSONStr, String publishOnLoadJSONStr, String rootDomId, String pubSubScope, String groupMemberships, Map<String, DojoDependencies> dependenciesForCurrentRequest, TemplateHashModel model) {
        Match match;
        String wsId;
        String url;
        StringBuilder content = new StringBuilder(10240);
        content.append("   <script type=\"text/javascript\">//<![CDATA[\n");
        if (this.getWebFrameworkConfig().isDojoLoaderTraceEnabled()) {
            content.append("require.trace.set(\"loader-inject\", 1);\nrequire.trace.set(\"loader-define\", 0);\n");
        }
        if (this.dependencyAggregator.isDebugMode()) {
            content.append(this.getWebFrameworkConfig().getDojoMessagesObject());
            content.append(".logging = true;\n");
        }
        content.append("require(['");
        content.append(checksum.substring(3, checksum.length() - 3));
        content.append("','dojo/domReady!");
        content.append("'], function(Page) {\n var p = new Page({services:");
        content.append(servicesJSONStr);
        content.append(",widgets:");
        content.append(widgetsJSONStr);
        content.append(",publishOnReady:");
        content.append(publishOnLoadJSONStr);
        if (pubSubScope != null && !pubSubScope.trim().equals("")) {
            content.append(",pubSubScope:\"");
            content.append(pubSubScope);
            content.append("\"");
        }
        if (groupMemberships != null && !groupMemberships.trim().equals("")) {
            content.append(",groupMemberships:");
            content.append(groupMemberships);
        }
        if ((url = this.getModelObject().getProperty("url")) != null && this.webScriptsContainer != null && this.webScriptsContainer.getRegistry() != null && (wsId = (match = this.webScriptsContainer.getRegistry().findWebScript("GET", url)).getWebScript().getDescription().getId()) != null) {
            content.append(",webScriptId:\"");
            content.append(wsId);
            content.append("\"");
        }
        content.append("\n}, '");
        content.append(rootDomId);
        content.append("');\n});\n");
        content.append("//]]></script>\n");
        return content.toString();
    }

    protected String buildConstantsForPage() {
        StringBuilder content = new StringBuilder(10240);
        content.append(">>>");
        content.append("require({cache:{\n");
        content.append("'service/constants/Default':function(){\n");
        StringWriter writer = new StringWriter();
        this.runWebScript("/constants/Default", writer);
        content.append(((Object)writer).toString());
        content.append("   }\n}});");
        return content.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runWebScript(String uri, Writer writer) {
        RequestContext context = this.getRequestContext();
        LocalWebScriptContext webScriptContext = new LocalWebScriptContext();
        webScriptContext.setTokens(context.getParameters());
        String url = UriUtils.replaceTokens(uri, context, null, null, "");
        webScriptContext.setScriptUrl(url.indexOf(63) == -1 ? url : url.substring(0, url.indexOf(63)));
        String requestPath = (String)((Object)context.getValue("requestPath"));
        if (requestPath == null) {
            requestPath = context.getContextPath();
        }
        webScriptContext.setExecuteUrl(requestPath + "/service" + url);
        webScriptContext.setRuntimeContainer((RuntimeContainer)this.webScriptsContainer);
        webScriptContext.setRequestContext(context);
        DummyModelObject dmo = new DummyModelObject();
        webScriptContext.setModelObject(dmo);
        Config config = this.configService.getConfig((Object)"Server");
        ServerConfigElement serverProperties = (ServerConfigElement)config.getConfigElement("server");
        LocalWebScriptRuntime runtime = new LocalWebScriptRuntime(writer, (RuntimeContainer)this.webScriptsContainer, (ServerProperties)serverProperties, webScriptContext);
        if (context.getRequestMethod() != null) {
            runtime.setScriptMethod("GET");
        }
        this.webScriptsContainer.suppressExtensibility();
        try {
            runtime.executeScript();
        }
        finally {
            this.webScriptsContainer.unsuppressExtensibility();
        }
    }

    class DummyModelObject
    extends AbstractModelObject {
        DummyModelObject() {
        }

        @Override
        public String getTypeId() {
            return null;
        }

        @Override
        public Map<String, Serializable> getProperties() {
            return new HashMap<String, Serializable>(16, 1.0f);
        }

        @Override
        public Map<String, Serializable> getCustomProperties() {
            return new HashMap<String, Serializable>(16, 1.0f);
        }
    }
}

