/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.surf;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.extensions.surf.DependencyHandler;
import org.springframework.extensions.surf.DojoDependencies;
import org.springframework.extensions.surf.DojoDependencyHandler;
import org.springframework.extensions.surf.util.I18NUtil;

public class DojoDependencyRule {
    private String declarationRegex;
    private Pattern declarationRegexPattern;
    private String dependencyRegex;
    private Pattern dependencyRegexPattern;
    private int targetGroup;
    private DojoDependencyHandler dojoDependencyHandler;
    private DependencyHandler dependencyHandler;
    private Map<Pattern, String> tokenMap = new HashMap<Pattern, String>(1);

    public Map<Pattern, String> getTokens() {
        return this.tokenMap;
    }

    protected String replaceTokens(String input) {
        String output = input;
        StringBuffer sb = new StringBuffer();
        Map<Pattern, String> tokens = this.getTokens();
        if (tokens != null) {
            for (Map.Entry<Pattern, String> tokenEntry : tokens.entrySet()) {
                Matcher matcher = tokenEntry.getKey().matcher(input);
                while (matcher.find()) {
                    matcher.appendReplacement(sb, tokenEntry.getValue());
                }
                matcher.appendTail(sb);
                output = sb.toString();
            }
        }
        return output;
    }

    protected void processRegexRules(String filePath, String fileContents, DojoDependencies dependencies) {
        Matcher m1 = this.declarationRegexPattern.matcher(fileContents);
        while (m1.find()) {
            String deps;
            if (m1.groupCount() < this.targetGroup || (deps = m1.group(this.targetGroup)) == null) continue;
            Matcher m2 = this.dependencyRegexPattern.matcher(deps);
            while (m2.find()) {
                String dep = m2.group(1);
                if (dep == null) continue;
                this.processDependency(dep, filePath, fileContents, m2, dependencies);
            }
        }
    }

    protected void processDependency(String dependency, String sourcePath, String sourceContents, Matcher matcher, DojoDependencies dependencies) {
        if ((dependency = dependency.trim()).startsWith("\"") || dependency.startsWith("'")) {
            dependency = dependency.substring(1);
        }
        if (dependency.endsWith("\"") || dependency.startsWith("'")) {
            dependency = dependency.substring(0, dependency.length() - 1);
        }
        if (dependency.contains("!")) {
            int eIdx;
            if (dependency.contains("dojo/text!")) {
                String textDependency = dependency.substring(dependency.indexOf("!") + 1);
                dependencies.addTextDep(textDependency);
            } else if (dependency.contains("/i18n!")) {
                String i18nDependency = dependency.substring(dependency.indexOf("!") + 1);
                Locale locale = I18NUtil.getLocale();
                String depPath = this.dojoDependencyHandler.getPath(sourcePath, i18nDependency) + ".js";
                this.addJavaScriptDependency(dependencies, depPath);
                String languageDep = null;
                String languageCountryDep = null;
                int lastSlash = i18nDependency.lastIndexOf("/");
                if (lastSlash == -1) {
                    languageDep = locale.getLanguage() + "/" + i18nDependency;
                    languageCountryDep = locale.getLanguage() + "-" + locale.getCountry().toLowerCase() + "/" + i18nDependency;
                } else {
                    String prefix = i18nDependency.substring(0, lastSlash);
                    String suffix = i18nDependency.substring(lastSlash);
                    languageDep = prefix + "/" + locale.getLanguage() + suffix;
                    languageCountryDep = prefix + "/" + locale.getLanguage() + "-" + locale.getCountry().toLowerCase() + suffix;
                }
                if (languageDep != null) {
                    depPath = this.dojoDependencyHandler.getPath(sourcePath, languageDep) + ".js";
                    this.addJavaScriptDependency(dependencies, depPath);
                }
                if (languageCountryDep != null) {
                    depPath = this.dojoDependencyHandler.getPath(sourcePath, languageCountryDep) + ".js";
                    this.addJavaScriptDependency(dependencies, depPath);
                }
            }
            String pluginDep = dependency.substring(dependency.indexOf("!") + 1);
            String pluginPath = this.dojoDependencyHandler.getPath(sourcePath, pluginDep) + ".js";
            this.addJavaScriptDependency(dependencies, pluginPath);
            if (pluginPath.endsWith("dojo/has.js") && (eIdx = dependency.indexOf("!")) != -1) {
                String ternary = dependency.substring(eIdx + 1);
                Pattern p1 = Pattern.compile("([^:|\\?])*");
                Matcher m1 = p1.matcher(ternary);
                while (m1.find()) {
                    String ternaryDep = m1.group(0);
                    if (ternaryDep == null || ternaryDep.equals("")) continue;
                    String ternaryDepPath = this.dojoDependencyHandler.getPath(sourcePath, ternaryDep) + ".js";
                    this.addJavaScriptDependency(dependencies, ternaryDepPath);
                }
            }
        } else {
            String depPath = this.dojoDependencyHandler.getPath(sourcePath, dependency) + ".js";
            this.addJavaScriptDependency(dependencies, depPath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addJavaScriptDependency(DojoDependencies dependencies, String path) {
        block6: {
            try {
                if (this.dependencyHandler.resourceInCache(path)) {
                    dependencies.addJavaScriptDep(path);
                    break block6;
                }
                InputStream in = this.dependencyHandler.getResourceInputStream(path);
                if (in == null) break block6;
                try {
                    dependencies.addJavaScriptDep(path);
                }
                finally {
                    in.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addNonAmdJavaScriptDependency(DojoDependencies dependencies, String path) {
        block6: {
            try {
                InputStream in;
                if (path.startsWith("/")) {
                    path = path.substring(1);
                }
                if ((in = this.dependencyHandler.getResourceInputStream(path)) == null) break block6;
                try {
                    dependencies.addNonAmdDep(path);
                }
                finally {
                    in.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public String getDeclarationRegex() {
        return this.declarationRegex;
    }

    public Pattern getDeclarationRegexPattern() {
        return this.declarationRegexPattern;
    }

    public void setDeclarationRegex(String declarationRegex) {
        this.declarationRegex = declarationRegex;
        this.declarationRegexPattern = Pattern.compile(declarationRegex);
    }

    public String getDependencyRegex() {
        return this.dependencyRegex;
    }

    public Pattern getDependencyRegexPattern() {
        return this.dependencyRegexPattern;
    }

    public void setDependencyRegex(String dependencyRegex) {
        this.dependencyRegex = dependencyRegex;
        this.dependencyRegexPattern = Pattern.compile(dependencyRegex);
    }

    public int getTargetGroup() {
        return this.targetGroup;
    }

    public void setTargetGroup(int targetGroup) {
        this.targetGroup = targetGroup;
    }

    public void setDojoDependencyHandler(DojoDependencyHandler dojoDependencyHandler) {
        this.dojoDependencyHandler = dojoDependencyHandler;
    }

    public DojoDependencyHandler getDojoDependencyHandler() {
        return this.dojoDependencyHandler;
    }

    public void setDependencyHandler(DependencyHandler dependencyHandler) {
        this.dependencyHandler = dependencyHandler;
    }

    public DependencyHandler getDependencyHandler() {
        return this.dependencyHandler;
    }
}

