/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.surf;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.surf.LessCssThemeHandler;

public class ExternalLessCssThemeHandler
extends LessCssThemeHandler {
    private static final Log logger = LogFactory.getLog(ExternalLessCssThemeHandler.class);
    private String cmd;

    public void setCmd(String cmd) {
        this.cmd = cmd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String processCssThemes(String path, StringBuilder cssContents) throws IOException {
        if (this.cmd == null || this.cmd.length() == 0) {
            throw new IllegalArgumentException("External LESS 'cmd' not set correctly in bean config.");
        }
        Process proc = Runtime.getRuntime().exec(this.cmd);
        BufferedWriter stdIn = new BufferedWriter(new OutputStreamWriter(proc.getOutputStream()));
        BufferedReader stdOut = new BufferedReader(new InputStreamReader(proc.getInputStream()));
        BufferedReader stdError = new BufferedReader(new InputStreamReader(proc.getErrorStream()));
        try {
            String s;
            stdIn.append(this.getLessVariables());
            stdIn.append(cssContents.toString());
            stdIn.close();
            StringBuilder buf = new StringBuilder(1024);
            while ((s = stdOut.readLine()) != null) {
                buf.append(s);
            }
            stdOut.close();
            s = stdError.readLine();
            if (s != null) {
                buf = new StringBuilder("Error during external LESS compilation for path: ").append(path).append("\r\n");
                do {
                    buf.append(s);
                } while ((s = stdError.readLine()) != null);
                stdError.close();
                throw new IOException(buf.toString());
            }
            String string = buf.toString();
            return string;
        }
        finally {
            stdError.close();
            stdOut.close();
            stdIn.close();
        }
    }
}

