/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.surf.mvc;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import org.springframework.extensions.config.WebFrameworkConfigElement;
import org.springframework.extensions.surf.ModelObjectService;
import org.springframework.extensions.surf.RequestContext;
import org.springframework.extensions.surf.RequestContextUtil;
import org.springframework.extensions.surf.ServletUtil;
import org.springframework.extensions.surf.TemplatesContainer;
import org.springframework.extensions.surf.WebFrameworkServiceRegistry;
import org.springframework.extensions.surf.exception.RendererExecutionException;
import org.springframework.extensions.surf.render.RenderService;
import org.springframework.extensions.surf.resource.ResourceService;
import org.springframework.extensions.surf.support.ThreadLocalRequestContext;
import org.springframework.extensions.surf.types.Page;
import org.springframework.extensions.surf.types.TemplateInstance;
import org.springframework.extensions.webscripts.DefaultURLHelper;
import org.springframework.extensions.webscripts.TemplateProcessor;
import org.springframework.extensions.webscripts.TemplateProcessorRegistry;
import org.springframework.extensions.webscripts.URLHelper;
import org.springframework.extensions.webscripts.URLHelperFactory;
import org.springframework.web.servlet.view.AbstractUrlBasedView;

public abstract class AbstractWebFrameworkView
extends AbstractUrlBasedView {
    public static final String MIMETYPE_HTML = "text/html;charset=utf-8";
    private URLHelperFactory urlHelperFactory = null;
    private WebFrameworkConfigElement webFrameworkConfiguration;
    private ModelObjectService modelObjectService;
    private ResourceService resourceService;
    private TemplatesContainer templatesContainer;
    private RenderService renderService;
    private Map<String, String> uriTokens = null;

    public AbstractWebFrameworkView(WebFrameworkConfigElement webFrameworkConfiguration, ModelObjectService modelObjectService, ResourceService resourceService, RenderService renderService, TemplatesContainer templatesContainer) {
        this.webFrameworkConfiguration = webFrameworkConfiguration;
        this.modelObjectService = modelObjectService;
        this.resourceService = resourceService;
        this.templatesContainer = templatesContainer;
        this.renderService = renderService;
    }

    public AbstractWebFrameworkView(WebFrameworkServiceRegistry webFrameworkServiceRegistry) {
        if (webFrameworkServiceRegistry != null) {
            this.renderService = webFrameworkServiceRegistry.getRenderService();
            this.templatesContainer = webFrameworkServiceRegistry.getTemplatesContainer();
            this.webFrameworkConfiguration = webFrameworkServiceRegistry.getWebFrameworkConfiguration();
            this.modelObjectService = webFrameworkServiceRegistry.getModelObjectService();
            this.resourceService = webFrameworkServiceRegistry.getResourceService();
        }
    }

    public URLHelperFactory getUrlHelperFactory() {
        return this.urlHelperFactory;
    }

    public void setUrlHelperFactory(URLHelperFactory urlHelper) {
        this.urlHelperFactory = urlHelper;
    }

    public WebFrameworkConfigElement getWebFrameworkConfiguration() {
        return this.webFrameworkConfiguration;
    }

    public ModelObjectService getObjectService() {
        return this.modelObjectService;
    }

    public ResourceService getResourceService() {
        return this.resourceService;
    }

    public TemplatesContainer getTemplatesContainer() {
        return this.templatesContainer;
    }

    public RenderService getRenderService() {
        return this.renderService;
    }

    public Map<String, String> getUriTokens() {
        return this.uriTokens;
    }

    public void setUriTokens(Map<String, String> uriTokens) {
        this.uriTokens = uriTokens;
    }

    protected void renderMergedOutputModel(Map<String, Object> mvcModel, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Map<String, Object> model;
        ServletUtil.setRequest(request);
        this.setupRequestContext(mvcModel, request);
        RequestContext context = ThreadLocalRequestContext.getRequestContext();
        response.setContentType(MIMETYPE_HTML);
        context.setResponse(response);
        context.setViewName(this.getUrl());
        if (this.uriTokens != null) {
            context.setUriTokens(this.uriTokens);
        }
        if ((model = context.getModel()) == null) {
            model = new HashMap<String, Object>(8);
            context.setModel(model);
        }
        model.putAll(mvcModel);
        if (model.get("url") == null) {
            URLHelper urlHelper = this.urlHelperFactory != null ? this.urlHelperFactory.createUrlHelper(context, this.uriTokens) : new DefaultURLHelper(context, this.uriTokens);
            model.put("url", urlHelper);
        }
        this.populateRequestContext(context, request);
        this.validateRequestContext(context, request);
        this.exposeModelAsRequestAttributes(model, request);
        String encoding = request.getCharacterEncoding();
        if (encoding == null) {
            try {
                request.setCharacterEncoding("utf-8");
            }
            catch (UnsupportedEncodingException uee) {
                throw new RendererExecutionException("Unable to set encoding to default: utf-8", uee);
            }
        }
        try {
            this.renderView(context);
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new Exception(t);
        }
        finally {
            context.release();
        }
    }

    protected abstract void renderView(RequestContext var1) throws Exception;

    protected void setupRequestContext(Map<String, Object> mvcModel, HttpServletRequest request) throws Exception {
    }

    protected void populateRequestContext(RequestContext context, HttpServletRequest request) throws Exception {
        RequestContextUtil.populateRequestContext(context, request);
    }

    protected void validateRequestContext(RequestContext context, HttpServletRequest request) throws Exception {
    }

    protected Page lookupPage(String pageId) {
        TemplateProcessor templateProcessor;
        TemplateProcessorRegistry templateProcessorRegistry;
        String validTemplatePath;
        Page page = this.getObjectService().getPage(pageId);
        if (page == null && (validTemplatePath = (templateProcessorRegistry = this.templatesContainer.getTemplateProcessorRegistry()).findValidTemplatePath(pageId)) != null && (templateProcessor = templateProcessorRegistry.getTemplateProcessor(validTemplatePath)) != null) {
            TemplateInstance templateInstance = this.modelObjectService.newTemplate(pageId);
            templateInstance.setTemplateTypeId(pageId);
            page = this.modelObjectService.newPage(pageId);
            page.setTemplateId(pageId);
        }
        return page;
    }
}

