/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.surf.mvc;

import jakarta.servlet.http.HttpServletRequest;
import java.util.Locale;
import java.util.StringTokenizer;
import org.springframework.extensions.surf.util.I18NUtil;
import org.springframework.web.servlet.i18n.AcceptHeaderLocaleResolver;

public class LocaleResolver
extends AcceptHeaderLocaleResolver {
    public Locale resolveLocale(HttpServletRequest request) {
        Locale locale = Locale.getDefault();
        String acceptLang = request.getHeader("Accept-Language");
        if (acceptLang != null && acceptLang.length() != 0) {
            StringTokenizer t = new StringTokenizer(acceptLang, ",; ");
            String language = t.nextToken().replace('-', '_');
            locale = I18NUtil.parseLocale((String)language);
        }
        I18NUtil.setLocale((Locale)locale);
        return locale;
    }
}

