/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.surf.resource;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.core.OrderComparator;
import org.springframework.extensions.config.WebFrameworkConfigElement;
import org.springframework.extensions.surf.WebFrameworkServiceRegistry;
import org.springframework.extensions.surf.exception.ResourceLoaderException;
import org.springframework.extensions.surf.resource.Resource;
import org.springframework.extensions.surf.resource.ResourceContent;
import org.springframework.extensions.surf.resource.ResourceLoader;
import org.springframework.extensions.surf.resource.ResourceLoaderFactory;
import org.springframework.extensions.surf.resource.support.VirtualizedWebappResourceLoaderFactory;

public class ResourceService
implements ApplicationContextAware,
ApplicationListener {
    private static final Log logger = LogFactory.getLog(ResourceService.class);
    private ApplicationContext applicationContext;
    private WebFrameworkServiceRegistry webFrameworkServiceRegistry;
    private List<ResourceLoaderFactory> resourceLoaderFactories;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void setServiceRegistry(WebFrameworkServiceRegistry webFrameworkServiceRegistry) {
        this.webFrameworkServiceRegistry = webFrameworkServiceRegistry;
    }

    public WebFrameworkServiceRegistry getServiceRegistry() {
        return this.webFrameworkServiceRegistry;
    }

    public WebFrameworkConfigElement getWebFrameworkConfiguration() {
        return this.getServiceRegistry().getWebFrameworkConfiguration();
    }

    public void onApplicationEvent(ApplicationEvent event) {
        ContextRefreshedEvent refreshEvent;
        ApplicationContext refreshContext;
        if (event instanceof ContextRefreshedEvent && (refreshContext = (refreshEvent = (ContextRefreshedEvent)event).getApplicationContext()) != null && refreshContext.equals(this.applicationContext)) {
            this.onBootstrap();
        }
    }

    protected void onBootstrap() {
        Map resourceLoaderFactoryBeans = BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)this.applicationContext, ResourceLoaderFactory.class, (boolean)true, (boolean)false);
        if (!resourceLoaderFactoryBeans.isEmpty()) {
            this.resourceLoaderFactories = new ArrayList(resourceLoaderFactoryBeans.values());
            VirtualizedWebappResourceLoaderFactory webappLoader = new VirtualizedWebappResourceLoaderFactory();
            webappLoader.setOrder(9999);
            webappLoader.setCacheTimeout(0L);
            this.resourceLoaderFactories.add(webappLoader);
            OrderComparator.sort(this.resourceLoaderFactories);
        } else {
            this.resourceLoaderFactories = new ArrayList<ResourceLoaderFactory>();
        }
    }

    public Resource getResource(String resourceId) throws ResourceLoaderException {
        String[] ids = this.getResourceDescriptorIds(resourceId);
        return this.getResource(ids[0], ids[1], ids[2]);
    }

    public Resource getResource(String protocolId, String endpointId, String objectId) throws ResourceLoaderException {
        Resource resource = null;
        ResourceLoader resourceLoader = this.getResourceLoader(protocolId, endpointId);
        if (resourceLoader != null) {
            resource = resourceLoader.load(objectId);
        }
        return resource;
    }

    public ResourceLoader getResourceLoader(String protocolId, String endpointId) {
        ResourceLoader resourceLoader = null;
        ResourceLoaderFactory resourceLoaderFactory = this.getResourceLoaderFactory(protocolId);
        if (resourceLoaderFactory != null) {
            resourceLoader = resourceLoaderFactory.getResourceLoader(protocolId, endpointId);
        }
        return resourceLoader;
    }

    public ResourceLoaderFactory getResourceLoaderFactory(String protocolId) {
        ResourceLoaderFactory factory = null;
        for (ResourceLoaderFactory resourceLoaderFactory : this.resourceLoaderFactories) {
            if (!resourceLoaderFactory.canHandle(protocolId)) continue;
            factory = resourceLoaderFactory;
            break;
        }
        return factory;
    }

    public ResourceContent getResourceContent(String resourceId) throws IOException, ResourceLoaderException {
        ResourceContent content = null;
        Resource resource = this.getResource(resourceId);
        if (resource != null) {
            content = resource.getContent();
        }
        return content;
    }

    public ResourceContent getResourceContent(String protocolId, String endpointId, String objectId) throws IOException, ResourceLoaderException {
        ResourceContent content = null;
        Resource resource = this.getResource(protocolId, endpointId, objectId);
        if (resource != null) {
            content = resource.getContent();
        }
        return content;
    }

    public ResourceContent getResourceMetadata(String resourceId) throws IOException, ResourceLoaderException {
        ResourceContent content = null;
        Resource resource = this.getResource(resourceId);
        if (resource != null) {
            content = resource.getMetadata();
        }
        return content;
    }

    public ResourceContent getResourceMetadata(String protocolId, String endpointId, String objectId) throws IOException, ResourceLoaderException {
        ResourceContent content = null;
        Resource resource = this.getResource(protocolId, endpointId, objectId);
        if (resource != null) {
            content = resource.getMetadata();
        }
        return content;
    }

    public String[] getResourceDescriptorIds(String resourceId) {
        String[] parts = new String[3];
        int x = resourceId.indexOf("://");
        if (x > -1) {
            parts[0] = resourceId.substring(0, x);
            String cdr = resourceId.substring(x + 3);
            int y = cdr.indexOf(47);
            if (y > -1) {
                parts[1] = cdr.substring(0, y);
                parts[2] = cdr.substring(y + 1);
            }
            if (parts[0].length() == 0) {
                parts[0] = null;
            }
            if (parts[1].length() == 0) {
                parts[1] = null;
            }
            if (parts[2].length() == 0) {
                parts[2] = null;
            }
        } else {
            if (resourceId.startsWith("/")) {
                resourceId = resourceId.substring(1);
            }
            parts[0] = "webapp";
            parts[1] = null;
            parts[2] = resourceId;
        }
        return parts;
    }
}

