/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.surf.types;

import org.dom4j.Document;
import org.springframework.extensions.surf.ModelHelper;
import org.springframework.extensions.surf.ModelPersisterInfo;
import org.springframework.extensions.surf.PersisterCallbackHandler;
import org.springframework.extensions.surf.RequestContext;
import org.springframework.extensions.surf.render.AbstractRenderableModelObject;
import org.springframework.extensions.surf.render.RenderUtil;
import org.springframework.extensions.surf.types.Component;
import org.springframework.extensions.surf.types.ComponentType;
import org.springframework.extensions.webscripts.WebScript;

public class ComponentImpl
extends AbstractRenderableModelObject
implements Component {
    private static final long serialVersionUID = -5779261897878106804L;
    private String regionId = null;
    private String scope = null;
    private String sourceId = null;
    private String componentTypeId = null;
    private WebScript resolvedWebScript;
    private PersisterCallbackHandler handler = null;

    public ComponentImpl(String id, ModelPersisterInfo key, Document document) {
        super(id, key, document);
        this.setGUID(id);
    }

    @Override
    public String getTypeId() {
        return "component";
    }

    @Override
    public String getRegionId() {
        if (this.regionId == null) {
            this.regionId = this.getProperty("region-id");
        }
        return this.regionId;
    }

    @Override
    public void setRegionId(String regionId) {
        this.setProperty("region-id", regionId);
        this.regionId = regionId;
        this.regenerateId();
    }

    @Override
    public String getSourceId() {
        if (this.sourceId == null) {
            this.sourceId = this.getProperty("source-id");
        }
        return this.sourceId;
    }

    @Override
    public void setSourceId(String sourceId) {
        this.setProperty("source-id", sourceId);
        this.sourceId = sourceId;
        this.regenerateId();
    }

    @Override
    public String getScope() {
        if (this.scope == null) {
            this.scope = this.getProperty("scope");
        }
        return this.scope;
    }

    @Override
    public void setScope(String scope) {
        this.setProperty("scope", scope);
        this.scope = scope;
        this.regenerateId();
    }

    @Override
    public String getComponentTypeId() {
        if (this.componentTypeId == null) {
            this.componentTypeId = this.getProperty("component-type-id");
            if (this.componentTypeId == null) {
                this.componentTypeId = "webscript";
            }
        }
        return this.componentTypeId;
    }

    @Override
    public void setComponentTypeId(String componentTypeId) {
        this.setProperty("component-type-id", componentTypeId);
        this.componentTypeId = componentTypeId;
    }

    @Override
    public String getChrome() {
        return this.getProperty("chrome");
    }

    @Override
    public void setChrome(String chrome) {
        this.setProperty("chrome", chrome);
    }

    @Override
    public String getURL() {
        String url = this.getProperty("url");
        if (url == null) {
            url = this.getProperty("uri");
        }
        return url;
    }

    @Override
    public void setURL(String url) {
        if (url != null) {
            this.setProperty("url", url);
        }
    }

    @Override
    public String getURI() {
        String uri = this.getProperty("uri");
        if (uri == null) {
            uri = this.getProperty("url");
        }
        return uri;
    }

    @Override
    public void setURI(String uri) {
        if (uri != null) {
            this.setProperty("url", uri);
        }
    }

    @Override
    public String getGUID() {
        return this.getProperty("guid");
    }

    @Override
    public void setGUID(String guid) {
        this.setProperty("guid", guid);
    }

    @Override
    public Object getSourceObject(RequestContext context) {
        return RenderUtil.getComponentBindingSourceObject(context, this);
    }

    @Override
    public ComponentType getComponentType(RequestContext context) {
        return context.getObjectService().getComponentType(this.getComponentTypeId());
    }

    protected void regenerateId() {
        String id = RenderUtil.generateComponentId(this.scope, this.regionId, this.sourceId);
        if (id == null && (id = this.getGUID()) == null) {
            id = ModelHelper.newGUID();
            this.setGUID(id);
        }
        this.id = id;
    }

    @Override
    public void setId(String id) {
    }

    @Override
    public void setResolvedWebScript(WebScript webScript) {
        this.resolvedWebScript = webScript;
    }

    @Override
    public WebScript getResolvedWebScript() {
        return this.resolvedWebScript;
    }

    @Override
    public String getIndex() {
        return this.getProperty("index");
    }

    @Override
    public void setIndex(String index) {
        this.setProperty("index", index);
    }

    @Override
    public int compareTo(Component o) {
        int oIndex = 50;
        int thisIndex = 50;
        try {
            oIndex = Integer.valueOf(o.getIndex());
        }
        catch (NumberFormatException e) {
            oIndex = 50;
        }
        try {
            thisIndex = Integer.valueOf(this.getIndex());
        }
        catch (NumberFormatException e) {
            thisIndex = 50;
        }
        return thisIndex - oIndex;
    }

    @Override
    public void setPersisterCallbackHandler(PersisterCallbackHandler handler) {
        this.handler = handler;
    }

    @Override
    public void onEviction() {
        if (this.handler != null) {
            this.handler.removedFromCache();
        }
    }
}

