/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.surf.types;

import org.dom4j.Document;
import org.springframework.extensions.surf.ModelObject;
import org.springframework.extensions.surf.ModelPersisterInfo;
import org.springframework.extensions.surf.RequestContext;
import org.springframework.extensions.surf.types.AbstractModelObject;
import org.springframework.extensions.surf.types.ContentAssociation;

public class ContentAssociationImpl
extends AbstractModelObject
implements ContentAssociation {
    public ContentAssociationImpl(String id, ModelPersisterInfo key, Document document) {
        super(id, key, document);
    }

    @Override
    public String getTypeId() {
        return "content-association";
    }

    @Override
    public String getSourceId() {
        return this.getProperty("source-id");
    }

    @Override
    public void setSourceId(String sourceId) {
        this.setProperty("source-id", sourceId);
    }

    @Override
    public String getDestId() {
        return this.getProperty("dest-id");
    }

    @Override
    public void setDestId(String destId) {
        this.setProperty("dest-id", destId);
    }

    @Override
    public String getAssociationType() {
        return this.getProperty("assoc-type");
    }

    @Override
    public void setSourceType(String sourceType) {
        this.setProperty("source-type", sourceType);
    }

    @Override
    public String getSourceType() {
        return this.getProperty("source-type");
    }

    @Override
    public void setAssociationType(String associationType) {
        this.setProperty("assoc-type", associationType);
    }

    @Override
    public String getFormatId() {
        return this.getProperty("format-id");
    }

    @Override
    public void setFormatId(String formatId) {
        this.setProperty("format-id", formatId);
    }

    @Override
    public ModelObject getObject(RequestContext context) {
        ModelObject modelObject = null;
        if (this.isTemplateAssociation()) {
            modelObject = context.getObjectService().getTemplate(this.getDestId());
        } else if (this.isPageAssociation()) {
            modelObject = context.getObjectService().getPage(this.getDestId());
        }
        return modelObject;
    }

    @Override
    public boolean isTemplateAssociation() {
        return this.getAssociationType() == null || "template".equalsIgnoreCase(this.getAssociationType());
    }

    @Override
    public boolean isPageAssociation() {
        return "page".equalsIgnoreCase(this.getAssociationType());
    }
}

